<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require  APPPATH . '/libraries/ElearningForma2PlusController.php';
require  APPPATH. '/libraries/ExportData.php';


/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 re
 * @version : 1.1
 * @since : 22 November 2018
 */
class Societe extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('membres_model');
        $this->load->model('societe_model');
        $this->load->library('pagination'); 
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning|Company list'; 

        $data['searchText']   = $this->input->post('searchText');   
        if (isset($_GET['idmembres']) && $_GET['idmembres'] != '') {
            $data['idSocMembers'] = $this->membres_model->Request('id_societe',$_GET['idmembres']);
        }
        $count = $this->societe_model->readCountByAdmin($data['searchText']);

        $returns = $this->paginationCompress ("listsociete/", $count, 15 );

        $data['company'] = $this->societe_model->readByAdmin($data['searchText'],$returns["page"], $returns["segment"]);
        $this->loadViews("admin/societe/list", $this->global, $data , NULL);
    } 

    public function delete(){
        if (isset($_GET['id'])) { //remove company by id society
            # code...
        }
        elseif (isset($_GET['idmembres'])) { //remove company by members
            $data = array(
                'id_societe' => 0
                );
            $this->membres_model->update($_GET['idmembres'],$data);
            redirect('listsociete?idmembres='.$_GET['idmembres'], 'refresh');
        }
    } 

    public function updatebymembers(){
        if (isset($_GET['idmembres']) && isset($_GET['idsociete'])) {
            $data = array(
                'id_societe' => $_GET['idsociete']
                );
            $this->membres_model->update($_GET['idmembres'],$data);
            redirect('listsociete?idmembres='.$_GET['idmembres'], 'refresh');
        }
    }
}

?>