<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Sequence extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('domaines_model');
        $this->load->model('matieres_model');
        $this->load->model('NiveauCorrespondantElExtranet_model');
        $this->load->model('sessions_model');
        $this->load->model('formations_model');
        $this->load->model('parcours_model');
        $this->load->model('historique_modif_link_model');
        $this->form_validation->set_error_delimiters($this->config->item('error_prefix'), $this->config->item('error_suffix'));
        $this->isLoggedIn();   
        $this->cpt = 0;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {

    }

    public function list()
    {
        $return = '' ;
        $cur_mat = -1 ;
        $this->cpt += 1;

        $this->global['pageTitle'] = 'E-learning : Gestion des séquences';

        $data['allResults'] = $this->sequence_model->getListResults();  
        $data['allModulesResults'] = $this->modules_model->getAlls();  
        $this->loadViews("admin/sequence/list", $this->global,$data, NULL );
    }

    public function getInfos(){
        $return = array();
        if (isset($_POST['sequence_id'])) {
            $return['allResults'] = $this->sequence_model->readSequence($_POST['sequence_id'],LOC,NULL);  
        }
        echo json_encode($return);
    }

    public function addSequence(){
        if (isset($_POST['sequence_titre_form']) && $_POST['sequence_titre_form'] != '') {
            $data = array(
                'sequence_titre' => $_POST['sequence_titre_form'],
                'sequence_objectifs' => isset($_POST['sequence_objectif_form']) ? $_POST['sequence_objectif_form'] : '',
                'auteur_id' => $this->session->userdata ('GUSERID'),
                'user_create' => $this->session->userdata ('GUSERID'),
                'sequence_duree'    => 0,
                'repertoire'        => '',
                'code'              => 'S'.$this->sequence_model->getNextCodeFormListSequence(),
                'domaine_id'        => 0,
                'matiere_id'        => 0,
            );
            $sequence_last_insert_id = $this->sequence_model->addSequenceList($data);
            if (isset($_POST['sequence_module_form']) && $_POST['sequence_module_form'] != '') {
               $datas = array(
                    'module_id'   => $_POST['sequence_module_form'],
                    'ordre'       => 1,
                    'sequence_id' => $sequence_last_insert_id,
                    'type'        => 0,
                    'loc'         => 1,
                );
                
                //add sequence to module
                $verification = $this->modules_model->getInfosContentByParams($datas);
                if (count($verification) < 1) {
                    //add sequence to module
                    $this->modules_model->addModule($datas);
                }

                // select a group where formation have a module
                //$allResutls = $this->formations_model->getInfosByModules($_POST['sequence_module']);
                $allResutls = $this->formations_model->getInfosByModulesJoinActiveMembers($_POST['sequence_module_form']);

                // select a group where formation have a module
                //$allResutls = $this->formations_model->getInfosByModules($_POST['sequence_module_form']);
                $f = 0;
                $infosFormation = array();
                $this->load->model('admin_model');
                if (count($allResutls) >= 1) {
                    foreach($allResutls as $res){
                        $this->admin_model->ajouterSequenceFormation($res->user_id,$sequence_last_insert_id,1,$_POST['sequence_module_form'],1,$res->parcours_id,1,$res->groupe_id,0);
                    }
                }
            }
            redirect('managesequences', 'refresh');
        }
    }


    public function add(){
        if (isset($_POST['ajaxForm'])) {
            $return = array();
            $idGroupe = '';
            $idStagiaire = '';
            if ($this->isTuteurConnet()) {
                $idGroupe = $this->session->userdata ('STAGIAIREGRP');
                $idStagiaire = $this->session->userdata ('STAGIAIREID');
            }
            else{
                $idGroupe = $this->session->userdata ('GROUPE');
                $idStagiaire = $this->session->userdata ('GUSERID');
            }
            $data = array(
                'sequence_titre'    => $_POST['sequence_titre'],
                'sequence_objectifs'=> $_POST['sequence_objectifs'],
                'sequence_duree'    => 0,
                'repertoire'        => '',
                'auteur_id'         => -1,
                'code'              => 'S'.$this->sequence_model->getNextCodeFormListSequence(),
                'domaine_id'        => $_POST['domaine_id'],
                'matiere_id'        => 0,
                'user_create'       => $this->session->userdata ('GUSERID'),
            );
            
            $idSequence  = $this->sequence_model->addSequenceList($data);
            $return['sequenceInfos'] = $data;
            $return['sequenceInfos']['idSequence'] = $idSequence;

            //ajouter la sequence dans le module
            $orderModule = $this->modules_model->getNextOrderFormModule($_POST['sequence_module']);
            $moduleData = array(
                'module_id'  => $_POST['sequence_module'],
                'ordre'      => $orderModule,
                'sequence_id'=> $idSequence,
                'type'       => 0,
                'loc'        => 1,
            );
            $this->modules_model->addModule($moduleData);
            $return['moduleInfos'] = $moduleData;

            $parcoursIdFinal = '';
            //ajouter la sequence dans la formation
            if ($_POST['action_btn'] == 'maj_for_presence_trainee') { // MAJ for presence trainee                
                $parcoursId = $this->formations_model->getIdByGroupe($idGroupe);
                $return['parcoursId'] = $parcoursId;
                if ($parcoursId >= 1) {
                   $parcoursIdFinal = $parcoursId;
                }
                else{
                    $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$idGroupe),$this->groupes_model->RequestByGrp('langue',$idGroupe));
                    $return['parcoursIdFinals'] = $parcoursIdFinal;
                }
                $formationData = array(
                    'user_id'        => $idStagiaire,
                    'groupe_id'      => $idGroupe,
                    'sequence_id'    => $idSequence,
                    'locs'           => 1,
                    'module_id'      => $_POST['sequence_module'],
                    'locm'           => 1,
                    'parcours_id'    => $parcoursIdFinal,
                    'locp'           => 1,
                    'ordre'          => $orderModule,
                    'note'           => 0
                );
                $this->formations_model->add($formationData);
                $return['formationInfos'] = $formationData;
            }
            elseif ($_POST['action_btn'] == 'maj_for_my_trainee') { //MAJ for all trainee from tutor
                $allResultTraineeFormTutot   = $this->groupes_model->readGrpTutor($this->session->userdata ('GUSERID'));
                foreach ($allResultTraineeFormTutot as $res){
                    $parcoursId = $this->formations_model->getIdByGroupe($res->id_groupe);
                    $return['parcoursId'] = $parcoursId;
                    if ($parcoursId >= 1) {
                       $parcoursIdFinal = $parcoursId;
                    }
                    else{
                        $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$res->id_groupe),$this->groupes_model->RequestByGrp('langue',$res->id_groupe));
                        $return['parcoursIdFinals'] = $parcoursIdFinal;
                    }
                    $formationData = array(
                        'user_id'        => $res->id,
                        'groupe_id'      => $res->id_groupe,
                        'sequence_id'    => $idSequence,
                        'locs'           => 1,
                        'module_id'      => $_POST['sequence_module'],
                        'locm'           => 1,
                        'parcours_id'    => $parcoursIdFinal,
                        'locp'           => 1,
                        'ordre'          => $orderModule,
                        'note'           => 0
                    );
                    $this->formations_model->add($formationData);
                    $return['formationInfos'] = $formationData;
                }
            }
            else{  //MAJ for all trainee active
                $allResultTrainee   = $this->membres_model->filtrer('',STAGIAIRE,'2');
                for ($i=0; $i < count($allResultTrainee) ; $i++) { 
                    $parcoursId = $this->formations_model->getIdByGroupe($allResultTrainee[$i]['groupeId']);
                    $return['parcoursId'] = $parcoursId;
                    if ($parcoursId >= 1) {
                       $parcoursIdFinal = $parcoursId;
                    }
                    else{
                        $parcoursIdFinal = $this->NiveauCorrespondantElExtranet_model->RequestByByNiveauExtranetAndLangage('id_parcours_el',$this->membres_model->Request('StageSociete',$allResultTrainee[$i]['groupeId']),$this->groupes_model->RequestByGrp('langue',$allResultTrainee[$i]['groupeId']));
                        $return['parcoursIdFinals'] = $parcoursIdFinal;
                    }
                    $formationData = array(
                        'user_id'        => $allResultTrainee[$i]['id'],
                        'groupe_id'      => $allResultTrainee[$i]['groupeId'],
                        'sequence_id'    => $idSequence,
                        'locs'           => 1,
                        'module_id'      => $_POST['sequence_module'],
                        'locm'           => 1,
                        'parcours_id'    => $parcoursIdFinal,
                        'locp'           => 1,
                        'ordre'          => $orderModule,
                        'note'           => 0
                    );
                    $this->formations_model->add($formationData);
                    $return['formationInfos'] = $formationData;
                }
            }

            echo json_encode($return);
        }
        else{

            $tilesequence     = $this->input->post('tilesequence');
            $code             = $this->input->post('code');
            $support          = $this->input->post('support');
            $Educationalgoals = $this->input->post('Educationalgoals');
            $author           = $this->session->userdata ('GUSERID');
            $duree            = $this->input->post('durationsh');

            /*if ($this->input->post('durationsh') !="") {
                $durationsh       = explode(":", $this->input->post('durationsh'));
                $duree            = $durationsh[0]*3600 + $durationsh[1]*60;
            }
            else{
                $duree            = "";
            }*/
            
            $idsequence       = $this->sequence_model->add($tilesequence,$code,$author,$support,$Educationalgoals,$duree);

            if(isset($_FILES["thumbnail"]) && $_FILES["thumbnail"]["error"] == 0){

                $files=$_FILES['thumbnail'];
                $tmp_name=$files['tmp_name'];
                $name=explode(".", $files['name']);
                $thumbname="thumbnail_".time()."_1_".$idsequence."_".LOC.".".$name[1];     
                $res=move_uploaded_file($tmp_name, RP_SEQUENCE_MODULES.$thumbname);
                if($res) {
                    $thumbinfo = array(            
                        'id_pr'           =>$idsequence, 
                        "loc_pr"          => LOC, 
                        "thumbnail"       => $thumbname, 
                        "date_create"     => time(), 
                        "type"            => 1, 
                        'user_create'     =>$this->session->userdata ('GUSERID')
                    );
                    $this->utilities_model->addthumb($thumbinfo);

                    $msg='Uploaded successfully';
                    $source_image = RP_SEQUENCE_MODULES.$thumbname;
                    $destination = RP_SEQUENCE_MODULES.$thumbname;
                    $tn_w = 1200;
                    $tn_h = 1280;
                    $quality = 1000;
                    $wmsource ="";
                    $success = $this->image_handler($source_image,$destination,$tn_w,$tn_h,$quality,$wmsource);
                    if($success) { 
                    $msg .= "Your image was saved successfully!"; 
                    }
                    else { 
                    $msg .=  "Your image was not saved."; 
                    }
                }
                else {
                    $msg='RP_SEQUENCE_MODULES : '.RP_SEQUENCE_MODULES.$thumbname.'  tmp_name: '.$tmp_name;
                }
            }
            
            redirect('editsequence/1/'.$idsequence, 'refresh');
        }
    }

    public function ajaxEditSequence()
    {
        $return = array();
        if (isset($_POST['idSequence'])) {
            $data = array(
                'sequence_titre'    => $_POST['sequence_titre'],
                'sequence_objectifs'=> $_POST['sequence_objectifs']
            );
            $this->sequence_model->updateListSequence($_POST['idSequence'],$data);
            $return = $data;
            $return['idSequence'] = $_POST['idSequence'];

            if (isset($_POST['sequence_module']) && $_POST['sequence_module'] != '' && $_POST['sequence_module'] != null) {
                //empty data in formation
                //$this->formations_model->deleteBySequence($_POST['idSequence']);
                $datas = array(
                    'module_id'   => $_POST['sequence_module'],
                    'ordre'       => 1,
                    'sequence_id' => $_POST['idSequence'],
                    'type'        => 0,
                    'loc'         => 1,
                );
                
                $verification = $this->modules_model->getInfosContentByParams($datas);
                if (count($verification) < 1) {
                    //add sequence to module
                    $this->modules_model->addModule($datas);
                }

                // select a group where formation have a module
                //$allResutls = $this->formations_model->getInfosByModules($_POST['sequence_module']);
                $allResutls = $this->formations_model->getInfosByModulesJoinActiveMembers($_POST['sequence_module']);
                $f = 0;
                $infosFormation = array();
                $this->load->model('admin_model');
                if (count($allResutls) >= 1) {
                    foreach($allResutls as $res){
                        $this->admin_model->ajouterSequenceFormation($res->user_id,$_POST['idSequence'],1,$_POST['sequence_module'],1,$res->parcours_id,1,$res->groupe_id,0);
                    }
                }
            }

        }
        echo json_encode($return);
    }

    public function editsequence($loc,$id){
        if ($this->input->post('tilesequence') != "" || $this->input->post('code') != "" || $this->input->post('integrateur') != "" || $this->input->post('support') != "" || $this->input->post('Educationalgoals') != "" || $this->input->post('durationsh') != "") {
            $idm = $this->sequence_model->update($id,$this->input->post('tilesequence'),$this->input->post('code'),$this->input->post('integrateur'),$this->input->post('support'),$this->input->post('Educationalgoals'),$this->input->post('durationsh'));

            if(isset($_FILES["thumbnail"]) && $_FILES["thumbnail"]["error"] == 0){
               
                $files=$_FILES['thumbnail'];
                $tmp_name=$files['tmp_name'];
                $name=explode(".", $files['name']);
                $thumbname="thumbnail_".time()."_1_".$id."_".LOC.".".$name[1];     
                $res=move_uploaded_file($tmp_name, RP_SEQUENCE_MODULES.$thumbname);
                if($res) {
                    $thumbinfo = array(           
                        "thumbnail"       => $thumbname, 
                        "date_create"     => time(),
                        'user_create'     =>$this->session->userdata ('GUSERID')
                    );
                    $this->utilities_model->modifthumb(1,$id,LOC,$thumbinfo);

                    $msg='Uploaded successfully';
                    $source_image = RP_SEQUENCE_MODULES.$thumbname;
                    $destination = RP_SEQUENCE_MODULES.$thumbname;
                    $tn_w = 1200;
                    $tn_h = 1280;
                    $quality = 1000;
                    $wmsource ="";
                    $success = $this->image_handler($source_image,$destination,$tn_w,$tn_h,$quality,$wmsource);
                    if($success) { 
                        $msg .= "Your image was saved successfully!"; 
                    }
                    else { 
                        $msg .=  "Your image was not saved."; 
                    }
                }
                
            }

            if ($idm) {
                redirect('managesequences', 'refresh');
            }
            
        }        
        else{
            define('SUBMENU',   MENU_SEQUENCE);
            $this->global['pageTitle'] = 'E-learning : Edition sequence';

            $this->form_validation->set_rules('edit_sequence', 'lang:edit_sequence', 'trim|required');

            $sequenceinfo = $this->sequence_model->info($id);
         
            $this->global['gobacktosequence']  = "<a href='".base_url()."managesequences'>Go back</a><br>" ;
            $this->global['sequencetitles']     = $sequenceinfo['titre'];
           

            $data['sequencetitle'] = array(
                'type'  => 'text',
                'name'  => 'tilesequence',
                'id'    => 'tilesequence',
                'value' => $this->form_validation->set_value('sequencetitle',$sequenceinfo['titre']),
                'class' => 'form-control'
            );

            $data['codesequence'] = array(
                'type'  => 'text',
                'name'  => 'code',
                'id'    => 'code',
                'value' => $this->form_validation->set_value('codesequence',$sequenceinfo['code']),
                'class' => 'form-control'
            );

            $membresautor = $this->membres_model->filtrer("",TUTEUR_INTEGRATEUR);

            $datalist = '<input list="autorsequence" name="integrateur" class="form-control autorsequence" value="'.$this->membres_model->GetAuteurName($sequenceinfo['auteur']).'">';

            $datalist .= '<datalist id="autorsequence">';
                foreach ($membresautor as $res) {
                   $datalist .= '<option data-id="'.$res['id'].'" value="'.$res['name'].'">';
                }
            $datalist .= '</datalist>';

            $data['urladdauteur'] = $datalist;
            $data['sequenceid']   = $sequenceinfo['id'];
            $data['filesupport'] = array(
                'type'  => 'text',
                'name'  => 'support',
                'id'    => 'support',
                'value' => $this->sequence_model->Support($sequenceinfo['id']),
                'class' => 'form-control'
            );
            $data['objectifs']                 = $sequenceinfo['objectifs'];
            $data['duree']                     = $sequenceinfo['duree'];
            $data['thumbnail']                 = base_url()."groupes/SEQUENCES/".$this->utilities_model->getthumb(1,$sequenceinfo['id'],LOC);


            $data['urlfilemanager'] = base_url().'filemanager?loc='.LOC.'&cmd=2&cmd1=1&id='.$sequenceinfo['id']."&form=sequence";
            $data['urlAddActivity'] = base_url().'editactivity?action=form_chapitre&loc='.LOC.'&cmd=2&cmd1=1&id='.$sequenceinfo['id']."&form=sequence";
            $data['urlViewSequence']= base_url().'viewseq?sequence='.$sequenceinfo['id']."&loc=".LOC;


            $data['detailsequence'] = $this->afficheDetailSequence($sequenceinfo['id'],LOC,true);

            
       
            $this->loadViews("admin/sequence/sequencemod", $this->global,$data, NULL );
        }
    }

    public function views(){
        if (isset($_GET) && $_GET['sequence'] != "") {
            # code...
        }
    }

    public function deleteSequence(){

        $id  = $this->input->post('id');
        $loc = $this->input->post('loc');

        /*Delete sequence in list_sequence and sequence table*/
        $this->sequence_model->del($id);

        /*Delete sequence in list_modules and modules table*/
        $this->modules_model->delSequence(-1,$id,$loc);

        /*Delete sequence in list_parcous and parcours table*/
        //$this->parcours_model->delItem(-1,$id,TYPE_SEQUENCE,$loc);

        /*Delete sequence in tracking table*/
        $this->tracking_model->delSequence($id,0);

        /*Delete item grp*/
        $this->supprimerItemGroupe($id,$loc,-1,-1,-1,-1,-1);

        /*Delete item formation*/
        $this->supprimerItemFormation(-1,$id,$loc,-1,-1,-1,-1,-1);

        return (OK);
        
    }

    public function supprimerItemGroupe($ids,$locs,$idm,$locm,$idp,$locp,$idg) {
        $this->sessions_model->delItem($ids,$locs,$idm,$locm,$idp,$locp,$idg);
        $result = $this->groupes_model->membres($idg);
        //$ret = $this->groupes_model->membres($idg);
        foreach($result as $res) {
            $this->formations_model->delItem($res->id,$ids,$locs,$idm,$locm,$idp,$locp,$idg);
            $this->tracking_model->del($res->id,$ids,$idg,$locs);
        }      
    }

    public function supprimerItemFormation($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg) {      
        $this->formations_model->delItem($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg);
        $this->tracking_model->del($idu,$ids,$idg,$locs);
      
    }

    public function addthumb($type,$id,$loc){

        $files=$_FILES['fileupload'];
        $tmp_name=$files['tmp_name'];
        $name=explode(".", $files['name']);
        $thumbname="thumbnail_".time()."_".$type."_".$id."_".$loc.".".$name[1];       
        $res=move_uploaded_file($tmp_name, RP_SEQUENCE_MODULES.$thumbname);
        if($res) {
            $thumbinfo = array(            
                'id_pr'           =>$id, 
                "loc_pr"          => $loc, 
                "thumbnail"       => $thumbname, 
                "date_create"     => time(), 
                "type"            => $type, 
                'user_create'     =>$this->session->userdata ('GUSERID')
            );
            $this->utilities_model->addthumb($thumbinfo);

            $msg='Uploaded successfully';
            //get the uploaded image
            $source_image = RP_SEQUENCE_MODULES.$thumbname;
            //specify the output path in your file system and the image size/quality
            $destination = RP_SEQUENCE_MODULES.$thumbname;
            $tn_w = 1200;
            $tn_h = 1280;
            $quality = 1000;
            //path to an optional watermark
            $wmsource ="";
            //$wmsource = RP_SEQUENCE_MODULES.'thumbnail_1547548773_1_429_1.jpg';
            // Try to process the image and echo a small message whether or not it worked. If the image is saved somewhere public, you could add an <img src> tag to display the image here, too!
            $success = $this->image_handler($source_image,$destination,$tn_w,$tn_h,$quality,$wmsource);
            if($success) { 
            $msg .= "Your image was saved successfully!"; 
            }
            else { 
            $msg .=  "Your image was not saved."; 
            }
        }
        else {
            $msg='RP_SEQUENCE_MODULES : '.RP_SEQUENCE_MODULES.$thumbname.'  tmp_name: '.$tmp_name;
        }
        
        echo $msg;
    }

    public function modifthumb($type,$id,$loc){

        $files=$_FILES['fileupload'];
        $tmp_name=$files['tmp_name'];
        $name=explode(".", $files['name']);
        $thumbname="thumbnail_".time()."_".$type."_".$id."_".$loc.".".$name[1];       
        $res=move_uploaded_file($tmp_name, RP_SEQUENCE_MODULES.$thumbname);
        if($res) {
            $msg='Uploaded successfully';

            $thumbinfo = array(           
                "thumbnail"       => $thumbname, 
                "date_create"     => time(),
                'user_create'     =>$this->session->userdata ('GUSERID')
            );
            $this->utilities_model->modifthumb($type,$id,$loc,$thumbinfo);

            //get the uploaded image
            $source_image = RP_SEQUENCE_MODULES.$thumbname;
            //specify the output path in your file system and the image size/quality
            $destination = RP_SEQUENCE_MODULES.$thumbname;
            $tn_w = 1200;
            $tn_h = 1280;
            $quality = 1000;
            //path to an optional watermark
            $wmsource ="";
            //$wmsource = RP_SEQUENCE_MODULES.'thumbnail_1547548773_1_429_1.jpg';
            // Try to process the image and echo a small message whether or not it worked. If the image is saved somewhere public, you could add an <img src> tag to display the image here, too!
            $success = $this->image_handler($source_image,$destination,$tn_w,$tn_h,$quality,$wmsource);
            if($success) { 
            $msg .= "Your image was saved successfully!"; 
            }
            else { 
            $msg .=  "Your image was not saved."; 
            }

        }
        else {
            $msg='RP_SEQUENCE_MODULES : '.RP_SEQUENCE_MODULES.$thumbname.'  tmp_name: '.$tmp_name;
        }
        echo $msg;

    }
    
    public function addauthor(){
        $author     = $this->input->post('idauthor');
        $sequenceid = $this->input->post('sequence_id');
        $infoadd = array('auteur_id' => $author);
        $this->sequence_model->addauthor($sequenceid,$infoadd);
    }

    public function afficheDetailSequence($ids,$loc,$position=false){
        $htmlRetour = "";      
       

        $htmlRetour .= "<table class='table'>";
            $htmlRetour .= "<thead>";
                $htmlRetour .= "<tr>";
                $htmlRetour .= "<th></th>";
                $htmlRetour .= "<th>ACTIVITE</th>";
                $htmlRetour .= "<th>TYPE</th>";
                $htmlRetour .= "<th>ACTIONS</th>";
                $htmlRetour .= "</tr>";
            $htmlRetour .= "</thead>";

        $detail = $this->sequence_model->readSequence($ids,$loc);
        $cnt_seq= $detail['cnt'];

        for($j=0;$j<$detail['cnt'];$j++)  {
            if ( $detail[$j]['numero'] == 0 ) continue ;
            $numero = $detail[$j]['numero'] ;
            if ($position){
                $cmd='';
                $url  = base_url().'editactivity?action=form_chapitre&id='.$detail[$j]['id_sequence'].'&numero='.$numero;
                $click    = "onClick=\"openWindow('".$url."','fenetre','scrollbars=yes,resizable=yes,width=750,height=500');\"";
                $lmodif = $this->script->LienNormal(array('url'=>'#', 'action'=>$click, 'val'=>"<span class='fa fa-edit'></span>"));

                $delchap= base_url().'editactivity?action=deleteactivite&id='.$detail[$j]['id_sequence'].'&numero='.$detail[$j]['numero'];
                $upurl  = base_url().'editactivity?action=up&id='.$ids.'&numero='.$detail[$j]['numero'];
                $up     = $this->script->LienNormal(array('url'=>$upurl, 'val'=>"<span class='glyphicon glyphicon-upload'></span>"));
                $downurl   = base_url().'editactivity?action=down&id='.$ids.'&numero='.$detail[$j]['numero'];
                $down   = $this->script->LienNormal(array('url'=>$downurl, 'val'=>"<span class='glyphicon glyphicon-download'></span>"));
                if ($numero == 1 ) {
                    if ($detail['cnt']  <> 2 ) {
                        $cmd.= $down."\n";
                    }
                } 
                elseif ($numero == ($detail['cnt']-1)) {
                    $cmd.= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$up."\n";
                } else {
                    $cmd.= $down.$up."\n";
                }
            }

            if ($detail[$j]['thumbnail'] == "" && $detail[$j]['type'] != 0 ) {
                $linkthumb  = "<a href='#' class='generatethumbnail' title='Generate thumbnail'><input type='hidden' class='activityid' name='activityid' value='".$detail[$j]['id_sequence']."'><input type='hidden' class='activitynumero' name='activitynumero' value='".$detail[$j]['numero']."'><input type='hidden' class='linkgeneratethumb' name='linkgeneratethumb' value='".base_url()."gthumb'><span class='fa fa-file-image-o'></span></a>";
            }
            else{
                $linkthumb  = "";
            }
           
            $space = str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;",($detail[$j]['niveau']>0)?$detail[$j]['niveau']-1:0);
            $titre = $detail[$j]['type']=="Titre"? strong($detail[$j]['titre']):$detail[$j]['titre'];
            $position = $position?$this->script->LienNormal(array('url'=>'#', 'action'=>'onclick="DeleteItem(\''.$delchap.'\');"', 'val'=>"<span class='fa fa-trash'></span>")).$lmodif:'';
            $htmlRetour .= "<tbody>";
            $htmlRetour .= "<tr>";
            $htmlRetour .= "<td>".$cmd."</td>";
            $htmlRetour .= "<td>".$space.$numero.' - '.utf8_decode($titre)."</td>";
            $htmlRetour .= "<td>".$this->sequence_model->type($detail[$j]['type'])."</td>";
            $htmlRetour .= "<td>".$position.$linkthumb."</td>";
            $htmlRetour .= "</tr>";
            $htmlRetour .= "</tbody>";

            
        }
        $htmlRetour .= "</table>";
        return($htmlRetour);
    }

    public function generatethumb(){
        $num = "";
        if (isset($_POST)) {
            $id         = $_POST['id'];
            if (isset($_POST['num']) && ($_POST['num'] != "" || $_POST['num'] != NULL)) {
                $num = $_POST['num'];
            }
            $width      = "1200";
            $height     = "1280";
            $date       = time();
            $seq= $this->sequence_model->readSequence($id,"",$num);
            for($j=0;$j<$seq['cnt'];$j++)  {             
                $link_support = $seq[$j]['link'];
                $thumbnailFile="";
                $redir        = 'redir.php?url';
                $support      = '';
                $urlF         = "";
                //echo "link : ".$seq[$j]['link']."  thumb : ".$seq[$j]['thumbnail']."<br>";
                if (($seq[$j]['link'] != "" || $seq[$j]['link'] != NULL) && $seq[$j]['thumbnail'] == "") {
                   
                    if ($this->validate_url($link_support)){
                        $support      .= $redir.$link_support;
                        $urlF         .= $link_support;
                    }
                    else{
                        if (strpos($link_support, $redir) == false) { 
                            
                            $filename      = $this->getFileName($link_support);

                            $ext            = explode(".", $filename);

                            if (isset($ext[1]) && $ext[1]=="pdf") {
                                $urlF         .= HTTP_FORMATIONS.$link_support;
                            }
                            elseif (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt")){
                                $urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
                            }
                            else{
                                //donwload file (default thumbnail)
                                $urlF  .= HTTP_FORMATIONS.$link_support;
                            }
                            //Lecture document localement
                            $support      .= $link_support;
                        }                 
                        else { 
                            //echo "2 : ".$link_support."<br>";
                            $support      .=$link_support;
                            $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
                        } 
                    }
                    $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
                    
                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }   

                    $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
                    
                    //echo "numero : ".$seq[$j]['numero']. " urlF : ".$urlF.'<br>';
                    $urlDest = $this->findUltimateDestination($urlF,10);
                    if ($this->validate_url($urlDest)){
                        $thumb = $this->generateThumbnail($urlDest,$width,$height,$fileLocation);

                        if($thumb){
                            $activityInfo = array(
                                "date_create" => $date,
                                "thumbnail_file" => $thumbnailFiles
                            );
                            if (isset($_POST['num']) && ($_POST['num'] != "" || $_POST['num'] != NULL)) {
                                $this->sequence_model->updateChapitre($id,$_POST['num'],$activityInfo);
                            }
                            else{
                                $this->sequence_model->updateChapitre($id,$seq[$j]['numero'],$activityInfo);
                            }
                            //var_dump($activityInfo);
                            echo "fileLocation : " .$fileLocation." id : ".$id. " numero : ".$seq[$j]['numero'].'<br>';

                        }
                        //echo $id." link initial1 : ".$seq[$j]['link']." link final1 : ".$urlF.'<br>';
                       
                    }
                }
                elseif ($seq[$j]['thumbnail'] != "" && !file_exists(REP_ACTIVITY_SEQUENCE.$seq[$j]['thumbnail'])) {
                    if ($this->validate_url($link_support)){
                        $support      .= $redir.$link_support;
                        $urlF         .= $link_support;
                    }
                    else{
                        if (strpos($link_support, $redir) == false) { 
                            //echo "1 : ".$link_support."<br>";
                            $filename      = $this->getFileName($link_support);

                            $ext            = explode(".", $filename);

                            if (isset($ext[1]) && $ext[1]=="pdf") {
                                $urlF         .= HTTP_FORMATIONS.$link_support;
                            }
                            elseif (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt")){
                                $urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
                            }
                            else{
                                //donwload file (default thumbnail)
                                $urlF  .= HTTP_FORMATIONS.$link_support;
                            }
                            //Lecture document localement
                            $support      .= $link_support;
                        }                 
                        else { 
                            //echo "2 : ".$link_support."<br>";
                            $support      .=$link_support;
                            $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
                        } 
                    }
                    $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
                    
                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }   

                    $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
                    $urlDest = $this->findUltimateDestination($urlF,10);
                    if ($this->validate_url($urlDest)){
                        $thumb = $this->generateThumbnail($urlDest,$width,$height,$fileLocation);

                        if($thumb){
                            $activityInfo = array(
                                "date_create" => $date,
                                "thumbnail_file" => $thumbnailFiles
                            );
                            if (isset($_POST['num']) && ($_POST['num'] != "" || $_POST['num'] != NULL)) {
                                $this->sequence_model->updateChapitre($id,$_POST['num'],$activityInfo);
                            }
                            else{
                                $this->sequence_model->updateChapitre($id,$seq[$j]['numero'],$activityInfo);
                            }
                            echo "fileLocation : " .$fileLocation." id : ".$id. " numero : ".$seq[$j]['numero'].'<br>';
                        }
                        //echo $id." link initial2 : ".$seq[$j]['link']." link final2 : ".$urlDest.'<br>';
                    }
                }
            }
        }
    }

    public function generateThumbActivite(){
        $return = array();
        if (isset($_POST['link']) && $_POST['link'] != '') {
            $width      = "1200";
            $height     = "1280";
            $date       = time();
            $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
                    
            if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
            }   

            $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
            
            $thumb = $this->generateThumbnail($_POST['link'],$width,$height,$fileLocation);

            if($thumb){
                $data = array(
                    "date_create" => $date,
                    "thumbnail_file" => $thumbnailFiles
                );

                $this->sequence_model->updateChapitre($_POST['idSequence'],$_POST['numSequence'],$data);
                $return = array(
                    'errors' => false,
                    'message'=> 'Vignette générer avec succées',
                    'thumbnailLink'=> HTTP_ACTIVITY_SEQUENCE.$thumbnailFiles,
                );

            } 
            else{
                $return = array(
                    'errors' => true,
                    'message'=> 'Une erreur est survenu lors de la génération du vignette.',
                );
            }  
        }
        else{
            $return = array(
                'errors' => true,
                'message'=> 'Impossible de générer la vignette car l\'activité ne contient aucun lien',
            );
        }
        echo json_encode($return);
    }

    public function generateThumbActiviteInSequence(){
        $return = array();
        if (isset($_POST['idSequence'])) {
            $allResults = $this->sequence_model->readSequence($_POST['idSequence'],1);
            $cnt_seq= $allResults['cnt'];

            for($j=0;$j<$allResults['cnt'];$j++)  {
                $sequence_id     = $allResults[$j]['id_sequence'];
                $sequence_numero = $allResults[$j]['numero'];
                $sequence_link   = $allResults[$j]['link'];

                if (isset($sequence_link) && $sequence_link != '') {
                    $width      = "1200";
                    $height     = "1280";
                    $date       = time();
                    $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
                            
                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }   

                    $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 
                    
                    $thumb = $this->generateThumbnail($sequence_link,$width,$height,$fileLocation);

                    if($thumb){
                        $data = array(
                            "date_create" => $date,
                            "thumbnail_file" => $thumbnailFiles
                        );

                        $this->sequence_model->updateChapitre($sequence_id,$sequence_numero,$data);
                        $return = array(
                            'errors' => false,
                            'message'=> 'Vignette générer avec succées',
                            'thumbnailLink'=> HTTP_ACTIVITY_SEQUENCE.$thumbnailFiles,
                        );

                    } 
                    else{
                        $return = array(
                            'errors' => true,
                            'message'=> 'Une erreur est survenu lors de la génération du vignette.',
                        );
                    }  
                }
                else{
                    $return = array(
                        'errors' => true,
                        'message'=> 'Impossible de générer la vignette car l\'activité ne contient aucun lien',
                    );
                }

            }
        }
        echo json_encode($return);
    }

    public function editActivity(){

        define('ID',            (isset($_GET['id'])?$_GET['id']:''));
        //define('LOC',           (isset($_GET['loc'])?$_GET['loc']:''));
        define('NUMERO',        (isset($_GET['numero'])?$_GET['numero']:''));
        define('ACTION',        (isset($_GET['action'])?$_GET['action']:''));
        $htmlRetour = "";
        $width      = "1200";
        $height     = "1280";
        $date = time();

        switch (ACTION) {
            case 'delete':
                //$ClsAdmin->SupprimerUneSequence(ID,LOC) ;
                header("Location: ".base_url()."editsequence/".LOC."/".ID."");
                exit();
                break;
            case 'deleteactivite':
                $this->sequence_model->delChapitre(ID,NUMERO) ;
                $this->tracking_model->delChapitre(ID,NUMERO)  ;
                header("Location: ".base_url()."editsequence/".LOC."/".ID."");
                exit();
                break;
            case 'down':
                $this->sequence_model->swapNumeroChapitre(ID,NUMERO,NUMERO+1) ;
                header("Location: ".base_url()."editsequence/".LOC."/".ID."");
                exit();
            break;
            case 'up':
                $this->sequence_model->swapNumeroChapitre(ID,NUMERO,NUMERO-1) ;
                header("Location: ".base_url()."editsequence/".LOC."/".ID."");
                exit();
                break;
            case 'form_chapitre':
                $htmlRetour .= $this->formChapitre(NUMERO);

                $this->global['pageTitle'] = 'E-learning : Activité';
                $this->global['contentDetail'] = $htmlRetour;
        
                $this->loadViews("admin/sequence/chapitre", $this->global, NULL , NULL);
                break;
            case 'modifchapitre':
                $link_support = $this->input->post('support');
                $thumbnailFile="";
                $redir        = 'redir.php?url';
                $support      = '';
                $urlF         = "";
                if ($this->validate_url($link_support)){
                    //echo "0 : ".$link_support."<br>";
                    $support      .= $redir.$link_support;
                    $urlF         .= $link_support;
                }
                else{
                    if (strpos($link_support, $redir) == false) { 
                        //echo "1 : ".$link_support."<br>";
                        $filename      = $this->getFileName($link_support);

                        $ext            = explode(".", $filename);

                        if ($ext[1]=="pdf") {
                            $urlF         .= HTTP_FORMATIONS.$link_support;
                        }
                        elseif ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt"){
                            $urlF   = base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
                        }
                        else{
                            //donwload file (default thumbnail)
                            $urlF  .= HTTP_FORMATIONS.$link_support;
                        }
                        //Lecture document localement
                        $support      .= $link_support;
                    }                 
                    else { 
                        //echo "2 : ".$link_support."<br>";
                        $support      .=$link_support;
                        $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
                    } 
                }
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }  
                $thumbnailFiles = "thumbnail_".$date.'_'.$this->session->userdata('GUSERID').'.png';
                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 

                $thumb = $this->generateThumbnail($urlF,$width,$height,$fileLocation);

                if($thumb){
                    $thumbnailFile .=$thumbnailFiles;
                }
                else{
                    $thumbnailFile .="";
                }             


                $type             = $this->input->post('LType')    ;
                $chap             = $this->input->post('text2')    ;
                $fic              = $support   ;
                $id_scorm         = $this->input->post('text4')    ;
                $mastery          = $this->input->post('text5')    ;
                $max_time         = '' ;
                $description      = $this->input->post('text6')    ;
                $keyword          = $this->input->post('text7')    ;
                $prerequis        = $this->input->post('text8')    ;
                $niveau           = $this->input->post('text9')    ;
                $launch           = $this->input->post('text10')   ;
                $regroupe         = $this->input->post('text11')   ;

                if ($type==TITRE) {
                    $activityInfo = array(           
                        "type"        => TITRE, 
                        "titre"       => $chap,
                        "niveau"      => $niveau,
                        "mastery"     => $mastery,
                        "prerequis"   => $prerequis,
                        "id_scorm"    => $id_scorm,
                        "description" => $description,
                        "regroupe"    => $regroupe,
                        "keyword"     => $keyword,
                        "date_create" => $date,
                        "thumbnail_file" => $thumbnailFile,
                        "link"        => "",
                        "launch"      => $launch
                    );
                }
                else{
                    if ( strlen(trim($chap))!=0 && strlen(trim($fic))!=0 ) {
                        $activityInfo = array(           
                            "type"        => $type, 
                            "titre"       => $chap,
                            "niveau"      => $niveau,
                            "mastery"     => $mastery,
                            "prerequis"   => $prerequis,
                            "id_scorm"    => $id_scorm,
                            "description" => $description,
                            "regroupe"    => $regroupe,
                            "keyword"     => $keyword,
                            "link"        => $fic,
                            "date_create" => $date,
                            "thumbnail_file" => $thumbnailFile,
                            "launch"      => $launch
                        );
                    }
                }
                $this->sequence_model->updateChapitre(ID,NUMERO,$activityInfo);
                echo "<script>window.close();</script>";

                break;
            case 'addchapitre':           
                $link_support = $this->input->post('support');
                $thumbnailFile="";
                $redir        = 'redir.php?url';
                $support      = '';
                $urlF         = "";
                if ($this->validate_url($link_support)){
                    //echo "0 : ".$link_support."<br>";
                    $support      .= $redir.$link_support;
                    $urlF         .= $link_support;
                }
                else{
                    if (strpos($link_support, $redir) == false) { 
                        //echo "1 : ".$link_support."<br>";
                        $filename      = $this->getFileName($link_support);

                        $ext            = explode(".", $filename);

                        if ($ext[1]=="pdf") {
                            $urlF         .= HTTP_FORMATIONS.$link_support;
                        }
                        elseif ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt"){
                            $urlF   = base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;;
                        }
                        else{
                            //donwload file (default thumbnail)
                            $urlF  .= HTTP_FORMATIONS.$link_support;
                        }
                        
                        //Lecture document localement
                        $support      .= $link_support;
                    }                 
                    else { 
                        //echo "2 : ".$link_support."<br>";
                        $support      .=$link_support;
                        $urlF         .= str_replace("/redir.php?url=", "", $link_support);                 
                    } 
                }
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }   

                $thumbnailFiles = "thumbnail_".$date.'_'.$this->session->userdata('GUSERID').'.png';
                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 

                $thumb = $this->generateThumbnail($urlF,$width,$height,$fileLocation);

                if($thumb){
                    $thumbnailFile .=$thumbnailFiles;
                }
                else{
                    $thumbnailFile .="";
                }  

                if (empty($urlF)) {
                    $status = 5;
                    $urlF = '';
                }
                else{
                    $resultStatus = $this->findStatusUrlFinal($this->findUltimateDestination($urlF,10));
                    $status = $resultStatus['status'];
                    $urlF = $resultStatus['urlF'];

                }
               // die('fileLocation : '.$fileLocation." url : ".$urlF." thum : ".$thumb);
               
                $type             = $this->input->post('LType')    ;
                $chap             = $this->input->post('text2')    ;
                $fic              = $support    ;
                $id_scorm         = $this->input->post('text4')    ;
                $mastery          = $this->input->post('text5')    ;
                $max_time         = '' ;
                $description      = $this->input->post('text6')    ;
                $keyword          = $this->input->post('text7')    ;
                $prerequis        = $this->input->post('text8')    ;
                $niveau           = $this->input->post('text9')    ;
                $launch           = $this->input->post('text10')   ;
                $regroupe         = $this->input->post('text11')   ;
                $current_date     = getdate();
                if ($niveau=="") $niveau=1;
                $numeroInser = $this->sequence_model->getMaxNum(ID);
                if ( $type == TITRE ) {
                    $activityInfo = array(           
                        "id_sequence" => ID, 
                        "numero"      => $numeroInser, 
                        "type"        => TITRE, 
                        "titre"       => $chap,
                        "niveau"      => $niveau,
                        "mastery"     => $mastery,
                        "prerequis"   => $prerequis,
                        "id_scorm"    => $id_scorm,
                        "description" => $description,
                        "regroupe"    => $regroupe,
                        "keyword"     => $keyword,
                        "link"        => $fic,
                        "thumbnail_file" => $thumbnailFile,
                        "date_create" => $current_date[0],
                        "launch"      => $launch,
                        'final_url' => $urlF,
                        'status_url' => $status
                    );
                }
                else{
                    if ( strlen(trim($chap))!=0 && strlen(trim($fic))!=0 ) {
                        
                        $activityInfo = array(           
                            "id_sequence" => ID, 
                            "numero"      => $numeroInser, 
                            "type"        => $type, 
                            "titre"       => $chap,
                            "niveau"      => $niveau,
                            "mastery"     => $mastery,
                            "prerequis"   => $prerequis,
                            "id_scorm"    => $id_scorm,
                            "description" => $description,
                            "regroupe"    => $regroupe,
                            "keyword"     => $keyword,
                            "thumbnail_file" => $thumbnailFile,
                            "link"        => $fic,
                            "date_create" => $current_date[0],
                            "launch"      => $launch,
                            'final_url' => $urlF,
                            'status_url' => $status
                        );
                    }
                }
                   
                $this->sequence_model->addChapitre(ID,$activityInfo);
            
                echo "<script>window.close();</script>";

                break;
        }
    }

    public function formChapitre($numero=NULL){
        global $ad_texte, $ad_titre, $ad_form;

        if ($numero != ''){
            $form = new HTML_Form(current_url().'?action=modifchapitre&id='.ID.'&numero='.$numero, 'formulaire', 90, "Modification activité");
            $detail = $this->sequence_model->readSequence(ID,LOC,$numero);
            for($j=0;$j<$detail['cnt'];$j++)  {
               $form->addRow("Numero", $detail[$j]['numero'] );

                $form->addOption("Selectionner le type de l'activite *  ", "LType", $this->sequence_model->listeTypeActivite(), isset($detail[$j]['type'])?$detail[$j]['type']:0, true);
                $form->addText("Activite", isset($detail[$j]['titre'])?$detail[$j]['titre']:'',true,LG_TA);
                $form->addTextFileManagers("Fichier",isset($detail[$j]['link'])?$detail[$j]['link']:'', CMD_FILE_FORMATION, false);
                $form->addFreeRow();
                $form->addButton("", "Enregister", 'VerifChapitre');

                $form->addFreeRow();
                $form->addTitreText("Scorm", '');
                $form->addText("ID Scorm", (isset($detail[$j]['id_scorm'])?$detail[$j]['id_scorm']:''),'',20);
                $form->addText("Mastery", isset($detail[$j]['mastery'])?$detail[$j]['mastery']:'','',3);
                $form->addTextArea("Description", isset($detail[$j]['description'])?$detail[$j]['description']:'',LG_TA, false);
                $form->addText("Keyword", isset($detail[$j]['keyword'])?$detail[$j]['keyword']:'','',LG_TA);
                $form->addText("Prerequis", isset($detail[$j]['prerequis'])?$detail[$j]['prerequis']:'','',20);
                $form->addText("Niveau (1,2,3)", isset($detail[$j]['niveau'])?$detail[$j]['niveau']:'','',3);
                $form->addTextArea("Launch", isset($detail[$j]['launch'])?$detail[$j]['launch']:'',LG_TA, false);
                $form->addText("Regroupe", isset($detail[$j]['regroupe'])?$detail[$j]['regroupe']:'','',20);
                $form->addSubmit("","VerifChapitre","","Enregister");

            }            
           
        } else{
            $detail = $this->sequence_model->readSequence(ID,LOC);
            $form = new HTML_Form(current_url().'?action=addchapitre&id='.ID,'',90, "Ajouter une activite");

            $form->addOption("Selectionner le type de l'activite *  ", "LType", $this->sequence_model->listeTypeActivite(), isset($detail[NUMERO]['type'])?$detail[NUMERO]['type']:0, true);
            $form->addText("Activite", isset($detail[NUMERO]['titre'])?$detail[NUMERO]['titre']:'',true,LG_TA);
            $form->addTextFileManagers("Fichier",isset($detail[NUMERO]['link'])?$detail[NUMERO]['link']:'', CMD_FILE_FORMATION, false);
            $form->addFreeRow();
            $form->addButton("", "Enregister", 'VerifChapitre');

            $form->addFreeRow();
            $form->addTitreText("Scorm", '');
            $form->addText("ID Scorm", (isset($detail[NUMERO]['id_scorm'])?$detail[NUMERO]['id_scorm']:''),'',20);
            $form->addText("Mastery", isset($detail[NUMERO]['mastery'])?$detail[NUMERO]['mastery']:'','',3);
            $form->addTextArea("Description", isset($detail[NUMERO]['description'])?$detail[NUMERO]['description']:'',LG_TA, false);
            $form->addText("Keyword", isset($detail[NUMERO]['keyword'])?$detail[NUMERO]['keyword']:'','',LG_TA);
            $form->addText("Prerequis", isset($detail[NUMERO]['prerequis'])?$detail[NUMERO]['prerequis']:'','',20);
            $form->addText("Niveau (1,2,3)", isset($detail[NUMERO]['niveau'])?$detail[NUMERO]['niveau']:'','',3);
            $form->addTextArea("Launch", isset($detail[NUMERO]['launch'])?$detail[NUMERO]['launch']:'',LG_TA, false);
            $form->addText("Regroupe", isset($detail[NUMERO]['regroupe'])?$detail[NUMERO]['regroupe']:'','',20);
            $form->addSubmit("","VerifChapitre","","Enregister");
        }

       

        return($form->toHTML());
    }

    
    public function link(){
        $this->global['pageTitle'] = 'E-learning : Broken management';
        $session_key = array();
        $session_key['status-link'] = '';
        $session_key['nb-consult-sorted'] = '';
        $session_key['arraySeq'] = '';
        $session_key['language'] = '';
        $session_key['domaines'] = '';
        $this->session->set_userdata($session_key);
        $data['sequenceList'] = $this->sequence_model->readAll();
        $this->load->library('pagination');

        $data['searchLink'] = '';

        
        if (!empty(is_array($this->session->userdata ('arraySeq'))) || $this->session->userdata ('status-link') != '') {
            $arraySeq = $this->session->userdata ('arraySeq');
            $data['status-link'] = $this->session->userdata ('status-link');
        }

        if(isset($_POST['searchLink'])){
            $keySequenceList          = isset($_POST['searchLink']) ? implode(',', $_POST['searchLink']) : null;

            $seqA = explode(",", $keySequenceList);
            for ($i=0; $i < count($seqA); $i++) { 
                $arraySeq[$i] = (int)($seqA[$i]);
            }
            $session_key['arraySeq'] = $arraySeq;
            $data['searchLink'] = $keySequenceList ;
        }

        if(isset($_POST['status-link'])){
            $data['status-link'] = $_POST['status-link'] ;
            $session_key['status-link'] = (int)$_POST['status-link'] ;
        }
        else{           

            $data['status-link'] = 3;
            $session_key['status-link'] = 3;
        }

        if(isset($_POST['nb-consult-sorted'])){
            $data['nb-consult-sorted'] = $_POST['nb-consult-sorted'] ;
            $session_key['nb-consult-sorted'] = (int)$_POST['nb-consult-sorted'] ;
        }


        if(isset($_POST['language'])){
            $data['language'] = $_POST['language'] ;
            $session_key['language'] = (int)$_POST['language'] ;
        }


        if(isset($_POST['domaines'])){
            $data['domaines'] = $_POST['domaines'] ;
            $session_key['domaines'] = (int)$_POST['domaines'] ;
        }

        $this->session->set_userdata($session_key);

        $data['account']  = $this->sequence_model->getCountListLinkActivityByIdSequence($this->session->userdata ('language'),$this->session->userdata ('domaines'),$this->session->userdata ('arraySeq'),$this->session->userdata ('status-link'));
        $returns = $this->paginationCompress ( "managelink/", $data['account'], 18 );
        $data['linksResults'] = $this->sequence_model->getListLinkActivityByIdSequence($this->session->userdata ('language'),$this->session->userdata ('domaines'),$this->session->userdata ('arraySeq'),$this->session->userdata ('nb-consult-sorted'),$this->session->userdata ('status-link'), $returns["page"], $returns["segment"]); 

        if (isset($_POST['exportLinkToExcel'])) {
            $linksResultsExport = $data['linksResults']; 

            require_once APPPATH.'/libraries/PHPEXCEL/PHPExcel.php';
            $explortName =  'export_link_'.time().'.xlsx';
            $i = 2;
            $phpExcel = new PHPExcel();
            $phpExcel->setActiveSheetIndex(0); 
            $styleArray = array(
                'font' => array(
                    'bold' => true,
                )
            );
            $foo = $phpExcel->getActiveSheet();

            $foo->setCellValue("A1", 'Sequence')
                ->setCellValue("B1", 'Title')
                ->setCellValue("C1", 'Link')
                ->setCellValue("D1", 'Nb consultation')
                ->setCellValue("E1", 'Date of last consultation')
                ->setCellValue("F1", 'Status')
                ->setTitle("Export link - ".time())
                ->getStyle("A1:F1")->applyFromArray($styleArray);
      
            $endCellSequence = 0;
            if (count($linksResultsExport) >= 0) {
                foreach ($linksResultsExport as $res) {
                    $statusText;
                    switch ($res->status_url) {
                        case 1:
                            $statusText = 'Normal link';
                            break;
                        case 2:
                            $statusText = 'Secure link (Internal access to the platform not possible)';
                            break;
                        case 3:
                            $statusText = 'Not found url';
                            break;
                        case 4:
                            $statusText = 'Insecure link (Internal access to the platform not possible)';
                            break;
                        case 5:
                            $statusText = 'Empty link';
                            break;
                        case 6:
                            $statusText = 'Response header false( possibility to Mixed content)';
                            break;
                        case 7:
                            $statusText = 'Not found url';
                            break;
                        default:
                        # code...
                        break;
                    }

                    $startCellSequence = $i;
                    $endCellSequence .= $res->id_sequence;
                    
                    //$foo->setCellValue("A".$i, utf8_encode($this->sequence_model->getNameById($res->id_sequence)).' start : A'.$startCellSequence.' end : A'.$endCellSequence. ' nb : '.$endCellSequence)
                    $foo->setCellValue("A".$i, $this->convert_utf8($this->sequence_model->getNameById($res->id_sequence)))
                        ->setCellValue("B".$i, $this->convert_utf8($res->titre))
                        ->setCellValue("C".$i, $res->final_url != '' ? $res->final_url : str_replace('/redir.php?url=', '', $res->link))
                        ->setCellValue("D".$i, $this->tracking_model->getNbConsultsByIdNum($res->id_sequence,$res->numero))
                        ->setCellValue("E".$i, $this->tracking_model->getDateLastConsultByIdNum($res->id_sequence,$res->numero) != '' ? date('Y-m-d', $this->tracking_model->getDateLastConsultByIdNum($res->id_sequence,$res->numero)) : '')
                        ->setCellValue("F".$i, $this->convert_utf8($statusText));


                    $i++;
                }
            }
            $foo->getColumnDimension("A")->setAutoSize(true);
            $foo->getColumnDimension("B")->setAutoSize(true);
            $foo->getColumnDimension("C")->setAutoSize(true);
            $foo->getColumnDimension("D")->setAutoSize(true);
            $foo->getColumnDimension("E")->setAutoSize(true);
            $foo->getColumnDimension("F")->setAutoSize(true);

            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.basename($explortName).'"');
            header('Cache-Control: max-age=0'); //no cache 
            ob_end_clean();
            $objWriter = PHPExcel_IOFactory::createWriter($phpExcel, "Excel2007");
            $objWriter->save("php://output");
            exit;
        }
   

        $this->loadViews("admin/sequence/linklist", $this->global,$data, NULL );

    }

    public function getStatusByLink(){
        $ret = array();
        if (isset($_POST['link'])) {
            $ret['finalUrl']  = $this->findUltimateDestination($_POST['link'],10);
            $ret['responses'] = $this->getHeaderResponses($_POST['link']);
        }
        echo json_encode($ret);
    }

    public function delActivity(){
        if (isset($_POST['idSequence'])) {
            $data_historique = array(
                'id_user'    => $this->session->userdata('GUSERID'),
                'id_link'    => $_POST['idSequence'],
                'numero'      => $_POST['numero'],
                'action'     => 'Deletion',
                'old_title'  => $this->sequence_model->RequestSeqByIdAndNumero('titre',$_POST['idSequence'],$_POST['numero']),
                'old_link'   => $this->sequence_model->RequestSeqByIdAndNumero('link',$_POST['idSequence'],$_POST['numero']),
                'date'       => time(),
            );

            $this->historique_modif_link_model->add($data_historique);
            $this->sequence_model->deleteActivityByIdSequenceNumero($_POST['idSequence'],$_POST['numero']);
        }
    }

    public function updateLink(){
        $ret['init'] = 'json';
        if (isset($_POST['idSequence'])) {
            if (empty($_POST['link'])) {
                $status = 5;
                $urlF = '';
            }
            else{
                $resultStatus = $this->findStatusUrlFinal($this->findUltimateDestination($_POST['link'],10));
                $status = $resultStatus['status'];
                $urlF = $resultStatus['urlF'];

            }


            $data_historique = array(
                'id_user'    => $this->session->userdata('GUSERID'),
                'id_link'    => $_POST['idSequence'],
                'numero'      => $_POST['numero'],
                'action'     => 'Modification',
                'old_status'     => $this->sequence_model->RequestSeqByIdAndNumero('status_url',$_POST['idSequence'],$_POST['numero']),
                'old_title'  => $this->sequence_model->RequestSeqByIdAndNumero('titre',$_POST['idSequence'],$_POST['numero']),
                'old_link'   => $this->sequence_model->RequestSeqByIdAndNumero('link',$_POST['idSequence'],$_POST['numero']),
                'date'       => time(),
            );

            $this->historique_modif_link_model->add($data_historique);

            $data = array(
                'link' => $urlF,
                'titre' => $_POST['title'],
                'date_create' => time(),
                'final_url' => $urlF,
                'status_url' => $status
            );
            $ret['urlF'] = $urlF;
            $ret['status'] = $status;
            $ret['title'] = $_POST['title'];
            $ret['response'] = $this->sequence_model->updateChapitre($_POST['idSequence'],$_POST['numero'],$data);

            if ($this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['idSequence'],$_POST['numero']) == "" || $this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['idSequence'],$_POST['numero']) == NULL) {
                $width      = "1200";
                $height     = "1280";
                $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
                        
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }   

                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 

                $thumb = $this->generateThumbnail($urlF,$width,$height,$fileLocation);

                if($thumb){
                    $activityInfo = array(
                        "thumbnail_file" => $thumbnailFiles
                    );
                    $this->sequence_model->updateChapitre($_POST['idSequence'],$_POST['numero'],$activityInfo);
                }
            }
        }
        echo json_encode($ret);
    }

    public function editActivite(){
        $return = array();
        if (isset($_POST['activite_sequence_id_modif'])) {

            if ($_POST['activite_type_modif'] == 1) { // add a link
                if ($_POST['activite_content_modif'] == '') {
                    $return = array(
                        'errors' => true,
                        'message'=> 'Veuillez entrer le lien',
                    );
                }
                else{
                    $urlF = $_POST['activite_content_modif'];
                }
            }
            else{ // add a doc
                if($_FILES['activite_content_file_modif']['size'] ==0){
                    $return = array(
                        'errors' => true,
                        'message'=> 'Veuillez selectionner le fichier',
                    );
                }
                else{
                    $repFormation = RP_FORMATION.'activitySequence';    
                    if ( ! is_dir($repFormation) ) {
                        mkdir($repFormation, 0755,true);
                    }
                    $config['upload_path']=$repFormation;      
                    $config['allowed_types']='gif|jpg|png|doc|docx|pdf|ppt|csv|xls|xlsx|mid|wma|ogg|wav|mp3|3gp|3g2|avi|mpg|mp4|mp4a|mp4b, .mp4r|mp4v|mp4p|asf|wmv|wma|flv|nut|rm|mov|mkv|ogg|ogv|oga|ogx|spx|opus|ogm|vob|ifo|webm|weba';
                    $config['encrypt_name'] = TRUE;
                    $config['max_size'] = '300000';                 
                    $this->load->library('upload');
                    $this->upload->initialize($config);  
                    if($this->upload->do_upload("activite_content_file_modif")){
                        $dataUpload = array('upload_data' => $this->upload->data());
                        $urlF = HTTP_FORMATION.'activitySequence/'.$dataUpload['upload_data']['file_name'];
                    }
                    else{
                        $return = array(
                            'errors' => true,
                            'message'=> 'Une erreur est survenu lors du téléchargement du fichier.',
                        );
                    }
                }
            }

            if (isset($urlF) && $urlF != '') {

                $data_historique = array(
                    'id_user'    => $this->session->userdata('GUSERID'),
                    'id_link'    => $_POST['activite_sequence_id_modif'],
                    'numero'      => $_POST['activite_sequence_numero_modif'],
                    'action'     => 'Modification',
                    'old_status'     => $this->sequence_model->RequestSeqByIdAndNumero('status_url',$_POST['activite_sequence_id_modif'],$_POST['activite_sequence_numero_modif']),
                    'old_title'  => $this->sequence_model->RequestSeqByIdAndNumero('titre',$_POST['activite_sequence_id_modif'],$_POST['activite_sequence_numero_modif']),
                    'old_link'   => $this->sequence_model->RequestSeqByIdAndNumero('link',$_POST['activite_sequence_id_modif'],$_POST['activite_sequence_numero_modif']),
                    'date'       => time(),
                );

                $this->historique_modif_link_model->add($data_historique);


                $thumbnailFile         = "";
                $width      = "1200";
                $height     = "1280";
                $date       = time();

                if (isset($_POST['generer_vignette_modif']) && $_POST['generer_vignette_modif'] == 1) {
                    $link_support          = "";
                    $urlFinalThumb         = "";


                    if (isset($urlF) && (strpos($urlF, '.doc') !== false) || (strpos($urlF, '.docx') !== false) || (strpos($urlF, '.ppt') !== false)){
                        $urlFinalThumb = "https://docs.google.com/gview?url=".$urlF."&amp;embedded=true";
                    }
                    elseif (strpos($urlF, '.pdf') !== false || strpos($urlF, '.PDF') !== false){
                        $urlFinalThumb = HTTP_ACTIVITY_SEQUENCE.$urlF;
                    }
                    else { 
                        $urlFinalThumb = $urlF;
                    }


                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }  
                    $thumbnailFiles = "thumbnail_".$date.'_'.$this->session->userdata('GUSERID').'.png';
                    $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 

                    $thumb = $this->generateThumbnail($urlFinalThumb,$width,$height,$fileLocation);

                    if($thumb){
                        $thumbnailFile .=$thumbnailFiles;
                    }
                    else{
                        $thumbnailFile .="";
                        $return = array(
                            'errors' => true,
                            'message'=> 'Une erreur est survenu lors de la génération du vignette.',
                        );
                    } 
                }

                if (isset($_POST['activite_sequence_parent']) && $_POST['activite_sequence_parent'] != $_POST['activite_sequence_id_modif']) {
                    $data = array(
                        'id_sequence'    => $_POST['activite_sequence_parent'],
                        'numero'        => $this->sequence_model->getNextNumBySequence($_POST['activite_sequence_parent']),
                        'link'           => $urlF,
                        'titre'          => $_POST['activite_titre_modif'],
                        'date_create'    => time(),
                        'final_url'      => $urlF,
                        'thumbnail_file' => $thumbnailFile,
                        'status_url'     => 1
                    );
                }
                else{ 
                    $data = array(
                        'link' => $urlF,
                        'titre' => $_POST['activite_titre_modif'],
                        'date_create' => time(),
                        'final_url' => $urlF,
                        'thumbnail_file' => $thumbnailFile,
                        'status_url' => 1
                    );
                }

                $this->sequence_model->updateChapitre($_POST['activite_sequence_id_modif'],$_POST['activite_sequence_numero_modif'],$data);
                $return = array(
                    'errors' => false,
                    'message'=> 'Modification effectué avec succées.',
                );
            }
            else{
                $return = array(
                    'errors' => true,
                    'message'=> 'Une erreur est survenu lors du téléchargement du fichier.',
                );
            }
        }
        echo json_encode($return);
    }

    public function newActivite(){
        $return = array();
        if (isset($_POST)) {
            $fileOrLink = '';
            
            $return['uploadFile'] = true; //initialise upload file
            if ($_POST['activite_type'] == 1) { // add a link
                if ($_POST['activite_content'] == '') {
                    $return = array(
                        'errors' => true,
                        'message'=> 'Veuillez entrer le lien',
                    );
                }
                else{
                    $fileOrLink = $_POST['activite_content'];
                }
            }
            else{ // add a doc
                if($_FILES['activite_content_file']['size'] ==0){
                    $return = array(
                        'errors' => true,
                        'message'=> 'Veuillez selectionner le fichier',
                        //'infosFile'=> $_FILES['activite_content_file'],
                        //'size'=> $_FILES['activite_content_file']['size'],
                    );
                }
                else{
                    $repFormation = RP_FORMATION.'activitySequence';    
                    if ( ! is_dir($repFormation) ) {
                        mkdir($repFormation, 0755,true);
                    }
                    $config['upload_path']=$repFormation;      
                    $config['allowed_types']='gif|jpg|png|doc|docx|pdf|ppt|csv|xls|xlsx|mid|wma|ogg|wav|mp3|3gp|3g2|avi|mpg|mp4|mp4a|mp4b, .mp4r|mp4v|mp4p|asf|wmv|wma|flv|nut|rm|mov|mkv|ogg|ogv|oga|ogx|spx|opus|ogm|vob|ifo|webm|weba';
                    $config['encrypt_name'] = TRUE;
                    $config['max_size'] = '300000';                 
                    $this->load->library('upload');
                    $this->upload->initialize($config);  
                    if($this->upload->do_upload("activite_content_file")){
                        $dataUpload = array('upload_data' => $this->upload->data());
                        $fileOrLink = HTTP_FORMATION.'activitySequence/'.$dataUpload['upload_data']['file_name'];
                    }
                    else{
                        $return = array(
                            'errors' => true,
                            'message'=> 'Une erreur est survenu lors du téléchargement du fichier.',
                        );
                    }
                }
            }

            if (isset($fileOrLink) && $fileOrLink != '') {
                $thumbnailFile         = "";
                $width      = "1200";
                $height     = "1280";
                $date       = time();
                if (isset($_POST['generer_vignette']) && $_POST['generer_vignette'] == 1) {
                    $link_support          = "";
                    $urlF                  = "";


                    if (isset($fileOrLink) && (strpos($fileOrLink, '.doc') !== false) || (strpos($fileOrLink, '.docx') !== false) || (strpos($fileOrLink, '.ppt') !== false)){
                        $urlF = "https://docs.google.com/gview?url=".$fileOrLink."&amp;embedded=true";
                    }
                    elseif (strpos($fileOrLink, '.pdf') !== false || strpos($fileOrLink, '.PDF') !== false){
                        $urlF = HTTP_ACTIVITY_SEQUENCE.$fileOrLink;
                    }
                    else { 
                        $urlF = $fileOrLink;
                    }


                    if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                        mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                    }  
                    $thumbnailFiles = "thumbnail_".$date.'_'.$this->session->userdata('GUSERID').'.png';
                    $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 

                    $thumb = $this->generateThumbnail($urlF,$width,$height,$fileLocation);

                    if($thumb){
                        $thumbnailFile .=$thumbnailFiles;
                    }
                    else{
                        $thumbnailFile .="";
                        $return = array(
                            'errors' => true,
                            'message'=> 'Une erreur est survenu lors de la génération du vignette.',
                        );
                    } 
                }
                $data = array(
                    'id_sequence'         => $_POST['activite_sequence_id'],
                    'titre'               => $_POST['activite_titre'],
                    'numero'              => $this->sequence_model->getNextNumBySequence($_POST['activite_sequence_id']),
                    'link'                => $fileOrLink,
                    'norme'               => 0,
                    'type'                => 1, //transform all news activity to link in 04-09-2024 by Alexandre
                    //'type'                => $_POST['activite_type'],
                    'id_scorm'            => 0,
                    'mastery'             => 0,
                    'max_time'            => '',
                    'description'         => '',
                    'keyword'             => '',
                    'prerequis'           => '',
                    'niveau'              => 0,
                    'launch'              => true,
                    'regroupe'            => false,
                    'status'              => 1,
                    'date_create'         => time(),
                    'thumbnail_file'      => $thumbnailFile,
                    'ifrmaccess'          => 0,
                    'final_url'           => $fileOrLink,
                    'status_url'          =>1,
                    'new'                 => 0,
                    'date_modification'   => time(),
                    'user_create'         => $this->session->userdata ('GUSERID')
                );
                $this->sequence_model->addContentSequence($data);
                $return = array(
                    'errors'  => false,
                    'message' => 'Données enregister avec succées',
                );
            }
           
        }
        else{
            $return = array(
                'errors' => true,
                'message'=> 'Veuillez remplir le formulaire',
            );
        }
        echo json_encode($return);
    }

    public function uploadThumbActivity(){
        $return = array();
        ini_set('max_execution_time', 300); //300 seconds = 5 minutes
        if(isset($_FILES["fileThumbNailContent"]) && $_FILES["fileThumbNailContent"]["error"] == 0){
            
            $filesThumb=$_FILES['fileThumbNailContent'];
            $tmp_name_thumb=$filesThumb['tmp_name'];


            $thumbnailFiles = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
            
            if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
            }  

            $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 

            $uploadFile = move_uploaded_file($tmp_name_thumb, $fileLocation);
            $return['uploadFileUrl'] = base_url().'groupes/ACTIVITES/'.$thumbnailFiles;
            $return['uploadFile'] = $uploadFile;

            $data = array(
                'thumbnail_file' => $thumbnailFiles,
                'user_create' => $this->session->userdata('GUSERID'),
                'date_modification' => time(),
            );
                
            $return['message'] = array(
                'status' => 'update', 
                'infos' => $this->sequence_model->updateChapitre($_POST['sequence_id'],$_POST['sequence_num'],$data), 
            );

        }

        echo json_encode($return);
        
    }

    public function getContentPlateforme(){
        $return = array();
        $htmlRetour = '';
        
        $id_groupe = isset($_POST['id_groupe']) ? $_POST['id_groupe'] : NULL;
        $key       = isset($_POST['keys']) ? $_POST['keys'] : '';
        $contentId = isset($_POST['content_id']) ? $_POST['content_id'] : NULL;
        $domaineId = isset($_POST['domaine_id']) ? $_POST['domaine_id'] : '';
        if (isset($_POST['content'])) {
            $contentType = $_POST['content'];
            $contentResults = $this->loadContentPlateforme($contentType, $key);            
            //Data traitement for view
            if (isset($contentResults)) {
                for ($h=0; $h < count($contentResults); $h++) { 
                    $htmlRetour .= '<ul id="formationPedagogiqueContent">';
                        $htmlRetour .= '<li class="conatainerFormationPedagogique">';
                            $htmlRetour .= '<span class="contenuFormationPedagogiqueContent">'.$contentResults[$h]['data']['domaine']['name'].'</span>'; 
                            $htmlRetour .= '<ul class="contenuFilsFormationPedagogiqueContent active">';
                            $domaine_id = $contentResults[$h]['data']['domaine']['id'];
                            $matieres = $contentResults[$h]['data']['matieres'];
                            for ($m=0; $m < count($matieres) ; $m++) { 
                                $htmlRetour .= '<li class="conatainerFormationPedagogique">';
                                    $htmlRetour .= '<span class="contenuFormationPedagogiqueContent">'.$matieres[$m]['name'].'</span>'; 
                                    $htmlRetour .= '<ul class="contenuFilsFormationPedagogiqueContent active">';
                                        for ($t=0; $t < count($matieres[$m]['contents']) ; $t++) {
                                            $ItemIsValid = $this->formations_model->ItemIsValid($matieres[$m]['contents'][$t]['id'],-1,$contentType,$id_groupe,1);
                                            if (isset($matieres[$m]['contents'][$t]['name'])) {
                                                $htmlRetour .= (isset($ItemIsValid) && $ItemIsValid >= 1) ? '<li class="conatainerFormationPedagogique bo-d-flex" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" data-key="'.$matieres[$m]['contents'][$t]['name'].'"><a href="#" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" class="btn-group-link-bo el-btn-circle-pink btn-green"><i class="bx bx-check"></i></a>&nbsp;&nbsp;'.$matieres[$m]['contents'][$t]['name'].'</li>' : '<li class="conatainerFormationPedagogique bo-d-flex" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" data-key="'.$matieres[$m]['contents'][$t]['name'].'"><div class="spinner-border text-pink d-none" role="status"><span class="visually-hidden">Loading...</span></div><a href="#" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" data-content-post="'.$contentId.'" data-domaine-post="'.$domaineId.'" class="btn-group-link-bo el-btn-circle-pink" onClick="addItemFormation(this, '.$contentType.', '.$matieres[$m]['contents'][$t]['id'].', '.$id_groupe.', '.$domaine_id.')"><i class="bx bx-plus"></i></a>&nbsp;&nbsp;'.$matieres[$m]['contents'][$t]['name'].'</li>';
                                            }
                                        }
                                    $htmlRetour .= '</ul>';
                                $htmlRetour .= '</li>';
                            }

                            $htmlRetour .= '</ul>';
                        $htmlRetour .= '</li>';
                    $htmlRetour .= '</ul>';
                }
            }

            $return['curent_groupe']  = $id_groupe;
            $return['contentType']    = isset($_POST['content']) ? $_POST['content'] : null;
            $return['contentResults'] = $contentResults;
            $return['htmlRetour']     = $htmlRetour;
        }
        echo json_encode($return);
    }
}

?>