<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Parcours extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('matieres_model');
        $this->load->model('sessions_model');
        $this->load->model('formations_model');
        $this->load->model('domaines_model');
        $this->load->model('admin_model');
        $this->isLoggedIn();   
        
    }
  
    public function index(){
        $this->global['pageTitle'] = 'E-learning : Gestion des parcours';
        $view = '';
        if (isset($_GET['id'])) {
            $view = 'admin/parcours/edit';
            $data['matieresResults']        = $this->matieres_model->readAll(-1);
            $data['contentParcoursResults'] = $this->parcours_model->readParcours($_GET['id'],1);
        }
        else{
            $view = 'admin/parcours/list';
            $data['parcoursResults'] = $this->loadContentPlateforme(2, '');
            //var_dump($data['parcoursResults']);
            //die();
        }

        $data['domaineResults'] = $this->domaines_model->getAll(); 

        $this->loadViews($view, $this->global,$data, NULL );
    }

    public function updateParcours(){
        if (isset($_POST['parcours_titre']) && isset($_POST['code'])) {
            $dataParcours = array(
                'parcours_titre' => $_POST['parcours_titre'], 
                'code'           => $_POST['code'], 
                'domaine_id'     => $_POST['domaine_id'], 
                'matiere_id'     => $_POST['matiere_id'], 
                'parcours_objectifs'     => $_POST['parcours_objectifs'], 
            );
            $this->parcours_model->update($_POST['parcours_id'],$dataParcours);
            redirect("manageparcours?id=".$_POST['parcours_id'],"refresh");
        }
    }

    public function list(){
        $ret = '';
        define("DETAILS", 0);
        define("IDM", 0);
        $id_ref = -1 ;

        $action = array() ;
  
        $dom = $this->domaines_model->read();
        
        for($i=0;$i<$dom['cnt'];$i++)  {
            $ret .= '<li><span class="domaineName">'.$dom[$i]['name'].'</span>
                <ul class="materialmenu">';

            $par = $this->parcours_model->readByDomaineThreeView($dom[$i]['id']);
            //var_dump($par);
            for($j=0;$j<$par['cnt'];$j++)  {
                $name_mat = $this->matieres_model->read($par[$j]['matiere_id']) ;
                /*if(!in_array($name_mat['name'], $name_mat)){    
                    if ($par[$j]['matiere_id'] != $id_ref ) {
                        $name = $par[$j]['matiere_id']==0?'Aucun':$name_mat['name'];
                        $id_ref = $par[$j]['matiere_id'] ;
                    }

                    if (isset($par[$i]['matiere_id']) && $par[$i]['matiere_id'] != $id_ref ) {

                        $name = $par[$i]['matiere_id']==0?'Aucun':$name_mat['name'];
                        if ( IDM==$par[$i]['matiere_id'] ) {

                            $ret .= '<li class="material"><span class="materialName" style="color:brown;font-weight:bold;">&nbsp;&nbsp;'.$name.'</span></li>';

                        } 
                        else {
                            $ret .= '<li class="material"><span class="materialName" style="color:brown;font-weight:bold;">&nbsp;&nbsp;'.$name.'</span></li>';

                        }

                        $id_ref = $par[$i]['matiere_id'] ;

                    }
                }*/
           


                if ( IDM!=$par[$j]['matiere_id'] ) continue;

                //if ($this->formations_model->ItemIsValid($par[$j]['id'],$this->session->userdata ('GUSERID'),TYPE_PARCOURS,$this->session->userdata ('STAGIAIREGRP'),1) >= 1) {
                if ($this->formations_model->ItemIsValid($par[$j]['id'],-1,TYPE_PARCOURS,$this->session->userdata ('STAGIAIREGRP'),1) >= 1) {

                    $ret .= '<li class="material"><span class="materialName" style="color:brown;font-weight:bold;">&nbsp;&nbsp;'.$par[$j]['titre'].'</span></li>';

                } else {

                    $ret .= '<li class="material">
                        <a data-mat="'.$par[$j]['matiere_id'].'" onclick="addItemsFormation(this);" data-id="'.$par[$j]['id'].'" data-domaine="'.$par[$j]['domaine_id'].'" title="Add parcours" href="#" class="btn btn-success btn-action-el add-parcours-program"><span class="glyphicon glyphicon-plus-sign"></span></a><span class="materialName">&nbsp;&nbsp;'.$par[$j]['titre'].'</span>
                    </li>';

                }
                

                if ( DETAILS == 1 ) {
                }
            }

            
            $ret .= '</ul></li>';
        }
        echo $ret;
    }

    public function deletematerial(){
        $id = $this->input->post('id');
        $this->matieres_model->del($id) ;
        $this->sequence_model->delMatiere($id);
        $this->modules_model->delMatiere($id);
        $this->parcours_model->delMatiere($id);
    }

    public function delete(){
        $id = $this->input->post('idDomains');
        $this->domaines_model->del($id) ;
        $this->matieres_model->delAll($id) ;
        $this->sequence_model->delDomaine($id);
        $this->modules_model->delDomaine($id);
        $this->parcours_model->delDomaine($id);
        return true;
    }
  
    public function add(){
        $name   = $this->input->post('domain_name');
        $id     = $this->domaines_model->add($name);
        redirect("/managedomains","refresh");
    }

    public function edit(){
        
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->domaines_model->update($id, $name);
        echo "###".$id."###";
    }

    public function editmatiere(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->matieres_model->update($id, $name);
        echo "###".$id."###";
    }

    public function addmaterial(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $id     = $this->matieres_model->add($name, $id);
        echo "###".$id."###";
    }

    public function showall(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $dom            = $this->domaines_model->read(-1,LOC);
        $ret            = "";
        //$cursor         = "";
        for($i=0;$i<$dom['cnt'];$i++)  {
            /*$mat = $this->matieres_model->readAll($dom[$i]['id']);
            for ($j=0;$j<$mat['cnt'];$j++) {
                if ($mat[$j]['id']==$idMaterial) {
                    # code...
                }
            }*/
            if ( in_array($dom[$i]['id'],$idDomains) ) {
                $cursor         = "not-allowed";
            } 
            else {
                $cursor         = "pointer";
            }
            $ret .= '<p><a class="movematerials" onclick="movematerial(this);">';
            $ret .= '<input type="hidden" class="materialid" value="'.$idMaterial.'">';
            $ret .= '<input type="hidden" class="domainsid" value="'.$dom[$i]['id'].'">';
            $ret .= '<span class="glyphicon glyphicon-plus" style="cursor:'.$cursor.';"></span>&nbsp;&nbsp;'.$dom[$i]['name'].'</a></p>';
        }
        echo "###".$ret."###";
    }

    public function movematerial(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $this->matieres_model->move($idMaterial,$idDomains,LOC);
        $this->sequence_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->modules_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->parcours_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);

    }

    public function ajaxDelete(){
        if (isset($_POST['idParcours'])) {
            $this->admin_model->SupprimerItemFormation(-1,-1,-1,-1,-1,$_POST['idParcours'],1,$_POST['idGroupes']);
            return true;
        }
    }

    public function deleteParcoursAdmin(){
        if (isset($_POST['idParcours'])) {
            echo $this->parcours_model->del($_POST['idParcours']);
        }
    }

    public function addNew(){
        $return = array();
        if (isset($_POST['dataParcours'])) {
            $idParcours = $this->admin_model->ajouterUnParcours($_POST['dataParcours']['title'],$_POST['dataParcours']['code'],-1,$_POST['dataParcours']['objectives'],0,-1);
            $dataParcoursUpdate = array(
                'domaine_id'     => $_POST['dataParcours']['domaine_select'],
                'matiere_id'     => $_POST['dataParcours']['matiere_select']
            ); 
            $this->parcours_model->update($idParcours,$dataParcoursUpdate);
            $parcoursInfosData = $this->afficheDetailParcours($idParcours,-1,false);
            $return['parcoursInfosData'] = array();
            foreach($parcoursInfosData as $p){

                $return['parcoursInfosData'] = array(
                    'item_id'  => $p->item_id,
                    'ordre'    => $p->ordre,
                    'type'     => $p->type,
                    'loc'      => $p->loc
                );  
            }
            $return['sequencesInfosData'] = $this->sequence_model->readByDomaineThreeView(0,1,'');
            $return['modulesInfosData']   = $this->modules_model->getAll();
            $return['idParcours'] = $idParcours;

            echo json_encode($return);
        }
    }

    public function getDetail(){
        $return = array();
        $i = 0;
        if (isset($_POST['idParcours'])) {
            $parcoursInfosData = $this->parcours_model->getInfosById($_POST['idParcours'],-1,false);
            foreach($parcoursInfosData as $p){

                $return['parcoursInfosData'] = array(
                    'parcours_titre'  => $p->parcours_titre,
                    'parcours_objectifs'    => $p->parcours_objectifs,
                    'parcours_duree'     => $p->parcours_duree,
                    'auteur_id'     => $this->membres_model->Request('prenom',$p->auteur_id).' '.$this->membres_model->Request('nom',$p->auteur_id),
                    'code'      => $p->code,
                    'domaine_id'      => $p->domaine_id,
                    'domaine_name'      => $this->domaines_model->Request('name',$p->domaine_id),
                    'matiere_name'      => $this->matieres_model->Request('name',$p->matiere_id),
                    'matiere_id'      => $p->matiere_id
                ); 
            }
            $parcoursInfosDataContent = $this->parcours_model->readParcours($_POST['idParcours'],-1,false);
            foreach($parcoursInfosDataContent as $pc){
                $return['parcoursInfosDataContent'][$i]= array(
                    'data_type'=> ($pc->type == TYPE_SEQUENCE) ? 'sequences' :'modules',
                    'item_id'  => $pc->item_id,
                    'ordre'    => $pc->ordre,
                    'type'     => $pc->type,
                    'name'     => ($pc->type == TYPE_SEQUENCE) ? $this->sequence_model->Request('sequence_titre',$pc->item_id) : $this->modules_model->Request('module_titre',$pc->item_id),
                    'loc'      => $pc->loc
                );
                $i++;
            }
            $return['sequencesInfosData'] = $this->sequence_model->readByDomaineThreeView(0,1,'');
            $return['modulesInfosData']   = $this->modules_model->getAll();

            echo json_encode($return);
        }
    }

    public function afficheDetailParcours($idp,$loc,$position=false){
        return $this->parcours_model->readParcours($idp,$loc);
    }
    public function addSequence(){
        if (isset($_POST['idParcours']) && isset($_POST['sequence_id'])) {
           echo $this->admin_model->ajouterUneSequenceParcours($_POST['idParcours'],$_POST['sequence_id'],1);
        }
    }
    public function addModule(){
        if (isset($_POST['idParcours']) && isset($_POST['module_id'])) {
           echo $this->admin_model->ajouterUnModuleParcours($_POST['idParcours'],$_POST['module_id'],1);
        }
    }

    public function addParcoursV3(){
        if (isset($_POST)) {
            $data = array(
                'parcours_titre'     => $_POST['parcours_titre'],
                'parcours_objectifs' => $_POST['parcours_objectifs'],
                'auteur_id'          => $this->session->userdata ('GUSERID'),
                'code'               => 'P'.$this->parcours_model->getMaxId(),
                'domaine_id'         => $_POST['domaine_id'],
                'matiere_id'         => isset($_POST['matiere_id']) ? $_POST['matiere_id'] : 0,
                'parcours_type'      => 0,
            );

            $id = $this->parcours_model->addV3($data);

            redirect("/manageparcours?id=".$id,"refresh");
        }
    }

    public function deleteContentParcoursV3(){
        $trakingParams  = array();
        $parcoursParams = array();
        if (isset($_POST['content_id']) && isset($_POST['content_type'])) {
            switch ($_POST['content_type']) {
                case TYPE_SEQUENCE: //TYPE_SEQUENCE
                    $trakingParams = array(
                        'sequence_id' => $_POST['content_id'],
                        'type' => array(7,8),
                    );
                    $parcoursParams = array(
                        'parcours_id'   => $_POST['content_parant_id'],
                        'item_id' => $_POST['content_id'],
                        'type' => TYPE_SEQUENCE,
                    );
                    $this->formations_model->delItem(-1,$_POST['content_id'],1,-1,1,$_POST['content_parant_id'],1,-1);
                    //$this->tracking_model->deleteByParams($trakingParams);
                    //$this->sequence_model->del($_POST['content_id']);
                    //$this->modules_model->delSequence(-1,$_POST['content_id'],1);
                    //$this->parcours_model->delContentByParams($parcoursParams);
                    break;
                case TYPE_MODULE: //TYPE_MODULE
                    $trakingParams = array(
                        'module_id'   => $_POST['content_id'],
                        'type' => array(7,8),
                    );
                    $parcoursParams = array(
                        'parcours_id'   => $_POST['content_parant_id'],
                        'item_id' => $_POST['content_id'],
                        'type' => TYPE_MODULE,
                    );
                    $this->formations_model->delItem(-1,-1,1,$_POST['content_id'],1,$_POST['content_parant_id'],1,-1);
                    
                    break;
                default:
                    // code...
                    break;
            }

            $this->tracking_model->deleteByParams($trakingParams);
            $this->parcours_model->delContentByParams($parcoursParams);

            redirect("/manageparcours?id=".$_POST['content_parant_id'],"refresh");
        }
    }

    public function ajaxDeleteContentParcoursV3(){
        $return         = array();
        $trakingParams  = array();
        $parcoursParams = array();
        if (isset($_POST['content_id']) && isset($_POST['content_type'])) {
            switch ($_POST['content_type']) {
                case TYPE_SEQUENCE: //TYPE_SEQUENCE
                    $trakingParams = array(
                        'sequence_id' => $_POST['content_id'],
                        'type' => array(7,8),
                    );
                    $parcoursParams = array(
                        'parcours_id'   => $_POST['content_parant_id'],
                        'item_id' => $_POST['content_id'],
                        'type' => TYPE_SEQUENCE,
                    );
                    $this->formations_model->delItem(-1,$_POST['content_id'],1,-1,1,$_POST['content_parant_id'],1,-1);
                    //$this->tracking_model->deleteByParams($trakingParams);
                    //$this->sequence_model->del($_POST['content_id']);
                    //$this->modules_model->delSequence(-1,$_POST['content_id'],1);
                    //$this->parcours_model->delContentByParams($parcoursParams);
                    break;
                case TYPE_MODULE: //TYPE_MODULE
                    $trakingParams = array(
                        'module_id'   => $_POST['content_id'],
                        'type' => array(7,8),
                    );
                    $parcoursParams = array(
                        'parcours_id'   => $_POST['content_parant_id'],
                        'item_id' => $_POST['content_id'],
                        'type' => TYPE_MODULE,
                    );
                    $this->formations_model->delItem(-1,-1,1,$_POST['content_id'],1,$_POST['content_parant_id'],1,-1);
                    
                    break;
                default:
                    // code...
                    break;
            }

            $return['tracking_model'] = $this->tracking_model->deleteByParams($trakingParams);
            $return['parcours_model'] = $this->parcours_model->delContentByParams($parcoursParams);

        }
        echo json_encode($return);
    }

    public function getContentPlateforme(){
        $return = array();
        $htmlRetour = '';
        
        $key       = isset($_POST['keys']) ? $_POST['keys'] : '';
        $parcoursId = isset($_POST['parcours_id']) ? $_POST['parcours_id'] : NULL;
        if (isset($_POST['content_type'])) {
            $contentType = $_POST['content_type'];
            $contentResults = $this->loadContentPlateforme($contentType, $key);            
            //Data traitement for view
            if (isset($contentResults)) {
                for ($h=0; $h < count($contentResults); $h++) { 
                    $htmlRetour .= '<ul id="formationPedagogiqueContent">';
                        $htmlRetour .= '<li class="conatainerFormationPedagogique">';
                            $htmlRetour .= '<span class="contenuFormationPedagogiqueContent">'.$contentResults[$h]['data']['domaine']['name'].'</span>'; 
                            $htmlRetour .= '<ul class="contenuFilsFormationPedagogiqueContent active">';
                            $domaine_id = $contentResults[$h]['data']['domaine']['id'];
                            $matieres = $contentResults[$h]['data']['matieres'];
                            for ($m=0; $m < count($matieres) ; $m++) { 
                                $htmlRetour .= '<li class="conatainerFormationPedagogique">';
                                    $htmlRetour .= '<span class="contenuFormationPedagogiqueContent">'.$matieres[$m]['name'].'</span>'; 
                                    $htmlRetour .= '<ul class="contenuFilsFormationPedagogiqueContent active">';
                                        for ($t=0; $t < count($matieres[$m]['contents']) ; $t++) {
                                            $itemIsExist = $this->parcours_model->getContentByParams($parcoursParams = array('parcours_id'=> $parcoursId,'item_id' => $matieres[$m]['contents'][$t]['id'],'type' => $contentType));
                                            if (isset($matieres[$m]['contents'][$t]['name'])) {
                                                $htmlRetour .= (isset($itemIsExist) && count($itemIsExist) >= 1) ? '<li class="conatainerFormationPedagogique bo-d-flex" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" data-key="'.$matieres[$m]['contents'][$t]['name'].'"><a href="#" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" class="btn-group-link-bo el-btn-circle-pink btn-green"><i class="bx bx-check"></i></a>&nbsp;&nbsp;'.$matieres[$m]['contents'][$t]['name'].'</li>' : '<li class="conatainerFormationPedagogique bo-d-flex" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" data-key="'.$matieres[$m]['contents'][$t]['name'].'"><div class="spinner-border text-pink d-none" role="status"><span class="visually-hidden">Loading...</span></div><a href="#" data-ident="content_'.$matieres[$m]['contents'][$t]['id'].'" class="btn-group-link-bo el-btn-circle-pink" onClick="addItemParcours(this, '.$parcoursId.', '.$contentType.', '.$matieres[$m]['contents'][$t]['id'].')"><i class="bx bx-plus"></i></a>&nbsp;&nbsp;'.$matieres[$m]['contents'][$t]['name'].'</li>';
                                            }
                                        }
                                    $htmlRetour .= '</ul>';
                                $htmlRetour .= '</li>';
                            }

                            $htmlRetour .= '</ul>';
                        $htmlRetour .= '</li>';
                    $htmlRetour .= '</ul>';
                }
            }

            $return['parcoursId']     = $parcoursId;
            $return['contentType']    = isset($_POST['content_type']) ? $_POST['content_type'] : null;
            $return['contentResults'] = $contentResults;
            $return['htmlRetour']     = $htmlRetour;
        }
        echo json_encode($return);
    }

    public function addContentPlateforme(){
        $return = array();
        if (isset($_POST['parcours_id'])) {
            $return['traitement'] = $this->parcours_model->addItem($_POST['parcours_id'],$_POST['content_id'],$_POST['content_type'],1);
        }
        echo json_encode($return);
    }

    public function ajaxDeleteV3(){
        $return = array();
        if (isset($_POST['parcours_id'])) {
            $parcoursParams = array(
                'parcours_id'   => $_POST['parcours_id'],
            );
            $return['formations_model'] = $this->formations_model->delItem(-1,-1,1,-1,1,$_POST['parcours_id'],1,-1);
            $return['parcours_model']    = $this->parcours_model->del($_POST['parcours_id']);
        }
        echo json_encode($return);
    }

}

?>