// Création dynamique des objets pour scales, rotations et positions
var scales = {};
var rotations = {};
var positions = {};

// Appliquer Wheelzoom et initialiser chaque image après le chargement de la page
window.onload = function() {
    var images = document.querySelectorAll('.img-zoom');
    images.forEach(function(image) {
        var imageId = image.id;

        // Initialiser les valeurs par défaut de zoom, rotation et position pour chaque image
        scales[imageId] = 1;
        rotations[imageId] = 0;
        positions[imageId] = { x: 0, y: 0 };

        wheelzoom(image,
            { 
                zoomOnWheel: false
             }
        );  // Active Wheelzoom sur chaque image
        enableDrag(image); // Activer le déplacement avec la souris
    });
};

// Fonction pour zoomer
function zoomIn(imageId) {
    scales[imageId] += 0.5;  // Augmente l'échelle
    applyTransform(imageId);
}

function zoomOut(imageId) {
    scales[imageId] = Math.max(0.1, scales[imageId] - 0.5);  // Diminue l'échelle
    applyTransform(imageId);
}

// Fonction pour la rotation
function rotateLeft(imageId) {
    rotations[imageId] -= 45;  // Rotation de 15 degrés vers la gauche
    applyTransform(imageId);
}

function rotateRight(imageId) {
    rotations[imageId] += 45;  // Rotation de 15 degrés vers la droite
    applyTransform(imageId);
}

// Appliquer les transformations de zoom, rotation, et déplacement
function applyTransform(imageId) {
    var image = document.getElementById(imageId);
    var pos = positions[imageId];
    image.style.transform = `translate(${pos.x}px, ${pos.y}px) scale(${scales[imageId]}) rotate(${rotations[imageId]}deg)`;
}

// Fonction pour activer le déplacement avec la souris
function enableDrag(image) {
    let isDragging = false;
    let startX = 0, startY = 0;
    let currentX = 0, currentY = 0;

    image.addEventListener('mousedown', function(e) {
        isDragging = true;
        startX = e.clientX - currentX;
        startY = e.clientY - currentY;
        image.style.cursor = 'grabbing';
    });

    window.addEventListener('mousemove', function(e) {
        if (isDragging) {
            currentX = e.clientX - startX;
            currentY = e.clientY - startY;
            positions[image.id].x = currentX;
            positions[image.id].y = currentY;
            applyTransform(image.id);
        }
    });

    window.addEventListener('mouseup', function() {
        isDragging = false;
        image.style.cursor = 'grab';
    });
}