var mediaConstraints = {
  audio: true
};
var mediaRecorder;

$(document).ready(function(){

  if ($('#main-slider-janvier').length >= '1') {
    loadSlideBoosterImg();
  }

  $('.stat-modal-expression').each(function(){
    var modal = $(this);
    var idExpressionModal = modal.attr('data-expression-id');
    var originExpressionModal = modal.attr('data-expression-origin');
    var container = modal.attr('id');
    setVideoStats(container,originExpressionModal,'',idExpressionModal);
  });
  //setVideoStats('stat-modal-expression4907','so in this example, our conversation has been recorded with this video','',4907);

  $('.close-modal-stat').click(function(e){
    e.preventDefault();
    $('.stat-modal-expression').removeClass('open');
  });



  $('.picture-nav-item-list').click(function(e){
    console.log('ato');
    $('.spinner').fadeIn('slow');
    e.preventDefault();
    $('.bs-btn-list').click();
    $('.link-list-media-item').removeClass('active');
    $('.media-nav-item-list').removeClass('active');
    var ident = nav.attr('data-ident');

    $.ajax({
      url : 'get-picture-content',
      type: 'post',
      data: { ident : ident },
      dataType: 'json',
      success: function(result){
        console.log(result);
        /*$('.container-media').html(result.htmlContent);
        var loaderStat = loadStat(result.idExpression,result.originalTexto);
        $('#stat-modal-expression').attr('data-expression-id',result.idExpression);
        $('#stat-modal-expression').attr('data-expression-origin',result.originalTexto);
        */
        $('.spinner').fadeOut('slow');
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
        console.log(error);
        console.log(msg);
      }
    });
  });


  $('.media-nav-item-list').click(function(e){
    e.preventDefault();
    $('.bs-btn-list').click();
    $('.link-list-media-item').removeClass('active');
    $('.media-nav-item-list').removeClass('active');
    $('.modal').removeClass('open');
    $('.spinner').fadeIn('slow');
    var nav = $(this);
    var urlGetInfosMediaContent = '';
    var id = '';
    var origin = '';
    var id = nav.attr('data-id');
    var mediaType = nav.attr('data-type');
    console.log('mediaType : ' + mediaType);
    nav.addClass('active');
    $('.container-media').attr('data-id',id);

    if (mediaType == 'audio') {
      urlGetInfosMediaContent = $('.baseURL').val()+'get-audio-content-by-expression-id';
      id = nav.attr('data-audio-id');
      origin = nav.attr('data-content-origin');
    }
    else{
      urlGetInfosMediaContent = $('.baseURL').val()+'get-media-content-by-expression-id';
      id = id.replace("vieo_", "");
    }

    $.ajax({
      url: urlGetInfosMediaContent,
      type: 'POST',
      data: {id : id.replace("vieo_", ""), origin : origin},
      dataType: 'json',
      success: function(result){
        //console.log(result);
        $('.container-media').html(result.htmlContent);
        var loaderStat = loadStat(result.idExpression,result.originalTexto);
        $('#stat-modal-expression').attr('data-expression-id',result.idExpression);
        $('#stat-modal-expression').attr('data-expression-origin',result.originalTexto);
        if (mediaType == 'audio') {
          if (result.originalTexto != "") {
            setVideoStats('analyse-lexicale',result.originalTexto,'',result.idExpression);     
          }
          else{
            $('.stat_duration').html('0');
            $('.stat_words').html('0');
            $('.stat_happaxes').html('0');
            $('.stat_debit').html('0');
            $('.stat_verbs').html('0');
            $('.stat_adjectif').html('0');
            $('.stat_active_voice').html('0');
            $('.stat_passive_voice').html('0');
          }
          $('.comment-audio').val(result.comment);
          $('.comment-audio').attr('data-id-expression',result.idExpression);
        }
        else{
          setVideoStats('stat-modal-expression',result.originalTexto,'',result.idExpression);     
        }
        
        if (loaderStat) {   
          $('.spinner').fadeOut('slow');
        }
        else{
          //toastr.error('An error appeared while loading statistics')
          $('.spinner').fadeOut('slow');
        }
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
        console.log(error);
        console.log(msg);
      }
    });
    $('.spinner').fadeOut('slow');
  });

  $('.audio-nav-item-list').click(function(e){
    e.preventDefault();
    $('.bs-btn-list').click();
    $('.link-list-media-item').removeClass('active');
    $('.video-nav-item-list').removeClass('active');
    $('.spinner').fadeIn('slow');
    var nav = $(this);
    var id = nav.attr('data-id');
    nav.addClass('active');
    $('.container-media').attr('data-id',id);

    $.ajax({
      url: $('.baseURL').val()+'get-audio-content-by-expression-id',
      type: 'POST',
      data: {id : id.replace("audio_", "")},
      dataType: 'json',
      success: function(result){
        console.log(result);
        $('.container-media').html(result.htmlContent);
        var loaderStat = loadStat(result.idExpression,result.originalTexto);
        $('#stat-modal-expression').attr('data-expression-id',result.idExpression);
        $('#stat-modal-expression').attr('data-expression-origin',result.originalTexto);
        setVideoStats('stat-modal-expression',result.originalTexto,'',result.idExpression);     
        if (loaderStat) {   
          $('.spinner').fadeOut('slow');
        }
        else{
          //toastr.error('An error appeared while loading statistics')
          $('.spinner').fadeOut('slow');
        }
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
        console.log(error);
        console.log(msg);
      }
    });
    $('.spinner').fadeOut('slow');
  });

  $('.audio-statistics').each(function(){
    var div = $(this);
    var idExpression = div.attr('data-expression-id');
    var originalTexto = div.attr('data-expression-origin');
    loadStat(idExpression,originalTexto);
  });


  $('.btn-edit-content-cible').click(function(e){
    e.preventDefault();
    $('.spinner').fadeIn('slow');
    var btn = $(this);
    var idExpression = btn.attr('data-btn-id');
    $('.content-cible').each(function(){
      var textarea = $(this);
      if (btn.attr('data-btn-id') == textarea.attr('data-content-id')) {
        var contents = textarea.val();
        $.ajax({
          url: $('.baseURL').val()+'edit-expression-cible',
          type: 'POST',
          data: {idExpression : idExpression, contentCible : contents},
          dataType: 'json',
          success: function(result){
            console.log(result);
            $('.spinner').fadeOut('slow');
          },
          error: function(error, msg){
            $('.spinner').fadeOut('slow');
            console.log(error);
            console.log(msg);
          }
       });
      }
    });
  });


  $("#btn-record").click(function(){
    captureUserMedia(mediaConstraints, onMediaSuccess, onMediaError);
    disablerec();
    disablesave();
    activestp();
  });

  $('#btn-stop-record').click(function(){
    mediaRecorder.stop();
    mediaRecorder.stream.stop();
    disablestp();
    activerec();
    activeSave();
    // 
    document.getElementById('video-rework-container').pause();
    //document.getElementById('videomain').currentTime = 0;
  });

  $('#btn-save-record').click(function(){
    disablesave();
    $('#div-rework-audio').fadeIn('slow');
  });

  $('#form-rework-audio').on('submit', function(e){
    e.preventDefault();
    //console.log('currentPage : ' + $('#currentPage').val());
    var form = $(this);
    formData.append('fname', $('#textboxname').val());
    formData.append('legende_f', $('#new_legende').val());
    formData.append('id_stagiaire', $('#traineeId').val());
    formData.append('id_groupe', $('#traineeGroupe').val());
    formData.append('infolangue', $('#langChoice').val());
    formData.append('idexp', $('#expressionidRework').val());
    formData.append('repertoireGroupe', $('#repertoireGroupe').val());
    formData.append('urlBaseAudio', $('#urlBaseAudio').val());
    $('.spinner').fadeIn('slow');
    /*console.log(formData);
    for (const value of formData.values()) {
      console.log(value);
    }*/
    $.ajax({
      url: form.attr('action'),
      type: form.attr('method'),
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function(result){
        console.log(result);
        $('.spinner').fadeOut('slow');
        form.fadeOut('slow');
        disablestp();
        activerec();
        disablesave();
        setTimeout('location.reload(true);','3000');
      },
      error: function(error, msg){
        $('.spinner').fadeOut('slow');
        console.log(error);
        console.log(msg);
      }
    });
  });
});

function loadStat(idExpression, originalTexto){
  var ret = false;
  var settings = {
    "url": $('#urlApiMyOdb').val()+"portail-stagiaire/labo/newtestapi.php",
    "method": "POST",
    "timeout": 0,
    "headers": {
      "Content-Type": "application/json",
    },
    "data": JSON.stringify({"sentence":originalTexto}),
  };
  //console.log(idExpression);

  if (originalTexto != '') {
    $.ajax(settings)
      .done(function (response) {
        try {
          var dataJson = JSON.parse(response);
          //console.log(dataJson);
          $.each(dataJson, function(i,obj) {
            //console.log(obj);
            //console.log($('.stat_duration').attr('data-id-expression') +' => '+ idExpression +' : '+ obj.stats_duree);
            //$(div).attr('testststs',obj.stats_debits);
            //$(div).find('.el-table').find('.sta_expression_1')
            //$(''+div+' .stat_debit').html(obj.stats_debits);
            $('.stat_duration').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_duree) != null) {
                $(this).html(obj.stats_duree);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
                //console.log('mamono');
              }
            });

            $('.stat_words').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_nbwords) != null) {
                $(this).html(obj.stats_nbwords);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            });

            $('.stat_happaxes').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_nbhapax) != null) {
                $(this).html(obj.stats_nbhapax);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            });

            $('.stat_debit').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_debits) != null) {
                $(this).html(obj.stats_debits);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            });
            //console.log('stats_nbverb : ' + obj.stats_nbverb);
            //console.log('glossaire_verbs : ' + obj.glossaire_verbs);

            $('.stat_verbs').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_nbverb) != null) {
                $(this).html(obj.stats_nbverb);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            });

            $('.stat_adjectif').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_nbadj) != null) {
                $(this).html(obj.stats_nbadj);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            });


            $('.stat_active_voice').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_nbact) != null) {
                $(this).html(obj.stats_nbact);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            });

            $('.stat_passive_voice').each(function(){
              if ($(this).attr('data-id-expression') === idExpression && typeof(obj.stats_nbpass) != null) {
                $(this).html(obj.stats_nbpass);
                $(this).parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            });

            ret = true;
          });
        } 
        catch (error) {
          console.log(error);
          ret = false;
        }        
    })
      .fail(function (jqXHR, textStatus) {
        console.log(jqXHR);
        ret = false;
    });
  }
  else{
    $('.spinner-border').fadeOut('slow');
  }

  return ret;
}

/*function loadStat(idExpression, originalTexto){
  var ret = false;
  var settings = {
    "url": $('#urlApiMyOdb').val()+"portail-stagiaire/labo/newtestapi.php",
    "method": "POST",
    "timeout": 0,
    "headers": {
      "Content-Type": "application/json",
    },
    "data": JSON.stringify({"sentence":originalTexto,"idexp":idExpression}),
  };
  //console.log(settings);

  if (originalTexto != '') {
    $.ajax(settings)
      .done(function (response) {
        try {
          var dataJson = JSON.parse(response);
          console.log(dataJson);
          $.each(dataJson, function(i,obj) {
            //console.log(obj);
            //console.log(i +' => '+ idExpression +' : '+ obj.stats_debits);
            //$(div).attr('testststs',obj.stats_debits);
            //$(div).find('.el-table').find('.sta_expression_1')
            //$(''+div+' .stat_debit').html(obj.stats_debits);
            //$('.stat_duration').each(function(){
              if ($('.stat_duration').attr('data-id-expression') === idExpression && typeof(obj.stats_duree) != null) {
                $('.stat_duration').html(obj.stats_duree);
                $('.stat_duration').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
                console.log('mamono v?');
              }
            //});

            //$('.stat_words').each(function(){
              if ($('.stat_words').attr('data-id-expression') === idExpression && typeof(obj.stats_nbwords) != null) {
                $('.stat_words').html(obj.stats_nbwords);
                $('.stat_words').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            //});

            //$('.stat_happaxes').each(function(){
              if ($('.stat_happaxes').attr('data-id-expression') === idExpression && typeof(obj.stats_nbhapax) != null) {
                $('.stat_happaxes').html(obj.stats_nbhapax);
                $('.stat_happaxes').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            //});

            //$('.stat_debit').each(function(){
              if ($('.stat_debit').attr('data-id-expression') === idExpression && typeof(obj.stats_debits) != null) {
                $('.stat_debit').html(obj.stats_debits);
                $('.stat_debit').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            //});
            //console.log('stats_nbverb : ' + obj.stats_nbverb);
            //console.log('glossaire_verbs : ' + obj.glossaire_verbs);

            //$('.stat_verbs').each(function(){
              if ($('.stat_verbs').attr('data-id-expression') === idExpression && typeof(obj.stats_nbverb) != null) {
                $('.stat_verbs').html(obj.stats_nbverb);
                $('.stat_verbs').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            //});

            //$('.stat_adjectif').each(function(){
              if ($('.stat_adjectif').attr('data-id-expression') === idExpression && typeof(obj.stats_nbadj) != null) {
                $('.stat_adjectif').html(obj.stats_nbadj);
                $('.stat_adjectif').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            //});


            //$('.stat_active_voice').each(function(){
              if ($('.stat_active_voice').attr('data-id-expression') === idExpression && typeof(obj.stats_nbact) != null) {
                $('.stat_active_voice').html(obj.stats_nbact);
                $('.stat_active_voice').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            //});

            //$('.stat_passive_voice').each(function(){
              if ($('.stat_passive_voice').attr('data-id-expression') === idExpression && typeof(obj.stats_nbpass) != null) {
                $('.stat_passive_voice').html(obj.stats_nbpass);
                $('.stat_passive_voice').parents('.bs-stat').find('.spinner-border').fadeOut('slow');
              }
            //});

            ret = true;
          });
        } 
        catch (error) {
          console.log(error);
          ret = false;
        }        
    })
      .fail(function (jqXHR, textStatus) {
        console.log(jqXHR);
        ret = false;
    });
  }

  return ret;
}*/

function onMediaError(e) {
  console.error('media error', e);
}

function mergeProps(obj1, obj2) { //obj1 is destination, obj2 is source
  for (var a in obj2) {
    if (obj2.hasOwnProperty(a) && !obj1.hasOwnProperty(a)) {
      obj1[a] = obj2[a];
    }
  }
  return obj1 //returns {a: 1, b: 4, c: 3, d: 4} should have {...b: 2...}
}
function onMediaSuccess(stream) {
  var audio = document.createElement('audio');
  document.getElementById('video-rework-container').play();
  document.getElementById('video-rework-container').muted = true; 
  audio = mergeProps(audio, {controls: true, muted: true});
  audio.srcObject = stream;
  audio.play();
  $( "#audios-container" ).empty();
  mediaRecorder = new MediaStreamRecorder(stream);
  mediaRecorder.stream = stream;
  //var recorderType = document.getElementById('audio-recorderType').value;
  mediaRecorder.mimeType = 'audio/wav';
  mediaRecorder.audioChannels = 1;
  mediaRecorder.ondataavailable = function(blob) {
    var urlblob =  URL.createObjectURL(blob);
    $('#btn-stop-record').click();
    formData = new FormData(document.getElementById('form-rework-audio'));
    formData.append('fileUpload', blob);
  };
  var timeInterval = document.getElementById('time-interval').value;
  if (timeInterval) timeInterval = parseInt(timeInterval);
  else timeInterval = 5000 * 1000;
  // get blob after specific time interval
  mediaRecorder.start(timeInterval);
  activestp();
  activeSave();
}


function reinitialisebtnControl(){
  $('#btn-record').prop('disabled', false);
  $('#btn-stop-record').prop('disabled', true);
  $('#btn-save-record').prop('disabled', true);
  $('#btn-merge-record').prop('disabled', true);

  $('#btn-record').removeClass('el-btn-dark');
  $('#btn-record').addClass('el-btn-pink');

  $('#btn-stop-record').removeClass('el-btn-pink');
  $('#btn-stop-record').addClass('el-btn-dark');

  $('#btn-save-record').removeClass('el-btn-pink');
  $('#btn-save-record').addClass('el-btn-dark');

  $('#btn-merge-record').removeClass('el-btn-pink');
  $('#btn-merge-record').addClass('el-btn-dark');
}

function captureUserMedia(mediaConstraints, successCallback, errorCallback) {
  navigator.mediaDevices.getUserMedia(mediaConstraints).then(successCallback).catch(errorCallback);
}

// button animation
function disablesave(){
  $('#btn-save-record').prop('disabled', true);
  $('#btn-save-record').removeClass('el-btn-pink');
  $('#btn-save-record').addClass('el-btn-dark');
}
function activeSave(){
  $('#btn-save-record').prop('disabled', false);
  $('#btn-save-record').removeClass('el-btn-dark');
  $('#btn-save-record').addClass('el-btn-pink');
}

function active_merge(){
  $('#btn-merge-record').prop('disabled', false);
  $('#btn-merge-record').removeClass('el-btn-dark');
  $('#btn-merge-record').addClass('el-btn-pink');
}
function disable_merge(){
  $('#btn-merge-record').prop('disabled', true);  
  $('#btn-merge-record').removeClass('el-btn-pink');
  $('#btn-merge-record').addClass('el-btn-dark');
}
function activestp(){
  $('#btn-stop-record').prop('disabled', false);
  $('#btn-stop-record').removeClass('el-btn-dark');
  $('#btn-stop-record').addClass('el-btn-pink');
}
function disablestp(){
  $('#btn-stop-record').prop('disabled', true);
  $('#btn-stop-record').removeClass('el-btn-pink');
  $('#btn-stop-record').addClass('el-btn-dark');
}

function activerec(){
  $('#btn-record').prop('disabled', false);
  $('#btn-record').addClass('el-btn-pink');
  $('#btn-record').removeClass('el-btn-dark');
} 

function disablerec(){
  $('#btn-record').prop('disabled', true);
  $('#btn-record').removeClass('el-btn-pink');
  $('#btn-record').addClass('el-btn-dark');
}



async function setVideoStats(container, txt, vd, idexp) {  
  const baseUrlApi = $('#urlApiMyOdb').val();
  try {
    const res = await fetchStats(baseUrlApi, idexp, txt);//stats1
    const refStat = await fetchStats(baseUrlApi, res[10].ref, res[10].text_reference);//stats2

    window.statsResult = res;
    window.refStats = refStat;

    window.newComparedData = compare(refStat, statsResult);//les statistique comparee

    setComparedStats(container,newComparedData);// pas important: 
  
    //const relatedData = await getRelatedExp($('#traineeId').val(), statsResult[10].ref);
    //remplirSelectAvecJSON(selectElement, relatedData);// pas important
  } catch (error) {
    console.error('Erreur lors de la requête AJAX', error);
    throw error;
  }
}

function setComparedStats(container,setComparedStats){
  /** LEXICAL DATA */
  /** debit */
  //console.log(container);
  $('#'+container+' .cell-old-debit').text(newComparedData[7].comparedDebits[0].oldstats_debits+ ' w/min');
  $('#'+container+' .cell-last-debit').text(newComparedData[7].comparedDebits[1].laststats_debits + ' w/min');
  $('#'+container+' .cell-diff-debit').text(newComparedData[7].comparedDebits[2].diffstats_debits.toFixed(2)  + ' w/min');

  /** Number of words */
  $('#'+container+' .cell-old-nbword').text(newComparedData[8].diffNbWord[0].oldstats_nbwords);
  $('#'+container+' .cell-last-nbword').text(newComparedData[8].diffNbWord[1].laststats_nbwords);
  $('#'+container+' .cell-diff-nbword').text(newComparedData[8].diffNbWord[2].diffstats_nbwords);

  /** Hapax */
  $('#'+container+' .cell-old-hapax').text(newComparedData[2].comparedHapxes[1].oldValue);
  $('#'+container+' .cell-last-hapax').text(newComparedData[2].comparedHapxes[2].newValue);
  $('#'+container+' .cell-diff-hapax').text(newComparedData[2].comparedHapxes[3].discoveredValue);


  /** GRAMATICAL DATA */
  /** Adjective */
  $('#'+container+' .cell-old-adj').text(newComparedData[0].comparedAdj[1].oldValue);
  $('#'+container+' .cell-last-adj').text(newComparedData[0].comparedAdj[2].newValue);
  $('#'+container+' .cell-new-adj').text(newComparedData[0].comparedAdj[3].discoveredValue);
  
  /** verb*/
  $('#'+container+' .cell-old-verb').text(newComparedData[1].comparedVerb[1].oldValue);
  $('#'+container+' .cell-last-verb').text(newComparedData[1].comparedVerb[2].newValue);
  $('#'+container+' .cell-new-verb').text(newComparedData[1].comparedVerb[3].discoveredValue);

  /** Substatifs*/
  $('#'+container+' .cell-old-sub').text(newComparedData[11].comparedSubs[1].oldValue);
  $('#'+container+' .cell-last-sub').text(newComparedData[11].comparedSubs[2].newValue);
  $('#'+container+' .cell-new-sub').text(newComparedData[11].comparedSubs[3].discoveredValue);

  /** Conjugaison
   * present verb
   */
  $('#'+container+' .cell-old-pres').text(newComparedData[3].comparedPresentV[1].oldValue);
  $('#'+container+' .cell-last-pres').text(newComparedData[3].comparedPresentV[2].newValue);
  $('#'+container+' .cell-new-pres').text(newComparedData[3].comparedPresentV[3].discoveredValue);
  /** past verb */
  $('#'+container+' .cell-old-past').text(newComparedData[4].comparedPastV[1].oldValue);
  $('#'+container+' .cell-last-past').text(newComparedData[4].comparedPastV[2].newValue);
  $('#'+container+' .cell-new-past').text(newComparedData[4].comparedPastV[3].discoveredValue);
  /** Modal verb */
  $('#'+container+' .cell-old-modal').text(newComparedData[9].comparedModal[1].oldValue);
  $('#'+container+' .cell-last-modal').text(newComparedData[9].comparedModal[2].newValue);
  $('#'+container+' .cell-new-modal').text(newComparedData[9].comparedModal[3].discoveredValue);
  /** ING verb */
  $('#'+container+' .cell-old-ing').text(newComparedData[10].comparedIngV[1].oldValue);
  $('#'+container+' .cell-last-ing').text(newComparedData[10].comparedIngV[2].newValue);
  $('#'+container+' .cell-new-ing').text(newComparedData[10].comparedIngV[3].discoveredValue);
  
  
  /** SYNTACTICAL DATA */
  /** Passive */
  $('#'+container+' .cell-old-pass').text(newComparedData[6].comparedPassive[1].oldValue);
  $('#'+container+' .cell-last-pass').text(newComparedData[6].comparedPassive[2].newValue);
  $('#'+container+' .cell-new-pass').text(newComparedData[6].comparedPassive[3].discoveredValue);

  /** Active */
  $('#'+container+' .cell-old-act').text(newComparedData[5].comparedActive[1].oldValue);
  $('#'+container+' .cell-last-act').text(newComparedData[5].comparedActive[2].newValue);
  $('#'+container+' .cell-new-act').text(newComparedData[5].comparedActive[3].discoveredValue);
}



async function compareStatAudio(sentence, identityContainer) {  
  const baseUrlApi = $('#urlApiMyOdb').val();
  try {
    const res = await fetchStats(baseUrlApi, identityContainer, sentence);//stats1
    const refStat = await fetchStats(baseUrlApi, res[10].ref, res[10].text_reference);//stats2

    window.statsResult = res;
    window.refStats = refStat;

    window.newComparedData = compare(refStat, statsResult);//les statistique comparee

    //console.log(res);
    //console.log(refStat);

    setComparedStatsAudio(identityContainer,newComparedData);// pas important: 
  
    //const relatedData = await getRelatedExp($('#traineeId').val(), statsResult[10].ref);
    //remplirSelectAvecJSON(selectElement, relatedData);// pas important
  } catch (error) {
    console.error('Erreur lors de la requête AJAX', error);
    throw error;
  }
}

function setComparedStatsAudio(identityContainer,setComparedStatsAudio){
  /** LEXICAL DATA */
  /** debit */
  //console.log(newComparedData[7].comparedDebits[1].laststats_debits + ' w/min');
  //console.log(newComparedData[8].diffNbWord[1].laststats_nbwords);
  //console.log(newComparedData[2].comparedHapxes[2].newValue);
  //console.log(newComparedData[0].comparedAdj[2].newValue);
  //$('#'+container+' .cell-old-debit').text(newComparedData[7].comparedDebits[0].oldstats_debits+ ' w/min');
  $('.cell-last-debit'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[7].comparedDebits[1].laststats_debits + ' w/min');
  $('.cell-last-debit'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  //$('#'+container+' .cell-diff-debit').text(newComparedData[7].comparedDebits[2].diffstats_debits.toFixed(2)  + ' w/min');

  /** Number of words */
  //$('#'+container+' .cell-old-nbword').text(newComparedData[8].diffNbWord[0].oldstats_nbwords);
  $('.cell-last-nbword'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[8].diffNbWord[1].laststats_nbwords);
  $('.cell-last-nbword'+identityContainer+'').find('.spinner-border').fadeOut('slow');
  //$('#'+container+' .cell-diff-nbword').text(newComparedData[8].diffNbWord[2].diffstats_nbwords);

  /** Hapax */
  //$('#'+container+' .cell-old-hapax').text(newComparedData[2].comparedHapxes[1].oldValue);
  $('.cell-last-hapax'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[2].comparedHapxes[2].newValue);
  //$('#'+container+' .cell-diff-hapax').text(newComparedData[2].comparedHapxes[3].discoveredValue);


  /** GRAMATICAL DATA */
  /** Adjective */
  //$('#'+container+' .cell-old-adj').text(newComparedData[0].comparedAdj[1].oldValue);
  $('.cell-last-adj'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[0].comparedAdj[2].newValue);
  //$('#'+container+' .cell-new-adj').text(newComparedData[0].comparedAdj[3].discoveredValue);
  
  /** verb*/
  //$('#'+container+' .cell-old-verb').text(newComparedData[1].comparedVerb[1].oldValue);
  $('.cell-last-verb'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[1].comparedVerb[2].newValue);
  //$('#'+container+' .cell-new-verb').text(newComparedData[1].comparedVerb[3].discoveredValue);

  /** Substatifs*/
  //$('#'+container+' .cell-old-sub').text(newComparedData[11].comparedSubs[1].oldValue);
  //$('#'+container+' .cell-last-sub').text(newComparedData[11].comparedSubs[2].newValue);
  //$('#'+container+' .cell-new-sub').text(newComparedData[11].comparedSubs[3].discoveredValue);

  /** Conjugaison
   * present verb
   */
  //$('#'+container+' .cell-old-pres').text(newComparedData[3].comparedPresentV[1].oldValue);
  $('.cell-last-pres'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[3].comparedPresentV[2].newValue);
  //$('#'+container+' .cell-new-pres').text(newComparedData[3].comparedPresentV[3].discoveredValue);
  /** past verb */
  //$('#'+container+' .cell-old-past').text(newComparedData[4].comparedPastV[1].oldValue);
  $('.cell-last-past'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[4].comparedPastV[2].newValue);
  //$('#'+container+' .cell-new-past').text(newComparedData[4].comparedPastV[3].discoveredValue);
  /** Modal verb */
  //$('#'+container+' .cell-old-modal').text(newComparedData[9].comparedModal[1].oldValue);
  //$('#'+container+' .cell-last-modal').text(newComparedData[9].comparedModal[2].newValue);
  //$('#'+container+' .cell-new-modal').text(newComparedData[9].comparedModal[3].discoveredValue);
  /** ING verb */
  //$('#'+container+' .cell-old-ing').text(newComparedData[10].comparedIngV[1].oldValue);
  //$('#'+container+' .cell-last-ing').text(newComparedData[10].comparedIngV[2].newValue);
  //$('#'+container+' .cell-new-ing').text(newComparedData[10].comparedIngV[3].discoveredValue);
  
  
  /** SYNTACTICAL DATA */
  /** Passive */
  //$('#'+container+' .cell-old-pass').text(newComparedData[6].comparedPassive[1].oldValue);
  $('.cell-last-pass'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[6].comparedPassive[2].newValue);
  //$('#'+container+' .cell-new-pass').text(newComparedData[6].comparedPassive[3].discoveredValue);

  /** Active */
  //$('#'+container+' .cell-old-act').text(newComparedData[5].comparedActive[1].oldValue);
  $('.cell-last-act'+identityContainer+'').find('.contentainer-result-stat').text(newComparedData[5].comparedActive[2].newValue);
  //$('#'+container+' .cell-new-act').text(newComparedData[5].comparedActive[3].discoveredValue);
}
function remplirSelectAvecJSON(selectElement, data) {
  selectElement.empty(); // Effacer les options existantes

  // Ajouter une option par défaut
  selectElement.append('<option value="">Sélectionner une légende</option>');

  // Parcourir les données JSON et ajouter les options à l'élément select
  $.each(data, function (index, item) {
    selectElement.append('<option value="' + item.legende_f + '">' + item.legende_f + '</option>');
  });
  window.myData = data;
}
async function fetchStats(baseUrlApi, idexp, sentence) {
  if (sentence != '') {
    return $.ajax({
      type: 'POST',
      url: `${baseUrlApi}/portail-stagiaire/labo/newtestapi.php`,
      data: JSON.stringify({ sentence }),
      dataType: "json"
    });
  }
  else{
    return '';
  }
}

function compare(stats1,stats2) {
    const passive = collectComparedDetails(stats1, stats2, 'Passive voice', 'phrase_passive');
    const active = collectComparedDetails(stats1, stats2, 'Active voice', 'phrase_active');
    const verb = collectComparedDetails(stats1, stats2, 'Verb', 'glossaire_verbs');
    const adjective = collectComparedDetails(stats1, stats2, 'Adjectives', 'glossaire_adjectivs');
    const hapax = collectComparedDetails(stats1, stats2, 'Hapaxes', 'glossaire_hapaxes');
    const present = collectComparedDetails(stats1, stats2, 'Present verb', 'conjugaison_presentVerb');
    const past = collectComparedDetails(stats1, stats2, 'Past verb', 'conjugaison_pastVerb');
    const debits = compareDiffNum(stats1, stats2, 'stats_debits');
    const nbwords = compareDiffNum(stats1, stats2, 'stats_nbwords');
    const modalV = collectComparedDetails(stats1, stats2, 'Modal verb','conjugaison_modalVerb');
    const ingV = collectComparedDetails(stats1, stats2, 'ING verb','conjugaison_ingVerb');
    const subs = collectComparedDetails(stats1, stats2, 'substantifs','glossaire_substantif');
    let comparedResult = [
        { comparedAdj: adjective},
        { comparedVerb: verb },
        { comparedHapxes: hapax},
        { comparedPresentV: present},
        { comparedPastV: past},
        { comparedActive: active},
        { comparedPassive: passive},
        { comparedDebits: debits},
        { diffNbWord: nbwords},
        { comparedModal: modalV},
        { comparedIngV: ingV},
        { comparedSubs: subs},
    ];
    return comparedResult;
}


/**
 * ALO V1 
 * Auteur: Boris Alexandre
 * Compare les différences entre deux ensembles de statistiques.
 * @param {Object[]} oldStats - Les anciennes statistiques.
 * @param {Object[]} newStats - Les nouvelles statistiques.
 * @param {string} element - L'élément à comparer (ex: 'Debits', 'Nombre de mots', etc.).
 * @returns {Object[]} - Un tableau d'objets contenant les valeurs comparées.
 */
function compareDiffNum(oldStats, newStats, element){
    const oldNumber = oldStats.find(item => item[element])?.[element] || 0;
    const lastNumber = newStats.find(item => item[element])?.[element] || 0;
    const diffNumber = lastNumber-oldNumber;
    const comparedDebits = [
        { ['old' + element]: oldNumber},
        { ['last' + element]: lastNumber},
        { ['diff' + element]: diffNumber}
    ];
    return comparedDebits;
}

/**
 * ALO V1 
 * Auteur: Boris Alexandre
 * Collection par intitulé de la comparaison statistique
 * @param {Object[]} oldStats - La statistique de reference
 * @param {Object[]} newStats - La nouvelle stat
 * @param {String} label - intitulé de l'element
 * @param {String} elements - Glossaire/liste de l'éléments
 * @returns {Object[]} formatedResult - Rassemble tout les données comparés
 */
function collectComparedDetails(oldStats, newStats, label, elements){
  const oldElementList = oldStats.find(item => item[elements])?.[elements] || [];
  const newElementList = newStats.find(item => item[elements])?.[elements] || [];
  const uniqueElements = newElementList.filter(discover => !oldElementList.includes(discover));
  //console.log('old___'+label,oldElementList[0]);
  var formatedResult = [
      {label: label},
      {oldValue:countElement(oldElementList)},
      {newValue:countElement(newElementList)},
      {discoveredValue:countElement(uniqueElements)},
      {oldlist:renderList(oldElementList)},
      {newlist:renderList(newElementList)},
      {discoveredList:renderList(uniqueElements)},
      {ProgressIndex:calculatePercent(uniqueElements.length, newElementList.length)+'%'},
  ];
  return formatedResult;
}
function calculatePercent(value, total) {
  if (total === 0) {
      return 0;
  }
  return Math.round((value / total) * 100 * 100) / 100;
}
function renderList(element){
    if(element[0] == "0" || element[0] == 0){
        x = [];
    }else{
        x = element
    }

    return x;
}

/**
 * Comptage et verification si l'element est vide
 * ALO V1
 * Auteur: Boris Alexandre
 * @param {*} element 
 * @returns 
 */
function countElement(element){
    if(element[0] == "0" || element[0] == 0){
        x = 0
    }else{
        x = element.length;
    }

    return x;
}
function getRelatedExp(id, idexpr){
  var headersList = {
    "Accept": "*/*",
    "Content-Type": "application/json"
  };
  var bodyContent = JSON.stringify({
    "id": id,
    "idexp": idexpr
  });
  const baseUrlApi = $('#urlApiMyOdb').val();
  return new Promise(function(resolve, reject) {
    $.ajax({
      type: 'POST',
      url: baseUrlApi+"portail-stagiaire/labo/statbyref.php",
      data: bodyContent,
      dataType: 'json',
      headers: headersList,
      success: function (data) {
          resolve(data); // Résoudre la promesse avec les données
      },
      error: function (xhr, status, error) {
          console.error(error);
          reject(error); // Rejeter la promesse avec l'erreur
      }
    });
  });
}
function openStatModal(btn){
  $('#analyse-lexicale').addClass('open');
  /*var link = $(btn);
  var origin = link.attr('data-expression-origin');
  var expressionId = link.attr('data-expression-id');
  $('.stat-modal-expression').each(function(){
    var modal = $(this);
    var idExpressionModal = modal.attr('data-expression-id');
    if (expressionId == idExpressionModal) {
      modal.find('.active-load-modal').addClass('active');
      modal.addClass('open');
    }
  });*/
}
function reworkAudio(link){
  var btn = $(link);
  $('#div-rework-audio').fadeOut('slow');
  $('#video-rework').attr('src',btn.attr('data-media'));
  $('.expressionidRework').val(btn.attr('data-expression-id'));
  $('#textboxname').val(btn.attr('data-media-name'));
  $('#video-rework-container').load();
  $('#rework-audio').addClass('open');
  reinitialisebtnControl();
}

function rework(link){
  var btn = $(link);
  $('#div-rework-audio').fadeOut('slow');
  $('#video-rework').attr('src',btn.attr('data-media'));
  $('.expressionidRework').val(btn.attr('data-expression-id'));
  $('#textboxname').val(btn.attr('data-media-name'));
  $('#audio_id').val(btn.attr('data-audio-id'));
  $('#content_origin').val(btn.attr('data-content-origin'));
  $('#video-rework-container').load();
  $('#rework-audio').addClass('open');
  reinitialisebtnControl();
}

function loadAudioRework(link){
  var btn = $(link);
  $('.spinner-border').fadeIn('slow');
  $('.stat_duration').html('');
  $('.stat_words').html('');
  $('.stat_happaxes').html('');
  $('.stat_debit').html('');
  $('.stat_verbs').html('');
  $('.stat_adjectif').html('');
  $('.stat_active_voice').html('');
  $('.stat_passive_voice').html('');
  loadStat($(':selected', btn).attr("data-id-expression"), $(':selected', btn).attr("data-content-lang-origin"));
  $('.audio-link-read').parent('.main-audio').stop();
  $('.audio-link-read').attr('src',btn.val());
  $('.audio-link-read').attr('data-course',btn.val());
  $('.audio-link-read').parent('.main-audio').load();
}

function reinitialiseContentStat(){
  $('.stat_words').html('');
  $('.stat_happaxes').html('');
  $('.stat_duration').html('');
  $('.stat_debit').html('');
  $('.stat_verbs').html('');
  $('.stat_adjectif').html('');
  $('.stat_active_voice').html('');
  $('.stat_passive_voice').html('');
  $('.spinner-border').fadeIn('slow');  
}

function registerContentOrigin(link){
  var btn = $(link);
  $('.spinner').fadeIn('slow');
  reinitialiseContentStat();
  $('.content-origin').each(function(){
    var textarea = $(this);
    if (textarea.is(':visible')) {
      var contents = textarea.val();
      var idExpression = textarea.attr('data-content-id');
      $.ajax({
        url: $('.baseURL').val()+'edit-expression-origin',
        type: 'POST',
        data: {idExpression : idExpression, contentOrigin : contents},
        dataType: 'json',
        success: function(result){
          console.log(result);
          loadStat(result.editId, result.origin);
          textarea.html(result.origin);
          textarea.val(result.origin);
          toastr.success(data_save_ok);
          $('.spinner').fadeOut('slow');
        },
        error: function(error, msg){
          $('.spinner').fadeOut('slow');
          console.log(error);
          console.log(msg);
          toastr.error(msg);
        }
     });
    }
  });
}

function copyTextContent(link){
  var btn = $(link);
  var contents = '';
  if (btn.hasClass('btn-copy-content-origin')) {
    contents = $('#content-origin').val();
  }
  else{
    contents = $('#content-cible').val();
  }

  var temp = $("<input>");
  $("body").append(temp);
  temp.val(contents).select();
  document.execCommand("copy");
  temp.remove();
}

function downloadTracript(link){
  var btn = $(link);
  //window.location.href = btn.attr('data-content');
  window.open(btn.attr('data-content') , '_blank');
}

function loadSlideBoosterImg(){

  /*image booster*/
  var main       = new Splide('#main-slider-janvier', {
    type      : 'slide',
    rewind    : true,
    pagination: false,
    arrows    : false,
  });
  var thumbnails = new Splide('#thumbnail-slider-janvier', {
    fixedWidth  : 100,
    fixedHeight : 60,
    gap         : 5,
    rewind      : true,
    pagination  : false,
    cover       : true,
    isNavigation: true,
    breakpoints : {
      600: {
        fixedWidth : 60,
        fixedHeight: 44,
      },
    },
  });
  main.sync( thumbnails );
  main.mount();
  thumbnails.mount();
}