$(document).ready(function(){
	initSlickCarousel();

	/*slick notification*/
	$('.notifs').slick({
	    dots: true,
	    infinite: false,
	    speed: 300,
	    slidesToShow: 3,
	    slidesToScroll: 3,
	    responsive: [
	      
	      {
	        breakpoint: 1024,
	        settings: {
	          slidesToShow: 2,
	          slidesToScroll: 2,
	          dots: true
	        }
	      },
	      {
	        breakpoint: 767,
	        settings: {
	          slidesToShow: 1,
	          slidesToScroll: 1
	        }
	      }
	      
	    ]
	});
	/*slick*/
	$('.personnal-training-area-sidebar').slick({
	    infinite: false,
	    speed: 300,
	    slidesToShow: 1,
	    slidesToScroll: 1
	});

	$('.container-content-page-sidebar').each(function(){	
		createEditorPersonalise($(this).attr('id'));		
    });

    $('.btn-save-content-page-training-area').click(function(e){
		e.preventDefault();
		$('.spinner').fadeIn('slow');
		var btn = $(this);
		var idPage = btn.attr('data-content-id-program');
		var title = btn.attr('data-container-title');
		var form = $("<form></form>");
	    var dataPageTraningArea = form.serializeArray();
	    dataPageTraningArea.push({name: 'comment-page', value: title});
	    dataPageTraningArea.push({name: 'id_page_training_area', value: idPage});
	    var currentInstance = '';  	
	    	
		$('.content-page-training-area').each(function(){	
	    	var container = $(this);
	    	if (container.is(':visible')) {
	    		currentInstance += container.find('.container-content-page-sidebar').attr('id');
	    	}
	    });  

	    if (currentInstance != '') {
	    	dataPageTraningArea.push({name: 'page-content', value: elearningEditors.get(currentInstance).getData()});
	    } 
	    
	    var dataPageTraningAreaJson = {};
	    for (i in dataPageTraningArea) {
	        dataPageTraningAreaJson[dataPageTraningArea[i].name] = dataPageTraningArea[i].value;
	    }
	    dataPageTraningArea=dataPageTraningAreaJson;  

	    $.ajax({
	        url  : $('.baseURL').val()+'update-page-traning-area',
	        type : 'post',       
	        data : {dataPageTraningArea : dataPageTraningArea}, 
	        dataType : 'json',
	        success : function(data){
	            toastr.success(data_save_ok);
	            $(".spinner").fadeOut("slow");
	        }
	    });
	});

    $('.personnal-training-area-sidebar .slick-track').addClass('nav nav-tabs md-tabs');
	$('.personnal-training-area-sidebar .slick-track').attr('role','tablist');

	//console.clear();
	$('.edit-favorite-training').click(function(){
		$('#modal-edit-personal-training-area #inputEditName').val($(this).attr('data-name'));
		$('#modal-edit-personal-training-area #inputEditId').val($(this).attr('data-idfav'));
		$('#modal-edit-personal-training-area').addClass('open');
	});

	$('#editPersonnalTrainingArea').on('submit', function(e){
        e.preventDefault();
        $('.spinner').fadeIn('slow');
        $.ajax({
            type: $(this).attr('method'),
            url:  $(this).attr('action'),
            data:  new FormData(this),            
            contentType: false,
            cache: false,
            processData:false,
            dataType: 'json',
            success: function(data){
                console.log(data);
                $('.tab-nav-item-head').each(function(){
                	if ($(this).attr('data-indiceid') == data.idUpdate) {
                		$(this).find('span').html(data.nameUpdate);
                	}
                });
                $('#modal-edit-personal-training-area').removeClass('open');
                $('.spinner').fadeOut('slow');
                toastr.success(data_saved_ko);
            }
        });
    });

    $('.remove-favorites-training').click(function(){
		$('#modal_confirm_delete_classifiction_favory #id_class').val($(this).attr('data-idfav'));
		$('#modal_confirm_delete_classifiction_favory').addClass('open');
	});

	$('.remove-content-favorites').click(function(){
		$('#modal-confirm-delete-content-favory #id_program_stat').val($(this).attr('data-id-fav'));
		$('#modal-confirm-delete-content-favory').addClass('open');
	});

	$('#deleteContentFavoris').on('submit', function(e){
        e.preventDefault();
        $('.spinner').fadeIn('slow');
        $.ajax({
            type: $(this).attr('method'),
            url:  $(this).attr('action'),
            data:  new FormData(this),            
            contentType: false,
            cache: false,
            processData:false,
            dataType: 'json',
            success: function(data){
                console.log(data);
                $('.container-content-fav').each(function(){
                	if ($(this).attr('data-indice-content') == data.idDelete) {
                		$(this).remove();
                	}
                });
                $('#modal-confirm-delete-content-favory').removeClass('open');
                $('.spinner').fadeOut('slow');
                toastr.error(data_delete_ok);
            }
        });
    });

	$('#deleteFormFavorites').on('submit', function(e){
        e.preventDefault();
        $('.spinner').fadeIn('slow');
        $.ajax({
            type: $(this).attr('method'),
            url:  $(this).attr('action'),
            data:  new FormData(this),            
            contentType: false,
            cache: false,
            processData:false,
            dataType: 'json',
            success: function(data){
                console.log(data);
                $('.navigation-training-area').each(function(){
                	if ($(this).attr('data-indice-navigation') == data.idDelete) {
                		if ($(this).next().length == 1) {
                			$(this).next().click();
                		}
                		else if ($(this).prev().length == 1) {
                			$(this).prev().click();
                		}
                		removeSlideSlick($(this).attr("data-slick-index"));
                		desctroySlickCarousel();
    					initSlickCarousel();
                	}
                });
                //$('.personnal-training-area')[0].slick.refresh();
                $('#modal_confirm_delete_classifiction_favory').removeClass('open');
                $('.spinner').fadeOut('slow');
                toastr.error(data_delete_ok);
            }
        });
    });

    $('.btn-create-new-classification').click(function(e){
		e.preventDefault();
		$('.spinner').fadeIn('slow');
		var intitule = $('.new_class').val();
		$.ajax({
            url : $('.baseURL').val()+'add-new-class',
            type : 'POST', 
            data : {"intitule" : intitule},
            dataType: 'json',
            success : function(data){ 
            	$('#modal-new-personal-training-area').removeClass('open');
            	toastr.success(data_save_ok);
                personaliseContentInPersonalTraningArea(data.id);
            }
        });
	});

	$("#key-data-favorites").on("keyup", function(e){ 
        var htmlResult = '';       
        if (e.keyCode == 13) {
            //$('#data-list').fadeOut("fast");
        }
        else{
            var key = $(this).val();
            if (key !=="" && key.length >= 3) {
                $('.title-training-area-el').each(function(){
                    var div = $(this);
                    var title = div.attr('data-title-area');
                    var indice = div.attr('data-indice-content');
                    if (title.indexOf(key) !== -1) {
                    	console.log(key +' '+ key);
                        htmlResult += '<div class="card-style-3 container-content-fav title-training-area-el" data-indice-content="'+indice+'" data-title-area="'+title+'">'+div.html()+'</div>';
                    }
                });

                if (htmlResult == '') {
                    var htmlNoResult = '<div id="content-nodata">';
                        htmlNoResult += '<div class="card">';
                            htmlNoResult += '<div class="card-container">';
                                htmlNoResult += '<div class="row empty-data-row">';
                                    htmlNoResult += '<div class="mb-12 text-center">';
                                        htmlNoResult += '<h4 class="nothing-data text-center">'+global_search_no_result_found+'</h4>';
                                    htmlNoResult += '</div>';
                                htmlNoResult += '</div>'; 
                            htmlNoResult += '</div>';
                        htmlNoResult += '</div>';
                    htmlNoResult += '</div>';
                    $('#view-all-result-search-data').html(htmlNoResult);
                }
                else{
                    $('#view-all-result-search-data').html('<div class="card-container">'+htmlResult+'</div>');
                }
                $(".tab-content").removeClass("active");
                $("#view-all-result-search-data").addClass('active');
                $("#result-search-data").addClass('active');
            }
            else{
                $('.tab-nav-item').each(function(){
                    console.log('click 1');
                    var tab = $(this);
                    if (tab.hasClass("active")) {
                        console.log('click 2');
                        tab.click();
                    }
                });
            }
        }
    });

    $('.form-page-training-area').on('submit', function(e){
        e.preventDefault();
        var form = $(this);
        $(".spinner").fadeIn("slow");
        var dataPageTraningArea=form.serializeArray();
        var container = elearningEditors.get('edit-page').getData();
        //var container = editor2.getData();
        //dataPageTraningArea.push({name: 'page-content', value: tinyMCE.get('edit-page').getContent()});
        dataPageTraningArea.push({name: 'page-content', value: container});
        dataPageTraningArea.push({name: 'idClassificationFavoris', value: $('#idClassificationFavoris').val()});
        dataPageTraningArea.push({name: 'edit-page-comment', value: $('#edit-page-comment').val()});
        var PageTraningAreaJson = {};
        for (i in dataPageTraningArea) {
            PageTraningAreaJson[dataPageTraningArea[i].name] = dataPageTraningArea[i].value;
        }
        dataPageTraningArea=PageTraningAreaJson; 
        if (container != "") {
            $.ajax({
                url     : form.attr('action'),
                type    : form.attr('method'),       
                data    : {dataPageTraningArea : dataPageTraningArea}, 
                dataType: 'json',
                success : function(data){
                    toastr.success(data_save_ok);
                    $("#form-page-training-area").trigger("reset");
                    $(".spinner").fadeOut("slow");
                }
            });
        }
        else{
            toastr.error(course_history_page_content_required);
            $(".spinner").fadeOut("slow");
        }
    });

    $('.btn-open-page').click(function(e){
        e.preventDefault();
        $('.current-page-open').val($(this).find('.current-bn-page').val());
        $(this).parents('.btn-action-page').find('.modal_read_content_of_page').addClass('open');
    });

    $('.btn-save-modif-page-in-training-area').click(function(e){
        e.preventDefault();
        var btn = $(this);
        var form = btn.parents('form');
	    var dataPageTraningArea = form.serializeArray();

        var currentInstance = '';  	
	    	
        $(".spinner").fadeIn("slow");
		currentInstance += btn.parents('.modal-action').parents('form.edit-page-loop').find('.content-page-result').find('.page-edit-content-traning-area').attr('id');

	    if (currentInstance != '') {
	    	dataPageTraningArea.push({name: 'page-content', value: elearningEditors.get(currentInstance).getData()});
	    } 	    
        var dataPageTraningAreaJson = {};
        for (i in dataPageTraningArea) {
            dataPageTraningAreaJson[dataPageTraningArea[i].name] = dataPageTraningArea[i].value;
        }
        dataPageTraningArea=dataPageTraningAreaJson;  
        $.ajax({
            url  : $('.baseURL').val()+'update-page-traning-area',
            type : 'post',       
            data : {dataPageTraningArea : dataPageTraningArea}, 
            dataType : 'json',
            success : function(data){
                console.log(data);
                toastr.success(data_save_ok);
                //location.reload();
                $('.modal-container-page').removeClass('open');
                $(".spinner").fadeOut("slow");
            }
        });
    });
    $('.el-dismiss').on('click', function() {
        $('.el-sidebar').removeClass('active');        
    });
 
    $('.el-open-menu').on('click', function(e) {
        e.preventDefault();

        if ($('.el-sidebar').hasClass('active')) {
        	$('.el-sidebar').removeClass('active');
        }
        else{
        	$('.el-sidebar').addClass('active');
        }
    }); 

});

function readTextToSpeachTrainingArea(link){
    var btn = $(link);
    $('#original-text').html(btn.attr('data-origin'));
    $('#traduction-text').html(btn.attr('data-traduction'));
    $('#text-to-speech').addClass('open');
}

function removeSlideSlick(navitem){
	$('.personnal-training-area').slick('slickRemove',navitem);
}

function initSlickCarousel() {
	$('.personnal-training-area').slick({
	    dots: false,
	    infinite: false,
	    speed: 300,
	    slidesToShow: 3,
	    slidesToScroll: 3,
  		setPosition: true,
	    responsive: [
			{
				breakpoint: 1200,
				settings: {
					slidesToShow: 3,
					slidesToScroll: 3,
					dots: true
				}
			},
			{
				breakpoint: 1024,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 2,
					dots: true
				}
			},
			{
			breakpoint: 767,
			settings: {
				slidesToShow: 1,
				slidesToScroll: 1
			}
			}
      
    	]
  	});
  	$('.profil-data-el').slick({
	    dots: false,
	    infinite: false,
	    speed: 300,
	    slidesToShow: 4,
	    slidesToScroll: 4,
  		setPosition: true,
	    responsive: [
			{
				breakpoint: 1200,
				settings: {
					slidesToShow: 4,
					slidesToScroll: 4,
					dots: true
				}
			},
			{
				breakpoint: 1024,
				settings: {
					slidesToShow: 2,
					slidesToScroll: 2,
					dots: true
				}
			},
			{
			breakpoint: 767,
			settings: {
				slidesToShow: 1,
				slidesToScroll: 1
			}
			}
      
    	]
  	});
}

function desctroySlickCarousel() {
  	if ($('.personnal-training-area').hasClass('slick-initialized')) {
    	$('.personnal-training-area').slick('destroy');
  	}      
}

function readContentInTrainingArea(btn){
	$('.spinner').fadeIn("slow");
	var statusUrlF = [];
    var alert_confirmation = '';
    var url_access_final = '';
	var objContentFavoris = {};
	objContentFavoris['contentLink']     = $(btn).attr('data-link');
	objContentFavoris['contentModule']   = $(btn).attr('data-module');
	objContentFavoris['contentNumero']   = $(btn).attr('data-numero');
	objContentFavoris['contentProgram']  = $(btn).attr('data-id-prog');
	objContentFavoris['contentFavoris']  = $(btn).attr('data-id-fav');
	objContentFavoris['contentType']     = $(btn).attr('data-doc-type');
	objContentFavoris['contentTitle']    = $(btn).text();
	$.ajax({  
        url: $('.baseURL').val()+'add-tracking-favoris',  
        type: "POST",
        data: objContentFavoris, 
        dataType: 'json',
        success: function(data) { 
			console.log(data);
			if (data.contentType == 'local_file' || data.contentType == 'embend_url') {
				console.log(data.urlFinal);
				$('.tab-content').removeClass('active');
				$('.content_title').html(data.contentTitle);
				$('.iframetrainingarea').attr('src',data.urlFinal);
				$('#content-89848414').addClass('active');
			}
			else if(data.contentType == 'nl_article'){
				location.replace(data.urlFinal); 
			}
			else if(data.contentType == 'sequence_activity'){ 
				$('.tab-content').removeClass('active');
				$('#content-011111').html(data.responses);
				$('#content-011111').addClass('active');
			}
			else{ // simple link
				if ((data.urlFinal.indexOf("https") !== -1) || data.urlFinal.indexOf("Https") !== -1) {
	                if (data.responses === false) {
	                    alert_confirmation = 'This content will be display in a new frame';
	                    url_access_final   = data.urlFinal;
	                }
	                else{
	                    $.each(data.responses, function(i, field){ 
	                        statusUrlF[i] = field;  
	                    });
	                    if(data.urlFinal.indexOf("learn-english-today.com") !== -1){
	                        alert_confirmation = 'This content will be display in a new frame';
	                        url_access_final   = data.urlFinal;
	                    }
	                    else if(typeof statusUrlF['0'] != "undefined" && (statusUrlF['0'].indexOf("403 Forbidden") !== -1 && data.urlFinal.indexOf("artsjournal.com") === -1 && data.urlFinal.indexOf("www.sciencedaily.com") === -1) || statusUrlF['0'].indexOf("404 Not Found") !== -1 || (statusUrlF['0'].indexOf("400 Bad Request") !== -1 && data.urlFinal.indexOf("forma2plus.com/groupes") === -1)){
	                        alert_confirmation = 'Sorry, opening the source request cannot be done because the link does not exist';
	                        url_access_final   = '';
	                    }
	                    else if(typeof statusUrlF['0'] != "undefined" && statusUrlF['0'].indexOf("403 Forbidden") !== -1 && data.urlFinal.indexOf("https://agendaweb.org" && data.urlFinal.indexOf("www.sciencedaily.com") === -1) !== -1 && data.urlFinal.indexOf("artsjournal.com") === -1 ){
	                        location.replace(viewLink); 
	                    }
	                    else if ($.isArray(statusUrlF['X-Frame-Options']) || statusUrlF['X-FRAME-OPTIONS'] === "DENY" || statusUrlF['x-frame-options'] === "SAMEORIGIN") {
	                        alert_confirmation = 'This content will be display in a new frame';
	                        url_access_final   = data.urlFinal;
	                        //return false;
	                    } 
	                    else if ((typeof statusUrlF['X-Content-Security-Policy'] != "undefined" && statusUrlF['X-Content-Security-Policy'] === "frame-ancestors 'self'") || (typeof statusUrlF['X-Frame-Options'] != "undefined" && (statusUrlF['X-Frame-Options'] === "SAMEORIGIN" || statusUrlF['X-Frame-Options'] === "DENY" || statusUrlF['X-Frame-Options'] === "deny"))) {
	                        alert_confirmation = 'This content will be display in a new frame';
	                        url_access_final   = data.urlFinal;
	                    } 
	                    else if (typeof statusUrlF['x-frame-options'] != "undefined"  && $.isArray(statusUrlF['x-frame-options']) && ((typeof statusUrlF['x-frame-options'][0] != "undefined" && statusUrlF['x-frame-options'][0] == "SAMEORIGIN") || typeof statusUrlF['x-frame-options'][1] != "undefined" && statusUrlF['x-frame-options'][1] == "SAMEORIGIN")) {
	                        alert_confirmation = 'This content will be display in a new frame';
	                        url_access_final   = data.urlFinal;
	                    }
	                    else if (typeof statusUrlF['Referrer-Policy'] != "" && statusUrlF['Referrer-Policy'] === "same-origin") {
	                        errorLink = 'This content will be display in a new frame';
	                        url_access_final   = data.urlFinal;
	                    }                    
	                    else if ($.isArray(statusUrlF['Content-Security-Policy'])){
	                        alert_confirmation = 'This content will be display in a new frame';
	                        url_access_final   = data.urlFinal;
	                    }                               
	                    else if (data.urlFinal.indexOf("www.sciencedaily.com") !== -1 || data.urlFinal.indexOf("www.bbc.co") !== -1 || data.urlFinal.indexOf("instructables.com") !== -1 || data.urlFinal.indexOf("cdkitchen.com") !== -1 || data.urlFinal.indexOf("thoughtco.com") !== -1 || data.urlFinal.indexOf("bbc.com") !== -1){ //Mise en place des exception
	                        alert_confirmation = 'This content will be display in a new frame';
	                        url_access_final   = data.urlFinal;
	                    }
	                    else{
	                        url_access_final   = data.urlFinal;
	                    }
	                }
	            }
	            else{
	                alert_confirmation = 'This content will be display in a new frame';
	                url_access_final   = data.urlFinal;
	            }


	            if (alert_confirmation != '') {
	                $('.alert-confirmation').text(alert_confirmation);
	                $('.url_access_confirmation').val(url_access_final);

	                if (url_access_final == '') {
	                    $('.btn-resufe-ch').hide();
	                    $('.btn-confirm-yes-ch').hide();
	                    $('.btn-confirm-ok-ch').show();
	                }
	                else{
	                    $('.btn-resufe-ch').show();
	                    $('.btn-confirm-yes-ch').show();
	                    $('.btn-confirm-ok-ch').hide();
	                }
	                $('#modal_confirm_action_access_link').addClass('open');
	                $(".spinner").fadeOut('slow');
	            }
	            else{                
	                $('.tab-content').removeClass('active');
	                $('.content_title').html(data.contentTitle);
					$('.iframetrainingarea').attr('src',url_access_final);
					$('#content-89848414').addClass('active');
	            }
			}
			$('.trackingmaxloaded').val(data.trackingid);
			$('.spinner').fadeOut("slow");
		}
    });
}


function personaliseContentInPersonalTraningArea(idFav){
	$('#idClassificationFavoris').val(idFav);
	$('.spinner').fadeIn('slow');
	$.ajax({
        url       : $('.baseURL').val()+"get-all-container-personnal-traning-area",
        type      : 'POST',       
        data      : {idFav : idFav},  
        dataType  : 'json', 
        success   : function(jsonResult){

        	/*Pedagogical traning*/
	    	var pedagogicalTraining = '<ul class="pedagogicalMenu">';
	    	var pedagogicalTrainingOption = '';
        	var pedagogicalTraningResultJson = jsonResult.pedagogicalTraningResultJson;
        	for (var p = 0; p < pedagogicalTraningResultJson.length; p++) {
        		pedagogicalTraining += '<li>';
                pedagogicalTraining += '<a href="#" data-linkInit = "'+pedagogicalTraningResultJson[p].link+'" data-titre = "'+pedagogicalTraningResultJson[p].titre+'" data-final-url = "'+pedagogicalTraningResultJson[p].final_url+'" data-thumb="'+pedagogicalTraningResultJson[p].thumbnail_file+'" class="btn btn-add-in-cours" onclick="addContentInPersonnalTraningArea(this,'+pedagogicalTraningResultJson[p].id_sequence+','+pedagogicalTraningResultJson[p].numero+','+idFav+', 1);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'+pedagogicalTraningResultJson[p].titre+'</span></a>';
                pedagogicalTraining += '</li>';
                pedagogicalTrainingOption += '<option data-id="'+pedagogicalTraningResultJson[p].id_sequence+'" value="'+pedagogicalTraningResultJson[p].titre+'">';
        	}
        	pedagogicalTraining += '</ul>';
        	$('.pedagogical-training-todo').html(pedagogicalTraining);
        	$('#pedagogical_training').html(pedagogicalTrainingOption);

        	/*Personnal Interest*/
	    	var personnalInterest = '<ul class="pedagogicalMenu">';
	    	var personnalInterestOption = '';
        	var personnalInterestResultJson = jsonResult.personnalInterestResultJson;
        	for (var pi = 0; pi < personnalInterestResultJson.length; pi++) {
        		personnalInterest += '<li>';
                personnalInterest += '<a href="#" data-linkInit = "'+personnalInterestResultJson[pi].link+'" data-titre = "'+personnalInterestResultJson[pi].titre+'" data-final-url = "'+personnalInterestResultJson[pi].final_url+'" data-thumb="'+personnalInterestResultJson[pi].thumbnail_file+'" class="btn btn-add-in-cours" onclick="addContentInPersonnalTraningArea(this,'+personnalInterestResultJson[pi].id_sequence+','+personnalInterestResultJson[pi].numero+','+idFav+',1);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'+personnalInterestResultJson[pi].titre+'</span></a>';
                personnalInterest += '</li>';
                personnalInterestOption += '<option data-id="'+personnalInterestResultJson[pi].id_sequence+'" value="'+personnalInterestResultJson[pi].titre+'">';
        	}
        	personnalInterest += '</ul>';
        	$('.personnal_interest_list').html(personnalInterest);
        	$('#personnal_interest_data_list').html(personnalInterestOption);

        	$('.pedagogicalMenu').treed();


        	/*Newsletter*/
	    	var newsletter = '<ul class="newslettermenu">';
	    	var newsletterOption = '';
        	var newsletterResultJson = jsonResult.newsletterResultJson;
        	for (var nl = 0; nl < newsletterResultJson.length; nl++) {
        		newsletter += '<li>';
                newsletter += '<a href="#" data-titre = "'+newsletterResultJson[nl].article+'" class="btn btn-add-in-cours" onclick="addContentInPersonnalTraningArea(this,'+newsletterResultJson[nl].ID+',null,'+idFav+',2);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'+newsletterResultJson[nl].article+'</span></a>';
                newsletter += '</li>';
                newsletterOption += '<option data-id="'+newsletterResultJson[nl].ID+'" value="'+newsletterResultJson[nl].article+'">';
        	}
        	newsletter += '</ul>';
        	$('.newsletterofthemonth').html(newsletter);
        	$('#newsletter_of_the_month').html(newsletterOption);
        	$('.newslettermenu').treed();

        	/*My links & document*/
	    	var linksAndDocument = '<ul class="linkanddocsmenu">';
	    	var linksAndDocumentOption = '';
        	var documentResultJson = jsonResult.documentResultJson;
        	for (var dc = 0; dc < documentResultJson.length; dc++) {
        		linksAndDocument += '<li>';
                linksAndDocument += '<a href="#" data-titre = "'+documentResultJson[dc].titre+'" class="btn btn-add-in-cours" onclick="addContentInPersonnalTraningArea(this,'+documentResultJson[dc].id+',null,'+idFav+',3);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'+documentResultJson[dc].titre+'</span></a>';
                linksAndDocument += '</li>';
                linksAndDocumentOption += '<option data-id="'+documentResultJson[dc].id+'" value="'+documentResultJson[dc].titre+'">';
        	}
        	linksAndDocument += '</ul>';
        	$('.database-document-exist').html(linksAndDocument);
        	$('#database_document_search').html(linksAndDocumentOption);
        	$('.linkanddocsmenu').treed();


        	/*Teacher links & document*/
	    	var teacherLinksAndDocument = '<ul class="teacherlinkanddocsmenu">';
	    	var teacherLinksAndDocumentOption = '';
        	var teacherLinksAndDocumentResultJson = jsonResult.teacherLinkAndDocumentJson;
        	//console.log('nb : ' + teacherLinksAndDocumentResultJson.length);
        	for (var td = 0; td < teacherLinksAndDocumentResultJson.length; td++) {
        		teacherLinksAndDocument += '<li>';
                teacherLinksAndDocument += '<a href="#" data-titre = "'+teacherLinksAndDocumentResultJson[td].titre+'" class="btn btn-add-in-cours" onclick="addContentInPersonnalTraningArea(this,'+teacherLinksAndDocumentResultJson[td].id+',null,'+idFav+',5);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'+teacherLinksAndDocumentResultJson[td].titre+'</span></a>';
                teacherLinksAndDocument += '</li>';
                teacherLinksAndDocumentOption += '<option data-id="'+teacherLinksAndDocumentResultJson[td].id+'" value="'+teacherLinksAndDocumentResultJson[td].titre+'">';
        	}
        	teacherLinksAndDocument += '</ul>';
        	//console.log(teacherLinksAndDocument);
        	$('.teacher-link-and-document-exist').html(teacherLinksAndDocument);
        	$('#teacher_link_and_document_search').html(teacherLinksAndDocumentOption);
        	$('.teacherlinkanddocsmenu').treed();



        	/*Community library soc*/
	    	var communityLibrary = '<ul class="communitylibrarymenu">';
	    	var communityLibraryOption = '';
        	var communityLibraryOptionResultJson = jsonResult.communityLibraryJson;
        	for (var cm = 0; cm < communityLibraryOptionResultJson.length; cm++) {
        		communityLibrary += '<li>';
                communityLibrary += '<a href="#" data-titre = "'+communityLibraryOptionResultJson[cm].titre+'" class="btn btn-add-in-cours" onclick="addContentInPersonnalTraningArea(this,'+communityLibraryOptionResultJson[cm].id+',null,'+idFav+',6);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'+communityLibraryOptionResultJson[cm].titre+'</span></a>';
                communityLibrary += '</li>';
                communityLibraryOption += '<option data-id="'+communityLibraryOptionResultJson[cm].id+'" value="'+communityLibraryOptionResultJson[cm].titre+'">';
        	}
        	communityLibrary += '</ul>';
        	$('.community-library-exist').html(communityLibrary);
        	$('#community_library_search').html(communityLibraryOption);
        	$('.communitylibrarymenu').treed();


        	$('.spinner').fadeOut('slow');
        	$('#pedagogicalTraining').addClass('active');
			$('#modal-personnalise-content-personnal-traning-area').addClass('open');
        }
    });
}

function addContentInPersonnalTraningArea(btn, id_prg, numero = null, id_classification_favoris, type){
	$(".spinner").fadeIn("slow");
    var title     = $(btn).attr('data-titre');
    var dataType = '';
    switch (type) { 
		case 1: 
			dataType = 'activity_sequence';
			break; 
		case 2: 
			dataType = 'nl_article';
			break; 
		case 3: 
			dataType = 'document';
			break;
		case 5: 
			dataType = 'library_professor';
			break;
		case 6: 
			dataType = 'community_library_forma2plus';
			break;
		default:	
			dataType = '';		
	}  

	$.ajax({
        url:      $('.baseURL').val()+"add-content-to-personal-traning-area",
        type:     'POST',       
        data:     {id_classification_favoris: id_classification_favoris, id_prg: id_prg, numero: numero, title: title, type: dataType},   
        dataType: 'json',
        success:  function(resultJson){
        	if (resultJson.insert >= 1) {        		
	            $(btn).removeAttr('onclick');
	            $(btn).find('i').removeClass('bx bxs-plus-circle glyphicon-plus-sign-modules');
	            $(btn).find('i').addClass('bx bxs-minus-circle glyphicon-plus-sign-modules');
	            toastr.success(data_save_ok); 
        	}
        	else{
        		toastr.error(data_saved_ko);
        	}
            $(".spinner").fadeOut("slow");
        }
    });
    return false;
}



