<div class="container-fluid">
  <div class="py-4">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="#">Accueil</a></li>
        <li class="breadcrumb-item"><a href="#">Utilisateur</a></li>
        <li class="breadcrumb-item active" aria-current="page">Liste</li>
      </ol>
    </nav>
  </div>
  <div class="content-bg bo-content">
    <h1 class="pb-3">Liste des utilisateurs &nbsp;<button class="btn-table-plus"><i class="bx bx-user-plus"></i></button></h1>
    <div class="row justify-content-center">
      <div class="col-12 pt-5">
        <div class="bo-form mb-5">
          <form name="form-users-search" id="form-users-search" action="<?php echo current_url() ?>" method="post">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <span class="form-label">Type d'utilisateur</span>
                  <select name="utilisateur_type" id="utilisateur_type" class="form-control">
                    <option></option>
                    <option <?php echo (isset($_POST['utilisateur_type']) && $_POST['utilisateur_type'] == 0) ? 'selected' : '' ?> value="0">Stagiaire</option>
                    <option <?php echo (isset($_POST['utilisateur_type']) && $_POST['utilisateur_type'] == 3) ? 'selected' : '' ?> value="3">Professeur</option>
                    <option <?php echo (isset($_POST['utilisateur_type']) && $_POST['utilisateur_type'] == 4) ? 'selected' : '' ?> value="4">Superviseur</option>
                    <option <?php echo (isset($_POST['utilisateur_type']) && $_POST['utilisateur_type'] == 2) ? 'selected' : '' ?> value="2">Administrateur</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <span class="form-label">Nom ou prénom(s) de l'utilisateur</span>
                  <input class="form-control" name="utilisateur_nom" id="utilisateur_nom" value="<?php echo isset($_POST['utilisateur_nom']) ? $_POST['utilisateur_nom'] : '' ?>" type="text" required>
                </div>
              </div>
              <div class="col-md-4">
                <button class="submit-btn submit-form-search" type="submit">Rechercher</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
    <div class="bo-table-container">        
      <table id="bo-users-table" class="display nowrap bo-table" style="width:100%">
        <thead>
          <tr>
            <th>Rôle</th>
            <th>Utilisateur</th>
            <th>Début accès</th>
            <th>Fin accès</th>
            <th>Nb cnx</th>
            <th>Dernière connexion</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if(isset($allResults) && count($allResults) >= 1) { foreach ($allResults as $user){ if (isset($user['id'])) { ?>
            <tr class="line_data_users">
              <td class="usersRole">
                <?php if ($user['type'] == 0) { ?>
                  STAGIAIRE
                <?php }elseif($user['type'] == 2){ ?>
                  ADMIN
                <?php }elseif($user['type'] == 3){
                  if ($user['tuteur_entreprise'] == 0) { ?>
                    PROFESSEUR
                  <?php } else{ ?>
                    RF
                <?php } }elseif($user['type'] == 4){ ?>
                  SUPERVISEUR
                <?php } else{ ?>
                  ACTEUR
                <?php } ?>
              </td>
              <td><?php echo $user['name']; ?></td>
              <td><?php echo (isset($user['date_debut_acces']) && $user['date_debut_acces'] != "") ? htmlspecialchars(date('Y/m/d', intval($user['date_debut_acces']))) : '' ?></td>
              <td><?php echo (isset($user['date_fin_acces']) && $user['date_fin_acces'] != "") ? htmlspecialchars(date('Y/m/d', intval($user['date_fin_acces']))) : '' ?></td>
              <td><?php echo $user['nbcnx']; ?></td>
              <td><?php echo (isset($user['last_cnx']) && $user['last_cnx'] != "") ? htmlspecialchars(date('Y/m/d', $user['last_cnx'])) : "(No connexion)" ?></td>
              <td class="text-center">
                <div class="btn-group row">
                  <button class="btn-table-less" style="<?php echo (isset($user['type']) && $user['type'] == 0) ? 'width: 33%;' : 'width: 50%;' ?>" onclick="deleteUser(<?php echo $user['id'] ?>,<?php echo $user['type'] ?>)"><i class="bx bx-trash"></i></button>
                  <a style="<?php echo (isset($user['type']) && $user['type'] == 0) ? 'width: 33%;' : 'width: 50%;' ?>" href="<?php echo base_url() ?>editmembers?id=<?php echo $user['id'] ?>&type=<?php echo $user['type'] ?>" class="btn-table-plus" ><i class="bx bx-edit"></i></a>
                  <?php if (isset($user['type']) && $user['type'] == 0) { ?>
                    <a href='#' style="<?php echo (isset($user['type']) && $user['type'] == 0) ? 'width: 33%;' : 'width: 50%;' ?>" onclick='window.open("<?php echo base_url().'adminbno?type_outil=2&menu=1&connexion='.$this->session->userdata ('CNX').'&id_modif='.$user['id'].'&groupe='.$user['id_groupe'] ?>","Obj","scrollbars=yes,width=550,height=590,resizable=yes")' class='btn-table-plus' ><i class='bx bxs-objects-horizontal-center'></i></a>
                  <?php } ?>
                </div>
              </td>
            </tr>
          <?php } } } ?>
        </tbody>
      </table>
    </div>
  </div><!-- .content-bg -->                            
</div>
<script type="text/javascript">
  function deleteUser(id,type){
    var res = confirm("Êtes-vous sûr de vouloir supprimer"+" "+id+"?");
    if(res){
      window.location.href="<?php echo base_url(); ?>deleteMembers?id="+id+"&type="+type;
    }
  }
</script>