<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Todolist_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();
        $this->load->model('membres_model');
        $this->load->model('utilities_model');
        $this->load->model('Teacher_link_and_document_model');
        $this->table = 'plan_de_travail';        
        $this->table_new_seq = 'new_sequence';   
        $this->table_cours_plannifier = 'cours_plannifier';   
        $this->table_membres = 'membres';     
        $this->table_stage = 'stag_individu';     
    }

    
    public function addnewlink($infoLink)
    {
        $this->db->trans_start();
        $this->db->insert($this->table_new_seq, $infoLink);
        
        $insert_id = $this->db->insert_id();
        
        $this->db->trans_complete();



        $this->db->select("MAX(id) as maxId");
        $this->db->from($this->table_new_seq);
        $query = $this->db->get();

        $result =  $query->result();

        if(!empty($result)){
            $infoUpdateLink = array('id_sequence'=>"NL".$result[0]->maxId);
            $this->db->where('link', $infoLink['link']);
            $this->db->where('titre', $infoLink['titre']);
            $this->db->update($this->table_new_seq, $infoUpdateLink);
            $this->db->affected_rows();
        } 


        $this->db->select("MAX(id) as maxId");
        $this->db->from($this->table_new_seq);
        $query = $this->db->get();

        $result =  $query->result();

        if(!empty($result)){
            $infoUpdateLink = array('id_sequence'=>"NL".$result[0]->maxId);
            $this->db->where('link', $infoLink['link']);
            $this->db->where('titre', $infoLink['titre']);
            $this->db->update($this->table_new_seq, $infoUpdateLink);
            $this->db->affected_rows();
        } 

        return $insert_id;
    }

    public function getMaxOrder($grp){
        $this->db->select("MAX(ordre_sequence) AS orderMax");
        $this->db->from($this->table);
        $this->db->where('id_groupe', $grp);
        $query = $this->db->get();
        $cnt = $query->num_rows();  
        if ($cnt >= 1) {
            $result =  $query->result();
            foreach ($result as $res){ 
                return $res->orderMax + 1;
            }
        }    
        else{
            return 1;
        }
    }
    public function update($id,$stat){
        $updateInfo = array('isDone'=>$stat,"date_cochage_lien"=>date("Y-m-d"));
        $this->db->where('id_plan_de_travail', $id);
        $this->db->update($this->table, $updateInfo);
        $this->db->affected_rows();
    }
    public function updateTodo($id_plan_de_travail,$dataInfo){
        $this->db->where('id_plan_de_travail', $id_plan_de_travail);
        $this->db->update($this->table, $dataInfo);
        $this->db->affected_rows();
    }
    public function resetHistorikCours($coursHistorik){
        $updateInfo = array('historique_cours'=>NULL);
        $this->db->where('historique_cours', $coursHistorik);
        $this->db->update($this->table, $updateInfo);
        $this->db->affected_rows();
    }
    public function deleteByHistorikCours($historique_cours){
        $this->db->where('historique_cours', $historique_cours);
        $this->db->delete($this->table);
    }
    public function updateCoursHistorique($id,$coursHistorik){
        $updateInfo = array('historique_cours'=>NULL);
        $this->db->where('id_plan_de_travail', $id);
        $this->db->update($this->table, $updateInfo);
        $this->db->affected_rows();
    }
    public function updateCoursHistoriqueByIdSequence($num_sequence,$groupes,$coursHistorik){
        $updateInfo = array('historique_cours'=>NULL);
        $this->db->where('num_sequence', $num_sequence);
        $this->db->where('id_groupe', $groupes);
        $this->db->update($this->table, $updateInfo);
        $this->db->affected_rows();
    }
    public function delete($id){
        $this->db->where('id_plan_de_travail', $id);
        $this->db->delete($this->table);
    }

    
    public function deletenewsequencebylib($idLib){
        $this->db->where('id_repertory', $idLib);
        $this->db->delete($this->table_new_seq);
    }
    
    public function deletenewsequence($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table_new_seq);
    }

    public function getInfoNewSeqInPlanDeW($idN){
        $this->db->select('*');
        $this->db->from($this->table);        
        $this->db->where('num_sequence', $idN);
        $query = $this->db->get();        
        $result = $query->result();        
        return $result;
    }

    

    public function getAllSourceByProfessor($array_data) {
        $this->db->select('s.*, p.id_stagiaire, p.historique_cours, CONCAT(m.prenom," ", m.nom) AS tuteur');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as s','s.id = p.num_sequence', 'inner');
        $this->db->join($this->table_membres.' as m','m.id = s.user_create', 'inner');
        $this->db->join($this->table_stage.' as ts','ts.id_stagiare_el = m.id', 'inner');
        $this->db->join($this->table_cours_plannifier.' as c','c.idStageCoursPlannifier = ts.id_stage_ext', 'inner');
        $this->db->where('c.dateHeureCoursPlannifier BETWEEN "'.$array_data["start_date"]. ' 00:00:00" AND "'.$array_data["end_date"].' 00:00:00"');
        if (!empty($array_data["trainer"]) && $array_data["trainer"] != 0) {
           $this->db->where('s.user_create', $array_data["trainer"]);
        }
        $this->db->where('m.type', 3);
        /*if ($array_data["societe"] != 0) {
           $this->db->where('soc.id_societe', $array_data["societe"]);
        }*/
        $query = $this->db->get(); 
        return $query->result()  ;
    }


    public function getAllSourceByProfessorForStat($array_data) {
        $this->db->select('DATE(FROM_UNIXTIME(s.date_cnx)) AS debutCnx');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as s','s.id = p.num_sequence', 'inner');
        $this->db->join($this->table_membres.' as m','m.id = s.user_create', 'inner');
        $this->db->join($this->table_stage.' as ts','ts.id_stagiare_el = m.id', 'inner');
        $this->db->join($this->table_cours_plannifier.' as c','c.idStageCoursPlannifier = ts.id_stage_ext', 'inner');
        $this->db->where('c.dateHeureCoursPlannifier BETWEEN "'.$array_data["start_date"]. ' 00:00:00" AND "'.$array_data["end_date"].' 00:00:00"');
   

        if (isset($array_data["trainer"]) && !empty($array_data["trainer"]) && isset($array_data["trainer"][1])) {
            $this->db->where_in('s.user_create', $array_data["trainer"]);
        }

        if (isset($array_data["connexion_date"][0]) && $array_data["connexion_date"][0] && isset($array_data["connexion_date"][1]) && $array_data["connexion_date"][1]) {
           $this->db->where('DATE(c.dateHeureCoursPlannifier) BETWEEN "'.$array_data["connexion_date"][0]. '" AND "'.$array_data["connexion_date"][1].'"');
        }
        else{
            $this->db->where('DATE(c.dateHeureCoursPlannifier)',$array_data["connexion_date"][0]);
        }


        $this->db->where('m.type', 3);
        $query = $this->db->get(); 
        return $query->result()  ;
    }



    public function TrainingProgTuteur($grp, $searchText = '', $page, $segment)
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        if(!empty($searchText)) {
            $likeCriteria = "(p.sequence  LIKE '%".$searchText."%'
                            OR  p.url  LIKE '%".$searchText."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->where('p.id_groupe', $grp);
        $this->db->order_by('p.ordre_sequence', 'asc');
        $this->db->limit($page, $segment);
        $query = $this->db->get();
        
        $result = $query->result();        
        return $result;
    }
    public function TrainingProgTuteurInCoursHistorikAndUserCreate($userCreate=NULL,$grp,$idHistorikCours)
    {
        $this->db->select('*,(SELECT COUNT(t.id_tracking) FROM tracking t,plan_de_travail pa WHERE t.sequence_id=pa.id_plan_de_travail AND  pa.id_plan_de_travail=p.id_plan_de_travail AND t.type=1) AS NBVUES,ls.type AS datatype,ls.id AS idnewsec, p.commentaire AS comment');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','INNER');
        $this->db->where('p.id_groupe', $grp);
        $this->db->where('p.historique_cours', $idHistorikCours);
        if ($userCreate != NULL) {
            $this->db->where('ls.user_create', $userCreate);
        }        
        $this->db->order_by('p.ordre_sequence', 'asc');
        $query = $this->db->get();
        
        $result = $query->result();        
        return $result;
    }

    public function countByIdGroup($idg){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idg);
        $query = $this->db->get();         
        return $query->num_rows();        
    }

    public function TrainingProgTuteurInUserCreateAndGrp($userCreate,$grp)
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        $this->db->where('p.id_groupe', $grp);
        $this->db->where('ls.user_create', $userCreate);
         $this->db->where('p.historique_cours', NULL);
        $this->db->order_by('p.ordre_sequence', 'asc');
        $query = $this->db->get();
        
        $result = $query->result();        
        return $result;
    }

    public function getContentByAuthorAndLib($user_create, $id_repertory)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $user_create);
        $this->db->where('id_repertory', $id_repertory);
        $this->db->where_not_in('link', '');
        $this->db->where_not_in('titre', 'SELECT titre FROM sequence');
        $this->db->group_by('titre');
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    }


    public function getAllByCourseHistoryAndType($idHistorikCours,$type)
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as n', 'p.num_sequence = n.id', 'INNER');
        $this->db->where('p.historique_cours', $idHistorikCours);
        $this->db->where('n.type', $type);
        $this->db->order_by('ordre_sequence', 'asc');
        $query = $this->db->get();
        return $query->result();        
    }

    public function getAllByCourseHistory($idHistorikCours)
    {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('historique_cours', $idHistorikCours);
        $this->db->order_by('ordre_sequence', 'asc');
        $query = $this->db->get();
        return $query->result();        
    }

    public function getByIdHistorikCours($idHistorikCours)
    {
        $this->db->select('*,(SELECT COUNT(t.id_tracking) FROM tracking t,plan_de_travail pa WHERE t.sequence_id=pa.id_plan_de_travail AND  pa.id_plan_de_travail=p.id_plan_de_travail AND t.type=1) AS NBVUES,ls.type AS typetumbnail,ls.id AS idnewsec');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        $this->db->join('membres as m', 'm.id = ls.user_create','left');
        $this->db->where('p.historique_cours', $idHistorikCours);
        $this->db->order_by('p.ordre_sequence', 'asc');
        $query = $this->db->get();
        return $query->result();        
    }

    public function getAllLinkAndDocNotInTodo($userCreate,$grp)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $userCreate);
        $this->db->where_not_in('id', array('SELECT num_sequence FROM '.$this->table.' WHERE id_groupe='.$grp.''));
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getAllLinkAndDocNotInTodoByTutor($userCreate)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $userCreate);
        $this->db->order_by('titre', 'ASC');
        $query = $this->db->get(); 
        return $query->result();
    }
    public function getAllLinkAndDocNoInRepertoryByTutor($userCreate)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $userCreate);
        $this->db->where('id_repertory', NULL);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getAllLinkAndDocInRepertory($id_repertory)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('id_repertory', $id_repertory);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    }

    public function getByAllDateIdGroup($groupe){
        $this->db->select('DATE_FORMAT(date_creation, "%b %Y") AS date_afficher, DATE_FORMAT(date_creation, "%m-%Y") AS date_value');
        $this->db->distinct('date_creation');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $groupe);
        $this->db->order_by('date_creation', 'desc');
        $query = $this->db->get();
        return $query->result();
    }

    public function getByAllByDateAndIdGroup($date_export,$id_groupe){
        $this->db->select('p.*,s.type AS documentType, (SELECT count(id_plan_de_travail) FROM plan_de_travail WHERE historique_cours = p.historique_cours) AS nbPlandeWParCh');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as s','s.id = p.num_sequence', 'INNER');
        $this->db->where('p.id_groupe', $id_groupe);
        $this->db->where('p.historique_cours !=', NULL);
        $this->db->like('DATE_FORMAT(p.date_creation, "%m-%Y")', $date_export);
        $this->db->order_by('p.historique_cours', 'desc');
        $query = $this->db->get();
        return $query->result();
    }

    public function getByAllByIdGroup($id_groupe){
        $this->db->select('p.*,s.type AS documentType, (SELECT count(id_plan_de_travail) FROM plan_de_travail WHERE historique_cours = p.historique_cours) AS nbPlandeWParCh');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as s','s.id = p.num_sequence', 'INNER');
        $this->db->where('p.id_groupe', $id_groupe);
        $this->db->where('p.historique_cours !=', NULL);
        $this->db->order_by('p.historique_cours', 'desc');
        $query = $this->db->get();
        return $query->result();
    }


    public function existPlandeW($idHc,$idnewsec,$groupe){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $groupe);
        $this->db->where('num_sequence', $idnewsec);
        $this->db->where('historique_cours', $idHc);
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function existPlandeWs($idHc,$url,$titre,$groupe){
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $groupe);
        $this->db->where('url', $url);
        $this->db->where('sequence', $titre);
        $this->db->where('historique_cours', $idHc);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function TrainingProgTuteurCount($searchText = '',$grp)
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        if(!empty($searchText)) {
            $likeCriteria = "(p.sequence  LIKE '%".$searchText."%'
                            OR  p.url  LIKE '%".$searchText."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->where('p.id_groupe', $grp);
        $query = $this->db->get(); 
        return count($query->result());
    }
    public function ReadTrainingProg($id)
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        
        $this->db->where('p.id_plan_de_travail', $id);
        $query = $this->db->get();
        
        $result = $query->result();        
        return $result;
    }
    public function TrainingProg($grp, $searchText = '', $page, $segment)
    {
        $this->db->select('*');
        $this->db->select('(SELECT COUNT(t.id_tracking) FROM tracking t,plan_de_travail pa WHERE t.sequence_id=pa.id_plan_de_travail AND  pa.id_plan_de_travail=p.id_plan_de_travail AND t.type=1) AS NBVUES');
        $this->db->select('ls.type AS typetumbnail');
        $this->db->select('ls.id AS idnewsec');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
       
        $this->db->join('membres as m', 'm.id = ls.user_create','left');
        if(!empty($searchText)) {
            $likeCriteria = "(p.sequence  LIKE '%".$searchText."%'
                            OR  p.url  LIKE '%".$searchText."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->where('p.id_groupe', $grp);
        $this->db->order_by('p.ordre_sequence', 'asc');
        $this->db->limit($page, $segment);
        $query = $this->db->get();
        
        $result = $query->result();        
        return $result;
    }

    public function TrainingProgTutorNullHistorikCourse($idStagiaire,$grp)
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        $this->db->where('p.id_groupe', $grp);
        $this->db->where('ls.user_create !=', $idStagiaire);
        $this->db->where('p.historique_cours', NULL);
        $query = $this->db->get();
        return $query->result();
    }

    public function TrainingProgCount($searchText = '',$grp)
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        if(!empty($searchText)) {
            $likeCriteria = "(p.sequence  LIKE '%".$searchText."%'
                            OR  p.url  LIKE '%".$searchText."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->where('p.id_groupe', $grp);
        $query = $this->db->get(); 
        return count($query->result());
    }

    public function TodoListDashbord($grp)
    {
        $this->db->select('*');
        $this->db->select('(SELECT COUNT(t.id_tracking) FROM tracking t,plan_de_travail pa WHERE t.sequence_id=pa.id_plan_de_travail AND  pa.id_plan_de_travail=p.id_plan_de_travail AND t.type=1) AS NBVUES');
        $this->db->select('ls.type AS typetumbnail');
        $this->db->select('ls.id AS idnewsec');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
       
        $this->db->join('membres as m', 'm.id = ls.user_create','left');
        
        $this->db->where('p.id_groupe', $grp);
  
        $query = $this->db->get();
        
        $result = $query->result();        
        return $result;
    }

    public function listLinksDocsBySearch($groupes,$user_create,$key) {

        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $user_create);
        if(!empty($key)) {
            $likeCriteria = "(titre  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    } 
    

    public function getNewSeqById($id,$order) {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('id', $id);
        $this->db->order_by($order, 'asc');
        $query = $this->db->get(); 
        return $query->result();
    } 

    public function getNewSeqByParams($user_create,$key,$order) {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $user_create);
        if(!empty($key)) {
            $likeCriteria = "(titre  LIKE '%".$key."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->order_by($order, 'asc');
        $query = $this->db->get(); 
        return $query->result();
    }

    public function listLinksDocs($searchText = '', $page, $segment,$user_create) {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $user_create);
        if(!empty($searchText)) {
            $likeCriteria = "(titre  LIKE '%".htmlentities($searchText)."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->order_by('id', 'desc');
        $this->db->limit($page, $segment);
        $query = $this->db->get(); 
        return $query->result();
    } 

    public function countLinksDocs($searchText = '',$user_create)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $user_create);
        if(!empty($searchText)) {
            $likeCriteria = "(titre  LIKE '%".htmlentities($searchText)."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->group_by('id');
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->num_rows();
    } 

    public function getAllLibraryByUserCreate($user_create)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $user_create);
        $this->db->group_by('id');
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    } 

    public function ReadDataLibrary($id) {
        
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('id', $id);
        $query = $this->db->get();         
        $result = $query->result()  ;        
        if (is_array($result)) {         
            foreach ($result as $res) {  
                $ret['titre']   = $res->titre;
                $ret['comment'] = $res->comment ;
                $ret['date_create']    = $res->date_create ;
                $ret['file']    = $res->link ;
                $ret['user_create']      = $res->user_create ;
                return($ret) ;
            }
        }
        return(false);
    }

    public function getAllDataNotInLibrary($user_create)
    {
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $user_create);
        $this->db->where('id_repertory', NULL);
        $this->db->group_by('titre');
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result();
    } 

    public function addTodo($id,$grp,$idHc=NULL) {

        $date = getdate() ;
        $getMaxOrder = $this->getMaxOrder($grp); 

        $infoS = $this->membres_model->getInfoStagiaire($grp);
        foreach($infoS as $trainne){
            $idTrainee = $trainne->id;
        }


        $getInfoNewSequence = $this->getInfoNewSequence($id);
        foreach($getInfoNewSequence as $s){
            $todoInfo = array(
                'sequence'=>utf8_encode($s->titre), 
                'url'=>utf8_encode($s->link),
                "num_sequence"=>$id,
                "historique_cours"=>$idHc,
                "ordre_sequence"=>$getMaxOrder,
                "isDone"=>0,
                "date_creation"=>date('Y-m-d'),
                "date_acces_stagiaire"=>"",
                "date_cochage_lien"=>"0000-00-00",
                "date_prev"=>"0000-00-00",
                "id_groupe"=>$grp,                
                "id_stagiaire"=>$idTrainee,
                "commentaire"=>$s->commentaire
            );
            
            $this->db->trans_start();
            $this->db->insert($this->table, $todoInfo);        
            $id = $this->db->insert_id();        
            $this->db->trans_complete();
            return $id;

        }
        //return $return;
    }

    public function getSequenceMaxOrder()
    {
        $idSequence = 'NL';
        $this->db->select('MAX(id) as maxId');
        $this->db->from($this->table_new_seq);
        $query = $this->db->get(); 
        foreach ($query->result() as $res) {
            $idSequence .= ($res->maxId + 1);
        }
        return $idSequence;
    } 

    public function addContentTeacherLinkAndDocInTodo($id,$grp,$idHc=NULL) {

        $date = getdate() ;
        $idTrainee = '';
        $getMaxOrder = $this->getMaxOrder($grp); 

        $infoS = $this->membres_model->getInfoStagiaire($grp);
        foreach($infoS as $trainne){
            $idTrainee = $trainne->id;
        }

        $data = array(
            'titre'=>$this->Teacher_link_and_document_model->RequestContent('titre', $id), 
            'link'=>$this->Teacher_link_and_document_model->RequestContent('link', $id),
            'type'=>$this->Teacher_link_and_document_model->RequestContent('type', $id), 
            'commentaire'=>$this->Teacher_link_and_document_model->RequestContent('commentaire', $id),
            'date_create'=>$this->Teacher_link_and_document_model->RequestContent('date_create', $id), 
            'user_create'=>$this->Teacher_link_and_document_model->RequestContent('user_create', $id),
            "ifrmaccess"=>$this->Teacher_link_and_document_model->RequestContent('ifrmaccess', $id),
            "id_repertory"=>$this->Teacher_link_and_document_model->RequestContent('id_repertory', $id)
        );

        $idNewSequence = $this->addnewlink($data);

        if (isset($idNewSequence)) {
            $getInfoNewSequence = $this->getInfoNewSequence($idNewSequence);
            foreach($getInfoNewSequence as $s){
                $todoInfo = array(
                    'sequence'=>utf8_encode($s->titre), 
                    'url'=>utf8_encode($s->link),
                    "num_sequence"=>$idNewSequence,
                    "historique_cours"=>$idHc,
                    "ordre_sequence"=>$getMaxOrder,
                    "isDone"=>0,
                    "date_creation"=>date('Y-m-d'),
                    "date_acces_stagiaire"=>"",
                    "date_cochage_lien"=>"0000-00-00",
                    "date_prev"=>"0000-00-00",
                    "id_groupe"=>$grp,                
                    "id_stagiaire"=>$idTrainee,
                    "commentaire"=>$s->commentaire
                );
                
                $this->db->trans_start();
                $this->db->insert($this->table, $todoInfo);        
                $todoId = $this->db->insert_id();        
                $this->db->trans_complete();
                return $todoId;

            }
        }
        //return $return;
    }

    public function updateNewSequence($id,$data) {
        
        $this->db->where('id', $id);
        $this->db->update($this->table_new_seq, $data);
        $this->db->affected_rows();
          
    }
    public function updatelink($id,$link) {

        $date = getdate() ;
        $infoUpdateLink = array('thumbnail_file'=>$link,'date_create'=>$date[0]);
        $this->db->where('id', $id);
        $this->db->update($this->table_new_seq, $infoUpdateLink);
        $this->db->affected_rows();
          
    }
    public function updatelinks($id,$link,$statacctumb) {

        $date = getdate() ;
        $infoUpdateLink = array('thumbnail_file'=>$link,'date_create'=>$date[0],'ifrmaccess'=>$statacctumb);
        $this->db->where('id', $id);
        $this->db->update($this->table_new_seq, $infoUpdateLink);
        $this->db->affected_rows();
          
    }
    public function getByOthorInLibrary($author){
        $criteria = array(NULL,0);
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $author);
        $this->db->where_not_in('id_repertory', $criteria);
        $query = $this->db->get(); 
        $result = $query->result();
        return $result;
    }

    public function getInfoNewSequenceByLibrary($id_library){
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('id_repertory', $id_library);
        $query = $this->db->get(); 
        $result = $query->result();
        return $result;
    }

    public function getInfoNewSequence($id){
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('id', $id);
        $query = $this->db->get(); 
        $result = $query->result();
        return $result;
    } 
     

     public function AdminTodo($searchText = '', $page, $segment)
    {
        $this->db->select('*');
        $this->db->select('(SELECT COUNT(s.id) FROM stat_programme s WHERE s.id_prg=ls.id AND s.type="todolist" AND s.type=0) AS NBCOMMENT');
        $this->db->select('(SELECT COUNT(t.id_tracking) FROM tracking t,plan_de_travail pa WHERE t.sequence_id=pa.id_plan_de_travail AND  pa.id_plan_de_travail=p.id_plan_de_travail AND t.type=2) AS NBVUES');
        $this->db->select('ls.id AS idnewsec');
        $this->db->select('ls.type AS datatype');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');       
        $this->db->join('membres as m', 'm.id = ls.user_create','left');
        if(!empty($searchText)) {
            $likeCriteria = "(p.sequence  LIKE '%".$searchText."%'
                            OR  p.url  LIKE '%".$searchText."%')";
            $this->db->where($likeCriteria);
        }
        $this->db->order_by('p.id_plan_de_travail', 'asc');
        $this->db->limit($page, $segment);
        $query = $this->db->get();
        
        $result = $query->result();        
        return $result;
    }

    public function CountAdminTodo($searchText = '')
    {
        $this->db->select('*');
        $this->db->from($this->table.' as p');
        $this->db->join($this->table_new_seq.' as ls', 'ls.id = p.num_sequence','left');
        if(!empty($searchText)) {
            $likeCriteria = "(p.sequence  LIKE '%".$searchText."%'
                            OR  p.url  LIKE '%".$searchText."%')";
            $this->db->where($likeCriteria);
        }
        $query = $this->db->get(); 
        return count($query->result());
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id_plan_de_travail', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }


    public function getAllByOthor($prop,$idRep,$rowperpage,$rowid){
        $this->db->select('*');
        $this->db->from($this->table_new_seq);
        $this->db->where('user_create', $prop);
        $this->db->where('id_repertory !=', $idRep);
        $this->db->or_where('id_repertory',NULL);
        $this->db->limit($rowperpage,$rowid);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    
    public function RequestNewSequence($field,$id) {

        $this->db->select($field);
        $this->db->from($this->table_new_seq);
        $this->db->where('id', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
}

?>