
<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Sessions_model extends CI_Model
{
    
    public function __construct(){    
        
        parent::__construct();
     
        $this->load->model('membres_model');
        $this->load->model('utilities_model');    
        $this->load->model('sequence_model');    
        $this->load->model('modules_model');   
        $this->load->model('parcours_model');   
        $this->table = 'session_groupe' ; 
        $this->table_parcours = 'list_parcours' ; 
     
    }

    public function delItemByGroupAndModuleAndSequence($idg,$idm,$ids){

        #####
        $this->db->where(1, 1);     
        if($ids!=-1){
            $this->db->where('sequence_id', $ids);
        }
        if($idm!=-1){
            $this->db->where('module_id', $idm);
        }
        if($idg!=-1){
            $this->db->where('groupe_id', $idg); 
        }
        $this->db->delete($this->table);
    }


    public function delItem($ids=-1,$locs=-1,$idm=-1,$locm=-1,$idp=-1,$locp=-1,$idg=-1) {

        $this->db->where(1, 1);
        if($ids!=-1){
            $this->db->where('sequence_id', $ids);
            $this->db->where('locs', $locs);
        }
        if($idm!=-1){
            $this->db->where('module_id', $idm);
            $this->db->where('locm', $locm);
        }
        if($idp!=-1){
            $this->db->where('parcours_id', $idp);
            $this->db->where('locp', $locp);
        }
        if($idg!=-1){
            $this->db->where('groupe_id', $idg);
        }
        $this->db->delete($this->table);


    }

    public function read($idg) {
        $keys = array('8', '11');
        $this->db->select('count(distinct p.parcours_id)');
        $this->db->from($this->table.' as s');
        $this->db->join($this->table_parcours.' as p', 'p.parcours_id=s.parcours_id','left');
        $this->db->where('s.groupe_id', $idg);
        $this->db->where_in('p.matiere_id', $keys);
        $query = $this->db->get(); 
        if ( $query->num_rows() > 0 ) {
            $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
            $this->db->from($this->table);
            $this->db->where('groupe_id', $idg);
            $this->db->where('sequence_id > ', 0);
            $this->db->order_by('ordre', 'parcours_id','module_id','sequence_id');
        }
        else{
            $this->db->select('sequence_id,locs,module_id,locm,parcours_id,locp,ordre');
            $this->db->from($this->table);
            $this->db->where('groupe_id', $idg);
            $this->db->where('sequence_id > ', 0);
            $this->db->order_by('ordre', 'parcours_id','module_id','sequence_id');
        }

        $query = $this->db->get(); 
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ;  
        $i = 0 ;      
        foreach ($result as $res){
            $ret[$i]['sequence_id'] = $res->sequence_id ;
            $ret[$i]['locs']        = $res->locs ;
            $ret[$i]['module_id']   = $res->module_id ;
            $ret[$i]['locm']        = $res->locm ;
            $ret[$i]['parcours_id'] = $res->parcours_id ;
            $ret[$i]['locp']        = $res->locp ;
            $ret[$i]['ordre']       = $res->ordre ;
            $i++ ;
        }

        for($i=0;$i<$ret['cnt'];$i++) {
            $name = '' ;
            $ret[$i]['sequence_name'] = $this->sequence_model->Title($ret[$i]['sequence_id'],$ret[$i]['locs']);
            $ret[$i]['module_name'] = $this->modules_model->Title($ret[$i]['module_id'],$ret[$i]['locm']);
            $ret[$i]['parcours_name'] = $this->parcours_model->Title($ret[$i]['parcours_id'],$ret[$i]['locp']);
        }
        return($ret);
    }
   
}

?>
