<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Document_repository_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct(); 
        $this->table            = 'document_repertory';     
        $this->table_doc        = 'document';        
        $this->table_membres    = 'membres';        
    }



    public function add($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }
    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }

    public function Request($field,$idc) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('name', 'asc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getAllByTypeMmebres($typeMembers) {
        $this->db->select('CONCAT(m.prenom," ", m.nom) AS membre, COUNT(rep.id) AS nbRep, COUNT(m.id) AS nbContent');
        $this->db->from($this->table_doc.' as dc');
        $this->db->join($this->table_membres.' as m', 'm.id_groupe = dc.groupe', 'INNER');
        $this->db->join($this->table.' as rep', 'rep.id = dc.id_repertory AND rep.user_create = m.id', 'INNER');
        $this->db->where('m.type', $typeMembers);
        $this->db->group_by('repp.id', 'asc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getByUserCreateIdGroup($idUserCreate,$idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('name', 'asc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getByUserCreateIdGroupAndTraineeSession($idUserCreate,$idGroup,$stagiaireId,$Order) {
        $author = array($idUserCreate,$stagiaireId);
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where_in('user_create', $author);
        $this->db->where('id_groupe', $idGroup);
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('name', 'asc');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getByGroup($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $query = $this->db->get(); 
        return $query->num_rows()  ; 
    }
    public function getByIdGroup($idGroup,$Order) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getByIdGroupNotInDocument($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->where_not_in('id', 'SELECT id_repertory FROM '.$this->table_doc.'');
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('id', 'desc');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getByUserCreateIdGroupNotInDocument($idUserCreate,$idGroup,$Order) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('user_create', $idUserCreate);
        $this->db->where('id_groupe', $idGroup);
        $this->db->where_not_in('id', 'SELECT id_repertory FROM '.$this->table_doc.'');
        if (isset($Order) && $Order == 'an') {
            $this->db->order_by('name', 'asc');
        }
        elseif (isset($Order) && $Order == 'dn') {
            $this->db->order_by('name', 'desc');
        }        
        elseif (isset($Order) && $Order == 'aid') {
            $this->db->order_by('id', 'asc');
        }        
        elseif (isset($Order) && $Order == 'did') {
            $this->db->order_by('id', 'desc');
        }
        else{
            $this->db->order_by('name', 'asc');
        }
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

}

?>
