<?php
define('THEMES','');
define("MAX_FILE_SIZE", "");
class HTML_Form {
	var $content = '' ; // Contient le code HTML.
	var $action;
	var $submit; //Contient la valeur du 'submit' du formulaire.
	var $submitButtonName; 	//Nom du bouton d'envoi du formulaire.
	var $submitActif = true ; 	//Bouton Submit
	var $formulaireName;	//Nom du formulaire
	var $idGroupe;
	var $serveurLocation;

	var $hidden = ""; //Contient le code des champs hidden, appel� dans toHTML
	var $cpt = 0; // compteur d'identifiant

	var $width1 = 30;
	var $color  = "#ECF2FD" ;

	function __construct($action, $name = '', $width='70', $titre) {
		global $ad_titre;
		$this->action 			= $action;
		$this->formulaireName	= ($name==''?'formulaire':$name);
		$this->submitButtonName = $ad_titre['enreg'];
		
		$this->content = '
  <table width="84%"  border="0" cellspacing="0" cellpadding="0">
    <tr>
 	  <td>
		<table width="100%"  border="0" cellspacing="0" cellpadding="0">
		  <tr>
			<td>
			  <table width="100%"  border="0" cellspacing="0" cellpadding="0">
				<tr valign="top">
					
					<td colspan="3" class="f2p_titreBox" width="100%" height="10" align="center" valign="middle">'.$titre.'</td>
					
				</tr>
			  </table>
			</td>
		  </tr>
		  <tr>
			<td style="border:1px solid #999; background-color:#fff;" align="center">
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
			     <form action="'.$this->action.'" method="post" enctype="multipart/form-data" name="'.$this->formulaireName.'">
				 <tr>
					<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
					<td width="100%" colspan="2" height="10" class="tabcell">&nbsp;</td>
					<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
				  </tr>';
	}


	/**
	 * HTML_Form :: toHTML()
	 * Lucas : option ne pas afficher le txt de l�gende sur les champs obligatoires
	 * Retourne le code HTML du formulaire.
	 * @return string code HTML.
	 * @access	public
	 **/
	function toHTMLSeandMailSms($disp_txt_obli=true) {
		global $ad_titre ;

		$valid = '&nbsp;' ;
		$txt_obli = $disp_txt_obli ? "&nbsp;* : ".$ad_titre['renseign'] : '';		// ligne du formulaire avec: * renseigmt obli

		if ( $this->submit != '' && $this->idGroupe == '' && $this->serveurLocation == '') {
			//Commande pour v�rification automatique des champs obligatoire
			$valid = '<input class="form" value="'.$this->submitButtonName.'" type="button" onclick="return('.$this->submit.'(this.form));"/>';
		} elseif ($this->submit != '' && $this->idGroupe != '' && $this->serveurLocation != '') {
			$idGroupe = $this->idGroupe;
			$serverLocation = $this->serveurLocation;
			$valid = "<input class=\"form\" value=".$this->submitButtonName." type=\"button\" onclick=\"return(".$this->submit."(this.form, ".$idGroupe.", '".$serverLocation."' ));\" />";
		}
		elseif ( $this->submitActif ) {
			$valid = '<input class="form submit_send_mail_sms_stagiaire" name="sendMailSMS" type="submit" value="Envoyer Mail SMS" />';
			$valid .= '<input class="form submit_send_mail_stagiaire" name="envoyer_mail" type="submit" value="Envoyer Mail" />';
			$valid .= '<input class="form submit_send_sms_stagiaire" name="sendSMS" type="submit" value="Envoyer SMS" />';
		} else {
			$txt_obli = "&nbsp" ;
		}



		$this->content.= '
				 <tr>
					<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
					<td width="100%" colspan="2" height="10" class="tabcell">&nbsp;</td>
					<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
				 </tr>
				 <tr>	<!-- derniere ligne dans le formulaire*/ -->
					<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
					<td width="'.$this->width1.'%" height="30" align="left" valign="middle">'.$txt_obli.'</td>
					<td width="'.(100-$this->width1).'%" height="30" align="right" valign="top" class="tabcell">'.$valid.'</td>
					<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
				 </tr>
				 <tr>
					<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
					<td width="100%" colspan="2" height="10" class="tabcell">&nbsp;</td>
					<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
				  </tr>
					 '.$this->hidden.'
			      </form>
			   </table>
		    </td>
		  </tr>
		  <tr>
			<td>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				  <tr>
					
					<td colspan="3" width="100%"><img src="'.THEMES.'images/px_trans.gif" alt="" width="1" height="10"></td>
					
				  </tr>
				</table>
			</td>
		  </tr>
	  </table>
	 </td>
	</tr>
</table>' ;
		return($this->content);
	}
	function toHTML($disp_txt_obli=true) {
		global $ad_titre ;

		$valid = '&nbsp;' ;
		$txt_obli = $disp_txt_obli ? "&nbsp;* : ".$ad_titre['renseign'] : '';		// ligne du formulaire avec: * renseigmt obli

		if ( $this->submit != '' && $this->idGroupe == '' && $this->serveurLocation == '') {
			//Commande pour v�rification automatique des champs obligatoire
			$valid = '<input class="form" value="'.$this->submitButtonName.'" type="button" onclick="return('.$this->submit.'(this.form));"/>';
		} elseif ($this->submit != '' && $this->idGroupe != '' && $this->serveurLocation != '') {
			$idGroupe = $this->idGroupe;
			$serverLocation = $this->serveurLocation;
			$valid = "<input class=\"form\" value=".$this->submitButtonName." type=\"button\" onclick=\"return(".$this->submit."(this.form, ".$idGroupe.", '".$serverLocation."' ));\" />";
		}
		elseif ( $this->submitActif ) {
			$valid = '<input class="form" type="submit" value="'.$this->submitButtonName.'" />';
		} else {
			$txt_obli = "&nbsp" ;
		}



		$this->content.= '
				 <tr>
					<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
					<td width="100%" colspan="2" height="10" class="tabcell">&nbsp;</td>
					<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
				 </tr>
				 <tr>	<!-- derniere ligne dans le formulaire*/ -->
					<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
					<td width="'.$this->width1.'%" height="30" align="left" valign="middle">'.$txt_obli.'</td>
					<td width="'.(100-$this->width1).'%" height="30" align="right" valign="top" class="tabcell">'.$valid.'</td>
					<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
				 </tr>
				 <tr>
					<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
					<td width="100%" colspan="2" height="10" class="tabcell">&nbsp;</td>
					<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="10"></td>
				  </tr>
					 '.$this->hidden.'
			      </form>
			   </table>
		    </td>
		  </tr>
		  <tr>
			<td>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				  <tr>
					
					<td colspan="3" width="100%"><img src="'.THEMES.'images/px_trans.gif" alt="" width="1" height="10"></td>
					
				  </tr>
				</table>
			</td>
		  </tr>
	  </table>
	 </td>
	</tr>
</table>' ;
		return($this->content);
	}

	/**
	* HTML_Form :: addRow()
	* Ajoute une ligne de titre au formulaire.
	* @param	string	$titre	intitul�
	* @param	string	$champ	valeur du champ
	* @access	public
	**/
	function addRow($titre, $champ) {
		$this->content.= '
		 <tr>
			<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
			<td width="'.$this->width1.'%" height="30" align="left" valign="top" class="tabcell">'.$titre.'</td>
			<td width="'.(100-$this->width1).'%" height="30" align="left" valign="top" class="tabcell">'.$champ.'</td>
			<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
		  </tr>';
	}

	/**
	* HTML_Form :: addFreeRow()
	* Ajoute une ligne .
	* @access	public
	**/
	function addFreeRow() {
		$this->content.= '
		 <tr>
			<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
			<td width="'.$this->width1.'%" height="30" align="left" valign="top" class="tabcell">&nbsp;</td>
			<td width="'.(100-$this->width1).'%" height="30" align="left" valign="top" class="tabcell">&nbsp;</td>
			<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
		  </tr>';
	}

	/**
	 * HTML_Form :: addTitreText()
	 * Ajoute une ligne de titre au formulaire.
	 * @param	string	$titre	intitul�
	 * @param	string	$color	couleur de la ligne
	 * @access	public
	 **/
	function addTitreText($titre) {
		$this->content.= '
		 <tr>
			<td width="10"><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
			<td width="100%" height="30" colspan="2" align="left" valign="middle" ><h3>'.$titre.'</h3></td>
			<td width="10" ><img src="'.THEMES.'images/px_trans.gif" alt="" width="10" height="1"></td>
		  </tr>';
	}


	/**
	* HTML_Form :: addHidden()
	* Ajoute un �l�ment 'input' de type 'hidden' au formulaire.
	* @param	$val	valeur
	* @param	$name	nom �ventuel du champs
	* @access	public
	**/
	function addHidden($val, $name='') {
		$this->cpt += 1; // compteur d'identifiant
		$name = ($name==''?'text'.$this->cpt:$name);
		$this->hidden.= "<input type=\"hidden\" value=\"".$val."\" name=\"".$name."\" />\n";
	}

	/**
	* HTML_Form :: addTextInfo()
	* Ajoute une nouvelle ligne avec une info au formulaire.
	* @param	string	$titre	intitul�
 	* @param	variant $val	valeur de l'attribut "value"
	* @access	public
	**/
	function addTextInfo($titre, $val) {
		$this->addRow($titre, $val) ;
	}

	/**
	* HTML_Form :: addTextImage()
	* Ajoute une image au formulaire.
	* @param	string	$titre			le titre de la ligne
	* @param	string	$lienImage		lien vers l'image
	* @access public
	**/
	function addTextImage($titre, $lienImage, $width ='', $height='') {
		$width 	= ($width==''?'':' width="'.$width.'px"');
		$height = ($height==''?'':' height="'.$height.'px"');
		$this->addRow($titre, '<img src="'.$lienImage.'"'.$width.$height.'/>') ;
	}

	/**
	 * HTML_Form :: addTextFileManager()
	 * Ajoute un 'file manager' au formulaire.
	 * @param	string	$titre			le titre de la ligne
	 * @param	string	$val			valeur par d�faut
	 * @param	array	$cmd
	 * @param 	bool	$obligatoire 	indique si le champ est obligatoire
	 * @param	string	$form			nom du formulaire
	 * @access	public
	 **/
	function addTextFileManager($titre, $val, $cmd, $obligatoire=true, $form='formulaire') {
		$this->cpt += 1; // compteur d'identifiant
     	$url = '&cmd='.$cmd.'&id='.$this->cpt.'&form='.$form ;
     	//$url = PAGE_DIR.'&cmd='.$cmd.'&id='.$this->cpt.'&form='.$form ;
		$click = "onClick=\"openWindow('".$url."','filemanager','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');

        $codeChamps = " <input class=\"form\" type=\"text\" maxLength=\"254\" size=\"".(LG_TA-10)."\" value=\"".$val."\" name=\"text".$this->cpt."\" />\n";
		$codeChamps.= "<a href=\"javascript:void(0);\" ".$click."><span class='glyphicon glyphicon-file'></span></a>\n";
		$this->addRow($titre.$obl, $codeChamps) ;

	}
	function addTextFileManagers($titre, $val, $cmd, $obligatoire=true, $form='formulaire') {
		$this->cpt += 1; // compteur d'identifiant
     	$url = 'filemanager?loc='.LOC.'&cmd='.$cmd.'&cmd1='.$cmd.'&id='.$this->cpt.'&form='.$form ;
		$click = "onClick=\"openWindow('".$url."','filemanager','scrollbars=yes,resizable=yes,width=500,height=590')\" ";
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');

        $codeChamps = " <input class=\"form\" type=\"text\" maxLength=\"254\" size=\"".(LG_TA-10)."\" value=\"".$val."\" name=\"support\" />\n";
		$codeChamps.= "<a href=\"javascript:void(0);\" ".$click."><span class='glyphicon glyphicon-file'></span></a>\n";
		$this->addRow($titre.$obl, $codeChamps) ;

	}

	/**
	 * HTML_Form :: addPassword()
	 * Ajoute un �l�ment 'input' de type 'password' au formulaire.
	 * @param 	string  $titre
	 * @param 	string  $val
	 * @param 	bool	$obligatoire
	 * @access	public
	 **/
	function addPassword($titre, $val='', $obligatoire=true) {
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$size = 30 ;
		$this->cpt += 1; // compteur d'identifiant
		$input = "<input class=\"form\" type=\"password\" maxlength=\"50\" size=\"".$size."\" value=\"".$val."\" name=\"text".$this->cpt."\" />";
		$this->addRow($titre.$obl, $input) ;

	}

	/**
	* HTML_Form :: addTextFile()
	* Ajoute un upload de fichier.
	* @param	string	$titre			le titre de la ligne
	* @param	string	$val			le chemin �ventuel par d�faut
	* @param	integer	$size			taille du champs
	* @param	boolean	$obligatoire	indique si le champs est obligatoire
	* @access public
	**/
	function addTextFile($titre, $val='', $size='', $obligatoire=true) {
		$this->cpt += 1; // compteur d'identifiant
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$size=($size==''?MAX_FILE_SIZE:$size);
		//$input = "<input class=\"form\" id=\"filer_input\" type=\"file\" size=\"23\" value=\"".$val."\" name=\"text".$this->cpt."\" maxLength=\"240\" />";
		$input = "<input class=\"form\" type=\"file\" size=\"23\" value=\"".$val."\" name=\"text".$this->cpt."\" maxLength=\"240\" />";
		$input.= (strlen($size)!=0?"<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$size."\" />":"");
		$this->addRow($titre.$obl, $input) ;
	}

	/**
	 * HTML_Form :: addText()
	 * Ajoute un �l�ment 'input' de type 'text' au formulaire.
	 * @param 	string  $titre
	 * @param 	string  $val
	 * @param 	bool	$obligatoire
	 * @access	public
	 **/
	function addText($titre, $val = '', $obligatoire=true, $size=30, $name='',$maxlength=90) {
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$this->cpt += 1; // compteur d'identifiant
		$name = ($name==''?'text'.$this->cpt:$name);
		$input = "<input class=\"form\" name=\"".$name."\" type=\"text\" maxlength=\"".$maxlength."\" size=\"".$size."\" value=\"".$this->ProtectTextValue($val)."\"  />";
		$this->addRow($titre.$obl, $input) ;
	}

	function ProtectTextValue($var) {
	      return(str_replace('"', "'", $var));
	  }
	function addTextSubjectMail($titre, $val = '', $obligatoire=true, $size=30, $name='',$maxlength=90) {
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$this->cpt += 1; // compteur d'identifiant
		$name = ($name==''?'text'.$this->cpt:$name);
		$input = "<input class=\"\" name=\"".$name."\" type=\"text\" maxlength=\"".$maxlength."\" size=\"".$size."\" value=\"".$this->ProtectTextValue($val)."\"  />";
		$this->addRow($titre.$obl, $input) ;
	}

	function addTextMail($titre, $val = '', $obligatoire=true, $size=30, $name='',$maxlength=90) {
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$this->cpt += 1; // compteur d'identifiant
		$name = ($name==''?'text'.$this->cpt:$name);
		$input = "<p>E-mail<br><input class=\"\" name=\"".$name."\" type=\"text\" maxlength=\"".$maxlength."\" size=\"".$size."\" value=\"".$this->ProtectTextValue($val)."\"  /></p>";
		$this->addRow($titre.$obl, $input) ;
	}

	function addTextSMS($titre, $val = '', $obligatoire=true, $size=30, $name='',$maxlength=90) {
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$this->cpt += 1; // compteur d'identifiant
		$name = ($name==''?'text'.$this->cpt:$name);
		$input = "<p>T&eacute;l&eacute;phone<br>Num&eacute;ro(s) de t&eacute;l&eacute;phone au format international (ex: +33600000000)<br><input class=\"\" placeholder=\"Phone Number\" name=\"recipients\" type=\"text\" maxlength=\"".$maxlength."\" size=\"".$size."\" value=\"".$this->ProtectTextValue($val)."\"  /></p>";
		$this->addRow($titre.$obl, $input) ;
	}

	/**
	 * HTML_Form :: addCheck()
	 * Ajoute un simple choix coch�/non coch� avec un checkbox.
	 * Par contre, il n'y a pas d'ajout automatique (comme dans addSelect)de champs hidden indiquant le nombre de champs.
	 * @param	string	$titre			intitul�
	 * @param	string	$explication	explication apparaissant � droite du checkbox
	 * @param	string	$nomChamps		nom du champs
 	 * @param	variant $val			valeur de l'attribut "value"
	 * @param	boolean $checked		indique si le champs est selectionne
	 * @access	public
	 **/
	function addCheck($titre, $explication='', $nomChamps='', $val='', $checked=false) {
		$this->cpt += 1; // compteur d'identifiant
		$nomChamps = ($nomChamps==''?'text'.$this->cpt:$nomChamps);
		$check = ($checked==true?'checked':'');
		$val = ($val==''?'':' value="'.$val.'"');
		$codeChamps = '&nbsp;<input class="checkbox" '.$check.' type="checkbox"  name="'.$nomChamps.'"'.$val.' /> '.$explication."\n";
		$this->addRow($titre, $codeChamps) ;
	}

	/**
	* HTML_Form :: addTextArea()
	* Ajoute une zone de texte au formulaire.
	* @param	string	$titre			le titre de la ligne
	* @param	string	$val			le texte par d�faut de la zone de texte
 	* @param 	bool	$obligatoire 	indique si le champ est obligatoire
	* @access public
	**/
	function addTextArea($titre, $val='', $cols='', $obligatoire=true) {
		$this->cpt += 1; // compteur d'identifiant
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$cols= ($cols==''?35:$cols);
		$codeChamps = "<textarea class=\"form\" cols=\"".$cols."\" rows=\"10\" name=\"text".$this->cpt."\" wrap=\"virtual\">".$val."</textarea>\n";
		$this->addRow($titre.$obl, $codeChamps) ;
	}
	function addTextAreaMail($titre, $val='', $cols='', $obligatoire=true) {
		$this->cpt += 1; // compteur d'identifiant
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$cols= ($cols==''?35:$cols);
		$codeChamps = "<textarea class=\"\" cols=\"".$cols."\" rows=\"10\" name=\"text".$this->cpt."\" wrap=\"virtual\">".$val."</textarea>\n";
		$this->addRow($titre.$obl, $codeChamps) ;
	}

	function addTextAreaSMS($titre, $val='', $cols='', $obligatoire=true) {
		$this->cpt += 1; // compteur d'identifiant
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$cols= ($cols==''?35:$cols);
		$codeChamps = "<textarea class=\"\" cols=\"".$cols."\" rows=\"10\" name=\"message\" wrap=\"virtual\">".$val."</textarea>\n";
		$this->addRow($titre.$obl, $codeChamps) ;
	}

	/**
	* HTML_Form :: addOption()
	* Ajoute un �l�ment de type 'select' au formulaire.
	* @param	string	$titre		titre de la ligne
	* @param	string	$nom		nom du 'select'
	* @param	array	$lgrp		tableau contenant 'id' et 'name' de chaque input
	* @param	integer	$sel		id du champ selectionn�
	* @param 	bool	$obligatoire
	* @access	public
	**/
	function addOption($titre, $nom, $lgrp, $sel, $obligatoire=true,$choix_default=false) {
		$this->cpt += 1; // compteur d'identifiant
		$nom = $nom==''?'text'.$this->cpt:$nom;
		$codeChamps = "\n<!--  Debut OPTION ".$nom." // -->\n";
		$codeChamps .= "<select class=\"form\" name=\"".$nom."\" size=\"1\"> \n";
        if($choix_default == true)
            $codeChamps .= '<option value="">Sélectionner</option>';

		for($j=0;$j<count($lgrp);$j++) {
			if ( isset($lgrp[$j]['id']) ) {
				$id 	= $lgrp[$j]['id'] 	;
				$name 	= $lgrp[$j]['name'] ;
				$selected  = ($id==$sel?'selected':'');
				$style = $j%2?'style="background-color:'.$this->color.';"':'';
				$codeChamps .= " &nbsp;<option ".$style." value=\"".$id."\" ".$selected.">".$name."</option>\n";
			}
		}
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$codeChamps .= "</select>\n";
		$codeChamps .= "<!--  Fin OPTION  // -->\n";
		$this->addRow($titre.$obl, $codeChamps) ;
	}

	function addOptionDataList($titre, $nom, $lgrp, $sel, $obligatoire=true,$choix_default=false) {
		$this->cpt += 1; // compteur d'identifiant
		$nom = $nom==''?'text'.$this->cpt:$nom;
		$codeChamps = "\n<!--  Debut OPTION ".$nom." // -->\n";
		$codeChamps .= '<input type="hidden"  name="'.$nom.'" id="valreturns" >';
		$codeChamps .= '<input type="text" class="form searchstudent" id="searchstudentId" placeholder="Stagiaire concerné" list="searchstudent" autocomplete="off">';
		$codeChamps .= "<datalist id='searchstudent'> \n";
        if($choix_default == true)
            $codeChamps .= "<option>Sélectionner</option>";

		for($j=0;$j<count($lgrp);$j++) {
			if ( isset($lgrp[$j]['id']) ) {
				$id 	= $lgrp[$j]['id'] 	;
				$name 	= CSS($lgrp[$j]['name']) ;
				//$text = Unreplace($text) ;
				$selected  = ($id==$sel?'selected':'');
				$style = $j%2?'style="background-color:'.$this->color.';"':'';
				$codeChamps .= " &nbsp;<option ".$style." value=\"".$name."\" data-id=\"".$id."\" ".$selected.">".$name."</option>\n";
			}
		}
		$obl = ($obligatoire?'&nbsp;*':'&nbsp;');
		$codeChamps .= "</datalist>\n";
		//$codeChamps .= "</select>\n";
		$codeChamps .= "<!--  Fin OPTION  // -->\n";
		$this->addRow($titre.$obl, $codeChamps) ;
	}


	/**
	* HTML_Form :: addTime()
	* Ajoute les champs pour rentrer une dur�e au format h:m.
	* @param string	$titre	intitul� de la ligne (par d�faut 'Dur�e')
	* @param string	$time	dur�e par d�faut en seconde.
	* @access public
	**/
	function addSelectTime($titre, $time='') {
		$this->cpt += 1;
		$m = ($time%3600)/60;
		$h = ($time-($m*60))/3600;
		$champs = '<input type="text" name="text'.$this->cpt.'" size="2" maxlength="2" value="'.$h.'">h';
		$this->cpt += 1;
		$champs.= '&nbsp;&nbsp;<input type="text" name="text'.$this->cpt.'" size="2" maxlength="2" value="'.$m.'">mn';
		$this->addRow("&nbsp;".$titre, $champs);
	}

/**
	* HTML_Form :: addTimeWithNameSpec()
	* D�riv� de addTime() par Lucas Cohen
	* Ajoute les champs pour rentrer une dur�e au format h:m.
	* @param string	$titre	intitul� de la ligne (par d�faut 'Dur�e')
	* @param string	$time	dur�e par d�faut en seconde.
	* @param string $name	champ name de l'�l�ment de formulaire
	* @access public
	**/
	function addTimeWithNameSpec($titre, $name, $time='') {
		$this->cpt += 1;
		$m = ($time%3600)/60;
		$h = ($time-($m*60))/3600;
		$champs = '<input type="text" name="'.$name.'-h" size="2" maxlength="2" value="'.$h.'">h';
		$this->cpt += 1;
		$champs.= '&nbsp;&nbsp;<input type="text" name="'.$name.'-m" size="2" maxlength="2" value="'.$m.'">mn';
		$this->addRow("&nbsp;".$titre, $champs);
	}





	/**
	* HTML_Form :: addChoice()
	* Ajoute des �l�ments de type 'radio' au formulaire.
	* @param	string	$titre		titre de la ligne
	* @param	array	$lgrp		tableau contenant 'id' et 'name' de chaque input
	* @param	integer	$sel		id du champ selectionn�
	* @param 	bool	$obligatoire
	* @access	public
	**/
	function addChoice($titre, $lgrp, $sel, $obligatoire=true) {
		$this->cpt += 1; // compteur d'identifiant
		$codeChamps = "\n<!--  Debut CHOICE // -->\n";
		//debug($lgrp);
		for($i=0; $i<count($lgrp)-1;$i++) {
			$choice = $lgrp[$i];
			$checked = ($choice['id']==$sel?' checked':'');
			$codeChamps.= "<input type=\"radio\" name=\"text".$this->cpt."\" class=\"bouton\" value=\"".$choice['id']."\"".$checked." /> <b>".$choice['name']."</b>&nbsp;&nbsp;&nbsp;&nbsp;\n";
		}
		$this->addRow($titre, $codeChamps);
	}

	/**
	* HTML_Form :: addDatePicker()
	* Ajoute un calendrier pour choisir une date.
	* Attention de bien nommer les formulaires avec chacun un nom unique
	* pour permettre un correct retour javascript.
	* @param	string	$titre			le titre de la ligne
	* @param	integer	$val			date par d�faut (format timestamp)
	* @access public
	**/
	function addDatePicker($titre, $val = '') { //'forms[\'".$this->formulaireName."\'].text".$this->cpt."'
		$this->cpt += 1; // compteur d'identifiant
		$calendar =
"<input class=\"form\" type=\"text\" name=\"text".$this->cpt."\" size=8 value=\"".ReplaceDate($val)."\" valign=\"middle\"/>
<a href=\"javascript:show_calendar(['".$this->formulaireName."', 'text".$this->cpt."']);\" onmouseover=\"window.status='Date Picker';return true;\" onmouseout=\"window.status='';return true;\">".IMG_CALENDAR."</a>";
		$this->addRow("&nbsp;".$titre, $calendar);
	}

	/**
	* HTML_Form :: addListAuto()
	* Ajoute des �l�ments de type 'liste' au formulaire + chargement de la page auto
	* @param	string	$titre		titre de la ligne
	* @param	array	$tabVal		tableau contenant 'id' et 'name' de chaque input
	* @param 	bool	$obligatoire
	* @access	public
	**/
	function addListAuto($titre, $tabVal, $obligatoire=true) {
		$codeChamps='<select class="form" name="LAuto" size="1" onchange="parent.parent.window.location.href=this.options[this.selectedIndex].value;" >';
		for($i=0;$i<count($tabVal);$i++) {
			$selected = $tabVal[$i]['selected']==true?'selected':'';
			$style = $i%2?'style="background-color:'.$this->color.';"':'';
			$codeChamps.= '	<option '.$style.' '.$selected.' value="'.$tabVal[$i]['id'].'" >'.$tabVal[$i]['name'].'</option>';
		}
		$codeChamps.='</select>';
		$this->addRow("&nbsp;".$titre, $codeChamps);
	}

	/**
	* HTML_Form :: addList()
	* Ajoute des �l�ments de type liste au formulaire.
	* @param	string	$titre		titre de la ligne
	* @param	array	$tabVal		tableau contenant 'id' et 'name' de chaque input
	* @param	integer	$sel		id du champ selectionn�
	* @param 	bool	$obligatoire
	* @access	public
	**/
	function addList($titre, $tabVal, $sel, $obligatoire=true) {
		$this->cpt += 1; // compteur d'identifiant
		$codeChamps="<select class=\"form\" name=\"text".$this->cpt."\" size=\"1\">";
		for($i=0;$i<$tabVal['cnt'];$i++) {
			$selected = $tabVal[$i]['id']==$sel?'selected':'';
			$style = $i%2?'style="background-color:'.$this->color.';"':'';
			$codeChamps.= '	<option '.$style.' '.$selected.' value="'.$tabVal[$i]['id'].'" >'.$tabVal[$i]['name'].'</option>';
		}
		$codeChamps.='</select>';
		$this->addRow("&nbsp;".$titre, $codeChamps);
	}

	/**
	* HTML_Form :: addTime()
	* Ajoute les champs pour rentrer une dur�e au format h:m.
	* @param string	$titre		intitul� de la ligne (par d�faut 'Dur�e')
	* @param string	$time		dur�e par d�faut, en h:m ou en seconde.
	* @param integer	$maxHour	nombre d'heures disponibles dans le champs "heure"
	* @access public
	**/
	function addTime($titre, $time='', $maxHour='') {
		$this->cpt += 1;
		$maxHour = ($maxHour==''?24:$maxHour);

		$ret = explode(':',$time);
		if(count($ret)>1) {//en h:m
			$h = $ret[0];
			$m = $ret[1];
		} else {//en seconde
			$m = $time%60;
			$h = ($time-$m)/60;
		}

		$champs = '';
		$champs.= '<select name="text'.$this->cpt.'" size="1">'."\n";
		for($i=0;$i<$maxHour;$i++){
			$sel = ($i==$h?' selected':'');
			//Pour la forme, on arrange un peu l'affichage
			$affichageHeure = ($i<10?'0'.$i:$i);
			$champs.= '<option value="'.$i.'"'.$sel.'>'.$affichageHeure.'</option>'."\n";
		}
		$champs.= "</select>h&nbsp;\n";
		$this->cpt += 1;
		$champs.= '<select name="text'.$this->cpt.'">'."\n";
		for($j=0;$j<60;$j=$j+5){
			$sel = ($j==$m?' selected':'');
			//Pour la forme, on arrange un peu l'affichage
			$affichageMin = ($j<10?'0'.$j:$j);
			$champs.='<option value="'.$j.'"'.$sel.'>'.$affichageMin.'</option>'."\n";
		}
		$champs.= "</select>m\n";
		$this->addRow("&nbsp;".$titre, $champs);
	}

	/**
	* HTML_Form :: addSubmit()
	* Ajoute un �l�ment 'input' de type 'submit' et de valeur '$submit' au formulaire.
	* @param	string	$submit				nom de la fonction javascript � appeler
	* @param	string	$submitButtonName 	nom du boutton "submit"
	* @access	public
	**/
	function addSubmit($submit, $groupe_id, $server_Location, $submitButtonName = '') {
		
		$this->idGroupe = $groupe_id;
		$this->serveurLocation = $server_Location;
		$this->submit = $submit;
		if(strlen($submitButtonName)!=0) { //Sinon valeur "enregistrer" d�fini par d�faut dans le constructeur
			$this->submitButtonName = $submitButtonName;
		}
	}
	function addSubmitSendMailSMS($submit, $groupe_id, $server_Location, $submitButtonName = '') {
		
		$this->idGroupe = $groupe_id;
		$this->serveurLocation = $server_Location;
		$this->submit = $submit;
		if(strlen($submitButtonName)!=0) { //Sinon valeur "enregistrer" d�fini par d�faut dans le constructeur
			$this->submitButtonName = $submitButtonName;
		}
	}

	/**
	* HTML_Form :: addButton()
	**/
	function addButton($titre, $submitButtonName = 'valider', $action='') {
	    $onclick='' ;
		if(strlen($action)>0) {
			$onclick='onclick="return('.$action.'(this.form));"' ;
		}
		$champs = '<div align="right" ><input class="form" value="'.$submitButtonName.'" type="button" '.$onclick.'/></div>';
		$this->addRow("&nbsp;".$titre, $champs);
	}

} //


/**
* HTML_Form_Simple
* Permet de cr�er un form avec une liste sans bouton submit
* @author 	Georges Caldeira <gcaldeira@anemalab.org>
* @package 	GaneshaFW
* @access	public
*/
class HTML_Form_Simple extends HTML_Form {
	var $submitActif = false ; 	//Pas de bouton Submit

	/**
	 * HTML_Form_Simple :: HTML_Form_Simple()
	 * constructeur
	 * @access	public
	 **/
	function __construct($width='70',$titre=''){
		parent::HTML_Form('', '', $width,$titre);
	}

}

/**
* HTML_Form_ListAuto
* Permet de cr�er une liste qui recharche la page automatiquement
* @author 	Georges Caldeira <gcaldeira@anemalab.org>
* @package 	GaneshaFW
* @access	public
*/
class HTML_Form_ListAuto {
	var $content = '' ;

	/**
	 * HTML_Form :: HTML_Form()
	 * Construit un nouveau formulaire ayant '$action' comme attribut 'action'.
	 * @access	public
	 **/
	function __construct($tabVal, $texte, $width='50') {
		$this->content = '
	<br />
	<div class="choose_stagiaire"><div class="stagiaire_picture">'.$texte.'</div>
		<div class="stagiaire_select">
			<form name="formListeAuto" method="post" action="">
			  <select class="form formAutoStafiaire" name="select" size="1" onchange="parent.parent.window.location.href=this.options[this.selectedIndex].value;" >';

		for($i=0;$i<count($tabVal);$i++) {
			$selected = $tabVal[$i]['selected']==true?'selected':'';
			$this->content.= '<option '.$selected.' value="'.$tabVal[$i]['id'].'" >'.utf8_encode($tabVal[$i]['name']).'</option>';
		}

		$this->content.='
			  </select>
			</form></div>	</div>' ;
	}

	/**
	* HTML_Form :: toHTML()
	* Retourne le code HTML du formulaire.
	* @return string code HTML.
	* @access	public
	**/
	function toHTML() {
	 	return($this->content);
	}

	/**
	* HTML_Form :: display()
	* Affiche le code HTML du formulaire.
	* @access	public
	**/
	function display(){
		put($this->toHTML());
	}

}

?>
