<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/retail/v2/catalog_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Retail\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Retail\V2\AddCatalogAttributeRequest;
use Google\Cloud\Retail\V2\AttributesConfig;
use Google\Cloud\Retail\V2\Catalog;
use Google\Cloud\Retail\V2\CatalogAttribute;
use Google\Cloud\Retail\V2\CompletionConfig;
use Google\Cloud\Retail\V2\GetAttributesConfigRequest;
use Google\Cloud\Retail\V2\GetCompletionConfigRequest;
use Google\Cloud\Retail\V2\GetDefaultBranchRequest;
use Google\Cloud\Retail\V2\GetDefaultBranchResponse;
use Google\Cloud\Retail\V2\ListCatalogsRequest;
use Google\Cloud\Retail\V2\ListCatalogsResponse;
use Google\Cloud\Retail\V2\RemoveCatalogAttributeRequest;
use Google\Cloud\Retail\V2\ReplaceCatalogAttributeRequest;
use Google\Cloud\Retail\V2\SetDefaultBranchRequest;
use Google\Cloud\Retail\V2\UpdateAttributesConfigRequest;
use Google\Cloud\Retail\V2\UpdateCatalogRequest;
use Google\Cloud\Retail\V2\UpdateCompletionConfigRequest;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Service for managing catalog configuration.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $catalogServiceClient = new CatalogServiceClient();
 * try {
 *     $formattedAttributesConfig = $catalogServiceClient->attributesConfigName('[PROJECT]', '[LOCATION]', '[CATALOG]');
 *     $catalogAttribute = new CatalogAttribute();
 *     $response = $catalogServiceClient->addCatalogAttribute($formattedAttributesConfig, $catalogAttribute);
 * } finally {
 *     $catalogServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class CatalogServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.retail.v2.CatalogService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'retail.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $attributesConfigNameTemplate;

    private static $branchNameTemplate;

    private static $catalogNameTemplate;

    private static $completionConfigNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/catalog_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/catalog_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/catalog_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/catalog_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAttributesConfigNameTemplate()
    {
        if (self::$attributesConfigNameTemplate == null) {
            self::$attributesConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/catalogs/{catalog}/attributesConfig'
            );
        }

        return self::$attributesConfigNameTemplate;
    }

    private static function getBranchNameTemplate()
    {
        if (self::$branchNameTemplate == null) {
            self::$branchNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/catalogs/{catalog}/branches/{branch}'
            );
        }

        return self::$branchNameTemplate;
    }

    private static function getCatalogNameTemplate()
    {
        if (self::$catalogNameTemplate == null) {
            self::$catalogNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/catalogs/{catalog}'
            );
        }

        return self::$catalogNameTemplate;
    }

    private static function getCompletionConfigNameTemplate()
    {
        if (self::$completionConfigNameTemplate == null) {
            self::$completionConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/catalogs/{catalog}/completionConfig'
            );
        }

        return self::$completionConfigNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'attributesConfig' => self::getAttributesConfigNameTemplate(),
                'branch' => self::getBranchNameTemplate(),
                'catalog' => self::getCatalogNameTemplate(),
                'completionConfig' => self::getCompletionConfigNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * attributes_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     *
     * @return string The formatted attributes_config resource.
     */
    public static function attributesConfigName($project, $location, $catalog)
    {
        return self::getAttributesConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a branch
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     * @param string $branch
     *
     * @return string The formatted branch resource.
     */
    public static function branchName($project, $location, $catalog, $branch)
    {
        return self::getBranchNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
            'branch' => $branch,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a catalog
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     *
     * @return string The formatted catalog resource.
     */
    public static function catalogName($project, $location, $catalog)
    {
        return self::getCatalogNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * completion_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     *
     * @return string The formatted completion_config resource.
     */
    public static function completionConfigName($project, $location, $catalog)
    {
        return self::getCompletionConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - attributesConfig: projects/{project}/locations/{location}/catalogs/{catalog}/attributesConfig
     * - branch: projects/{project}/locations/{location}/catalogs/{catalog}/branches/{branch}
     * - catalog: projects/{project}/locations/{location}/catalogs/{catalog}
     * - completionConfig: projects/{project}/locations/{location}/catalogs/{catalog}/completionConfig
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'retail.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Adds the specified
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to the
     * [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to add
     * already exists, an ALREADY_EXISTS error is returned.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedAttributesConfig = $catalogServiceClient->attributesConfigName('[PROJECT]', '[LOCATION]', '[CATALOG]');
     *     $catalogAttribute = new CatalogAttribute();
     *     $response = $catalogServiceClient->addCatalogAttribute($formattedAttributesConfig, $catalogAttribute);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string           $attributesConfig Required. Full AttributesConfig resource name. Format:
     *                                           `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
     * @param CatalogAttribute $catalogAttribute Required. The [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]
     *                                           to add.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\AttributesConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function addCatalogAttribute(
        $attributesConfig,
        $catalogAttribute,
        array $optionalArgs = []
    ) {
        $request = new AddCatalogAttributeRequest();
        $requestParamHeaders = [];
        $request->setAttributesConfig($attributesConfig);
        $request->setCatalogAttribute($catalogAttribute);
        $requestParamHeaders['attributes_config'] = $attributesConfig;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'AddCatalogAttribute',
            AttributesConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets an [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->attributesConfigName('[PROJECT]', '[LOCATION]', '[CATALOG]');
     *     $response = $catalogServiceClient->getAttributesConfig($formattedName);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Full AttributesConfig resource name. Format:
     *                             `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\AttributesConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getAttributesConfig($name, array $optionalArgs = [])
    {
        $request = new GetAttributesConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAttributesConfig',
            AttributesConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a [CompletionConfig][google.cloud.retail.v2.CompletionConfig].
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->completionConfigName('[PROJECT]', '[LOCATION]', '[CATALOG]');
     *     $response = $catalogServiceClient->getCompletionConfig($formattedName);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Full CompletionConfig resource name. Format:
     *                             `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/completionConfig`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\CompletionConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getCompletionConfig($name, array $optionalArgs = [])
    {
        $request = new GetCompletionConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCompletionConfig',
            CompletionConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get which branch is currently default branch set by
     * [CatalogService.SetDefaultBranch][google.cloud.retail.v2.CatalogService.SetDefaultBranch]
     * method under a specified parent catalog.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $response = $catalogServiceClient->getDefaultBranch();
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $catalog
     *           The parent catalog resource name, such as
     *           `projects/&#42;/locations/global/catalogs/default_catalog`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\GetDefaultBranchResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function getDefaultBranch(array $optionalArgs = [])
    {
        $request = new GetDefaultBranchRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['catalog'])) {
            $request->setCatalog($optionalArgs['catalog']);
            $requestParamHeaders['catalog'] = $optionalArgs['catalog'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDefaultBranch',
            GetDefaultBranchResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists all the [Catalog][google.cloud.retail.v2.Catalog]s associated with
     * the project.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $catalogServiceClient->listCatalogs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $catalogServiceClient->listCatalogs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The account resource name with an associated location.
     *
     *                             If the caller does not have permission to list
     *                             [Catalog][google.cloud.retail.v2.Catalog]s under this location, regardless
     *                             of whether or not this location exists, a PERMISSION_DENIED error is
     *                             returned.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCatalogs($parent, array $optionalArgs = [])
    {
        $request = new ListCatalogsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCatalogs',
            $optionalArgs,
            ListCatalogsResponse::class,
            $request
        );
    }

    /**
     * Removes the specified
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] from the
     * [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to
     * remove does not exist, a NOT_FOUND error is returned.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedAttributesConfig = $catalogServiceClient->attributesConfigName('[PROJECT]', '[LOCATION]', '[CATALOG]');
     *     $key = 'key';
     *     $response = $catalogServiceClient->removeCatalogAttribute($formattedAttributesConfig, $key);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $attributesConfig Required. Full AttributesConfig resource name. Format:
     *                                 `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
     * @param string $key              Required. The attribute name key of the
     *                                 [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to remove.
     * @param array  $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\AttributesConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function removeCatalogAttribute(
        $attributesConfig,
        $key,
        array $optionalArgs = []
    ) {
        $request = new RemoveCatalogAttributeRequest();
        $requestParamHeaders = [];
        $request->setAttributesConfig($attributesConfig);
        $request->setKey($key);
        $requestParamHeaders['attributes_config'] = $attributesConfig;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'RemoveCatalogAttribute',
            AttributesConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Replaces the specified
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] in the
     * [AttributesConfig][google.cloud.retail.v2.AttributesConfig] by updating the
     * catalog attribute with the same
     * [CatalogAttribute.key][google.cloud.retail.v2.CatalogAttribute.key].
     *
     * If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to
     * replace does not exist, a NOT_FOUND error is returned.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedAttributesConfig = $catalogServiceClient->attributesConfigName('[PROJECT]', '[LOCATION]', '[CATALOG]');
     *     $catalogAttribute = new CatalogAttribute();
     *     $response = $catalogServiceClient->replaceCatalogAttribute($formattedAttributesConfig, $catalogAttribute);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string           $attributesConfig Required. Full AttributesConfig resource name. Format:
     *                                           `projects/{project_number}/locations/{location_id}/catalogs/{catalog_id}/attributesConfig`
     * @param CatalogAttribute $catalogAttribute Required. The updated
     *                                           [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute].
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Indicates which fields in the provided
     *           [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to update. The
     *           following are NOT supported:
     *
     *           * [CatalogAttribute.key][google.cloud.retail.v2.CatalogAttribute.key]
     *
     *           If not set, all supported fields are updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\AttributesConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function replaceCatalogAttribute(
        $attributesConfig,
        $catalogAttribute,
        array $optionalArgs = []
    ) {
        $request = new ReplaceCatalogAttributeRequest();
        $requestParamHeaders = [];
        $request->setAttributesConfig($attributesConfig);
        $request->setCatalogAttribute($catalogAttribute);
        $requestParamHeaders['attributes_config'] = $attributesConfig;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReplaceCatalogAttribute',
            AttributesConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Set a specified branch id as default branch. API methods such as
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search],
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct],
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts]
     * will treat requests using "default_branch" to the actual branch id set as
     * default.
     *
     * For example, if `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/1` is set as
     * default, setting
     * [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
     * `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/default_branch` is equivalent
     * to setting
     * [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
     * `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/1`.
     *
     * Using multiple branches can be useful when developers would like
     * to have a staging branch to test and verify for future usage. When it
     * becomes ready, developers switch on the staging branch using this API while
     * keeping using `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/default_branch`
     * as [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
     * route the traffic to this staging branch.
     *
     * CAUTION: If you have live predict/search traffic, switching the default
     * branch could potentially cause outages if the ID space of the new branch is
     * very different from the old one.
     *
     * More specifically:
     *
     * * PredictionService will only return product IDs from branch {newBranch}.
     * * SearchService will only return product IDs from branch {newBranch}
     * (if branch is not explicitly set).
     * * UserEventService will only join events with products from branch
     * {newBranch}.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $catalogServiceClient->setDefaultBranch();
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $catalog
     *           Full resource name of the catalog, such as
     *           `projects/&#42;/locations/global/catalogs/default_catalog`.
     *     @type string $branchId
     *           The final component of the resource name of a branch.
     *
     *           This field must be one of "0", "1" or "2". Otherwise, an INVALID_ARGUMENT
     *           error is returned.
     *
     *           If there are no sufficient active products in the targeted branch and
     *           [force][google.cloud.retail.v2.SetDefaultBranchRequest.force] is not set, a
     *           FAILED_PRECONDITION error is returned.
     *     @type string $note
     *           Some note on this request, this can be retrieved by
     *           [CatalogService.GetDefaultBranch][google.cloud.retail.v2.CatalogService.GetDefaultBranch]
     *           before next valid default branch set occurs.
     *
     *           This field must be a UTF-8 encoded string with a length limit of 1,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type bool $force
     *           If set to true, it permits switching to a branch with
     *           [branch_id][google.cloud.retail.v2.SetDefaultBranchRequest.branch_id] even
     *           if it has no sufficient active products.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function setDefaultBranch(array $optionalArgs = [])
    {
        $request = new SetDefaultBranchRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['catalog'])) {
            $request->setCatalog($optionalArgs['catalog']);
            $requestParamHeaders['catalog'] = $optionalArgs['catalog'];
        }

        if (isset($optionalArgs['branchId'])) {
            $request->setBranchId($optionalArgs['branchId']);
        }

        if (isset($optionalArgs['note'])) {
            $request->setNote($optionalArgs['note']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetDefaultBranch',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * The catalog attributes in the request will be updated in the catalog, or
     * inserted if they do not exist. Existing catalog attributes not included in
     * the request will remain unchanged. Attributes that are assigned to
     * products, but do not exist at the catalog level, are always included in the
     * response. The product attribute is assigned default values for missing
     * catalog attribute fields, e.g., searchable and dynamic facetable options.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $attributesConfig = new AttributesConfig();
     *     $response = $catalogServiceClient->updateAttributesConfig($attributesConfig);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param AttributesConfig $attributesConfig Required. The [AttributesConfig][google.cloud.retail.v2.AttributesConfig]
     *                                           to update.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Indicates which fields in the provided
     *           [AttributesConfig][google.cloud.retail.v2.AttributesConfig] to update. The
     *           following is the only supported field:
     *
     *           * [AttributesConfig.catalog_attributes][google.cloud.retail.v2.AttributesConfig.catalog_attributes]
     *
     *           If not set, all supported fields are updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\AttributesConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAttributesConfig(
        $attributesConfig,
        array $optionalArgs = []
    ) {
        $request = new UpdateAttributesConfigRequest();
        $requestParamHeaders = [];
        $request->setAttributesConfig($attributesConfig);
        $requestParamHeaders[
            'attributes_config.name'
        ] = $attributesConfig->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateAttributesConfig',
            AttributesConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the [Catalog][google.cloud.retail.v2.Catalog]s.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $catalog = new Catalog();
     *     $response = $catalogServiceClient->updateCatalog($catalog);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param Catalog $catalog      Required. The [Catalog][google.cloud.retail.v2.Catalog] to update.
     *
     *                              If the caller does not have permission to update the
     *                              [Catalog][google.cloud.retail.v2.Catalog], regardless of whether or not it
     *                              exists, a PERMISSION_DENIED error is returned.
     *
     *                              If the [Catalog][google.cloud.retail.v2.Catalog] to update does not exist,
     *                              a NOT_FOUND error is returned.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Indicates which fields in the provided
     *           [Catalog][google.cloud.retail.v2.Catalog] to update.
     *
     *           If an unsupported or unknown field is provided, an INVALID_ARGUMENT error
     *           is returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\Catalog
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCatalog($catalog, array $optionalArgs = [])
    {
        $request = new UpdateCatalogRequest();
        $requestParamHeaders = [];
        $request->setCatalog($catalog);
        $requestParamHeaders['catalog.name'] = $catalog->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateCatalog',
            Catalog::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates the [CompletionConfig][google.cloud.retail.v2.CompletionConfig]s.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $completionConfig = new CompletionConfig();
     *     $response = $catalogServiceClient->updateCompletionConfig($completionConfig);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param CompletionConfig $completionConfig Required. The [CompletionConfig][google.cloud.retail.v2.CompletionConfig]
     *                                           to update.
     *
     *                                           If the caller does not have permission to update the
     *                                           [CompletionConfig][google.cloud.retail.v2.CompletionConfig], then a
     *                                           PERMISSION_DENIED error is returned.
     *
     *                                           If the [CompletionConfig][google.cloud.retail.v2.CompletionConfig] to
     *                                           update does not exist, a NOT_FOUND error is returned.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Indicates which fields in the provided
     *           [CompletionConfig][google.cloud.retail.v2.CompletionConfig] to update. The
     *           following are the only supported fields:
     *
     *           * [CompletionConfig.matching_order][google.cloud.retail.v2.CompletionConfig.matching_order]
     *           * [CompletionConfig.max_suggestions][google.cloud.retail.v2.CompletionConfig.max_suggestions]
     *           * [CompletionConfig.min_prefix_length][google.cloud.retail.v2.CompletionConfig.min_prefix_length]
     *           * [CompletionConfig.auto_learning][google.cloud.retail.v2.CompletionConfig.auto_learning]
     *
     *           If not set, all supported fields are updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Retail\V2\CompletionConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCompletionConfig(
        $completionConfig,
        array $optionalArgs = []
    ) {
        $request = new UpdateCompletionConfigRequest();
        $requestParamHeaders = [];
        $request->setCompletionConfig($completionConfig);
        $requestParamHeaders[
            'completion_config.name'
        ] = $completionConfig->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateCompletionConfig',
            CompletionConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
