<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/audit/audit_log.proto

namespace Google\Cloud\Audit;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Authentication information for the operation.
 *
 * Generated from protobuf message <code>google.cloud.audit.AuthenticationInfo</code>
 */
class AuthenticationInfo extends \Google\Protobuf\Internal\Message
{
    /**
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     *
     * Generated from protobuf field <code>string principal_email = 1;</code>
     */
    protected $principal_email = '';
    /**
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     *
     * Generated from protobuf field <code>string authority_selector = 2;</code>
     */
    protected $authority_selector = '';
    /**
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct third_party_principal = 4;</code>
     */
    protected $third_party_principal = null;
    /**
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     *
     * Generated from protobuf field <code>string service_account_key_name = 5;</code>
     */
    protected $service_account_key_name = '';
    /**
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;</code>
     */
    private $service_account_delegation_info;
    /**
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     *
     * Generated from protobuf field <code>string principal_subject = 8;</code>
     */
    protected $principal_subject = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $principal_email
     *           The email address of the authenticated user (or service account on behalf
     *           of third party principal) making the request. For third party identity
     *           callers, the `principal_subject` field is populated instead of this field.
     *           For privacy reasons, the principal email address is sometimes redacted.
     *           For more information, see [Caller identities in audit
     *           logs](https://cloud.google.com/logging/docs/audit#user-id).
     *     @type string $authority_selector
     *           The authority selector specified by the requestor, if any.
     *           It is not guaranteed that the principal was allowed to use this authority.
     *     @type \Google\Protobuf\Struct $third_party_principal
     *           The third party identification (if any) of the authenticated user making
     *           the request.
     *           When the JSON object represented here has a proto equivalent, the proto
     *           name will be indicated in the `&#64;type` property.
     *     @type string $service_account_key_name
     *           The name of the service account key used to create or exchange
     *           credentials for authenticating the service account making the request.
     *           This is a scheme-less URI full resource name. For example:
     *           "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     *     @type array<\Google\Cloud\Audit\ServiceAccountDelegationInfo>|\Google\Protobuf\Internal\RepeatedField $service_account_delegation_info
     *           Identity delegation history of an authenticated service account that makes
     *           the request. It contains information on the real authorities that try to
     *           access GCP resources by delegating on a service account. When multiple
     *           authorities present, they are guaranteed to be sorted based on the original
     *           ordering of the identity delegation events.
     *     @type string $principal_subject
     *           String representation of identity of requesting party.
     *           Populated for both first and third party identities.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Audit\AuditLog::initOnce();
        parent::__construct($data);
    }

    /**
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     *
     * Generated from protobuf field <code>string principal_email = 1;</code>
     * @return string
     */
    public function getPrincipalEmail()
    {
        return $this->principal_email;
    }

    /**
     * The email address of the authenticated user (or service account on behalf
     * of third party principal) making the request. For third party identity
     * callers, the `principal_subject` field is populated instead of this field.
     * For privacy reasons, the principal email address is sometimes redacted.
     * For more information, see [Caller identities in audit
     * logs](https://cloud.google.com/logging/docs/audit#user-id).
     *
     * Generated from protobuf field <code>string principal_email = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setPrincipalEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->principal_email = $var;

        return $this;
    }

    /**
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     *
     * Generated from protobuf field <code>string authority_selector = 2;</code>
     * @return string
     */
    public function getAuthoritySelector()
    {
        return $this->authority_selector;
    }

    /**
     * The authority selector specified by the requestor, if any.
     * It is not guaranteed that the principal was allowed to use this authority.
     *
     * Generated from protobuf field <code>string authority_selector = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAuthoritySelector($var)
    {
        GPBUtil::checkString($var, True);
        $this->authority_selector = $var;

        return $this;
    }

    /**
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct third_party_principal = 4;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getThirdPartyPrincipal()
    {
        return $this->third_party_principal;
    }

    public function hasThirdPartyPrincipal()
    {
        return isset($this->third_party_principal);
    }

    public function clearThirdPartyPrincipal()
    {
        unset($this->third_party_principal);
    }

    /**
     * The third party identification (if any) of the authenticated user making
     * the request.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct third_party_principal = 4;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setThirdPartyPrincipal($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->third_party_principal = $var;

        return $this;
    }

    /**
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     *
     * Generated from protobuf field <code>string service_account_key_name = 5;</code>
     * @return string
     */
    public function getServiceAccountKeyName()
    {
        return $this->service_account_key_name;
    }

    /**
     * The name of the service account key used to create or exchange
     * credentials for authenticating the service account making the request.
     * This is a scheme-less URI full resource name. For example:
     * "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
     *
     * Generated from protobuf field <code>string service_account_key_name = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_key_name = $var;

        return $this;
    }

    /**
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceAccountDelegationInfo()
    {
        return $this->service_account_delegation_info;
    }

    /**
     * Identity delegation history of an authenticated service account that makes
     * the request. It contains information on the real authorities that try to
     * access GCP resources by delegating on a service account. When multiple
     * authorities present, they are guaranteed to be sorted based on the original
     * ordering of the identity delegation events.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.ServiceAccountDelegationInfo service_account_delegation_info = 6;</code>
     * @param array<\Google\Cloud\Audit\ServiceAccountDelegationInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceAccountDelegationInfo($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Audit\ServiceAccountDelegationInfo::class);
        $this->service_account_delegation_info = $arr;

        return $this;
    }

    /**
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     *
     * Generated from protobuf field <code>string principal_subject = 8;</code>
     * @return string
     */
    public function getPrincipalSubject()
    {
        return $this->principal_subject;
    }

    /**
     * String representation of identity of requesting party.
     * Populated for both first and third party identities.
     *
     * Generated from protobuf field <code>string principal_subject = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setPrincipalSubject($var)
    {
        GPBUtil::checkString($var, True);
        $this->principal_subject = $var;

        return $this;
    }

}

