<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    require APPPATH . '/libraries/ElearningForma2PlusController.php';
    require  APPPATH. '/libraries/ExportData.php';

    class Statistic extends ElearningForma2PlusController
    {
        /**
         * This is default constructor of the class
         */
        public function __construct()
        {
            parent::__construct();
            $this->isLoggedIn();           
            $this->tracking_type = 10; 
        }
        
        /*old stat*/
        /*public function index()
        {

            $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('premium_nenu_stat');
            $this->loadTrackingEl(0,0,$this->tracking_type);
            $idGroupe = '';
            $views = '';
            if($this->isTuteurConnet()){
                $idGroupe = $this->session->userdata ('STAGIAIREGRP');
                $views = 'tutor/stat/list';
            }
            else{
                $idGroupe = $this->session->userdata ('GROUPE');
                $views = 'trainee/stat/list';
            }
            $data['statcnx']       = $this->stat_model->getTimeCnxGlobal($this->session->userdata ('GUSERID'));
            $this->loadViews($views, $this->global, $data , NULL);
        }*/
        public function index()
        {

            $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('premium_nenu_stat');
            $this->loadTrackingEl(0,0,$this->tracking_type);
            $idGroupe = '';
            $idStagiaire = '';
            $views = '';
            if($this->isTuteurConnet()){
                $idGroup = $this->session->userdata ('STAGIAIREGRP');
                $idStagiaire = $this->session->userdata ('STAGIAIREID');
                $views = 'tutor/stat/list';
            }
            else{
                $idGroup = $this->session->userdata ('GROUPE');
                $idStagiaire = $this->session->userdata ('GUSERID');
                $views = 'trainee/stat/list';
            }

            /*database document*/
            $data['nbConnexion']     = $this->membres_model->Request('nbconnexion',$idStagiaire);
            $data['repertoryDocument']     = $this->Document_repository_model->getByGroup($idGroup);
            $data['dataBaseAccount']     = $this->document_model->CountDocumentsByGroup($idGroup);

            $data['courseHistory']       = count($this->coursHistorik_model->getByIdGroup($idGroup));
            $data['todoListAccount']     = $this->todolist_model->countByIdGroup($idGroup);

            $data['categoryExpression']  = count($this->categoryExpression_model->getCategoryByIdGroup($idGroup));
            $data['expressionAccount']   = $this->databankExpression_model->countByIdStagiaire($idStagiaire);
          
            $data['trainigAreaAccount']  = count($this->stat_prg_model->getAllExcericeByMembres($idStagiaire));          
            $data['categoryTrainigAreaAccount']  = count($this->classificationFavoris_Model->getClassTuteurByTrainee($idGroup));            

            $this->loadViews($views, $this->global, $data , NULL);
        }

        public function getjsondata(){
            $dataStat = array();
            if (isset($_POST['event'])) {
                switch ($_POST['event']) {
                    case 1:
                        $allResult       = $this->stat_model->getTimeCnxGlobal($this->session->userdata ('GUSERID'));
                        break;
                    case 2:
                        $allResult       = $this->stat_model->getTimeCnxForMonth($this->session->userdata ('GUSERID'));
                        break;
                    case 3:
                        $allResult       = $this->stat_model->getTimeCnxForMonthBefore($this->session->userdata ('GUSERID'));
                        break;
                    case 4:
                        $allResult       = $this->stat_model->getTimeCnxForYear($this->session->userdata ('GUSERID'));

                        if (isset($allResult) && count($allResult) >= 1) {
                            foreach ($allResult as $res) {              
                                $dataStat [] = array(
                                    "dateCnx" => substr($this->convertMonthToList($res->date_cnx),0,3), 
                                    "dureeCnx" => $res->duree_cnx,
                                    "totalActivite" => $res->total_activite
                                );   
                            }
                        }
                        break;
                    
                    default:
                        # code...
                        break;
                }
            }

            echo json_encode($dataStat);

        }

        public function export(){
            $this->loadTrackingEl(0,0,$this->tracking_type);
            if (isset($_GET) && $_GET['event'] != NULL) {
                $event = $_GET['event'];
                $q     = $_GET['q'];
                $tot = 0 ;
                $tot1 = 0 ;
                
                switch ($event) {
                    case 1:
                        $data['title_stats']   = $this->lang->line('premium_nenu_stat_time_cnx_global');
                        $data['statcnx']       = $this->stat_model->getTimeCnxGlobal($this->session->userdata ('GUSERID'),NULL, NULL);
                        break;
                    case 2:
                        $data['title_stats']   = $this->lang->line('premium_nenu_stat_cnx_time_for_month');
                        $data['statcnx']       = $this->stat_model->getTimeCnxForMonth($this->session->userdata ('GUSERID'),NULL, NULL);


                        break;
                    case 3:
                        $data['title_stats']   = $this->lang->line('premium_nenu_stat_cnx_time_for_month_before');
                        $data['statcnx']       = $this->stat_model->getTimeCnxForMonthBefore($this->session->userdata ('GUSERID'),NULL, NULL);

                        break;
                    case 4:
                        $data['title_stats']   = $this->lang->line('premium_nenu_stat_time_cnx_for_year');
                        $data['statcnx']       = $this->stat_model->getTimeCnxForYear($this->session->userdata ('GUSERID'),NULL, NULL);
                        
                        break;
                    
                    default:
                        # code...
                        break;
                }

                
                $exporter = new ExportDataExcel('browser',$data['title_stats'].'.xls');
                $exporter->initialize();
                if ($q=="global") {
                    $exporter->addRow(array("Date de connexion","Heure de début","Durée de connexion","Total activites")); 
                    foreach ($data['statcnx'] as $res) {
                        $exporter->addRow(array($res->date_cnx,$res->heures_cnx,$res->duree_cnx,$res->total_activite));     
                        $tot += $res->time_cnx_tot;
                        $tot1 += $res->total_activite;

                        $i++ ;
                    }
                    $exporter->addRow(array("\r","Total Time",$this->ReplaceTime($tot))); 
                    $exporter->addRow(array("\r","Total Activities",$tot1)); 
                }
                else{
                    $exporter->addRow(array("Date de l'exercice","Heure de l'exercice","Durée de l'exercice","Sequence","Exercice")); 
                    $data['detailstatcnx']       = $this->stat_model->getDetailStat($this->session->userdata ('GUSERID'),$_GET['groupe'],$_GET['date_connexion'],NULL, NULL);
                    $durre_exercice_export = "";

                    foreach ($data['detailstatcnx'] as $res) {
                        if ($res->duree_exercice=="838:59:59") {
                            $durre_exercice_export .= "";
                        }
                        else{
                            $durre_exercice_export .= $res->duree_exercice;
                        }
                        $exporter->addRow(array($res->date_exercice,str_replace(".000000", "", $res->heure_exercice),$durre_exercice_export,$res->sequence,$res->exercice));

                        $i++ ;
                    }
                }
                $exporter->finalize();
                exit();
            }
        }

        public function detail(){
            $this->loadTrackingEl(0,0,$this->tracking_type);
            if (isset($_GET) && $_GET['event'] != NULL) {
                $event     = $_GET['event'];
                $idTrainee = $_GET['stag'];
                $groupe    = $_GET['groupe'];
                $date_cnx  = $_GET['date_unix_detect'];
                $limit     = 7;
                switch ($event) {
                    case 1:
                        $data['title_stats']   = "Detail of the Time Connection Global";
                        $data['detail']        = 1;
                        
                        break;
                    case 2:
                        $data['title_stats']   = "Detail of the Connection time for the month";
                        $data['detail']        = 2;

                    

                        break;
                    case 3:
                        $data['title_stats']   = "Detail of the Connection time for the month before";
                        $data['detail']        = 3;
                       
                      
                        break;
                    case 4:
                        $data['title_stats']   = "Detail of the Connection time for the year";
                        $data['detail']        = 4;
                      
                        break;
                    
                    default:
                        # code...
                        break;
                }

                $this->global['pageTitle'] = 'E-learning : '.$data['title_stats'];
                $data['statcnx']       = $this->stat_model->getDetailStat($this->session->userdata ('GUSERID'),$groupe,$date_cnx);

                $this->loadViews("trainee/stat/detail", $this->global, $data , NULL);

            }
        }

        public function ReplaceTime($val, $format=0) {
            $h = intval(intval($val) / 3600);
            if ($h < 10 && $format==0) {
                $h =  "0".$h;
            }

            $m = ((intval($val) / 60) % 60);
            if ($m < 10 && $format==0) {
                $m =  "0".$m;
            }

            $s = (intval($val) % 60);
            if ($s < 10 && $format==0) {
                $s = "0".$s;
            }

            switch($format) {
            case 0 :
                $res = $h.':'.$m.':'.$s;
                break;
            case 1 :
                $res = ($h>0?$h.' h ':'');
                $res.= ($m>0?$m.' mn ':'');
                $res.= ($s>0 || strlen($res)==0?$s.' s':'');
                break;
            }
            return($res);
        }
     
    }

?>