<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Sequence extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();    
        $this->isLoggedIn();  
        $this->load->model('formations_model'); 
        $this->load->model('admin_model');  
        $this->width      = "1200";
        $this->height     = "1280";
        $this->date       = time();
        $this->tracking_type = 8; 
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }


    public function read()
    {
      if (isset($_POST)) {        
        $id                       = $_POST['id'];
        $numero                   = $_POST['numero'];
        $trackingsession           = $this->tracking_model->Add($id,$numero,$this->tracking_type);
        echo "##".$trackingsession;                     
      }    

    }

    public function getHeader(){
      $return = array();
      $arrayFinal = array();
      if (isset($_POST)) {
        $returnContentHeader = $this->getResponseUrl($_POST['link']);
        $arrayFinal['status_url'] = $returnContentHeader[0];
        foreach ($returnContentHeader as $key => $value) {
          $valSplit = explode(': ', $value);
          $position = strpos($value, ': ');
          if ($position === false) {
            if (isset($value[1])) {
              $arrayFinal[$value] = $value;
            }
          }
          else{
            if (isset($valSplit[1])) {
              $arrayFinal[$valSplit[0]] = $valSplit[1];
            }
          }
                    
        }    
        //var_dump($arrayFinal)  ;  
        if (isset($arrayFinal['X-Frame-Options']) && ($arrayFinal['X-Frame-Options'] == 'SAMEORIGIN' || $arrayFinal['X-Frame-Options'] == 'DENY')) {
          $return['access'] = 'DENIED';
        }
        elseif (isset($arrayFinal['X-FRAME-OPTIONS']) && ($arrayFinal['X-FRAME-OPTIONS'] == 'SAMEORIGIN' || $arrayFinal['X-FRAME-OPTIONS'] == 'DENY')) {
          $return['access'] = 'DENIED';
        }
        elseif (isset($arrayFinal['Content-Security-Policy']) && strpos($arrayFinal['Content-Security-Policy'], "frame-ancestors 'self'") !== false) {
          $return['access'] = 'DENIED';
        }
        elseif (isset($arrayFinal['HTTP/1.1 200 OK']) && $arrayFinal['HTTP/1.1 200 OK'] != 'HTTP/1.1 200 OK') {
          $return['access'] = 'NOTFOUND';
        }
        else{
          $return['access'] = 'ACCESSIBLE';
        }
        echo json_encode($return);
      }
     
    }

    public function detail(){
      
    }

    public function getSequenceInfo(){
        $data = array();
        if (isset($_POST['idSequence']) && isset($_POST['numero'])) {
            if (isset($_POST['page_name']) && $_POST['page_name'] == 'favoris') {
                $this->tracking_type = 24;
            }
            $this->loadTrackingEl($_POST['id'],$_POST['numero'],$this->tracking_type,$_POST['module_id']);

            $result = $this->sequence_model->sequenceInfo($_POST['idSequence'],$_POST['numero']);
            $data['test'] = 'vfdf';
            foreach ($result as $res) {
                $data = array(
                    'id_sequence' => $res->id_sequence , 
                    'titre' => $res->titre , 
                    'numero' => $res->numero , 
                    'link' => $res->link , 
                    'type' => $res->type , 
                    'thumbnail_file' => $res->thumbnail_file , 
                    'status' => $res->status , 
                    'final_url' => $res->final_url , 
                    'status_url' => $res->status_url 
                );
           }
           echo json_encode($data);
        }

    }
    public function getByIdInFav(){
        $codeHTML = '';
        $lienCol= 1;
        $nbrSeq= 1;
        if (isset($_POST['idSequence'])) {
            if (isset($_POST['page_name']) && $_POST['page_name'] == 'favoris') {
                $this->tracking_type = 24;
            }
            $this->loadTrackingEl($_POST['id'],0,$this->tracking_type,$_POST['module_id']);
            
            if ($this->isTuteurConnet()) {
                $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'));
            }
            else{
                $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
            }
            $imgthumbnail = '';
            $class = '';
            
            $codeHTML = "";
            $codeHTML .='<p class="notification"></p>
                   <div class="loader-nl"></div>';
            $codeHTML .='<div class="row container-cat-article">';    
            if (isset($chapitre['cnt'])) {
                // colonne lien

                /*$codeHTML.=' <div class="row col_lien " value="'.$lienCol.'">
                <div class="col-md-12">
                <h5 class="titre-your-module titre-activ"><b>Activities of '.$_POST['sequenceName'].' </b></h5> 
                </div>
                <div class="row row-lien">
                ';
                */
                $lienCol= $lienCol + 1;
                for($i=0;$i<$chapitre['cnt'];$i++) {
                
                    $type           = $chapitre[$i]['type']     ;
                    $titre          = $chapitre[$i]['titre']    ;
                    $numero         = $chapitre[$i]['numero']   ;
                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                    $final_url      = $chapitre[$i]['final_url']  ;
                    $status_url     = $chapitre[$i]['status_url']  ;

                    $suite = "";
                    $nb_word = strlen(htmlentities($chapitre[$i]['titre']));

                    $nb_restant = $nb_word - 40;
                    $original_text =  substr(htmlentities($chapitre[$i]['titre']),0,40);
                    if ($nb_restant >= 1) {
                      $suite .= "<a href='#' style='text-decoration:none;font-size:1rem;font-weight:400;color:#fff;'> ...</a>";
                    }
                    else{
                      $suite .= "";
                    }
                  
                    $link_support = $linkUrl;
                    $redir        = 'redir.php?url';
                    $support      = '';
                    $urlF         = "";
                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                        $codeHTML .= "";                
                    }
                    else{
                        $fileimg = base_url()."groupes/img_default.jpg";
                        $codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                    }

                    if ($titre != 'Support') {

                        if ($this->validate_url($link_support)){
                            $urlF         .= $link_support;
                            $codeHTML .='<div class="col-md-2 padding-col">';            
                                $codeHTML .='<div class="container-image hovereffect">';            
                                    $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                    $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   

                                    $codeHTML .='<div class="overlay">'; 
                                        $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                            $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                            $codeHTML .='</a>';                                   
                                        $codeHTML .='</div>'; 
                                        $codeHTML .='<div style="float: left !important;">'; 
                                            $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" onclick="viewActivityInFavorite(this);" data-module="'.$_POST['module_id'].'" data-st="'.$_POST['id'].'" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn link-loop-article" title="Access the article">'; 
                                                 $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                            $codeHTML .='</a>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 
                                $codeHTML .='</div>'; 
                            $codeHTML .='</div>'; 
                        }
                        else{
                            if (strpos($link_support, $redir) === false) { 
                                //$filename      = $this->getFileName($link_support);
                                //$ext            = explode(".", $filename);
                                if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                    //if (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt" && $ext[1]=="pdf")){
                                    //$urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;
                                    $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                    
                                    $codeHTML .='<div class="col-md-2 padding-col">';            
                                        $codeHTML .='<div class="container-image hovereffect">';            
                                            $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                            $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$titre.'</span></div>';   

                                            $codeHTML .='<div class="overlay">'; 
                                                $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                                    $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                        $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                                    $codeHTML .='</a>';                                   
                                                $codeHTML .='</div>'; 
                                                $codeHTML .='<div style="float: left !important;">'; 
                                                    $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlFormation.'" class="lien_activites" onclick="viewActivityInFavorite(this);" data-st="'.$_POST['id'].'" data-module="'.$_POST['module_id'].'" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlFormation.'" class="btn link-loop-article" title="Access the article">'; 
                                                         $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                                    $codeHTML .='</a>'; 
                                                $codeHTML .='</div>'; 
                                            $codeHTML .='</div>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 


                                }
                                else{
                                    $urlF  .= HTTP_FORMATIONS.$link_support;
                                    $codeHTML .='<div class="col-md-2 padding-col">';            
                                        $codeHTML .='<div class="container-image hovereffect">';            
                                            $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                            $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$titre.'</span></div>';   

                                            $codeHTML .='<div class="overlay">'; 
                                                $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                                    $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                        $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                                    $codeHTML .='</a>';                                   
                                                $codeHTML .='</div>'; 
                                                $codeHTML .='<div style="float: left !important;">'; 
                                                    $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" onclick="viewActivityInFavorite(this);" data-id="'.$id_sequence.'" data-st="'.$_POST['id'].'" data-module="'.$_POST['module_id'].'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn link-loop-article" title="Access the article">'; 
                                                         $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                                    $codeHTML .='</a>'; 
                                                $codeHTML .='</div>'; 
                                            $codeHTML .='</div>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 
                                }
                            }                 
                            else { 
                                $urlF         .= str_replace("/redir.php?url=", "", $link_support); 
                                $codeHTML .='<div class="col-md-2 padding-col">';            
                                    $codeHTML .='<div class="container-image hovereffect">';            
                                        $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                        $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$titre.'</span></div>';   

                                        $codeHTML .='<div class="overlay">'; 
                                            $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                                $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                    $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                                $codeHTML .='</a>';                                   
                                            $codeHTML .='</div>'; 
                                            $codeHTML .='<div style="float: left !important;">'; 
                                                $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-st="'.$_POST['id'].'" data-module="'.$_POST['module_id'].'" onclick="viewActivityInFavorite(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn link-loop-article" title="Access the article">'; 
                                                     $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                                $codeHTML .='</a>'; 
                                            $codeHTML .='</div>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 
                                $codeHTML .='</div>';              
                            } 
                        }
                    }
                    $nbrSeq= $nbrSeq + 1;
                        
                }
                $codeHTML .='</div></div>';
                
            }
        }
        echo $codeHTML;
    }
    public function getByIdInFavThumb(){
        $codeHTML = '';
        $lienCol= 1;
        $nbrSeq= 1;
        if (isset($_POST['idSequence'])) {
            $this->loadTrackingEl($_POST['idSequence'],0,$this->tracking_type);
            
            if ($this->isTuteurConnet()) {
                $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'));
            }
            else{
                $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
            }
            $imgthumbnail = '';
            $class = '';
            
            $codeHTML = "";
            $codeHTML .='<p class="notification"></p>
                   <div class="loader-nl"></div>';
            $codeHTML .='<div class="row container-cat-article">';    
            if (isset($chapitre['cnt'])) {
                // colonne lien

                /*$codeHTML.=' <div class="row col_lien " value="'.$lienCol.'">
                <div class="col-md-12">
                <h5 class="titre-your-module titre-activ"><b>Activities of '.$_POST['sequenceName'].' </b></h5> 
                </div>
                <div class="row row-lien">
                ';
                */
                $lienCol= $lienCol + 1;
                for($i=0;$i<$chapitre['cnt'];$i++) {
                
                    $type           = $chapitre[$i]['type']     ;
                    $titre          = $chapitre[$i]['titre']    ;
                    $numero         = $chapitre[$i]['numero']   ;
                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                    $final_url      = $chapitre[$i]['final_url']  ;
                    $status_url     = $chapitre[$i]['status_url']  ;

                    
                    $link_support = $linkUrl;
                    $redir        = 'redir.php?url';
                    $support      = '';
                    $urlF         = "";
                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                        $codeHTML .= "";                
                    }
                    else{
                        $fileimg = base_url()."groupes/img_default.jpg";
                        $codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                    }

                    if ($titre != 'Support') {

                        if ($this->validate_url($link_support)){
                            $urlF         .= $link_support;
                            $codeHTML .='<div class="col-md-2 padding-col">';            
                                $codeHTML .='<div class="container-image hovereffect">';            
                                    $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                    $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$original_text.$suite.'</span></div>';   

                                    $codeHTML .='<div class="overlay">'; 
                                        $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                            $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                            $codeHTML .='</a>';                                   
                                        $codeHTML .='</div>'; 
                                        $codeHTML .='<div style="float: left !important;">'; 
                                            $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" onclick="viewActivityInFavoriteInThumbs(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn link-loop-article" title="Access the article">'; 
                                                 $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                            $codeHTML .='</a>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 
                                $codeHTML .='</div>'; 
                            $codeHTML .='</div>'; 
                        }
                        else{
                            if (strpos($link_support, $redir) === false) { 
                                //$filename      = $this->getFileName($link_support);
                                //$ext            = explode(".", $filename);
                                if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                    //if (isset($ext[1]) && ($ext[1]=="doc" || $ext[1]=="docx" || $ext[1]=="ppt" && $ext[1]=="pdf")){
                                    //$urlF   .= base_url().'groupes/index.php?link='.HTTP_FORMATIONS.$link_support;
                                    $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                    
                                    $codeHTML .='<div class="col-md-2 padding-col">';            
                                        $codeHTML .='<div class="container-image hovereffect">';            
                                            $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                            $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$titre.'</span></div>';   

                                            $codeHTML .='<div class="overlay">'; 
                                                $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                                    $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                        $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                                    $codeHTML .='</a>';                                   
                                                $codeHTML .='</div>'; 
                                                $codeHTML .='<div style="float: left !important;">'; 
                                                    $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlFormation.'" class="lien_activites" onclick="viewActivityInFavoriteInThumbs(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlFormation.'" class="btn link-loop-article" title="Access the article">'; 
                                                         $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                                    $codeHTML .='</a>'; 
                                                $codeHTML .='</div>'; 
                                            $codeHTML .='</div>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 


                                }
                                else{
                                    $urlF  .= HTTP_FORMATIONS.$link_support;
                                    $codeHTML .='<div class="col-md-2 padding-col">';            
                                        $codeHTML .='<div class="container-image hovereffect">';            
                                            $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                            $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$titre.'</span></div>';   

                                            $codeHTML .='<div class="overlay">'; 
                                                $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                                    $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                        $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                                    $codeHTML .='</a>';                                   
                                                $codeHTML .='</div>'; 
                                                $codeHTML .='<div style="float: left !important;">'; 
                                                    $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" onclick="viewActivityInFavoriteInThumbs(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn link-loop-article" title="Access the article">'; 
                                                         $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                                    $codeHTML .='</a>'; 
                                                $codeHTML .='</div>'; 
                                            $codeHTML .='</div>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 
                                }
                            }                 
                            else { 
                                $urlF         .= str_replace("/redir.php?url=", "", $link_support); 
                                $codeHTML .='<div class="col-md-2 padding-col">';            
                                    $codeHTML .='<div class="container-image hovereffect">';            
                                        $codeHTML .='<img class="image-timthumb img-vignette" title="" alt="Avatar" src="'.$fileimg.'">';            
                                        $codeHTML .='<div class="legend"><span class="titleTumbnail">'.$titre.'</span></div>';   

                                        $codeHTML .='<div class="overlay">'; 
                                            $codeHTML .='<div class="btn-group-vertical" style="float: right !important;">'; 
                                                $codeHTML .='<a href="#" class="btn link-action-nl btn-add-comment"  data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');" title="Add comment">'; 
                                                    $codeHTML .=' <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" width="40%" class="image-action-nl img-comment-nl">'; 
                                                $codeHTML .='</a>';                                   
                                            $codeHTML .='</div>'; 
                                            $codeHTML .='<div style="float: left !important;">'; 
                                                $codeHTML .='<a href="#" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" onclick="viewActivityInFavoriteInThumbs(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn link-loop-article" title="Access the article">'; 
                                                     $codeHTML .='<img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" width="25%" class="image-action-nl">'; 
                                                $codeHTML .='</a>'; 
                                            $codeHTML .='</div>'; 
                                        $codeHTML .='</div>'; 
                                    $codeHTML .='</div>'; 
                                $codeHTML .='</div>';              
                            } 
                        }
                    }
                    $nbrSeq= $nbrSeq + 1;
                        
                }
                $codeHTML .='</div></div>';
                
            }
        }
        echo $codeHTML;
    }
    /*public function getById(){
        $codeHTML = '';
        $lienCol= 1;
        $nbrSeq= 1;
        if (isset($_POST['idSequence'])) {
            $trackingid = $this->tracking_model->Add($_POST['idSequence'],0,$_POST['tracking_type'],$_POST['module_id']);
            $sessionArray = array('TRACKINGID'=>$trackingid);                                    
            $this->session->set_userdata($sessionArray);
            $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
            
            if ($this->isTuteurConnet()) {
                $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'));
            }
            else{
                $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('GUSERID'),$this->session->userdata ('GROUPE'));
            }
            $imgthumbnail = '';
            $class = '';
            
            $codeHTML .='</div>';
            if (isset($chapitre['cnt'])) {
                // colonne lien

                $codeHTML.=' <div class="row col_lien " value="'.$lienCol.'">
                <div class="col-md-12">
                <h5 class="titre-your-module titre-activ"><b>Activities of '.$_POST['sequenceName'].' </b></h5> 
                </div>
                <div class="row-lien">
                ';
                
                $lienCol= $lienCol + 1;
                for($i=0;$i<$chapitre['cnt'];$i++) {
                
                    $type           = $chapitre[$i]['type']     ;
                    $titre          = $chapitre[$i]['titre']    ;
                    $numero         = $chapitre[$i]['numero']   ;
                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                    $final_url      = $chapitre[$i]['final_url']  ;
                    $status_url     = $chapitre[$i]['status_url']  ;

                    if (($final_url == NULL || $final_url == "") && $linkUrl != '') {
                        $final_url = $linkUrl;
                    }

                    
                    $link_support = $linkUrl;
                    $redir        = 'redir.php?url';
                    $support      = '';
                    $urlF         = "";
                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                        $codeHTML .= "";                
                    }
                    else{
                        $fileimg = base_url()."groupes/default.png";
                        $codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                    }

                    if ($titre != 'Support') {

                        if ($this->validate_url($link_support)){
                            $suffixe = '';
                            if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                $suffixe  = 'https://';
                            }
                            elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                $suffixe  = 'http://';
                            }
                            else{
                                $suffixe  = '';
                            }
                            $urlF  .= $suffixe.$link_support;
                            $codeHTML .='
                                <div class="col-md-2 sequenceActivity">
                                    <div class="sequ1 sequence sequence1 col-lien-pointer" value="'.$nbrSeq.'">
                                        <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
                                        <div class="sequence-hover" value="'.$nbrSeq.'">
                                            <div class = "btn-group-vertical btn-action-activity btn-action-sequence-pdg">
                                                <a class="btn link-action-nl btn-add-comment-activity" title="Add comment" data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');">
                                                    <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" >
                                                </a>
                                                <a  data-title="'.$titre.'" onclick="addInFavorites(this,'.$id_sequence.','.$numero.');" class="btn link-action-nl btn-add-fav-activity" title="Add favorite">
                                                    <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl">
                                                </a>
                                            </div>
                                            <a href="#" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlF.'" class="btn link-loop-nl lien_activites" title="Access the article">
                                              <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" class="image-action-nl img-loop-nl">                                                  
                                            </a>
                                        </div>
                                        <p> '.$titre.'</p>
                                    </div>
                                </div>
                                ';  
                        }
                        else{
                            if (strpos($link_support, $redir) === false) { 
                                if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                    $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                    
                                    $codeHTML .='
                                    <div class="col-md-2 sequenceActivity">
                                        <div class="sequ1 sequence sequence1 col-lien-pointer" value="'.$nbrSeq.'">
                                            <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
                                            <div class="sequence-hover" value="'.$nbrSeq.'">
                                                <div class = "btn-group-vertical btn-action-activity btn-action-sequence-pdg">
                                                    <a class="btn link-action-nl btn-add-comment-activity" title="Add comment" data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');">
                                                        <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" >
                                                    </a>
                                                    <a  data-title="'.$titre.'" onclick="addInFavorites(this,'.$id_sequence.','.$numero.');" class="btn link-action-nl btn-add-fav-activity" title="Add favorite">
                                                        <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl">
                                                    </a>
                                                </div>
                                                <a href="#" data-brew="redirect" data-link="'.$urlFormation.'" onclick="viewActivity(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlFormation.'" class="btn link-loop-nl lien_activites" title="Access the article">
                                                  <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" class="image-action-nl img-loop-nl">                                                  
                                                </a>
                                            </div>
                                            <p> '.$titre.'</p>
                                        </div>
                                    </div>
                                    ';  


                                }
                                else{
                                    $suffixe = '';
                                    //$urlF  .= HTTP_FORMATIONS.$link_support;
                                    if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                        $suffixe  = 'https://';
                                    }
                                    elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                        $suffixe  = 'http://';
                                    }
                                    else{
                                        $suffixe  = '';
                                    }
                                    $urlF  .= $suffixe.$link_support;
                                    $codeHTML .='
                                    <div class="col-md-2 sequenceActivity csdsssssssss">
                                        <div class="sequ1 sequence sequence1 col-lien-pointer" value="'.$nbrSeq.'">
                                            <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
                                            <div class="sequence-hover" value="'.$nbrSeq.'">
                                                <div class = "btn-group-vertical btn-action-activity btn-action-sequence-pdg">
                                                    <a class="btn link-action-nl btn-add-comment-activity" title="Add comment" data-title="'.$titre.'"  onclick="addComment(this,'.$id_sequence.','.$numero.');">
                                                        <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" >
                                                    </a>
                                                    <a  data-title="'.$titre.'" onclick="addInFavorites(this,'.$id_sequence.','.$numero.');" class="btn link-action-nl btn-add-fav-activity" title="Add favorite">
                                                        <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl">
                                                    </a>
                                                </div>
                                                <a href="#" data-brew="redirect" data-link="'.$urlF.'"  onclick="viewActivity(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlF.'" class="btn link-loop-nl lien_activites" title="Access the article">
                                                  <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" class="image-action-nl img-loop-nl">                                                  
                                                </a>
                                            </div>
                                            <p> '.$titre.'</p>
                                        </div>
                                    </div>
                                    ';  
                                }
                            }                 
                            else { 
                                $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                $suffixe = '';
                                if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                    $suffixe  = 'https://';
                                }
                                elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                    $suffixe  = 'http://';
                                }
                                else{
                                    $suffixe  = '';
                                }

                                $urlF  .= $suffixe.$urlF1;
                                $codeHTML .='
                                <div class="col-md-2 sequenceActivity">
                                    <div class="sequ1 sequence sequence1 col-lien-pointer" value="'.$nbrSeq.'" >
                                        <img class="" id="image-thumb" src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
                                        <div class="sequence-hover" value="'.$nbrSeq.'">
                                            <div class="btn-group-vertical btn-action-activity btn-action-sequence-pdg">
                                                <a class="btn link-action-nl btn-add-comment-activity" title="Add comment" data-title="'.$titre.'" onclick="addComment(this,'.$id_sequence.','.$numero.');">
                                                    <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" >
                                                </a>
                                                <a  data-title="'.$titre.'" onclick="addInFavorites(this,'.$id_sequence.','.$numero.');" class="btn link-action-nl btn-add-fav-activity" title="Add favorite">
                                                    <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl">
                                                </a>
                                            </div>
                                            <a href="#" data-brew="redirect" data-statusurl="'.$status_url.'" data-finalurl="'.$urlF.'"   onclick="viewActivity(this);" data-id="'.$id_sequence.'" data-num="'.$numero.'" data-statusurl="'.$status_url.'" class="btn link-loop-nl lien_activites" title="Access the article">
                                              <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" class="image-action-nl img-loop-nl">                                                  
                                            </a>
                                        </div>
                                        <p> '.$titre.'</p>
                                    </div>
                                </div>
                                ';               
                            } 
                        }
                    }
                    $nbrSeq= $nbrSeq + 1;
                        
                }
                $codeHTML .='</div></div>';
                
            }
        }
        echo $codeHTML;
    }*/

    public function getListItems(){
        $HTML = '';
        $HTMLOption = '';
        if (isset($_POST['idDomaine'])) {
            $sequenceArray = $this->sequence_model->readByDomaineThreeView(0,1,'');
        }
        elseif (isset($_POST['key'])) {
            $sequenceArray = $this->sequence_model->readByDomaineThreeView(0,1,$_POST['key']);
        }

        $HTML .= '<li><span>None</span><ul>';
        $HTML .= '<input type="hidden" class="totalSeq" value="'.$sequenceArray['cnt'].'">';
        if (isset($sequenceArray)) {
            for ($i=0; $i < $sequenceArray['cnt']; $i++) { 
                $deleteClass = '';
                if ($this->formations_model->ItemIsValid($sequenceArray[$i]['id'],-1,TYPE_SEQUENCE,$this->session->userdata ('STAGIAIREGRP'),1) >= 1)  {
                    $deleteClass = 'delete';
                }
                else{
                       $deleteClass = 'add-item';
                }
                $HTML .= '<li class="sequence-link '.$deleteClass.'"><span class="domaineName">'.$sequenceArray[$i]['titre'].'</span>';

                $HTML .= '<input type="hidden" class="sequence_id" value="'.$sequenceArray[$i]['id'].'">';
                $HTML .= '<input type="hidden" class="matiere_id" value="'.$sequenceArray[$i]['matiere_id'].'">';
                $HTML .= '<input type="hidden" class="domaine_id" value="'.$sequenceArray[$i]['domaine_id'].'">';
                if (isset($_POST['idParcours'])) {
                    $HTML .= '<input type="hidden" class="parcours_id" value="'.$_POST['idParcours'].'">';
                }
                if (isset($_POST['idModule'])) {
                    $HTML .= '<input type="hidden" class="module_id" value="'.$_POST['idModule'].'">';
                }
                $HTML .= '<ul class="materialmenu"></ul></li>';

                $HTMLOption .= '<option class="option_sequence_items" data-id="'.$sequenceArray[$i]['id'].'" value="'.$sequenceArray[$i]['titre'].'">';
            }
        }
        $HTML .= '</ul></li>';
        echo $HTMLOption."##".$HTML;
    }

    public function addSequenceItemsFormation(){
        if (isset($_POST['sequence_id']) && $this->isTuteurConnet()) {
            if (isset($_POST['module_id'])) {
                echo $this->admin_model->ajouterSequenceFormation($this->session->userdata ('STAGIAIREID'),$_POST['sequence_id'],1,$_POST['module_id'],1,$_POST['parcours_id'],1,$this->session->userdata ('STAGIAIREGRP'),$_POST['domaine_id']);
            }
            else{
                echo $this->admin_model->ajouterSequenceFormation($this->session->userdata ('STAGIAIREID'),$_POST['sequence_id'],1,0,1,0,1,$this->session->userdata ('STAGIAIREGRP'),$_POST['domaine_id']);
            }
        }
        else{
            if (isset($_POST['module_id'])) {
                echo $this->admin_model->ajouterSequenceFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupeId']),$_POST['sequence_id'],1,$_POST['module_id'],1,$_POST['parcours_id'],1,$_POST['groupeId'],$_POST['domaine_id']);
            }
            else{
                echo $this->admin_model->ajouterSequenceFormation($this->groupes_model->RequestByGrp('id_membres',$_POST['groupeId']),$_POST['sequence_id'],1,0,1,0,1,$_POST['groupeId'],$_POST['domaine_id']);
            }
        }
    }

    public function addTrackingAndSatus(){
        $ret = array();
        $ret['retour'] = "tracking and url final";
        if (isset($_POST['link'])) {
            if (strpos($_POST['link'], 'learnenglishteens.britishcouncil.org') !== false || strpos($_POST['link'], 'learnenglish.britishcouncil.org') !== false || strpos($_POST['link'], 'learnenglishkids.britishcouncil.org') !== false || strpos($_POST['link'], 'www.liveworksheets.com') !== false || strpos($_POST['link'], 'www.teachingenglish.org.uk') !== false || strpos($_POST['link'], 'www.usingenglish.com') !== false || strpos($_POST['link'], 'www.englisch-hilfen.de') !== false || strpos($_POST['link'], 'leo.stcloudstate.edu') !== false || strpos($_POST['link'], 'elt.oup.com') !== false || strpos($_POST['link'], 'thebalancecareers.com') !== false || strpos($_POST['link'], 'premierskillsenglish.britishcouncil.org') !== false || strpos($_POST['link'], 'grammar.ccc.commnet.edu') !== false || strpos($_POST['link'], 'continuingstudies.uvic.ca') !== false || strpos($_POST['link'], 'www.grammarly.com') !== false || strpos($_POST['link'], 'www.anglaisfacile.com') !== false){
                $ret['finalUrl']  = $_POST['link'];
                $ret['responses'] = false;
            }
            else{
                $ret['finalUrl']  = $this->findUltimateDestination($_POST['link'],10);
                $ret['responses'] = $this->getHeaderResponses($_POST['link']);
            }
            
            if (strpos($_POST['link'], 'vimeo.com') !== false || strpos($_POST['link'], 'facebook.com') !== false || strpos($_POST['link'], 'dailymotion.com') !== false || strpos($_POST['link'], 'youtube') !== false || strpos($_POST['link'], 'youtu.be') !== false) {
                $ret['mediaUrl'] = $this->getEmbedUrl($_POST['link']);
            }
        }

        if (isset($_POST['idSequence'])) {
            $this->loadTrackingEl($_POST['idSequence'],$_POST['numero'],$_POST['tracking_type'],$_POST['module_id']);
        }
        echo json_encode($ret);
    }

    public function addTrackingNavigation(){
        $dataLastActivity = array();
        if (isset($_POST['id'])) {
            $trackingTypeMenu;
            switch ($_POST['id']) {
                case 'my_profil':
                    $trackingTypeMenu = 111;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('my_profil')
                    );
                    break;
                case 'my_library':
                    $trackingTypeMenu = 8;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('my_library')
                    );
                    break;
                case 'my_tanishep':
                    $trackingTypeMenu = 2;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('my_tanishep')
                    );
                    break;
                case 'my_booster':
                    $trackingTypeMenu = 22;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('my_booster')
                    );
                    break;
                case 'tools':
                    $trackingTypeMenu = 2;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('tools')
                    );
                    break;
                case 'dashbord':
                    $trackingTypeMenu = 18;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('dashboard')
                    );
                    break;
                case 'toolspage':
                    $trackingTypeMenu = 2;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('tools')
                    );
                    break; 
                case 'jitsiRoom':
                    $trackingTypeMenu = 30;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('conference_room')
                    );
                    break;  
                case 'mobileclassroom':
                    $trackingTypeMenu = 77;
                    $dataLastActivity = array(
                        'last_activity' => $this->lang->line('mobile_classroom')
                    );
                    break;                
                default:
                    // code...
                    break;
            }

            $this->updateLastActivity($dataLastActivity);
            $this->loadTrackingEl(0,0,$trackingTypeMenu);
        }
    }

    
    public function addTracking(){
        $ret = array();
        $ret['retour'] = "tracking and url final";

        if (isset($_POST['idSequence'])) {
            $this->loadTrackingEl($_POST['idSequence'],$_POST['numero'],$_POST['tracking_type'],$_POST['module_id']);
        }
        echo json_encode($ret);
    }

    public function addTrackingToAccessContent(){
        $ret = array();
        $ret['retour'] = "tracking and url final";

        if (isset($_POST['idSequence'])) {
            $this->loadTrackingEl($_POST['idSequence'],$_POST['numero'],$_POST['tracking_type'],$_POST['module_id']);
        }
        echo json_encode($ret);
    }
    public function addTrackingExerciceInFav(){
        $ret = array();
        $ret['retour'] = "tracking";
        if (isset($_POST['id'])) {
            $this->loadTrackingEl($_POST['id'],$_POST['numero'],24,$_POST['module_id']);
        }
        echo json_encode($ret);
    }

    public function getDataByParams(){
        $this->loadTrackingEl(0,0,$this->tracking_type);
        if (isset($_POST['key']) && isset($_POST['data_type']) && isset($_POST['domaine'])) {
            $nbrSeq = 1;
            $lienCol= 1;
            $codeHTML = '';
            $footerclass = '';
            if ($this->isTuteurConnet()) {
                $userId  = $this->session->userdata ('STAGIAIREID');
                $groupId = $this->session->userdata ('STAGIAIREGRP');
                $footerclass = 'card-footer-trainner';
            }
            else{
                $userId  = $this->session->userdata ('GUSERID');
                $groupId = $this->session->userdata ('GROUPE');
            }
            $ret_newsletter2 = $this->sequence_model->getPavetSequenceHaut($groupId,$userId,$_POST['domaine']);
            if (isset($_POST['method']) && $_POST['method'] == 'keypress') {
                if(!empty($ret_newsletter2)){
                    $lienCol= $lienCol + 1;
                    $chapitre = array();
                    if(is_array($ret_newsletter2['module'])){
                        foreach($ret_newsletter2['module'] as $key2=>$value2){
                            foreach($value2 as $key3=>$value3){
                                $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$_POST['domaine']);
                                foreach($ret_newsletter3['module'] as $key4=>$value4){
                                    if(is_array($value4)){
                                        foreach($value4 as $key5=>$value5){
                                            if($value5['sequence_name'] != "") {
                                                $chapitre = $this->chapitres_model->readTraineeSequencesSearch($value5['sequence_id'],$userId,$groupId,$_POST['key']);
                                                if (isset($chapitre['cnt'])) {
                                                    // colonne lien

                                                    $lienCol= $lienCol + 1;
                                                    for($i=0;$i<$chapitre['cnt'];$i++) {
                                                    
                                                        $type           = $chapitre[$i]['type']     ;
                                                        $titre          = $chapitre[$i]['titre']    ;
                                                        $numero         = $chapitre[$i]['numero']   ;
                                                        $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                                                        $linkUrl        = $chapitre[$i]['lienUrl']  ;
                                                        $id_sequence    = $chapitre[$i]['id_sequence']  ;
                                                        $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                                                        $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                                                        $status_url     = $chapitre[$i]['status_url']  ;

                                                        
                                                        $link_support = $linkUrl;
                                                        $redir        = 'redir.php?url';
                                                        $support      = '';
                                                        $urlF         = "";
                                                        if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                                                            $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                                                            $codeHTML .= "";                
                                                        }
                                                        else{
                                                            $fileimg = base_url()."groupes/bg-laptop.png";
                                                            //$codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                                                        }

                                                        if ($titre != 'Support') {
                                                            if (isset($_POST['pave']) && $_POST['pave'] == 7) {
                                                                if ($this->validate_url($link_support)){
                                                                    $suffixe = '';
                                                                    if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                        $suffixe  = 'https://';
                                                                    }
                                                                    elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                        $suffixe  = 'http://';
                                                                    }
                                                                    else{
                                                                        $suffixe  = '';
                                                                    }
                                                                    $urlF  .= $suffixe.$link_support;
                                                                    $codeHTML .='
                                                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                            <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                                <div class="card-img">
                                                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                </div>
                                                                                <div class="card-title">
                                                                                    <h4>'.$titre.'</h4>
                                                                                </div>
                                                                                <div class="card-footer '.$footerclass.'">
                                                                                    <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                        <i class="fa-solid fa-comment"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                        <i class="fa-solid fa-heart"></i>
                                                                                    </a>';
                                                                                     $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                    $codeHTML .= '
                                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    ';               
                                                                }
                                                                else{
                                                                    if (strpos($link_support, $redir) === false) { 
                                                                        if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                                            $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                                            
                                                                            $codeHTML .='
                                                                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                                <div class="card sequ1" value="'.$nbrSeq.'">
                                                                                    <div class="card-img">
                                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                    </div>
                                                                                    <div class="card-title">
                                                                                        <h4>'.$titre.'</h4>
                                                                                    </div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>';
                                                                                        $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                        $codeHTML .= '
                                                                                        <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlFormation.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlFormation.'" class="btn-explore" title="Access the article">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            ';  


                                                                        }
                                                                        else{
                                                                            $suffixe = '';
                                                                            if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                                $suffixe  = 'https://';
                                                                            }
                                                                            elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                                $suffixe  = 'http://';
                                                                            }
                                                                            else{
                                                                                $suffixe  = '';
                                                                            }
                                                                            $urlF  .= $suffixe.$link_support;
                                                                            $codeHTML .='
                                                                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                                <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites"  data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                                    <div class="card-img">
                                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                    </div>
                                                                                    <div class="card-title">
                                                                                        <h4>'.$titre.'</h4>
                                                                                    </div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>';
                                                                                        $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                        $codeHTML .= '
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            ';  
                                                                        }
                                                                    }                 
                                                                    else { 
                                                                        $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                                        $suffixe = '';
                                                                        if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                                            $suffixe  = 'https://';
                                                                        }
                                                                        elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                                            $suffixe  = 'http://';
                                                                        }
                                                                        else{
                                                                            $suffixe  = '';
                                                                        }

                                                                        $urlF  .= $suffixe.$urlF1; 
                                                                        $codeHTML .='
                                                                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                                <div class="card" value="'.$nbrSeq.'" >
                                                                                    <div class="card-img">
                                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                    </div>
                                                                                    <div class="card-title">
                                                                                        <h4>'.$titre.'</h4>
                                                                                    </div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="Add comment" data-title="'.$titre.'" onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a  data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>';
                                                                                        $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                        $codeHTML .= '
                                                                                        <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlF.'"  onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        ';               
                                                                    } 
                                                                }
                                                            }
                                                            else{
                                                                if ($this->validate_url($link_support)){
                                                                    $suffixe = '';
                                                                    if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                        $suffixe  = 'https://';
                                                                    }
                                                                    elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                        $suffixe  = 'http://';
                                                                    }
                                                                    else{
                                                                        $suffixe  = '';
                                                                    }
                                                                    $urlF  .= $suffixe.$link_support;
                                                                    $codeHTML .='
                                                                        <div class="card-style-1 sequenceActivity">
                                                                            <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                                <div class="card-left">
                                                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                </div>
                                                                                <div class="card-right sequence-hover" value="'.$nbrSeq.'">
                                                                                    <div class="card-title">
                                                                                        <h4>'.$titre.'</h4>
                                                                                    </div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-see" title="Access the article">
                                                                                            <i class="fa-solid fa-eye"></i>
                                                                                        </a>
                                                                                        <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>';
                                                                                        $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                        $codeHTML .= '
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    ';               
                                                                }
                                                                else{
                                                                    if (strpos($link_support, $redir) === false) { 
                                                                        if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                                            $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                                            
                                                                            $codeHTML .='
                                                                            <div class="card-style-1 sequenceActivity">
                                                                                <div class="card" value="'.$nbrSeq.'">
                                                                                    <div class="card-left">
                                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                    </div>
                                                                                    <div class="card-right sequence-hover" value="'.$nbrSeq.'">
                                                                                        <div class="card-title">
                                                                                            <h4>'.$titre.'</h4>
                                                                                        </div>
                                                                                        <div class="card-footer '.$footerclass.'">
                                                                                           <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlFormation.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlFormation.'" class="btn-see" title="Access the article">
                                                                                                <i class="fa-solid fa-eye"></i>
                                                                                            </a>
                                                                                            <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                                <i class="fa-solid fa-comment"></i>
                                                                                            </a>';

                                                                                            $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                            $codeHTML .= '
                                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                                <i class="fa-solid fa-heart"></i>
                                                                                            </a>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            ';  


                                                                        }
                                                                        else{
                                                                            $suffixe = '';
                                                                            if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                                $suffixe  = 'https://';
                                                                            }
                                                                            elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                                $suffixe  = 'http://';
                                                                            }
                                                                            else{
                                                                                $suffixe  = '';
                                                                            }
                                                                            $urlF  .= $suffixe.$link_support;
                                                                            $codeHTML .='
                                                                            <div class="card-style-1 sequenceActivity">
                                                                                <div class="card" value="'.$nbrSeq.'">
                                                                                    <div class="card-left">
                                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                    </div>
                                                                                    <div class="card-right sequence-hover" value="'.$nbrSeq.'">
                                                                                        <div class="card-title">
                                                                                            <h4>'.$titre.'</h4>
                                                                                        </div>
                                                                                        <div class="card-footer '.$footerclass.'">
                                                                                            <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlF.'"  onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-see" title="Access the article">
                                                                                                <i class="fa-solid fa-eye"></i>
                                                                                            </a>
                                                                                            <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                                <i class="fa-solid fa-comment"></i>
                                                                                            </a>';

                                                                                            $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                            $codeHTML .= '
                                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                                <i class="fa-solid fa-heart"></i>
                                                                                            </a>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            ';  
                                                                        }
                                                                    }                 
                                                                    else { 
                                                                        $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                                        $suffixe = '';
                                                                        if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                                            $suffixe  = 'https://';
                                                                        }
                                                                        elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                                            $suffixe  = 'http://';
                                                                        }
                                                                        else{
                                                                            $suffixe  = '';
                                                                        }

                                                                        $urlF  .= $suffixe.$urlF1; 
                                                                        $codeHTML .='
                                                                            <div class="card-style-1 sequenceActivity">
                                                                                <div class="card" value="'.$nbrSeq.'" >
                                                                                    <div class="card-left">
                                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                                    </div>
                                                                                    <div class="card-right sequence-hover" value="'.$nbrSeq.'">
                                                                                        <div class="card-title">
                                                                                            <h4>'.$titre.'</h4>
                                                                                        </div>
                                                                                        <div class="card-footer '.$footerclass.'">
                                                                                            <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlF.'"  onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-see" title="Access the article">
                                                                                                <i class="fa-solid fa-eye"></i>
                                                                                            </a>
                                                                                            <a class="add-comment" title="Add comment" data-title="'.$titre.'" onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                                <i class="fa-solid fa-comment"></i>
                                                                                            </a>';

                                                                                            $codeHTML .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                                            $codeHTML .= '
                                                                                            <a  data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                                <i class="fa-solid fa-heart"></i>
                                                                                            </a>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        ';               
                                                                    } 
                                                                }
                                                            }
                                                        }
                                                        $nbrSeq= $nbrSeq + 1;
                                                            
                                                    }                        
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            echo $codeHTML;
        }
    }
    
    public function getDataComplementary($groupId,$userId,$method,$key='',$data_type,$id=null,$numero=null){
        $output = '';
        $ret_complementary_activities=$this->sequence_model->getPavetComplementary($groupId); 
        $array_newsletter = $this->sequence_model->getPavetHaut($groupId,4);
        $array_ped_training = $this->sequence_model->getPavetHaut($groupId,6);
        $array_pers_ling = $this->sequence_model->getPavetHaut($groupId,7);
        $array_ling_tools = $this->sequence_model->getPavetHaut($groupId,8);

        $arrayListeModule = array();
        $array_id_module_newsletter = array();
        $array_id_module_ped_training = array();
        $array_id_module_pers_ling = array();
        $array_id_module_ling_tools = array();   

        if(!empty($array_newsletter)){
            if (is_array($array_newsletter['module'])) {
                foreach($array_newsletter['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_newsletter[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ped_training)){
            if (is_array($array_ped_training['module'])) {
                foreach($array_ped_training['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ped_training[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_pers_ling)){
            if (is_array($array_pers_ling['module'])) {
                foreach($array_pers_ling['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_pers_ling[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ling_tools)){
            if (is_array($array_ling_tools['module'])) {
                foreach($array_ling_tools['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ling_tools[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($ret_complementary_activities)){
            if (is_array($ret_complementary_activities['module'])) {
                foreach($ret_complementary_activities['module'] as $key=>$value){
                    $arrayListeModule[] = $value['module_id'];
                }
            }
        }

        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;
        if(!empty($ret_complementary_activities)){
            if(is_array($ret_complementary_activities['module'])){
                foreach($ret_complementary_activities['module'] as $key=>$value){
                    if (in_array($value['module_id'], $arrayListeModule)) {
                        if ($method == 'keypress') {
                            if ($data_type == 'Sequences') {
                                if ($key !='') {
                                    $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($value['sequence_id']);
                                    if ($thumbnailSeq != '') {
                                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
                                    }
                                    else{

                                        $fileimg = base_url()."groupes/img_default.jpg";
                                    }
                                    $output .='
                                    <div class="col-md-2 sequenceTotal">
                                        <div class="sequ1 sequence col-lien-pointer" onmouseleave="dactiveActionPdg(this);" onmouseover="activeActionPdg(this);">
                                            <img class="" id="image-thumb"  src="'.$fileimg.'" width="100%" height="100%" style="border-radius:10px;">
                                            <div class="sequence-hover" style="display:none;">
                                                <div class = "btn-group-vertical btn-action-activity btn-action-sequence-pdg">
                                                    <a class="btn link-action-nl" onclick="addCommentSequenceActivitySearch(this);" data-title="'.$value['sequence_name'].'" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'" title="Add comment">
                                                        <img src="'.base_url().'/assets/images/HOVER/NL-ACTIONS/Commentaire-vignette-Normal.png" class="image-action-nl img-comment-nl" style="z-index:100 !important;">
                                                    </a>
                                                    <a data-title="'.$value5['sequence_name'].'" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'" class="btn link-action-nl" onclick="addFavorySequenceActivitySearch(this);"  title="Add favorite">
                                                        <img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Favorites-vignette-Normal.png" class="image-action-nl img-favorite-nl" style="z-index:100 !important;">
                                                    </a>
                                                </div>
                                                <a href="#"  onclick="getActivityInSequenceClickSearch(this);"  data-name="'.$value['sequence_name'].'" data-id="'.$value['sequence_id'].'" class="btn link-loop-nl btn-loop-activity-by-sequence" title="Access to the activity"><img src="'.base_url().'assets/images/HOVER/NL-ACTIONS/Loupe-vignette-icon.png" class="image-action-nl img-loop-nl">        
                                                </a>
                                            </div>
                                        </div>
                                        <p>'.$value5['sequence_name'].'</p>
                                    </div>';
                                } 
                            }
                        } 
                        else{
                            //if ($data_type == 'Sequences' && $key !='' && $this->like_match('%$key%',$value['sequence_name'])) {                
                            if ($data_type == 'Sequences') {                
                                $output   .= '
                                <li class="classification-favoris-list-data-pdg" data-id="'.$value['sequence_id'].'" data-module="'.$value['module_id'].'" data-type="'.$data_type.'">'.$value['sequence_name'].'
                                </li>';
                            }
                            else{
                                if($value['sequence_name'] != "") {
                                    $chapitre = $this->chapitres_model->readTraineeSequencesSearch($value['sequence_id'],$groupId,$userId,$key);
                                    if (isset($chapitre['cnt'])) {
                                        for($i=0;$i<$chapitre['cnt'];$i++) {
                                            $output   .= '<li class="classification-favoris-list-data-pdg" data-id="'.$chapitre[$i]['id_sequence'].'" data-numero="'.$chapitre[$i]['numero'].'" data-type="'.$data_type.'">'.$chapitre[$i]['titre'].'</li>';
                                        }
                                    }
                                }
                            }
                        }
                    } 
                }
            } 
        }
        return $output;
    }

    public function personalInterest()
    {
        $retour = "";
        $nbrBtn= 1;
        $nbrMod= 1;
        $nbrSeq= 1;
        $lienCol= 1;
        $sequence_id;
        $paves_sequence_nom = '';
        $tabContentHtml = '';
        $idGroupe = '';
        //Declaration variable numero pour chaque liste
        $numeroSeq = 0;
        $PAVE = isset($_GET['pave']) ? $_GET['pave'] : 0;
        $paves_sequence_nom .= $this->lang->line('educational_library_pedagogical_training');
        $this->global['titlelibrary'] = $this->lang->line('educational_library_pedagogical_training');
        $this->tracking_type = 7; 
        if ($this->isTuteurConnet()) {
            $idGroupe = $this->session->userdata ('STAGIAIREGRP');
        }
        else{
            $idGroupe = $this->session->userdata ('GROUPE');
        }
        $data['PAVE_SEQUENCE'] = $PAVE;
        $this->loadTrackingEl(0,0,$this->tracking_type);
        
        $this->global['pageTitle'] = 'E-learning : '.$paves_sequence_nom;
        $this->global['groupe'] = $idGroupe;
        $this->global['sequenceTitle'] = $paves_sequence_nom;
        $data['TRACKING_TYPE'] = $this->tracking_type;

        $url_sequence = ""; 
        define('PAGELOCALFORMATION',  base_url().'formation'); 
        $data['ret_newsletter2'] = $this->sequence_model->getPavetSequenceHaut($idGroupe,$this->session->userdata ('GUSERID'),$PAVE);
        $nbrBtn    = 1;
        $moduleId;
        $moduleName;
        $groupeId;
        if(isset($data['ret_newsletter2']) && !empty($data['ret_newsletter2'])){
            if(is_array($data['ret_newsletter2']['module'])){ 
                foreach($data['ret_newsletter2']['module'] as $key2=>$value2){ if(is_array($value2)){ 
                    foreach($value2 as $key3=>$value3){ 
                        if ($nbrBtn == 1) {
                            $moduleId     = $value3['module_id'];
                            $moduleName   = $key2;
                            $groupeId     = $value3['idg'];
                        }
                        $nbrBtn ++; }
                    }
                }
            }
        }

        if (isset($moduleId) && $moduleId > 0) {
            $data['dataLoadPageLibrary']  = $this->getModuleContentLoadPage($groupeId,$moduleId,$moduleName,$PAVE);
        }
        $data['moduleloaded']  = isset($moduleId) ? $moduleId : NULL;
        $data['classification_favoris']  = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata('GUSERID'),$idGroupe); 
        if ($this->isTuteurConnet()) {
            $data['historik_course'] = $this->coursHistorik_model->getByUserCreateIdGroupTraineeCreate($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREID'),$idGroupe); 
            $this->loadViews("tutor/trainee/persalinterest", $this->global,$data, NULL );
        }   
        else{
            $this->loadViews("trainee/sequence/persalinterest", $this->global,$data, NULL );
        }
        
    }
    
    //comment in 27-12-2023
    /*public function getById(){
        $codeHTML = '';
        $lienCol= 1;
        $nbrSeq= 1;
        $GROUPE = '';
        $footerclass = '';
        $PAVE = isset($_POST['pave']) ? $_POST['pave'] : NULL;
        isset($_POST['idSequence']) ? $this->loadTrackingEl($_POST['idSequence'],0,$this->tracking_type,isset($_POST['module_id']) ? $_POST['module_id'] : '') : '';
        if (isset($_POST['idSequence']) && isset($_POST['containerExist']) && $_POST['containerExist'] == 'false') {

            if ($this->isTuteurConnet()) {
                $GROUPE = $this->session->userdata ('STAGIAIREGRP');
                $footerclass = 'card-footer-trainner';
            }
            else{
                $GROUPE = $this->session->userdata ('GROUPE');
            }
            $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('GUSERID'),$GROUPE);
            $imgthumbnail = '';
            $class = '';
            
            $codeHTML.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your activities (content of '.$this->sequence_model->Request('sequence_titre',$_POST['idSequence']).')</h2></div>';
            $codeHTML .= '<div class="card-container">';

                if (isset($chapitre['cnt'])) {
                    // colonne lien

                    $lienCol= $lienCol + 1;
                    for($i=0;$i<$chapitre['cnt'];$i++) {
                    
                        $user_create    = $chapitre[$i]['user_create']     ;
                        $type           = $chapitre[$i]['type']     ;
                        $titre          = $chapitre[$i]['titre']    ;
                        $numero         = $chapitre[$i]['numero']   ;
                        $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                        $linkUrl        = $chapitre[$i]['lienUrl']  ;
                        $id_sequence    = $chapitre[$i]['id_sequence']  ;
                        $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                        if ($type == 4 && $user_create != null) {
                            $final_url      = HTTP_FORMATION.'activitySequence/'.$chapitre[$i]['lienUrl']  ;
                        }
                        else{
                            $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                        }
                        $status_url     = $chapitre[$i]['status_url']  ;

                        
                        $link_support = $linkUrl;
                        $redir        = 'redir.php?url';
                        $support      = '';
                        $urlF         = "";
                        if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                            $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                            $codeHTML .= "";                
                        }
                        else{
                            $fileimg = base_url()."groupes/bg-laptop.png";
                            //$codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                        }

                        if ($titre != 'Support') {
                            if ($this->validate_url($link_support)){
                                $suffixe = '';
                                if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                    $suffixe  = 'https://';
                                }
                                elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                    $suffixe  = 'http://';
                                }
                                else{
                                    $suffixe  = '';
                                }
                                $urlF  .= $suffixe.$link_support;
                                $codeHTML .='
                                    <div class="card-style-4 sequenceActivity">
                                        <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                            <div class="card-img">
                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                            </div>
                                            <div class="card-title">
                                                <h4>'.$titre.'</h4>
                                            </div>';
                                            if ($this->isTuteurConnet() && $PAVE == 7) {
                                                if ($user_create == $this->session->userdata ('GUSERID')) {
                                                    $codeHTML .='
                                                    <div class="card-footer '.$footerclass.'">
                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                        </a>
                                                    </div>
                                                    <div class="card-footer '.$footerclass.'">
                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                            <i class="fa-solid fa-comment"></i>
                                                        </a>
                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                            <i class="fa-solid fa-heart"></i>
                                                        </a>
                                                        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-edit"></i>
                                                        </a>
                                                        <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </a>
                                                    </div>';
                                                }
                                                else{
                                                    $codeHTML .='
                                                    <div class="card-footer '.$footerclass.' opacity"></div>
                                                    <div class="card-footer '.$footerclass.'">
                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                            <i class="fa-solid fa-comment"></i>
                                                        </a>
                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                            <i class="fa-solid fa-heart"></i>
                                                        </a>
                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                        </a>
                                                    </div>';
                                                }       
                                            }
                                            else{
                                                $codeHTML .='<div class="card-footer '.$footerclass.'">
                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                        <i class="fa-solid fa-comment"></i>
                                                    </a>
                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                        <i class="fa-solid fa-heart"></i>
                                                    </a>';  

                                                    if($this->isTuteurConnet()){
                                                        $codeHTML .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                    }                                                                 
                                                    $codeHTML .= '
                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                    </a>
                                                </div>';
                                            }
                                        $codeHTML .='</div>
                                    </div>
                                ';               
                            }
                            else{
                                if (strpos($link_support, $redir) === false) { 
                                    if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                        $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                        
                                        $codeHTML .='
                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                            <div class="card sequ1" value="'.$nbrSeq.'">
                                                <div class="card-img">
                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                </div>
                                                <div class="card-title">
                                                    <h4>'.$titre.'</h4>
                                                </div>';
                                                if ($this->isTuteurConnet() && $PAVE == 7) {
                                                    if ($user_create == $this->session->userdata ('GUSERID')) {
                                                        $codeHTML .='
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                            </a>
                                                        </div>
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                <i class="fa-solid fa-comment"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-heart"></i>
                                                            </a>
                                                            <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                    <i class="fa-solid fa-edit"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-trash"></i>
                                                            </a>
                                                        </div>';
                                                    }
                                                    else{
                                                        $codeHTML .='
                                                        <div class="card-footer '.$footerclass.' opacity"></div>
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                <i class="fa-solid fa-comment"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-heart"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                            </a>
                                                        </div>';
                                                    }       
                                                }
                                                else{
                                                    $codeHTML .='<div class="card-footer '.$footerclass.'">
                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                            <i class="fa-solid fa-comment"></i>
                                                        </a>
                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                            <i class="fa-solid fa-heart"></i>
                                                        </a>';  

                                                        if($this->isTuteurConnet()){
                                                            $codeHTML .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                        }                                                                 
                                                        $codeHTML .= '
                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                        </a>
                                                    </div>';
                                                }
                                        $codeHTML .='</div>
                                        </div>
                                        ';  


                                    }
                                    else{
                                        $suffixe = '';
                                        if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                            $suffixe  = 'https://';
                                        }
                                        elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                            $suffixe  = 'http://';
                                        }
                                        else{
                                            $suffixe  = '';
                                        }
                                        $urlF  .= $suffixe.$link_support;
                                        $codeHTML .='
                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                            <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                <div class="card-img">
                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                </div>
                                                <div class="card-title">
                                                    <h4>'.$titre.'</h4>
                                                </div>';
                                                if ($this->isTuteurConnet() && $PAVE == 7) {
                                                    if ($user_create == $this->session->userdata ('GUSERID')) {
                                                        $codeHTML .='
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                            </a>
                                                        </div>
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                <i class="fa-solid fa-comment"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-heart"></i>
                                                            </a>
                                                            <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                    <i class="fa-solid fa-edit"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-trash"></i>
                                                            </a>
                                                        </div>';
                                                    }
                                                    else{
                                                        $codeHTML .='
                                                        <div class="card-footer '.$footerclass.' opacity"></div>
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                <i class="fa-solid fa-comment"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-heart"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                            </a>
                                                        </div>';
                                                    }       
                                                }
                                                else{
                                                    $codeHTML .='<div class="card-footer '.$footerclass.'">
                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                            <i class="fa-solid fa-comment"></i>
                                                        </a>
                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                            <i class="fa-solid fa-heart"></i>
                                                        </a>';  

                                                        if($this->isTuteurConnet()){
                                                            $codeHTML .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                        }                                                                 
                                                        $codeHTML .= '
                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                        </a>
                                                    </div>';
                                                }
                                        $codeHTML .='</div>
                                        </div>
                                        ';  
                                    }
                                }                 
                                else { 
                                    $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                    $suffixe = '';
                                    if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                        $suffixe  = 'https://';
                                    }
                                    elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                        $suffixe  = 'http://';
                                    }
                                    else{
                                        $suffixe  = '';
                                    }

                                    $urlF  .= $suffixe.$urlF1; 
                                    $codeHTML .='
                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                            <div class="card" value="'.$nbrSeq.'" >
                                                <div class="card-img">
                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                </div>
                                                <div class="card-title">
                                                    <h4>'.$titre.'</h4>
                                                </div>';
                                                if ($this->isTuteurConnet() && $PAVE == 7) {
                                                    if ($user_create == $this->session->userdata ('GUSERID')) {
                                                        $codeHTML .='
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                            </a>
                                                        </div>
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                <i class="fa-solid fa-comment"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-heart"></i>
                                                            </a>
                                                            <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                    <i class="fa-solid fa-edit"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-trash"></i>
                                                            </a>
                                                        </div>';
                                                    }
                                                    else{
                                                        $codeHTML .='
                                                        <div class="card-footer '.$footerclass.' opacity"></div>
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                <i class="fa-solid fa-comment"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                <i class="fa-solid fa-heart"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                            </a>
                                                        </div>';
                                                    }       
                                                }
                                                else{
                                                    $codeHTML .='<div class="card-footer '.$footerclass.'">
                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                            <i class="fa-solid fa-comment"></i>
                                                        </a>
                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                            <i class="fa-solid fa-heart"></i>
                                                        </a>';  

                                                        if($this->isTuteurConnet()){
                                                            $codeHTML .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                        }                                                                 
                                                        $codeHTML .= '
                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                        </a>
                                                    </div>';
                                                }
                                        $codeHTML .='</div>
                                        </div>
                                    ';               
                                } 
                            }
                        }
                        $nbrSeq= $nbrSeq + 1;
                            
                    }                        
                }
                
                if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
                    $codeHTML .= '
                        <div class="row empty-data-row">
                            <div class="col-md-12 text-center">
                                <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
                            </div>
                        </div>';
                }
            $codeHTML .= '</div>';
        }
        echo $codeHTML;
    }*/
    public function getById(){
        $codeHTML = '';
        $lienCol= 1;
        $nbrSeq= 1;
        $GROUPE = '';
        $footerclass = '';
        $PAVE = isset($_POST['pave']) ? $_POST['pave'] : NULL;
        isset($_POST['idSequence']) ? $this->loadTrackingEl($_POST['idSequence'],0,$this->tracking_type,isset($_POST['module_id']) ? $_POST['module_id'] : '') : '';
        //if (isset($_POST['idSequence']) && isset($_POST['containerExist']) && $_POST['containerExist'] == 'false') {
        if (isset($_POST['idSequence']) && isset($_POST['containerExist'])) {

            if ($this->isTuteurConnet()) {
                $GROUPE = $this->session->userdata ('STAGIAIREGRP');
                $footerclass = 'card-footer-trainner';
            }
            else{
                $GROUPE = $this->session->userdata ('GROUPE');
            }
            $chapitre = $this->chapitres_model->readTraineeSequences($_POST['idSequence'],$this->session->userdata ('GUSERID'),$GROUPE);
            $imgthumbnail = '';
            $class = '';
            
            $codeHTML.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your activities (content of '.$this->sequence_model->Request('sequence_titre',$_POST['idSequence']).')</h2></div>';
            $codeHTML .= '<div class="card-container">';

                if (isset($chapitre['cnt'])) {
                    // colonne lien

                    $lienCol= $lienCol + 1;
                    for($i=0;$i<$chapitre['cnt'];$i++) {
                    
                        $user_create    = $chapitre[$i]['user_create']     ;
                        $type           = $chapitre[$i]['type']     ;
                        $titre          = $chapitre[$i]['titre']    ;
                        $numero         = $chapitre[$i]['numero']   ;
                        $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                        $linkUrl        = $chapitre[$i]['lienUrl']  ;
                        $id_sequence    = $chapitre[$i]['id_sequence']  ;
                        $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                        if ($type == 4 && $user_create != null) {
                            $final_url      = HTTP_FORMATION.'activitySequence/'.$chapitre[$i]['lienUrl']  ;
                        }
                        else{
                            $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                        }
                        $status_url     = $chapitre[$i]['status_url']  ;

                        
                        $link_support = $linkUrl;
                        $redir        = 'redir.php?url';
                        $support      = '';
                        $urlF         = "";
                        if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                            $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                            $codeHTML .= "";                
                        }
                        else{
                            $fileimg = base_url()."groupes/bg-laptop.png";
                            //$codeHTML .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                        }

                        if ($titre != 'Support') {
                            if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                $urlF  = 'https://'.$link_support; 
                            }
                            elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                $urlF  = 'http://'.$link_support;
                            }
                            elseif (strpos($link_support, $redir) === false) {
                                if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                    $urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                }
                                else { 
                                    $urlF = $link_support;
                                }
                            }
                            else{
                                $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                if ((strpos($urlF1, '.doc') !== false) || (strpos($urlF1, '.docx') !== false) || (strpos($urlF1, '.ppt') !== false) || (strpos($urlF1, '.pdf') !== false)){
                                    $urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$urlF1."&amp;embedded=true";
                                }
                                else {                                                      
                                    if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                        $urlF = 'https://'.$urlF1;
                                    }
                                    elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                        $urlF = 'http://'.$urlF1;
                                    }
                                    else{
                                        $urlF = $urlF1;
                                    }
                                }
                            }

                            $codeHTML .='
                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                <div class="card" value="'.$nbrSeq.'" >
                                    <div class="card-img">
                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'"><img src="'.$fileimg.'" alt=""></a>
                                    </div>
                                    <div class="card-title">
                                        <h4>'.$titre.'</h4>
                                    </div>';
                                    if ($this->isTuteurConnet() && $PAVE == 7) {
                                        if ($user_create == $this->session->userdata ('GUSERID')) {
                                            $codeHTML .='
                                            <div class="card-footer '.$footerclass.'">
                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                </a>
                                            </div>
                                            <div class="card-footer '.$footerclass.'">
                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                    <i class="fa-solid fa-comment"></i>
                                                </a>
                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                    <i class="fa-solid fa-heart"></i>
                                                </a>
                                                <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                        <i class="fa-solid fa-edit"></i>
                                                </a>
                                                <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                    <i class="fa-solid fa-trash"></i>
                                                </a>
                                            </div>';
                                        }
                                        else{
                                            $codeHTML .='
                                            <div class="card-footer '.$footerclass.' opacity"></div>
                                            <div class="card-footer '.$footerclass.'">
                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                    <i class="fa-solid fa-comment"></i>
                                                </a>
                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                    <i class="fa-solid fa-heart"></i>
                                                </a>
                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                </a>
                                            </div>';
                                        }       
                                    }
                                    else{
                                        $codeHTML .='<div class="card-footer '.$footerclass.'">
                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                <i class="fa-solid fa-comment"></i>
                                            </a>
                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                <i class="fa-solid fa-heart"></i>
                                            </a>';  

                                            if($this->isTuteurConnet()){
                                                $codeHTML .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                            }                                                                 
                                            $codeHTML .= '
                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                            </a>
                                        </div>';
                                    }
                                $codeHTML .='</div>
                            </div>';
                        }
                        $nbrSeq= $nbrSeq + 1;
                            
                    }                        
                }
                
                if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
                    $codeHTML .= '
                        <div class="row empty-data-row">
                            <div class="col-md-12 text-center">
                                <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
                            </div>
                        </div>';
                }
            $codeHTML .= '</div>';
        }
        echo $codeHTML;
    }

    public function like_match($pattern, $subject){
        $pattern = str_replace('%', '.*', preg_quote($pattern, '/'));
        return (bool) preg_match("/^{$pattern}$/i", $subject);
    }

    /*comment in 27-12-2023*/
    /*public function getModuleContent(){
        $retour = array();
        $html = '';
        $seq = 0;
        $seqC = 0;
        $container = 0;
        $imgthumbnail = '';
        $class = '';
        $activeMenu = '';
        $activeContent = '';
        $lienCol= 1;
        $nbrSeq= 1;
        $footerclass = '';
        $PAVE = isset($_POST['pave']) ? $_POST['pave'] : NULL;
        //$containerSluky = 'tab-sequence-library'.time();
        $containerSluky = 'tab-sequence-library';
        $this->loadTrackingEl(0,0,$this->tracking_type,isset($_POST['moduleId']) ? $_POST['moduleId'] : '');
        if ($this->isTuteurConnet()) {
            $footerclass = 'card-footer-trainner';
        }

        if (isset($_POST['indice']) && $_POST['indice'] == 'complementary') {
            $groupId = $_POST['groupeId'];
            $ret_complementary_activities=$this->sequence_model->getPavetComplementary($groupId); 
            $array_newsletter = $this->sequence_model->getPavetHaut($groupId,4);
            $array_ped_training = $this->sequence_model->getPavetHaut($groupId,6);
            $array_pers_ling = $this->sequence_model->getPavetHaut($groupId,7);
            $array_ling_tools = $this->sequence_model->getPavetHaut($groupId,8);

            $arrayListeModule = array();
            $array_id_module_newsletter = array();
            $array_id_module_ped_training = array();
            $array_id_module_pers_ling = array();
            $array_id_module_ling_tools = array();   

            if(!empty($array_newsletter)){
                if (is_array($array_newsletter['module'])) {
                    foreach($array_newsletter['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_newsletter[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ped_training)){
                if (is_array($array_ped_training['module'])) {
                    foreach($array_ped_training['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ped_training[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_pers_ling)){
                if (is_array($array_pers_ling['module'])) {
                    foreach($array_pers_ling['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_pers_ling[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ling_tools)){
                if (is_array($array_ling_tools['module'])) {
                    foreach($array_ling_tools['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ling_tools[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($ret_complementary_activities)){
                if (is_array($ret_complementary_activities['module'])) {
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        $arrayListeModule[] = $value['module_id'];
                    }
                }
            }

            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;            
            $html .= '<div class="tab-wrap">';
                if(!empty($ret_complementary_activities)){
                    if(is_array($ret_complementary_activities['module']) && $_POST['pave']=='6'){
                        $html .= '<div class="tab-nav-container mb-2">';
                            $html .= '<div class="tab-nav responsive" id="tab-sequence-library">';
                                foreach($ret_complementary_activities['module'] as $key=>$value){ if (in_array($value['module_id'], $arrayListeModule)) {
                                    $html .= '
                                        <div class="tab-nav-item navigation-course-history '.($seqC == 0 ? 'active' : '').'" data-id="content-sequence'.$value['sequence_id'].'" data-id-sequence="'.$this->convert_utf8($value['sequence_id']).'" data-id-module="'.$this->convert_utf8($_POST['moduleId']).'" data-id-pave="'.$_POST['pave'].'" 
                                                data-name="'.$this->convert_utf8($value['sequence_name']).'">
                                            <div class="tab-nav-item-head">
                                                <span>'.$this->convert_utf8($value['sequence_name']).'</span>
                                            </div>
                                            <div class="course-color"></div>
                                            <div class="tab-nav-item-footer">
                                                <button data-title="'.$this->convert_utf8($value['sequence_name']).'" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);"><i class="fa-solid fa-heart"></i></button>
                                                <button data-title="'.$this->convert_utf8($value['sequence_name']).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'"><i class="fa-solid fa-comment"></i></button>
                                            </div>
                                        </div>';

                                $seqC++; }  }
                            $html .= '</div>';
                        $html .= '</div>';
                        $html .= '<div class="tab-content-container">';                    
                            foreach($ret_complementary_activities['module'] as $key=>$value){ if (in_array($value['module_id'], $arrayListeModule)) { if ( $container === 0 ) { $activeContent .= 'active'; 
                                    $chapitre = $this->chapitres_model->readTraineeSequences($value['sequence_id'],$this->session->userdata ('GUSERID'),$_POST['groupeId']);
                                    $html .= '<div id="content-sequence'.$value['sequence_id'].'"  class="tab-content '.$activeContent.'">';
                                        
                                        $html.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your sequences (content of Complementary Activities)</h2></div>';
                                        $html .= '<div class="card-container">';
                                            if (isset($chapitre['cnt'])) {
                                                // colonne lien
                                                $lienCol= $lienCol + 1;
                                                for($i=0;$i<$chapitre['cnt'];$i++) {                                    
                                                    $user_create    = $chapitre[$i]['user_create']     ;
                                                    $type           = $chapitre[$i]['type']     ;
                                                    $titre          = $chapitre[$i]['titre']    ;
                                                    $numero         = $chapitre[$i]['numero']   ;
                                                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                                                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
                                                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
                                                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                                                    $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                                                    $status_url     = $chapitre[$i]['status_url']  ;

                                                    
                                                    $link_support = $linkUrl;
                                                    $redir        = 'redir.php?url';
                                                    $support      = '';
                                                    $urlF         = "";
                                                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                                                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                                                        $html .= "";                
                                                    }
                                                    else{
                                                        $fileimg = base_url()."groupes/bg-laptop.png";
                                                        //$html .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                                                    }

                                                    if ($titre != 'Support') {
                                                        if ($this->validate_url($link_support)){
                                                            $suffixe = '';
                                                            if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                $suffixe  = 'https://';
                                                            }
                                                            elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                $suffixe  = 'http://';
                                                            }
                                                            else{
                                                                $suffixe  = '';
                                                            }
                                                            $urlF  .= $suffixe.$link_support;
                                                            $html .='
                                                                <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                    <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                        <div class="card-img">
                                                                            <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                        </div>
                                                                        <div class="card-title">
                                                                            <h4>'.$titre.'</h4>
                                                                        </div>';
                                                                        if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                            if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                                $html .='
                                                                                <div class="card-footer '.$footerclass.'">
                                                                                    <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                    </a>
                                                                                </div>
                                                                                <div class="card-footer '.$footerclass.'">
                                                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                        <i class="fa-solid fa-comment"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-heart"></i>
                                                                                    </a>
                                                                                    <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-edit"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-trash"></i>
                                                                                    </a>
                                                                                </div>';
                                                                            }
                                                                            else{
                                                                                $html .='
                                                                                <div class="card-footer '.$footerclass.' opacity"></div>
                                                                                <div class="card-footer '.$footerclass.'">
                                                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                        <i class="fa-solid fa-comment"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-heart"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                    </a>
                                                                                </div>';
                                                                            }       
                                                                        }
                                                                        else{
                                                                            $html .='<div class="card-footer '.$footerclass.'">
                                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                    <i class="fa-solid fa-comment"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-heart"></i>
                                                                                </a>';  

                                                                                if($this->isTuteurConnet()){
                                                                                    $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                                }                                                                 
                                                                                $html .= '
                                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                </a>
                                                                            </div>';
                                                                        }
                                                                    $html='</div>
                                                                </div>
                                                            ';               
                                                        }
                                                        else{
                                                            if (strpos($link_support, $redir) === false) { 
                                                                if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                                    $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                                    
                                                                    $html .='
                                                                    <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                        <div class="card sequ1" value="'.$nbrSeq.'">
                                                                            <div class="card-img">
                                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                            </div>
                                                                            <div class="card-title">
                                                                                <h4>'.$titre.'</h4>
                                                                            </div>';
                                                                            if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                                if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                                    $html .='
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>
                                                                                        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                                <i class="fa-solid fa-edit"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-trash"></i>
                                                                                        </a>
                                                                                    </div>';
                                                                                }
                                                                                else{
                                                                                    $html .='
                                                                                    <div class="card-footer '.$footerclass.' opacity"></div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>';
                                                                                }       
                                                                            }
                                                                            else{
                                                                                $html .='<div class="card-footer '.$footerclass.'">
                                                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                        <i class="fa-solid fa-comment"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-heart"></i>
                                                                                    </a>';  

                                                                                    if($this->isTuteurConnet()){
                                                                                        $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                                    }                                                                 
                                                                                    $html .= '
                                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                    </a>
                                                                                </div>';
                                                                            }
                                                                        $html='</div>
                                                                    </div>
                                                                    ';  


                                                                }
                                                                else{
                                                                    $suffixe = '';
                                                                    if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                        $suffixe  = 'https://';
                                                                    }
                                                                    elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                        $suffixe  = 'http://';
                                                                    }
                                                                    else{
                                                                        $suffixe  = '';
                                                                    }
                                                                    $urlF  .= $suffixe.$link_support;
                                                                    $html .='
                                                                    <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                        <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                            <div class="card-img">
                                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                            </div>
                                                                            <div class="card-title">
                                                                                <h4>'.$titre.'</h4>
                                                                            </div>';
                                                                            if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                                if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                                    $html .='
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>
                                                                                        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                                <i class="fa-solid fa-edit"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-trash"></i>
                                                                                        </a>
                                                                                    </div>';
                                                                                }
                                                                                else{
                                                                                    $html .='
                                                                                    <div class="card-footer '.$footerclass.' opacity"></div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>';
                                                                                }       
                                                                            }
                                                                            else{
                                                                                $html .='<div class="card-footer '.$footerclass.'">
                                                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                        <i class="fa-solid fa-comment"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-heart"></i>
                                                                                    </a>';  

                                                                                    if($this->isTuteurConnet()){
                                                                                        $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                                    }                                                                 
                                                                                    $html .= '
                                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                    </a>
                                                                                </div>';
                                                                            }
                                                                        $html='</div>
                                                                    </div>
                                                                    ';  
                                                                }
                                                            }                 
                                                            else { 
                                                                $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                                $suffixe = '';
                                                                if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                                    $suffixe  = 'https://';
                                                                }
                                                                elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                                    $suffixe  = 'http://';
                                                                }
                                                                else{
                                                                    $suffixe  = '';
                                                                }

                                                                $urlF  .= $suffixe.$urlF1; 
                                                                $html .='
                                                                    <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                        <div class="card" value="'.$nbrSeq.'" >
                                                                            <div class="card-img">
                                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                            </div>
                                                                            <div class="card-title">
                                                                                <h4>'.$titre.'</h4>
                                                                            </div>';
                                                                            if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                                if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                                    $html .='
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>
                                                                                        <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                                <i class="fa-solid fa-edit"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-trash"></i>
                                                                                        </a>
                                                                                    </div>';
                                                                                }
                                                                                else{
                                                                                    $html .='
                                                                                    <div class="card-footer '.$footerclass.' opacity"></div>
                                                                                    <div class="card-footer '.$footerclass.'">
                                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                            <i class="fa-solid fa-comment"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                            <i class="fa-solid fa-heart"></i>
                                                                                        </a>
                                                                                        <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                        </a>
                                                                                    </div>';
                                                                                }       
                                                                            }
                                                                            else{
                                                                                $html .='<div class="card-footer '.$footerclass.'">
                                                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                        <i class="fa-solid fa-comment"></i>
                                                                                    </a>
                                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-heart"></i>
                                                                                    </a>';  

                                                                                    if($this->isTuteurConnet()){
                                                                                        $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                                    }                                                                 
                                                                                    $html .= '
                                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                    </a>
                                                                                </div>';
                                                                            }
                                                                        $html='</div>
                                                                    </div>
                                                                ';               
                                                            } 
                                                        }
                                                    }
                                                    $nbrSeq= $nbrSeq + 1;
                                                        
                                                }                        
                                            }
                                            
                                            if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
                                                $html .= '
                                                    <div class="row empty-data-row">
                                                        <div class="col-md-12 text-center">
                                                            <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
                                                        </div>
                                                    </div>';
                                            }
                                        $html .= '</div>';
                                    $html .= '</div>';
                                $container++; }  }
                            }
                        $html .= '</div>';
                    }
                    else{
                        $html.='
                        <div class="row empty-data-row">
                            <div class="col-md-12 text-center">
                                <h4 class="nothing-data text-center">'.$this->lang->line('course_history_not_found_data').'</h4>
                            </div>
                        </div>';
                    }
                }
            $html .= '</div>';
        }
        else {
            $moduleContent = isset($_POST['moduleId']) ? $this->sequence_model->getPavetSequenceHauts($_POST['moduleName'],$_POST['groupeId'],$_POST['moduleId'],$_POST['pave']) : NULL;
            
            $html .= '<div class="tab-wrap">';
                $html .= '<div class="tab-nav-container mb-2">';
                    $html .= '<div class="tab-nav responsive" id="'.$containerSluky .'">';
                        foreach($moduleContent['module'] as $key4=>$value4){
                            if(is_array($value4)){ $sequenceName = ''; foreach($value4 as $key5=>$value5){if($value5['sequence_name'] != "") { $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name']; $sequenceUrl = $value5['sequence_url']; $idsequence = $value5['sequence_id']; $locsequence  = $value5['locs']; if($seq == 0) { $activeMenu .= 'active'; }
                                    $html .= '<div class="tab-nav-item navigation-course-history '.$activeMenu.'" data-id="content-sequence'.$idsequence.'" data-id-sequence="'.$this->convert_utf8($idsequence).'" data-id-module="'.$this->convert_utf8($_POST['moduleId']).'" data-id-pave="'.$_POST['pave'].'" 
                                        data-name="'.$this->convert_utf8($sequenceName).'">
                                            <div class="tab-nav-item-head">
                                                <span>'.$sequenceName.'</span>
                                            </div>
                                            <div class="course-color"></div>
                                            <div class="tab-nav-item-footer">
                                                <button data-title="'.$this->convert_utf8($sequenceName).'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);"><i class="fa-solid fa-heart"></i></button>
                                                <button data-title="'.$this->convert_utf8($sequenceName).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="fa-solid fa-comment"></i></button>';
                                                if ($this->isTuteurConnet() && $PAVE == 7) {
                                                    if ($this->session->userdata ('GUSERID') == $value5['user_create']) {
                                                        $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-trash" onclick="deleteListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-trash-alt"></i></button>';
                                                        $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-edit" onclick="editListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-edit-alt"></i></button>';
                                                    }
                                                    $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-add" onclick="addContentInListSequence(this);" data-module="'.$_POST['moduleId'].'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bx-plus"></i></button>';
                                                }
                                            $html .='</div>
                                        </div>';

                                    }
                                }
                            $seq++; }
                        }
                    $html .= '</div>';
                $html .= '</div>';
                $html .= '<div class="tab-content-container">';                    
                    foreach($moduleContent['module'] as $key4=>$value4){
                        if(is_array($value4)){ foreach($value4 as $key5=>$value5){ if($value5['sequence_name'] != "") {  if ( $container === 0 ) { $activeContent .= 'active'; 
                            $chapitre = $this->chapitres_model->readTraineeSequences($value5['sequence_id'],$this->session->userdata ('GUSERID'),$_POST['groupeId']);
                            $html .= '<div id="content-sequence'.$value5['sequence_id'].'"  class="tab-content '.$activeContent.'">';
                                
                                $html.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your activities (content of '.$this->sequence_model->Request('sequence_titre',$value5['sequence_id']).')</h2></div>';
                                $html .= '<div class="card-container">';
                                    if (isset($chapitre['cnt'])) {
                                        // colonne lien
                                        $lienCol= $lienCol + 1;
                                        for($i=0;$i<$chapitre['cnt'];$i++) {                                    
                                            $user_create    = $chapitre[$i]['user_create']     ;
                                            $type           = $chapitre[$i]['type']     ;
                                            $titre          = $chapitre[$i]['titre']    ;
                                            $numero         = $chapitre[$i]['numero']   ;
                                            $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                                            $linkUrl        = $chapitre[$i]['lienUrl']  ;
                                            $id_sequence    = $chapitre[$i]['id_sequence']  ;
                                            $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                                            $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                                            $status_url     = $chapitre[$i]['status_url']  ;

                                            
                                            $link_support = $linkUrl;
                                            $redir        = 'redir.php?url';
                                            $support      = '';
                                            $urlF         = "";
                                            if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                                                $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                                                $html .= "";                
                                            }
                                            else{
                                                $fileimg = base_url()."groupes/bg-laptop.png";
                                                //$html .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                                            }

                                            if ($titre != 'Support') {
                                                if ($this->validate_url($link_support)){
                                                    $suffixe = '';
                                                    if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                        $suffixe  = 'https://';
                                                    }
                                                    elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                        $suffixe  = 'http://';
                                                    }
                                                    else{
                                                        $suffixe  = '';
                                                    }
                                                    $urlF  .= $suffixe.$link_support;
                                                    $html .='
                                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                            <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                <div class="card-img">
                                                                    <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                </div>
                                                                <div class="card-title">
                                                                    <h4>'.$titre.'</h4>
                                                                </div>';
                                                                if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                    if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                        $html .='
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>
                                                                            <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-edit"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-trash"></i>
                                                                            </a>
                                                                        </div>';
                                                                    }
                                                                    else{
                                                                        $html .='
                                                                        <div class="card-footer '.$footerclass.' opacity"></div>
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>';
                                                                    }       
                                                                }
                                                                else{
                                                                    $html .='<div class="card-footer '.$footerclass.'">
                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                            <i class="fa-solid fa-comment"></i>
                                                                        </a>
                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                            <i class="fa-solid fa-heart"></i>
                                                                        </a>';  

                                                                        if($this->isTuteurConnet()){
                                                                            $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                        }                                                                 
                                                                        $html .= '
                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                        </a>
                                                                    </div>';
                                                                }
                                                            $html .='</div>
                                                        </div>
                                                    ';               
                                                }
                                                else{
                                                    if (strpos($link_support, $redir) === false) { 
                                                        if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                            $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                            
                                                            $html .='
                                                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                <div class="card sequ1" value="'.$nbrSeq.'">
                                                                    <div class="card-img">
                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                    </div>
                                                                    <div class="card-title">
                                                                        <h4>'.$titre.'</h4>
                                                                    </div>';
                                                                    if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                        if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                            $html .='
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                </a>
                                                                            </div>
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                    <i class="fa-solid fa-comment"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-heart"></i>
                                                                                </a>
                                                                                <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-edit"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-trash"></i>
                                                                                </a>
                                                                            </div>';
                                                                        }
                                                                        else{
                                                                            $html .='
                                                                            <div class="card-footer '.$footerclass.' opacity"></div>
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                    <i class="fa-solid fa-comment"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-heart"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                </a>
                                                                            </div>';
                                                                        }       
                                                                    }
                                                                    else{
                                                                        $html .='<div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>';  

                                                                            if($this->isTuteurConnet()){
                                                                                $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                            }                                                                 
                                                                            $html .= '
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>';
                                                                    }
                                                                $html .='</div>
                                                            </div>
                                                            ';  


                                                        }
                                                        else{
                                                            $suffixe = '';
                                                            if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                $suffixe  = 'https://';
                                                            }
                                                            elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                $suffixe  = 'http://';
                                                            }
                                                            else{
                                                                $suffixe  = '';
                                                            }
                                                            $urlF  .= $suffixe.$link_support;
                                                            $html .='
                                                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                    <div class="card-img">
                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                    </div>
                                                                    <div class="card-title">
                                                                        <h4>'.$titre.'</h4>
                                                                    </div>';
                                                                    if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                        if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                            $html .='
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                </a>
                                                                            </div>
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                    <i class="fa-solid fa-comment"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-heart"></i>
                                                                                </a>
                                                                                <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-edit"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-trash"></i>
                                                                                </a>
                                                                            </div>';
                                                                        }
                                                                        else{
                                                                            $html .='
                                                                            <div class="card-footer '.$footerclass.' opacity"></div>
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                    <i class="fa-solid fa-comment"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-heart"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                </a>
                                                                            </div>';
                                                                        }       
                                                                    }
                                                                    else{
                                                                        $html .='<div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>';  

                                                                            if($this->isTuteurConnet()){
                                                                                $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                            }                                                                 
                                                                            $html .= '
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>';
                                                                    }
                                                                $html .='</div>
                                                            </div>
                                                            ';  
                                                        }
                                                    }                 
                                                    else { 
                                                        $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                        $suffixe = '';
                                                        if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                            $suffixe  = 'https://';
                                                        }
                                                        elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                            $suffixe  = 'http://';
                                                        }
                                                        else{
                                                            $suffixe  = '';
                                                        }

                                                        $urlF  .= $suffixe.$urlF1; 
                                                        $html .='
                                                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                <div class="card" value="'.$nbrSeq.'" >
                                                                    <div class="card-img">
                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                    </div>
                                                                    <div class="card-title">
                                                                        <h4>'.$titre.'</h4>
                                                                    </div>';
                                                                    if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                        if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                            $html .='
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                </a>
                                                                            </div>
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                    <i class="fa-solid fa-comment"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-heart"></i>
                                                                                </a>
                                                                                <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                        <i class="fa-solid fa-edit"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-trash"></i>
                                                                                </a>
                                                                            </div>';
                                                                        }
                                                                        else{
                                                                            $html .='
                                                                            <div class="card-footer '.$footerclass.' opacity"></div>
                                                                            <div class="card-footer '.$footerclass.'">
                                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                    <i class="fa-solid fa-comment"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-heart"></i>
                                                                                </a>
                                                                                <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                                </a>
                                                                            </div>';
                                                                        }       
                                                                    }
                                                                    else{
                                                                        $html .='<div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>';  

                                                                            if($this->isTuteurConnet()){
                                                                                $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                            }                                                                 
                                                                            $html .= '
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>';
                                                                    }
                                                                $html .='</div>
                                                            </div>
                                                        ';               
                                                    } 
                                                }
                                            }
                                            $nbrSeq= $nbrSeq + 1;
                                                
                                        }                        
                                    }
                                    
                                    if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
                                        $html .= '
                                            <div class="row empty-data-row">
                                                <div class="col-md-12 text-center">
                                                    <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
                                                </div>
                                            </div>';
                                    }
                                $html .= '</div>';
                            $html .= '</div>';
                        } } $container++; }  }
                    }
                $html .= '</div>';
            $html .= '</div>';
        }

        $retour['html'] = $html;
        $retour['containerSluky'] = $containerSluky;
        echo json_encode($retour);
    }*/
    public function getModuleContent(){
        $retour = array();
        $html = '';
        $seq = 0;
        $seqC = 0;
        $container = 0;
        $imgthumbnail = '';
        $class = '';
        $activeMenu = '';
        $activeContent = '';
        $lienCol= 1;
        $nbrSeq= 1;
        $footerclass = '';
        $PAVE = isset($_POST['pave']) ? $_POST['pave'] : NULL;
        $paves_sequence_nom = (isset($_POST['pave']) && $_POST['pave'] == 6) ? $this->lang->line('educational_library_pedagogical_training') : $this->lang->line('educational_library_personnal_interest');
        $moduleNameActivity = isset($_POST['moduleName']) ? $_POST['moduleName'] : '';
        //$containerSluky = 'tab-sequence-library'.time();
        $containerSluky = 'tab-sequence-library';
        $this->loadTrackingEl(0,0,$this->tracking_type,isset($_POST['moduleId']) ? $_POST['moduleId'] : '');



        $dataLastActivity = array(
            'last_activity' => $paves_sequence_nom.' -> '.$moduleNameActivity
        );
        $this->updateLastActivity($dataLastActivity);

        if ($this->isTuteurConnet()) {
            $footerclass = 'card-footer-trainner';
        }

        if (isset($_POST['indice']) && $_POST['indice'] == 'complementary') {
            $groupId = $_POST['groupeId'];
            $ret_complementary_activities=$this->sequence_model->getPavetComplementary($groupId); 
            $array_newsletter = $this->sequence_model->getPavetHaut($groupId,4);
            $array_ped_training = $this->sequence_model->getPavetHaut($groupId,6);
            $array_pers_ling = $this->sequence_model->getPavetHaut($groupId,7);
            $array_ling_tools = $this->sequence_model->getPavetHaut($groupId,8);

            $arrayListeModule = array();
            $array_id_module_newsletter = array();
            $array_id_module_ped_training = array();
            $array_id_module_pers_ling = array();
            $array_id_module_ling_tools = array();   

            if(!empty($array_newsletter)){
                if (is_array($array_newsletter['module'])) {
                    foreach($array_newsletter['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_newsletter[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ped_training)){
                if (is_array($array_ped_training['module'])) {
                    foreach($array_ped_training['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ped_training[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_pers_ling)){
                if (is_array($array_pers_ling['module'])) {
                    foreach($array_pers_ling['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_pers_ling[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($array_ling_tools)){
                if (is_array($array_ling_tools['module'])) {
                    foreach($array_ling_tools['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ling_tools[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($ret_complementary_activities)){
                if (is_array($ret_complementary_activities['module'])) {
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        $arrayListeModule[] = $value['module_id'];
                    }
                }
            }

            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;            
            $html .= '<div class="tab-wrap">';
                if(!empty($ret_complementary_activities)){
                    if(is_array($ret_complementary_activities['module']) && $_POST['pave']=='6'){
                        $html .= '<div class="tab-nav-container mb-2">';
                            $html .= '<div class="tab-nav responsive" id="tab-sequence-library">';
                                foreach($ret_complementary_activities['module'] as $key=>$value){ if (in_array($value['module_id'], $arrayListeModule)) {
                                    $html .= '
                                        <div class="tab-nav-item navigation-course-history '.($seqC == 0 ? 'active' : '').'" data-id="content-sequence'.$value['sequence_id'].'" data-id-sequence="'.$this->convert_utf8($value['sequence_id']).'" data-id-module="'.$this->convert_utf8($_POST['moduleId']).'" data-id-pave="'.$_POST['pave'].'" 
                                                data-name="'.$this->convert_utf8($value['sequence_name']).'">
                                            <div class="tab-nav-item-head">
                                                <span>'.$this->convert_utf8($value['sequence_name']).'</span>
                                            </div>
                                            <div class="course-color"></div>
                                            <div class="tab-nav-item-footer">
                                                <button data-title="'.$this->convert_utf8($value['sequence_name']).'" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);"><i class="fa-solid fa-heart"></i></button>
                                                <button data-title="'.$this->convert_utf8($value['sequence_name']).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$value['sequence_id'].'" data-code="'.$value['code'].'"><i class="fa-solid fa-comment"></i></button>
                                            </div>
                                        </div>';

                                $seqC++; }  }
                            $html .= '</div>';
                        $html .= '</div>';
                        $html .= '<div class="tab-content-container">';                    
                            foreach($ret_complementary_activities['module'] as $key=>$value){ if (in_array($value['module_id'], $arrayListeModule)) { if ( $container === 0 ) { $activeContent .= 'active'; 
                                    $chapitre = $this->chapitres_model->readTraineeSequences($value['sequence_id'],$this->session->userdata ('GUSERID'),$_POST['groupeId']);
                                    $html .= '<div id="content-sequence'.$value['sequence_id'].'"  class="tab-content '.$activeContent.'">';
                                        
                                        $html.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your sequences (content of Complementary Activities)</h2></div>';
                                        $html .= '<div class="card-container">';
                                            if (isset($chapitre['cnt'])) {
                                                // colonne lien
                                                $lienCol= $lienCol + 1;
                                                for($i=0;$i<$chapitre['cnt'];$i++) {                                    
                                                    $user_create    = $chapitre[$i]['user_create']     ;
                                                    $type           = $chapitre[$i]['type']     ;
                                                    $titre          = $chapitre[$i]['titre']    ;
                                                    $numero         = $chapitre[$i]['numero']   ;
                                                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                                                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
                                                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
                                                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                                                    if ($type == 4 && $user_create != null) {
                                                        $final_url      = HTTP_FORMATION.'activitySequence/'.$chapitre[$i]['lienUrl']  ;
                                                    }
                                                    else{
                                                        $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                                                    }
                                                    $status_url     = $chapitre[$i]['status_url']  ;

                                                    
                                                    $link_support = $linkUrl;
                                                    $redir        = 'redir.php?url';
                                                    $support      = '';
                                                    $urlF         = "";
                                                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                                                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                                                        $html .= "";                
                                                    }
                                                    else{
                                                        $fileimg = base_url()."groupes/bg-laptop.png";
                                                        //$html .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                                                    }

                                                    if ($titre != 'Support') {
                                                        if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                            $urlF  = 'https://'.$link_support; 
                                                        }
                                                        elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                            $urlF  = 'http://'.$link_support;
                                                        }
                                                        elseif (strpos($link_support, $redir) === false) {
                                                            if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                                $urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                            }
                                                            else { 
                                                                $urlF = $link_support;
                                                            }
                                                        }
                                                        else{
                                                            $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                            if ((strpos($urlF1, '.doc') !== false) || (strpos($urlF1, '.docx') !== false) || (strpos($urlF1, '.ppt') !== false) || (strpos($urlF1, '.pdf') !== false)){
                                                                $urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$urlF1."&amp;embedded=true";
                                                            }
                                                            else {                                                      
                                                                if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                                    $urlF = 'https://'.$urlF1;
                                                                }
                                                                elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                                    $urlF = 'http://'.$urlF1;
                                                                }
                                                                else{
                                                                    $urlF = $urlF1;
                                                                }
                                                            }
                                                        }

                                                        $html .='
                                                        <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                            <div class="card" value="'.$nbrSeq.'" >
                                                                <div class="card-img">
                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'"><img src="'.$fileimg.'" alt=""></a>
                                                                </div>
                                                                <div class="card-title">
                                                                    <h4>'.$titre.'</h4>
                                                                </div>';
                                                                if ($this->isTuteurConnet() && $PAVE == 7) {
                                                                    if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                        $html .='
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>
                                                                            <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                    <i class="fa-solid fa-edit"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-trash"></i>
                                                                            </a>
                                                                        </div>';
                                                                    }
                                                                    else{
                                                                        $html .='
                                                                        <div class="card-footer '.$footerclass.' opacity"></div>
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>';
                                                                    }       
                                                                }
                                                                else{
                                                                    $html .='<div class="card-footer '.$footerclass.'">
                                                                        <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                            <i class="fa-solid fa-comment"></i>
                                                                        </a>
                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                            <i class="fa-solid fa-heart"></i>
                                                                        </a>';  

                                                                        if($this->isTuteurConnet()){
                                                                            $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                        }                                                                 
                                                                        $html .= '
                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                        </a>
                                                                    </div>';
                                                                }
                                                            $html .='</div>
                                                        </div>';
                                                    }
                                                    $nbrSeq= $nbrSeq + 1;
                                                        
                                                }                        
                                            }
                                            
                                            if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
                                                $html .= '
                                                    <div class="row empty-data-row">
                                                        <div class="col-md-12 text-center">
                                                            <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
                                                        </div>
                                                    </div>';
                                            }
                                        $html .= '</div>';
                                    $html .= '</div>';
                                $container++; }  }
                            }
                        $html .= '</div>';
                    }
                    else{
                        $html.='
                        <div class="row empty-data-row">
                            <div class="col-md-12 text-center">
                                <h4 class="nothing-data text-center">'.$this->lang->line('course_history_not_found_data').'</h4>
                            </div>
                        </div>';
                    }
                }
            $html .= '</div>';
        }
        else {
            $moduleContent = isset($_POST['moduleId']) ? $this->sequence_model->getPavetSequenceHauts($_POST['moduleName'],$_POST['groupeId'],$_POST['moduleId'],$_POST['pave']) : NULL;
            
            $html .= '<div class="tab-wrap">';
                $html .= '<div class="tab-nav-container mb-2">';
                    $html .= '<div class="tab-nav responsive" id="'.$containerSluky .'">';
                        foreach($moduleContent['module'] as $key4=>$value4){
                            if(is_array($value4)){ $sequenceName = ''; foreach($value4 as $key5=>$value5){if($value5['sequence_name'] != "") { $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name']; $sequenceUrl = $value5['sequence_url']; $idsequence = $value5['sequence_id']; $locsequence  = $value5['locs']; if($seq == 0) { $activeMenu .= 'active'; }
                                    $html .= '<div class="tab-nav-item navigation-course-history '.$activeMenu.'" data-id="content-sequence'.$idsequence.'" data-id-sequence="'.$this->convert_utf8($idsequence).'" data-id-module="'.$this->convert_utf8($_POST['moduleId']).'" data-id-pave="'.$_POST['pave'].'" 
                                        data-name="'.$this->convert_utf8($sequenceName).'">
                                            <div class="tab-nav-item-head">
                                                <span>'.$sequenceName.'</span>
                                            </div>
                                            <div class="course-color"></div>
                                            <div class="tab-nav-item-footer">
                                                <button data-title="'.$this->convert_utf8($sequenceName).'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);"><i class="fa-solid fa-heart"></i></button>
                                                <button data-title="'.$this->convert_utf8($sequenceName).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="fa-solid fa-comment"></i></button>';
                                                if ($this->isTuteurConnet() && $PAVE == 7) {
                                                    if ($this->session->userdata ('GUSERID') == $value5['user_create']) {
                                                        $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-trash" onclick="deleteListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-trash-alt"></i></button>';
                                                        $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" data-sequence-objectif="'.$this->convert_utf8($value5['sequence_objectifs']).'" data-id-module="'.$this->convert_utf8($_POST['moduleId']).'" class="btn-edit" onclick="editListSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bxs-edit-alt"></i></button>';
                                                    }
                                                    $html .= '<button data-title="'.$this->convert_utf8($sequenceName).'" class="btn-add" onclick="addContentInListSequence(this);" data-module="'.$_POST['moduleId'].'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'"><i class="bx bx-plus"></i></button>';
                                                }
                                            $html .='</div>
                                        </div>';

                                    }
                                }
                            $seq++; }
                        }
                    $html .= '</div>';
                $html .= '</div>';
                $html .= '<div class="tab-content-container">';                    
                    foreach($moduleContent['module'] as $key4=>$value4){
                        if(is_array($value4)){ foreach($value4 as $key5=>$value5){ if($value5['sequence_name'] != "") {  if ( $container === 0 ) { $activeContent .= 'active'; 
                            $chapitre = $this->chapitres_model->readTraineeSequences($value5['sequence_id'],$this->session->userdata ('GUSERID'),$_POST['groupeId']);
                            $html .= '<div id="content-sequence'.$value5['sequence_id'].'"  class="tab-content '.$activeContent.'">';
                                
                                $html.= '<div class="tab-title title-active-menu-pg"><h2 class="content_title">Your activities (content of '.$this->sequence_model->Request('sequence_titre',$value5['sequence_id']).')</h2></div>';
                                $html .= '<div class="card-container">';
                                    if (isset($chapitre['cnt'])) {
                                        // colonne lien
                                        $lienCol= $lienCol + 1;
                                        for($i=0;$i<$chapitre['cnt'];$i++) {                                    
                                            $user_create    = $chapitre[$i]['user_create']     ;
                                            $type           = $chapitre[$i]['type']     ;
                                            $titre          = $chapitre[$i]['titre']    ;
                                            $numero         = $chapitre[$i]['numero']   ;
                                            $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                                            $linkUrl        = $chapitre[$i]['lienUrl']  ;
                                            $id_sequence    = $chapitre[$i]['id_sequence']  ;
                                            $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                                            if ($type == 4 && $user_create != null) {
                                                $final_url      = HTTP_FORMATION.'activitySequence/'.$chapitre[$i]['lienUrl']  ;
                                            }
                                            else{
                                                $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                                            }
                                            $status_url     = $chapitre[$i]['status_url']  ;

                                            
                                            $link_support = $linkUrl;
                                            $redir        = 'redir.php?url';
                                            $support      = '';
                                            $urlF         = "";
                                            if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                                                $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                                                $html .= "";                
                                            }
                                            else{
                                                $fileimg = base_url()."groupes/bg-laptop.png";
                                                //$html .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                                            }

                                            if ($titre != 'Support') {
                                                if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                    $urlF  = 'https://'.$link_support; 
                                                }
                                                elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                    $urlF  = 'http://'.$link_support;
                                                }
                                                elseif (strpos($link_support, $redir) === false) {
                                                    if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                        $urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                    }
                                                    else { 
                                                        $urlF = $link_support;
                                                    }
                                                }
                                                else{
                                                    $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                    if ((strpos($urlF1, '.doc') !== false) || (strpos($urlF1, '.docx') !== false) || (strpos($urlF1, '.ppt') !== false) || (strpos($urlF1, '.pdf') !== false)){
                                                        $urlF = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$urlF1."&amp;embedded=true";
                                                    }
                                                    else {                                                      
                                                        if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                            $urlF = 'https://'.$urlF1;
                                                        }
                                                        elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                            $urlF = 'http://'.$urlF1;
                                                        }
                                                        else{
                                                            $urlF = $urlF1;
                                                        }
                                                    }
                                                }

                                                $html .='
                                                <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                    <div class="card" value="'.$nbrSeq.'" >
                                                        <div class="card-img">
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" ><img src="'.$fileimg.'" alt=""></a>
                                                        </div>
                                                        <div class="card-title">
                                                            <h4>'.$titre.'</h4>
                                                        </div>';
                                                        if ($this->isTuteurConnet() && $PAVE == 7) {
                                                            if ($user_create == $this->session->userdata ('GUSERID')) {
                                                                $html .='
                                                                <div class="card-footer '.$footerclass.'">
                                                                    <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                    </a>
                                                                </div>
                                                                <div class="card-footer '.$footerclass.'">
                                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                        <i class="fa-solid fa-comment"></i>
                                                                    </a>
                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                        <i class="fa-solid fa-heart"></i>
                                                                    </a>
                                                                    <a data-type="'.$type.'" data-link="'.$urlF.'" data-title="'.$titre.'" onclick="editContentListSequence(this,'.$id_sequence.','.$numero.');" class="btn-edit" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                            <i class="fa-solid fa-edit"></i>
                                                                    </a>
                                                                    <a data-title="'.$titre.'" onclick="deleteContentListSequence(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                        <i class="fa-solid fa-trash"></i>
                                                                    </a>
                                                                </div>';
                                                            }
                                                            else{
                                                                $html .='
                                                                <div class="card-footer '.$footerclass.' opacity"></div>
                                                                <div class="card-footer '.$footerclass.'">
                                                                    <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                        <i class="fa-solid fa-comment"></i>
                                                                    </a>
                                                                    <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                        <i class="fa-solid fa-heart"></i>
                                                                    </a>
                                                                    <a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>
                                                                    <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                        '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                    </a>
                                                                </div>';
                                                            }       
                                                        }
                                                        else{
                                                            $html .='<div class="card-footer '.$footerclass.'">
                                                                <a class="add-comment" title="'.$this->lang->line('course_history_placeholder_comment').'" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                    <i class="fa-solid fa-comment"></i>
                                                                </a>
                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="'.$this->lang->line('trainee_area_infos_modal_label_add').'">
                                                                    <i class="fa-solid fa-heart"></i>
                                                                </a>';  

                                                                if($this->isTuteurConnet()){
                                                                    $html .= '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="'.$this->lang->line('my_link_and_document_add_to_course_history').'"><i class="fa-solid fa-clock-rotate-left"></i></a>';
                                                                }                                                                 
                                                                $html .= '
                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="'.$this->lang->line('course_history_placeholder_article').'">
                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                </a>
                                                            </div>';
                                                        }
                                                    $html .='</div>
                                                </div>';
                                            }
                                            $nbrSeq= $nbrSeq + 1;
                                                
                                        }                        
                                    }
                                    
                                    if (isset($chapitre['cnt']) && $chapitre['cnt'] < 1){
                                        $html .= '
                                            <div class="row empty-data-row">
                                                <div class="col-md-12 text-center">
                                                    <h4 class="nothing-data text-center">'.$this->lang->line('my_link_and_document_datatable_empty_data').'</h4>
                                                </div>
                                            </div>';
                                    }
                                $html .= '</div>';
                            $html .= '</div>';
                        } } $container++; }  }
                    }
                $html .= '</div>';
            $html .= '</div>';
        }

        $retour['html'] = $html;
        $retour['containerSluky'] = $containerSluky;
        echo json_encode($retour);
    }

    public function searchDataLib(){
        $retour = array();
        $tabContentHtml = '';
        $seq = 0;
        $seqC = 0;
        $container = 0;
        $imgthumbnail = '';
        $class = '';
        $activeMenu = '';
        $activeContent = '';
        $lienCol= 1;
        $nbrSeq= 1;
        $footerclass = '';
        $idGroupe = '';
        if ($this->isTuteurConnet()) {
            $footerclass = 'card-footer-trainner';
            $idGroupe = $this->session->userdata ('STAGIAIREGRP');
        }
        else{
            $idGroupe = $this->session->userdata ('GROUPE');
        }
        $PAVE = isset($_POST['dataForm']['pave_sequence']) ? $_POST['dataForm']['pave_sequence'] : '';
        $ret_complementary_activities=$this->sequence_model->getPavetComplementary($idGroupe);  
        $ret_newsletter2 = $this->sequence_model->getPavetSequenceHaut($idGroupe, $this->session->userdata ('GUSERID'),$PAVE);

        $array_newsletter = $this->sequence_model->getPavetHaut($idGroupe,4);
        $array_ped_training = $this->sequence_model->getPavetHaut($idGroupe,6);
        $array_pers_ling = $this->sequence_model->getPavetHaut($idGroupe,7);
        $array_ling_tools = $this->sequence_model->getPavetHaut($idGroupe,8);

        $arrayListeModule = array();
        $array_id_module_newsletter = array();
        $array_id_module_ped_training = array();
        $array_id_module_pers_ling = array();
        $array_id_module_ling_tools = array();   

        if(!empty($array_newsletter)){
            if (is_array($array_newsletter['module'])) {
                foreach($array_newsletter['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_newsletter[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ped_training)){
            if (is_array($array_ped_training['module'])) {
                foreach($array_ped_training['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ped_training[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_pers_ling)){
            if (is_array($array_pers_ling['module'])) {
                foreach($array_pers_ling['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_pers_ling[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($array_ling_tools)){
            if (is_array($array_ling_tools['module'])) {
                foreach($array_ling_tools['module'] as $key=>$value){
                    foreach($value as $key2=>$value2){
                        $arrayListeModule[] = $value2['module_id'];
                        $array_id_module_ling_tools[] = $value2['module_id'];
                    }
                }
            }
        }
        if(!empty($ret_complementary_activities)){
            if (is_array($ret_complementary_activities['module'])) {
                foreach($ret_complementary_activities['module'] as $key=>$value){
                    $arrayListeModule[] = $value['module_id'];
                }
            }
        }

        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_newsletter) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;
        $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ling_tools) ;     
        $nbrBtn= 1;
        $active = '';
        $active = $nbrBtn == 1 ? 'active' : '';
        $tabContentHtml.= '<div class="card-container">';
        if (isset($_POST['dataForm']['dataType']) && $_POST['dataForm']['dataType'] == 'Sequences') {
            foreach($ret_newsletter2['module'] as $key2=>$value2){
                if(is_array($value2)){ 
                    
                    foreach($value2 as $key3=>$value3){
                        $ret_newsletter3=$this->sequence_model->getPavetSequenceHautsSearch($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE,$_POST['dataForm']['key-data-pdg']);
                        foreach($ret_newsletter3['module'] as $key4=>$value4){
                            if(is_array($value4)){
                                $sequenceName = '';
                                foreach($value4 as $key5=>$value5){
                                    if($value5['sequence_name'] != "") {
                                        $sequenceName = ($this->session->userdata ('site_lang') == 'english' && $value5['sequence_name'] == "Articles REBONDIR") ? "Anastasia Autret's Tips" : $value5['sequence_name'];
                                        $sequenceUrl   = $value5['sequence_url'];  
                                        $idsequence    = $value5['sequence_id'];   
                                        $locsequence    = $value5['locs'];   
                                        //Thumb
                                        $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($idsequence);
                                        if ($thumbnailSeq != '' && file_exists($thumbnailSeq)) {
                                            $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
                                        }
                                        else{

                                            $fileimg = base_url()."groupes/bg-laptop.png";
                                        }

                                        $tabContentHtml .='
                                            <div class="card-style-4 sequenceActivity">
                                                <div class="card">
                                                    <div class="card-img">
                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                    </div>
                                                    <div class="card-title">
                                                        <h4>'.$this->convert_utf8($sequenceName).'</h4>
                                                    </div>
                                                    <div class="card-footer '.$footerclass.'">
                                                        <a href="#" data-title="'.$this->convert_utf8($sequenceName).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" title="Add comment">
                                                            <i class="fa-solid fa-comment"></i>
                                                        </a>
                                                        <a data-title="'.$this->convert_utf8($sequenceName).'" data-id="'.$idsequence.'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);" title="Add favorite">
                                                            <i class="fa-solid fa-heart"></i>
                                                        </a>
                                                        <a href="#" class="btn-explore" onclick="getAllActivityBySequence(this);" data-pave="'.$PAVE.'" value="'.$nbrSeq.'" data-name="'.$sequenceName.'" data-ids="'.$idsequence.'">                
                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        ';
                                    }
                                }
                            }
                        }
                    }
                        
                }
            }   
 
            if(!empty($ret_complementary_activities)){
                if(is_array($ret_complementary_activities['module']) && $PAVE=='6'){
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        if (in_array($value['module_id'], $arrayListeModule) && strpos($value['sequence_name'], $_POST['dataForm']['key-data-pdg']) !== false) {
                            $thumbnailSeq = $this->sequence_model->getThumbFromLastSequence($value['sequence_id']);
                            if ($thumbnailSeq != '' && file_exists($thumbnailSeq)) {
                                $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnailSeq;
                            }
                            else{

                                $fileimg = base_url()."groupes/bg-laptop.png";
                            }
                            $tabContentHtml .= '
                            <div class="card-style-4 sequenceActivity">
                                <div class="card">
                                    <div class="card-img">
                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                    </div>
                                    <div class="card-title">
                                        <h4>'.$value['sequence_name'].'</h4>
                                    </div>
                                    <div class="card-footer card-footer-trainner">
                                        <a href="#" class="btn-see" onclick="getAllActivityBySequence(this);" tablinks" data-pave="'.$PAVE.'" value="'.$nbrSeq.'" data-name="'.$value['sequence_name'].'" data-ids="'.$value['sequence_id'].'">
                                            <i class="fa-solid fa-eye"></i>
                                        </a>
                                        <a href="#" data-title="'.$this->convert_utf8($value['sequence_name']).'" class="add-comment" onclick="addCommentSequence(this);" data-id="'.$value['sequence_id'].'" data-code="'.$value5['code'].'" title="Add comment">
                                            <i class="fa-solid fa-comment"></i>
                                        </a>
                                        <a data-title="'.$this->convert_utf8($value['sequence_name']).'" data-id="'.$value['sequence_id'].'" data-code="'.$value5['code'].'" class="add-favorite" onclick="addSequenceInFavorite(this);" title="Add favorite">
                                            <i class="fa-solid fa-heart"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>';
                        } 
                    } 
                } 
            }
        }
        else{
            foreach($ret_newsletter2['module'] as $key2=>$value2){
                if(is_array($value2)){ 
                    
                    foreach($value2 as $key3=>$value3){
                        $ret_newsletter3=$this->sequence_model->getPavetSequenceHauts($value3['MODULENAME'],$value3['idg'],$value3['module_id'],$PAVE);
                        foreach($ret_newsletter3['module'] as $key4=>$value4){
                            if(is_array($value4)){
                                $sequenceName = '';
                                foreach($value4 as $key5=>$value5){
                                    if($value5['sequence_name'] != "") {
                                        $chapitre = $this->chapitres_model->readTraineeSequencesSearch($value5['sequence_id'],$this->session->userdata ('GUSERID'),$value3['idg'],$_POST['dataForm']['key-data-pdg']);
                                        $imgthumbnail = '';
                                        $class = '';
                                        if (isset($chapitre['cnt'])) {
                                            // colonne lien

                                            $lienCol= $lienCol + 1;
                                            for($i=0;$i<$chapitre['cnt'];$i++) {
                                            
                                                $type           = $chapitre[$i]['type']     ;
                                                $titre          = $chapitre[$i]['titre']    ;
                                                $numero         = $chapitre[$i]['numero']   ;
                                                $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                                                $linkUrl        = $chapitre[$i]['lienUrl']  ;
                                                $id_sequence    = $chapitre[$i]['id_sequence']  ;
                                                $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                                                $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                                                $status_url     = $chapitre[$i]['status_url']  ;

                                                
                                                $link_support = $linkUrl;
                                                $redir        = 'redir.php?url';
                                                $support      = '';
                                                $urlF         = "";
                                                if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                                                    $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                                                    $codeHTML .= "";                
                                                }
                                                else{
                                                    $fileimg = base_url()."groupes/bg-laptop.png";
                                                    //$tabContentHtml .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                                                }

                                                if ($titre != 'Support') {
                                                    if ($this->validate_url($link_support)){
                                                        $suffixe = '';
                                                        if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                            $suffixe  = 'https://';
                                                        }
                                                        elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                            $suffixe  = 'http://';
                                                        }
                                                        else{
                                                            $suffixe  = '';
                                                        }
                                                        $urlF  .= $suffixe.$link_support;
                                                        $tabContentHtml .='
                                                            <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                    <div class="card-img">
                                                                        <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                    </div>
                                                                    <div class="card-title">
                                                                        <h4>'.$titre.'</h4>
                                                                    </div>
                                                                    <div class="card-footer '.$footerclass.'">
                                                                        <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                            <i class="fa-solid fa-comment"></i>
                                                                        </a>
                                                                        <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                            <i class="fa-solid fa-heart"></i>
                                                                        </a>';
                                                                         $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                        $tabContentHtml .= '
                                                                        <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                            '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        ';               
                                                    }
                                                    else{
                                                        if (strpos($link_support, $redir) === false) { 
                                                            if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                                $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                                
                                                                $tabContentHtml .='
                                                                <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                    <div class="card sequ1" value="'.$nbrSeq.'">
                                                                        <div class="card-img">
                                                                            <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                        </div>
                                                                        <div class="card-title">
                                                                            <h4>'.$titre.'</h4>
                                                                        </div>
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>';
                                                                            $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                            $tabContentHtml .= '
                                                                            <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlFormation.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlFormation.'" class="btn-explore" title="Access the article">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                ';  


                                                            }
                                                            else{
                                                                $suffixe = '';
                                                                if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                                    $suffixe  = 'https://';
                                                                }
                                                                elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                                    $suffixe  = 'http://';
                                                                }
                                                                else{
                                                                    $suffixe  = '';
                                                                }
                                                                $urlF  .= $suffixe.$link_support;
                                                                $tabContentHtml .='
                                                                <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                    <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                                        <div class="card-img">
                                                                            <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                        </div>
                                                                        <div class="card-title">
                                                                            <h4>'.$titre.'</h4>
                                                                        </div>
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>';
                                                                            $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                            $tabContentHtml .= '
                                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                ';  
                                                            }
                                                        }                 
                                                        else { 
                                                            $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                            $suffixe = '';
                                                            if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                                $suffixe  = 'https://';
                                                            }
                                                            elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                                $suffixe  = 'http://';
                                                            }
                                                            else{
                                                                $suffixe  = '';
                                                            }

                                                            $urlF  .= $suffixe.$urlF1; 
                                                            $tabContentHtml .='
                                                                <div class="card-style-4 sequenceActivity" data-sequence="'.$id_sequence.'" data-numero="'.$numero.'">
                                                                    <div class="card" value="'.$nbrSeq.'" >
                                                                        <div class="card-img">
                                                                            <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                                        </div>
                                                                        <div class="card-title">
                                                                            <h4>'.$titre.'</h4>
                                                                        </div>
                                                                        <div class="card-footer '.$footerclass.'">
                                                                            <a class="add-comment" title="Add comment" data-title="'.$titre.'" onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                                <i class="fa-solid fa-comment"></i>
                                                                            </a>
                                                                            <a  data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                                <i class="fa-solid fa-heart"></i>
                                                                            </a>';
                                                                            $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                            $tabContentHtml .= '
                                                                            <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlF.'"  onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            ';               
                                                        } 
                                                    }
                                                }
                                                $nbrSeq= $nbrSeq + 1;
                                                    
                                            }                        
                                        }
                                    }
                                }
                            }
                        }
                    }
                        
                }
            }   
  
            if(!empty($ret_complementary_activities)){
                if(is_array($ret_complementary_activities['module']) && $PAVE=='6'){
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        if (in_array($value['module_id'], $arrayListeModule)) {
                            $chapitre = $this->chapitres_model->readTraineeSequencesSearch($value['sequence_id'],$this->session->userdata ('GUSERID'),$idGroupe,$_POST['dataForm']['key-data-pdg']);
                            $imgthumbnail = '';
                            $class = '';
                            if (isset($chapitre['cnt'])) {
                                // colonne lien

                                $lienCol= $lienCol + 1;
                                for($i=0;$i<$chapitre['cnt'];$i++) {
                                
                                    $type           = $chapitre[$i]['type']     ;
                                    $titre          = $chapitre[$i]['titre']    ;
                                    $numero         = $chapitre[$i]['numero']   ;
                                    $thumbnail_file = $chapitre[$i]['thumbnail_file']   ;
                                    $linkUrl        = $chapitre[$i]['lienUrl']  ;
                                    $id_sequence    = $chapitre[$i]['id_sequence']  ;
                                    $detect_link    = $chapitre[$i]['ifrmaccess']  ;
                                    $final_url      = $chapitre[$i]['final_url'] == NULL ? $chapitre[$i]['lienUrl'] : $chapitre[$i]['final_url']  ;
                                    $status_url     = $chapitre[$i]['status_url']  ;

                                    
                                    $link_support = $linkUrl;
                                    $redir        = 'redir.php?url';
                                    $support      = '';
                                    $urlF         = "";
                                    if ($thumbnail_file !="" && is_file(REP_ACTIVITY_SEQUENCE.$thumbnail_file)) {
                                        $fileimg = HTTP_MAIN."groupes/ACTIVITES/".$thumbnail_file;
                                        $codeHTML .= "";                
                                    }
                                    else{
                                        $fileimg = base_url()."groupes/bg-laptop.png";
                                        //$tabContentHtml .= '<input type="hidden" class="link-scan-sequence" value="'.base_url().'scan-activity/'.$id_sequence.'/'.$numero.'">';
                                    }

                                    if ($titre != 'Support') {
                                        if ($this->validate_url($link_support)){
                                            $suffixe = '';
                                            if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                $suffixe  = 'https://';
                                            }
                                            elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                $suffixe  = 'http://';
                                            }
                                            else{
                                                $suffixe  = '';
                                            }
                                            $urlF  .= $suffixe.$link_support;
                                            $tabContentHtml .='
                                                <div class="card-style-1 sequenceActivity">
                                                    <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                        <div class="card-img">
                                                            <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                        </div>
                                                        <div class="card-title">
                                                            <h4>'.$titre.'</h4>
                                                        </div>
                                                        <div class="card-footer '.$footerclass.'">
                                                            <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                <i class="fa-solid fa-comment"></i>
                                                            </a>
                                                            <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                <i class="fa-solid fa-heart"></i>
                                                            </a>';
                                                             $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                            $tabContentHtml .= '
                                                            <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            ';               
                                        }
                                        else{
                                            if (strpos($link_support, $redir) === false) { 
                                                if ((strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                                                    $urlFormation = "https://docs.google.com/gview?url=".HTTP_FORMATIONS.$final_url."&amp;embedded=true";
                                                    
                                                    $tabContentHtml .='
                                                    <div class="card-style-1 sequenceActivity">
                                                        <div class="card sequ1" value="'.$nbrSeq.'">
                                                            <div class="card-img">
                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                            </div>
                                                            <div class="card-title">
                                                                <h4>'.$titre.'</h4>
                                                            </div>
                                                            <div class="card-footer '.$footerclass.'">
                                                                <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                    <i class="fa-solid fa-comment"></i>
                                                                </a>
                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                    <i class="fa-solid fa-heart"></i>
                                                                </a>';
                                                                $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                $tabContentHtml .= '
                                                                <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlFormation.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$urlFormation.'" class="btn-explore" title="Access the article">
                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    ';  


                                                }
                                                else{
                                                    $suffixe = '';
                                                    if (strpos($link_support, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($link_support, 'https') === false){
                                                        $suffixe  = 'https://';
                                                    }
                                                    elseif (strpos($link_support, 'learnenglish.ecenglish.com') !== false && strpos($link_support, 'http') === false){
                                                        $suffixe  = 'http://';
                                                    }
                                                    else{
                                                        $suffixe  = '';
                                                    }
                                                    $urlF  .= $suffixe.$link_support;
                                                    $tabContentHtml .='
                                                    <div class="card-style-1 sequenceActivity">
                                                        <div class="card" value="'.$nbrSeq.'" data-brew="validate" data-link="'.$urlF.'" class="lien_activites" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'">
                                                            <div class="card-img">
                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                            </div>
                                                            <div class="card-title">
                                                                <h4>'.$titre.'</h4>
                                                            </div>
                                                            <div class="card-footer '.$footerclass.'">
                                                                <a class="add-comment" title="Add comment" data-title="'.$titre.'"  onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                    <i class="fa-solid fa-comment"></i>
                                                                </a>
                                                                <a data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                    <i class="fa-solid fa-heart"></i>
                                                                </a>';
                                                                $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                $tabContentHtml .= '
                                                                <a href="#" data-title="'.$titre.'" data-brew="redirect" data-link="'.$urlF.'" onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    ';  
                                                }
                                            }                 
                                            else { 
                                                $urlF1         = str_replace("/redir.php?url=", "", $link_support); 
                                                $suffixe = '';
                                                if (strpos($urlF1, 'bbc.co.uk/worldservice/learningenglish/') !== false && strpos($urlF1, 'https') === false){
                                                    $suffixe  = 'https://';
                                                }
                                                elseif (strpos($urlF1, 'learnenglish.ecenglish.com') !== false && strpos($urlF1, 'http') === false){
                                                    $suffixe  = 'http://';
                                                }
                                                else{
                                                    $suffixe  = '';
                                                }

                                                $urlF  .= $suffixe.$urlF1; 
                                                $tabContentHtml .='
                                                    <div class="card-style-1 sequenceActivity">
                                                        <div class="card" value="'.$nbrSeq.'" >
                                                            <div class="card-img">
                                                                <a href="#"><img src="'.$fileimg.'" alt=""></a>
                                                            </div>
                                                            <div class="card-title">
                                                                <h4>'.$titre.'</h4>
                                                            </div>
                                                            <div class="card-footer '.$footerclass.'">
                                                                <a class="add-comment" title="Add comment" data-title="'.$titre.'" onclick="addCommentActivity(this,'.$id_sequence.','.$numero.');">
                                                                    <i class="fa-solid fa-comment"></i>
                                                                </a>
                                                                <a  data-title="'.$titre.'" onclick="addLinksInFavorites(this,'.$id_sequence.','.$numero.');" class="add-favorite" title="Add favorite">
                                                                    <i class="fa-solid fa-heart"></i>
                                                                </a>';
                                                                $tabContentHtml .= $this->isTuteurConnet() ? '<a data-title="'.$titre.'" onclick="addActivityCourseHistory(this,'.$id_sequence.','.$numero.');" class="add-course" title="Add to training formation"><i class="fa-solid fa-clock-rotate-left"></i></a>' : '';
                                                                $tabContentHtml .= '
                                                                <a data-title="'.$titre.'" href="#" data-brew="redirect" data-link="'.$urlF.'"  onclick="viewActivity(this , '.$id_sequence.');" data-num="'.$numero.'" data-statusurl="'.$status_url.'" data-finalurl="'.$final_url.'" class="btn-explore" title="Access the article">
                                                                    '.$this->lang->line('explore_label').'<i class="fa-solid fa-arrow-right"></i>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                ';               
                                            } 
                                        }
                                    }
                                    $nbrSeq= $nbrSeq + 1;
                                        
                                }                        
                            }
                        } 
                    } 
                } 
            }

        }
        $tabContentHtml.='</div>';
        $retour['html'] = $tabContentHtml;
        echo json_encode($retour);
    }

    public function getListSequenceByModule(){
        $return = array();
        $i = 0;
        if (isset($_POST['module'])) {
            $getByModule = $this->sequence_model->getByModule($_POST['module']);
            foreach ($getByModule as $res) {
                $return[$i] = array(
                    'sequence_id'    => $res->sequence_id,
                    'sequence_titre' => $res->sequence_titre,
                );
                $i++;
            }
        }
        echo json_encode($return);
    }

    public function addContentSequence(){
        $return = array();
        $data = array();
        $width      = "1200";
        $height     = "1280";
        $date       = time();
        if (isset($_POST['sequence_content'])) {
            $return['uploadFile'] = true; //initialise upload file
            if ($_POST['type_content'] == 1) { // add a link
                $fileOrLink = $_POST['link_content'];
            }
            else{ // add a doc
                $repFormation = RP_FORMATION.'activitySequence';    
                if ( ! is_dir($repFormation) ) {
                    mkdir($repFormation, 0755,true);
                }
                $config['upload_path']=$repFormation;      
                $config['allowed_types']='gif|jpg|png|doc|docx|pdf|ppt|csv|xls|xlsx|mid|wma|ogg|wav|mp3|3gp|3g2|avi|mpg|mp4|mp4a|mp4b, .mp4r|mp4v|mp4p|asf|wmv|wma|flv|nut|rm|mov|mkv|ogg|ogv|oga|ogx|spx|opus|ogm|vob|ifo|webm|weba';
                $config['encrypt_name'] = TRUE;
                $config['max_size'] = '300000';                 
                $this->load->library('upload');
                $this->upload->initialize($config);  
                if($this->upload->do_upload("file_content")){
                    $dataUpload = array('upload_data' => $this->upload->data());
                    $fileOrLink = $dataUpload['upload_data']['file_name'];
                    $return['uploadFile'] = true;
                }
                else{
                    $return['uploadFile'] = false;
                }
            }

            if (isset($fileOrLink) && $fileOrLink != '') {

                $thumbnailFile         = "";
                $link_support          = "";
                $urlF                  = "";

                if ($_POST['type_content'] == 4 ) {
                    $link_support      = HTTP_FORMATION.'activitySequence/'.$fileOrLink ;
                }
                else{
                    $link_support      = $fileOrLink ;
                }


                if (isset($link_support) && (strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                    $urlF = "https://docs.google.com/gview?url=".$link_support."&amp;embedded=true";
                }
                else { 
                    $urlF = $link_support;
                }


                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }  
                $thumbnailFiles = "thumbnail_".$date.'_'.$this->session->userdata('GUSERID').'.png';
                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles; 

                $thumb = $this->generateThumbnail($urlF,$width,$height,$fileLocation);

                if($thumb){
                    $thumbnailFile .=$thumbnailFiles;
                }
                else{
                    $thumbnailFile .="";
                } 


                $data = array(
                    'id_sequence'        => $_POST['sequence_content'],
                    'titre'               => $_POST['title_content'],
                    'numero'              => $this->sequence_model->getNextNumBySequence($_POST['sequence_content']),
                    'link'                => $fileOrLink,
                    'norme'               => 0,
                    'type'                => $_POST['type_content'],
                    'id_scorm'            => 0,
                    'mastery'             => 0,
                    'max_time'            => '',
                    'description'         => '',
                    'keyword'             => '',
                    'prerequis'           => '',
                    'niveau'              => 0,
                    'launch'              => true,
                    'regroupe'            => false,
                    'status'              => 1,
                    'date_create'         => time(),
                    'thumbnail_file'      => $thumbnailFile,
                    'ifrmaccess'          => 0,
                    'final_url'           => $fileOrLink,
                    'status_url'          =>1,
                    'new'                 => 0,
                    'date_modification'   => time(),
                    'user_create'         => $this->session->userdata ('GUSERID')
                );
                $return = $data;

                $return['insert'] = $this->sequence_model->addContentSequence($data);
            }
        }
        echo json_encode($return);
    }
    public function editContentSequence(){
        $return = array();
        $data = array();
        $width      = "1200";
        $height     = "1280";
        $date       = time();
        if (isset($_POST['idSequence'])) {
            $olderLink = $this->sequence_model->RequestSeqByIdAndNumero('link',$_POST['idSequence'],$_POST['numSequence']);            
            $return['id_sequence']    = $_POST['idSequence'];
            $return['numero']         = $_POST['numSequence'];
            $return['uploadFile'] = true; //initialise upload file
            if ($_POST['type_content'] == 1) { // add a link
                $fileOrLink = $_POST['link_content'];
            }
            else{ // add a doc
                $repFormation = RP_FORMATION.'activitySequence';    
                if ( ! is_dir($repFormation) ) {
                    mkdir($repFormation, 0755,true);
                }
                $config['upload_path']=$repFormation;      
                $config['allowed_types']='gif|jpg|png|doc|docx|pdf|ppt|csv|xls|xlsx|mid|wma|ogg|wav|mp3|3gp|3g2|avi|mpg|mp4|mp4a|mp4b, .mp4r|mp4v|mp4p|asf|wmv|wma|flv|nut|rm|mov|mkv|ogg|ogv|oga|ogx|spx|opus|ogm|vob|ifo|webm|weba';
                $config['encrypt_name'] = TRUE;
                $config['max_size'] = '300000';                 
                $this->load->library('upload');
                $this->upload->initialize($config);  
                if($this->upload->do_upload("file_content")){
                    $dataUpload = array('upload_data' => $this->upload->data());
                    $fileOrLink = $dataUpload['upload_data']['file_name'];
                    $return['uploadFile'] = true;
                }
                else{
                    $return['uploadFile'] = false;
                }
            }

            if (isset($fileOrLink) && $fileOrLink != '') {

                $thumbnailFile         = "";
                $link_support          = "";
                $urlF                  = "";

                if ($_POST['type_content'] == 4 ) {
                    $link_support      = HTTP_FORMATION.'activitySequence/'.$fileOrLink ;
                }
                else{
                    $link_support      = $fileOrLink ;
                }


                if (isset($link_support) && (strpos($link_support, '.doc') !== false) || (strpos($link_support, '.docx') !== false) || (strpos($link_support, '.ppt') !== false) || (strpos($link_support, '.pdf') !== false)){
                    $urlF = "https://docs.google.com/gview?url=".$link_support."&amp;embedded=true";
                }
                else { 
                    $urlF = $link_support;
                }


                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }  
                $thumbnailFiles = "thumbnail_".$date.'_'.$this->session->userdata('GUSERID').'.png';
                $fileLocation = REP_ACTIVITY_SEQUENCE.$thumbnailFiles;

                $generaThumb = false;

                if ($_POST['type_content'] == 1 && $olderLink == $_POST['link_content']) { 
                    $generaThumb = false;
                } 
                else{
                    $generaThumb = true;
                }

                if (isset($generaThumb) && $generaThumb == true) {                    
                    $thumb = $this->generateThumbnail($urlF,$width,$height,$fileLocation);
                    if($thumb){
                        $thumbnailFile .=$thumbnailFiles;
                    }
                    else{
                        $thumbnailFile .="";
                    }

                    $data = array(
                        'titre'               => $_POST['title_content'],
                        'link'                => $fileOrLink,
                        'norme'               => 0,
                        'type'                => $_POST['type_content'],
                        'id_scorm'            => 0,
                        'mastery'             => 0,
                        'max_time'            => '',
                        'description'         => '',
                        'keyword'             => '',
                        'prerequis'           => '',
                        'niveau'              => 0,
                        'launch'              => true,
                        'regroupe'            => false,
                        'status'              => 1,
                        'date_create'         => time(),
                        'thumbnail_file'      => $thumbnailFile,
                        'ifrmaccess'          => 0,
                        'final_url'           => $fileOrLink,
                        'status_url'          =>1,
                        'new'                 => 0,
                        'date_modification'   => time(),
                        'user_create'         => $this->session->userdata ('GUSERID')
                    );
                }
                else{
                    $data = array(
                        'titre'               => $_POST['title_content'],
                        'link'                => $fileOrLink,
                        'norme'               => 0,
                        'type'                => $_POST['type_content'],
                        'id_scorm'            => 0,
                        'mastery'             => 0,
                        'max_time'            => '',
                        'description'         => '',
                        'keyword'             => '',
                        'prerequis'           => '',
                        'niveau'              => 0,
                        'launch'              => true,
                        'regroupe'            => false,
                        'status'              => 1,
                        'date_create'         => time(),
                        'ifrmaccess'          => 0,
                        'final_url'           => $fileOrLink,
                        'status_url'          =>1,
                        'new'                 => 0,
                        'date_modification'   => time(),
                        'user_create'         => $this->session->userdata ('GUSERID')
                    );
                }
                $return['thumbnail_file'] = $this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['idSequence'],$_POST['numSequence']);     
                $return['result'] = $data;

                $return['insert'] = $this->sequence_model->updateChapitre($_POST['idSequence'],$_POST['numSequence'],$data);
            }
        }
        echo json_encode($return);
    }
}

?>


  
  
  