<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Members extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();        
        $this->isLoggedIn();   
        
    }
  
    public function index(){
    }

    public function profil(){
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('my_profil');
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $idMembres = "";
        $idMaxNumStage = "";
        $idGroupe = "";

        if ($this->isTuteurConnet()) {
            $idMembres = $this->session->userdata ('GUSERID');
            $idGroupe = $this->session->userdata ('STAGIAIREGRP');
            $data['traineeProfilElResutls'] = $this->membres_model->getInfoMembres($this->session->userdata ('STAGIAIREID'));
        }
        else{
            $idMembres = $this->session->userdata ('GUSERID');
            $idGroupe = $this->session->userdata ('GROUPE');
        }

        if (isset($_POST['edit_profil'])) {
            $photo= isset($_FILES['input-file-preview']) && (isset($_FILES['error']) && $_FILES['input-file-preview']['error']==0)?$_FILES['input-file-preview']:'';
            if (isset($_FILES['input-file-preview']) && $_FILES['input-file-preview']['error']==0) {
                $photo= $_FILES['input-file-preview'];
            }
            else{
                $photo= '';
            }

            $data = array(
                'nom'          => $_POST['name'],
                'prenom'       => $_POST['firstname'],
                'email'        => $_POST['email'],
                'tel'          => $_POST['phonenumber'],
                'adresse'      => $_POST['adresse'],
                'id_societe'   => $_POST['company'],
                'login'        => $_POST['username'],
                'cp'           => $_POST['codepostal'],
                'password'     => $_POST['password']
            );
            $this->membres_model->update($idMembres,$data);
            $this->CopyPhotoMembre($photo,$idMembres);
        }

        $data['membres']              = $this->membres_model->getInfoMembres($idMembres);
        $data['qcmResult']            = $this->qcmResult($this->session->userdata ('IDSTAGE'));
        $data['profilExtranetResult'] = $this->isTuteurConnet() ? $this->getProfilExtranet($this->session->userdata ('STAGIAIREEXTRANETID')) : $this->getProfilExtranet($this->session->userdata ('GEXTRANETID'));
        $mailDeDemarageInfos          = $this->getInfosMailDeDemarage($this->config->item('webcal_api_remonte_data')."?func=getMailDeDemarage&idstage=".$this->session->userdata ('IDSTAGE')); 
        $data['jsonDataMailDeDemarageDecode'] = json_decode($mailDeDemarageInfos) != NULL ? json_decode($mailDeDemarageInfos)->data : NULL; 
        if ($this->isTuteurConnet()) {
            $this->loadViews("tutor/profil/index", $this->global,$data, NULL );

        }
        else{
            $this->loadViews("trainee/profil/index", $this->global,$data, NULL );
        }
    }

}

?>