<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    require APPPATH . '/libraries/ElearningForma2PlusController.php';
    require  APPPATH. '/libraries/ExportData.php';

    /**
     * Class : Todolist
     * Base Class to control over all the classes
     * @author : Alexandre Boris
     * @version : 1.1
     * @since : 136 Decémbre 2019
     */

    class DatabankExpression extends ElearningForma2PlusController
    {
        /**
         * This is default constructor of the class
         */
        public function __construct()
        {
            parent::__construct(); 
            $this->load->model('ExpressionRecording_model'); 
            $this->isLoggedIn();   
        }
        
        /**
         * This function used to load the first screen of the user
         */
        public function index()
        {
            $this->global['pageTitle']       = "E-elearning F2+ - ".$this->lang->line('training_expression_data_bank'); 
            $idGroupe = "";

            if ($this->isTuteurConnet()) {
                $idGroupe = $this->session->userdata ('STAGIAIREGRP');
                $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
            }
            else{
                $idGroupe = $this->session->userdata ('GROUPE');
            }

            $this->loadTrackingEl(0,0,$this->tracking_type);   
            $data['message'] = '';
                  
            $data['voicesListResutls']     = $this->getVoiceListResults();
            $data['resultsNotInCat']     = $this->isTuteurConnet() ? $this->databankExpression_model->getAllNotInCat($this->session->userdata ('STAGIAIREID'))->result() : $this->databankExpression_model->getAllNotInCat($this->session->userdata ('GUSERID'))->result();
            $data['resultsNotInCatR']     = $this->isTuteurConnet() ? $this->ExpressionRecording_model->getAllNotInCat($this->session->userdata ('STAGIAIREID'))->result() : $this->ExpressionRecording_model->getAllNotInCat($this->session->userdata ('GUSERID'))->result();
            $data['allCategoryResult']   = $this->categoryExpression_model->getCategoryByIdGroup($idGroupe);
            $data['langageList']         = $this->databankExpression_model->getLangageList();

            if ($this->isTuteurConnet()) {
                $this->loadViews("tutor/e-databank/list", $this->global, $data , NULL);
            }
            else{
                $this->loadViews("trainee/e-databank/list", $this->global, $data , NULL);
            }
        }
        public function getListLangage(){
            $retour = "";
            $result = $this->databankExpression_model->getListLangage();
            foreach ($result as $l) {
                if (isset($_GET['optionSelect']) && $_GET['optionSelect'] != "" &&  $_GET['optionSelect'] == $l->id){
                    $retour .="<option value='".$l->id."' selected=selected>".$l->intitule."</option>";
                }else{
                    $retour .="<option value='".$l->id."'>".$l->intitule."</option>";
                }
            }
            echo $retour;
        }

        public function add(){
            $this->loadTrackingEl(0,0,$this->tracking_type);
            $this->form_validation->set_rules('original_text_langage', $this->lang->line('training_expression_new_expression_language_Origin'), 'required');
            $this->form_validation->set_rules('target_text_langage', $this->lang->line('training_expression_new_expression_language_cible'), '');
            $this->form_validation->set_rules('langage_traduction', $this->lang->line('training_expression_new_expression_language_tr'), '');
            $this->form_validation->set_rules('category', $this->lang->line('training_expression_new_expression_cat'), '');
            //die($this->form_validation->run());

            if($this->form_validation->run() == FALSE)
            {
                $this->data['target_text_langage'] = array(
                    'type'  => 'text',
                    'name'  => 'target_text_langage',
                    'id'    => 'target_text_langage',
                    'value' => $this->form_validation->set_value('target_text_langage'),
                    'class' => 'form-control'
                ); 
                $this->data['original_text_langage'] = array(
                    'type'  => 'text',
                    'name'  => 'original_text_langage',
                    'id'    => 'original_text_langage',
                    'value' => $this->form_validation->set_value('original_text_langage'),
                    'class' => 'form-control'
                ); 
                $errors = validation_errors();
                $this->session->set_flashdata('message', $errors);
                $this->data['target_language'] = $this->databankExpression_model->getListLangage();


                $this->global['pageTitle']     ="Add new expression";

                 redirect("/databank-expression","refresh");
            }
            else
            {
                $idTraineer = NULL;
                if($this->isTuteurConnet()){
                    $idTraineer = $this->session->userdata('GUSERID');
                }
                $data = array(
                    'content_langue_origine' => $this->input->post('original_text_langage'),
                    'id_stagiaire'           => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),                
                    'id_category'            => $this->input->post('category'),         
                    'target_langue_cible'    => $this->input->post('langage_traduction'),
                    'content_langue_cible'   => $this->input->post('target_text_langage'),
                    'user_create'            => $this->session->userdata('GUSERID'),
                    'date_creation'          => date("Y-m-d H:i:s"),
                    'id_tuteur'                       => isset($idTraineer) ? $this->session->userdata('GUSERID') : NULL,
                );          

                $this->databankExpression_model->addExpression($data);
                $this->session->set_flashdata('message', "Expression add succefully");
                redirect("/databank-expression","refresh");
                
            }
        }
        public function delete(){
            if (isset($_POST) && $_POST['expressionId'] != "") {
                if ($_POST['cible'] && $_POST['cible'] == "expression_recording") {
                    echo  $this->ExpressionRecording_model->delete($_POST['expressionId']);
                }
                else{
                    echo  $this->databankExpression_model->deleteExpression($_POST['expressionId']);
                }
            }
        }
        
        public function view(){
            if ( isset($_POST['id']) && $_POST['id'] != "" )
            {
                
                $exp                                      = $this->databankExpression_model->Expression($_POST['id'])->row();
                $dataExpression                           = array();
                $dataExpression['id_expression']          = $exp->id_expression;
                $dataExpression['id_stagiaire']           = $exp->id_stagiaire;
                $dataExpression['id_tuteur']              = $exp->id_tuteur;
                $dataExpression['langue']                 = $exp->langue;
                $dataExpression['content_langue_origine'] = $exp->content_langue_origine;
                $dataExpression['target_langue_cible']    = $exp->intitule;
                $dataExpression['content_langue_cible']   = $exp->content_langue_cible;
                $dataExpression['audio_langue_origine']   = $exp->audio_langue_origine;
                $dataExpression['audio_langue_cible']     = $exp->audio_langue_cible;
                $dataExpression['date_creation']          = $exp->date_creation; 

                echo json_encode($dataExpression);

            }
        }

        public function edit(){
            $current_url = (isset($_GET['categ']) && $_GET['categ'] != '') ? 'databank-expression?categ='.$_GET['categ'] : 'databank-expression';
            $this->loadTrackingEl(0,0,$this->tracking_type);
            $this->form_validation->set_rules('original_text_langage_edit', $this->lang->line('training_expression_new_expression_language_Origin'), 'required');
            $this->form_validation->set_rules('target_text_langage_edit', $this->lang->line('training_expression_new_expression_language_cible'), 'required');
            $this->form_validation->set_rules('langage_traduction_edit', $this->lang->line('training_expression_new_expression_language_tr'), '');
            $this->form_validation->set_rules('category_edit', $this->lang->line('training_expression_new_expression_cat'), 'required');

            if($this->form_validation->run() == FALSE)
            {
                redirect($current_url);
            }
            else
            {
                $langue = '';
                switch ($this->input->post('origin_langage_edit')) {
                    case 1:
                        $langue = 'en';
                        break;
                    case 2:
                        $langue = 'ar';
                        break;
                    case 3:
                        $langue = 'zh';
                        break;
                    case 4:
                        $langue = 'es';
                        break;
                    case 5:
                        $langue = 'fr';
                        break;
                    case 6:
                        $langue = 'ru';
                        break;
                    
                    default:
                        $langue = NULL;
                        break;
                }

                if ($this->input->post('container_cible') == 'expression_recording') {
                    $data = array(
                        'transcription_langage' => $this->input->post('origin_langage_edit'),
                        'transcription'         => $this->input->post('original_text_langage_edit'),
                        'translate_langage'     => $this->input->post('langage_traduction_edit'),
                        'date'                  => time(),
                        'translation'           => $this->input->post('target_text_langage_edit'),
                        'id_category'           => $this->input->post('category_edit')
                    ); 
                    $status = $this->ExpressionRecording_model->update($this->input->post('expression_infos_id_edit'), $data);
                }
                else{
                    $data = array(
                        'langue'                 => $langue,
                        'original_langue_cible'  => $this->input->post('origin_langage_edit'),
                        'content_langue_origine' => $this->input->post('original_text_langage_edit'),
                        'target_langue_cible'    => $this->input->post('langage_traduction_edit'),
                        'date_creation'          => date("Y-m-d H:i:s"),
                        'content_langue_cible'   => $this->input->post('target_text_langage_edit'),
                        'id_category'            => $this->input->post('category_edit')
                    ); 

                    $status = $this->databankExpression_model->editExpression($this->input->post('expression_infos_id_edit'),$data);
                }
                        

                if (isset($status)){
                    redirect($current_url);
                }
                else{
                    redirect($current_url);
                }
            }
        }

        public function ajaxEdition()
        {
            if (isset($_POST['dataExpression'])) {

                $data = array(
                    'content_langue_origine'          => $_POST['dataExpression']['original_text_langage_mod'],
                    'target_langue_cible'             => $_POST['dataExpression']['langage_traduction_mod'],
                    'id_category'                     => $_POST['dataExpression']['category_mod'],
                    'content_langue_cible'            => $_POST['dataExpression']['target_text_langage_mod'],
                    'date_creation'                   => date("Y-m-d H:i:s")
                );
                $this->databankExpression_model->editExpression($_POST['dataExpression']['expression_infos_id_mod'], $data);
                $data['expression_infos_id_mod'] = $_POST['dataExpression']['expression_infos_id_mod'];
                echo json_encode($data);
            }
        }

        public function record(){
            $this->global['pageTitle'] = 'Record audio';
            if (isset($_GET) && $_GET['id'] != NULL) {
                $this->loadViews("trainee/e-databank/record", $this->global, NULL , NULL);
            }
        }

        public function uploadaudio(){
            if (isset($_GET) && $_GET['id'] != NULL) {
                $repgrp = RP_GROUPES."GRP".$this->session->userdata('GROUPE')."/expression/";
                if ( ! is_dir($repgrp) ) {
                    mkdir($repgrp, 0777,true);
                }
                $size = $_FILES['audio_data']['size']; 
                $input = $_FILES['audio_data']['tmp_name'];

                $output = $this->session->userdata ('GUSERID')."_".time().".mp3";
                $destination = $repgrp.$output;
                if(@move_uploaded_file($input, $destination)){
                    $data = array('audio_langue_origine' => $output);
                    $this->databankExpression_model->addOriginAudio($_GET['id'],$data);
                    echo '###'.$destination;
                }
                else{
                    echo '###vvvvv'.$repgrp;
                }
            }
        }

        public function export(){
            $exporter = new ExportDataExcel('browser', 'Export_expression.xls');
            $exporter->initialize();
            $exporter->addRow(array("Origin", "Langage cible", "Cible", "Creation date")); 
            if (isset($_POST)) {
                $result = $this->databankExpression_model->listExpression($this->session->userdata ('GUSERID'),$_POST['key'],$_POST['startDate'],$_POST['endDate'])->result();
                foreach ($result as $res) {
                    $exporter->addRow(array($res->content_langue_origine,$res->intitule,$res->content_langue_cible,$res->date_creation));   
                }
            }
            $exporter->finalize();
            exit();
        }

        public function ajaxAdd()
        {
            $return = array();
            $category = NULL;
            $idTraineer;
            if (isset($_POST)) {

                if (isset($_POST['dataExpression']['visibilityNewCat']) && $_POST['dataExpression']['visibilityNewCat'] == 1 ) {
                    $dataCat = array(
                        'id_groupe' => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREGRP') : $this->session->userdata ('GROUPE'),
                        'intitule'  => $this->convert_utf8($_POST['dataExpression']['new_category'])
                    );
                    $categoryId = $this->CategoryExpression_model->add($dataCat);
                    $return['newCategoryId'] = $categoryId;
                    $return['newCategoryName'] = $_POST['dataExpression']['new_category'];
                    $return['visibilityNewCat'] = $_POST['dataExpression']['visibilityNewCat'];
                }
                else{
                    $categoryId =  $_POST['dataExpression']['category_expression'];
                }


                $langue = '';
                switch ($_POST['dataExpression']['origin_langage_']) {
                    case 1:
                        $langue = 'en';
                        break;
                    case 2:
                        $langue = 'ar';
                        break;
                    case 3:
                        $langue = 'zh';
                        break;
                    case 4:
                        $langue = 'es';
                        break;
                    case 5:
                        $langue = 'fr';
                        break;
                    case 6:
                        $langue = 'ru';
                        break;
                    
                    default:
                        $langue = NULL;
                        break;
                }

                $additional_data = array(
                    'langue'                          => $langue,
                    'original_langue_cible'           => $_POST['dataExpression']['origin_langage_'],
                    'content_langue_origine'          => $_POST['dataExpression']['text_langage_origin'],
                    'target_langue_cible'             => $_POST['dataExpression']['target_langue_cible'],
                    'id_stagiaire'                    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                    'id_tuteur'                       => NULL,
                    'id_category'                     => $categoryId ,
                    'content_langue_cible'            => $_POST['dataExpression']['text_langage_cible'],
                    'date_creation'                   => date("Y-m-d H:i:s"),
                    'user_create'                     => $this->session->userdata('GUSERID'),
                    'id_tuteur'                       => $this->isTuteurConnet() ? $this->session->userdata('GUSERID') : NULL,
                );
                $return['newExpressionId'] = $this->databankExpression_model->addExpression($additional_data);
                $return['category'] = $categoryId;
                echo json_encode($return);
            }
        }

        public function ajaxAddFromGlossary(){
            $return = array();
            if (isset($_POST)) {
                $additional_data = array(
                    'langue'                          => 'en',
                    'original_langue_cible'           => 5,
                    'content_langue_origine'          => $_POST['original-content-glossary'],
                    'target_langue_cible'             => 1,
                    'id_stagiaire'                    => $this->isTuteurConnet() ? $this->session->userdata ('STAGIAIREID') : $this->session->userdata ('GUSERID'),
                    'id_tuteur'                       => NULL,
                    'id_category'                     => $_POST['category_new_expression_glossary'] ,
                    'content_langue_cible'            => $_POST['translate-content-glossary'],
                    'date_creation'                   => date("Y-m-d H:i:s"),
                    'user_create'                     => $this->session->userdata('GUSERID'),
                    'id_tuteur'                       => $this->isTuteurConnet() ? $this->session->userdata('GUSERID') : NULL,
                );
                $return = array(
                    'status' => true,
                    'id'     => $this->databankExpression_model->addExpression($additional_data),
                );
            }
            echo json_encode($return);
        }
    }

?>