<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    require APPPATH . '/libraries/ElearningForma2PlusController.php';

    class CorporateLibrarySoc extends ElearningForma2PlusController
    {
        /**
         * This is default constructor of the class
         */
        public function __construct()
        {
            parent::__construct();
            $this->isLoggedIn();   
            $this->load->model('corporate_library_soc_model');
            $this->load->model('content_corporate_library_soc_model');
            $this->tracking_type = 105;
        }
        
        public function index(){
             $this->loadTrackingEl(0,0,$this->tracking_type);  
            $this->global['pageTitle'] = 'E-learning : Corporate library';
            $idSociete;
            $idGroupe;
            $views;
            $libraryName = '';
            $order = '';
            if (isset($_GET['order']) && $_GET['order'] != '') {
                $order = $_GET['order'];
            }
            if ($_GET['soc'] && !empty($_GET['soc']) && $_GET['soc'] != 0) {
                $idSociete = $_GET['soc'];
            }
            else{
                $idSociete = 697;
                $dataSoc = array(
                    'id_societe' => 697,
                    'date_modif' => time()
                );
                $this->membres_model->update($this->session->userdata('STAGIAIREID'),$dataSoc);
            }
            
            if ($this->isTuteurConnet()) {   
                $data['historik_course'] = $this->coursHistorik_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));              
                $idGroupe = $this->session->userdata('STAGIAIREGRP');
                $views    = "tutorList";
            }
            else{

                $idGroupe = $this->session->userdata('GROUPE');
                $views    = "traineeList";
            }

            $data['classification_favoris']   = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$idGroupe); 
            if (count($this->corporate_library_soc_model->getBySoc($idSociete,$order)) < 1) {
                if ($this->societe_model->Request('description',$idSociete) == '') {
                    $libraryName .= $this->lang->line('corporate_library');
                }
                else{
                    $libraryName .= $this->lang->line('corporate_lib_init').' '.$this->societe_model->Request('description',$idSociete);
                }
                $dataDefaultLib = array(
                    'id_soc'      => $idSociete,
                    'user_create' => $this->session->userdata('GUSERID'),
                    'id_groupe'   => $idGroupe,
                    'name'        => $libraryName,
                    'date' => time(),
                );
                $this->corporate_library_soc_model->add($dataDefaultLib);
            }
            $data['allResult'] = $this->corporate_library_soc_model->getBySoc($idSociete,$order);
            $this->loadViews("commun/corporate_library_soc/".$views, $this->global, $data , NULL);
            
        }

        public function addRep(){
            if (isset($_POST['repertory']) && $_POST['repertory'] != '') {
                if ($this->isTuteurConnet()) {
                    $data = array(
                        'name'        => $this->input->post('repertory'),
                        'user_create' => $this->session->userdata ('GUSERID'),
                        'id_groupe'   => $this->session->userdata ('STAGIAIREGRP'),
                        'id_soc'      => $this->session->userdata ('IDSOCIETE'),
                        'description' => $this->input->post('description'),
                        'date'        => time(),
                    );  
                } 
                else{
                    $data = array(
                        'name'        => $this->input->post('repertory'),
                        'user_create' => $this->session->userdata ('GUSERID'),
                        'id_groupe'   => $this->session->userdata ('GROUPE'),
                        'id_soc'      => $this->session->userdata ('IDSOCIETE'),
                        'description' => $this->input->post('description'),
                        'date'        => time(),
                    );  
                }           
                $ret = $this->corporate_library_soc_model->add($data);
                echo '##'.$ret;
            }

        }
        
        public function addLink(){
            $this->loadTrackingEl(0,0,$this->tracking_type);  
            $title   = $this->input->post('dataLink')['inputTitleLink'];
            $comment = $this->input->post('dataLink')['textareaCommentLink'];
            $link    = $this->input->post('dataLink')['inputLink'];
            $repert  = ($this->input->post('dataLink')['repertory'] == "" || $this->input->post('dataLink')['repertory'] == 0) ? NULL : $this->input->post('dataLink')['repertory'];
            $mycomment = "" ;
           
            if (strlen(trim($comment)) == 0) {
                $mycomment .= "" ;
                $nb   = 0 ;
            }
            else{
                $mycomment .= $comment;
                $nb   = 1 ;
            }
            
            if ($this->session->userdata ('GUSERTYPE') == TUTEUR) {
                $groupe = $this->session->userdata ('STAGIAIREGRP');
            }
            else{
                $groupe = $this->session->userdata('GROUPE');
            }
            $additional_data = array(
                'id_corporate_library_soc'  => $repert,
                'titre'          => $title,
                'commentaire'    => $mycomment,
                'link'           => $link,
                'user_create'    => $this->session->userdata('GUSERID'),      
                'type'           => 0,       
                'date_create'    => time(),    
            );

            $id = $this->content_corporate_library_soc_model->add($additional_data);
            echo $id;

        }

        public function addDoc(){
            $this->loadTrackingEl(0,0,$this->tracking_type);   
            $mycomment = "" ;
            $retour = array();
            $groupe;
            
            if ($this->session->userdata ('GUSERTYPE') == TUTEUR) {
                $groupe = $this->session->userdata ('STAGIAIREGRP');
            }
            else{
                $groupe = $this->session->userdata('GROUPE');
            }
            $rep = RP_SOCIETE.'SOCIETE'.$this->session->userdata ('IDSOCIETE');  
            if ( ! is_dir($rep) ) {
                mkdir($rep, 0755,true);
            }

            $config['upload_path']=$rep;       

            $config['allowed_types']='*';
            $config['encrypt_name'] = TRUE;
            $config['max_size'] = '200000';
            
             
            $this->load->library('upload');
            $this->upload->initialize($config);  
            if($this->upload->do_upload("inputFileDoc")){
                $data = array('upload_data' => $this->upload->data());

                if (strlen(trim($this->input->post('textareaCommentDoc'))) == 0) {
                    $mycomment .= "" ;
                    $nb   = 0 ;
                }
                else{
                    $mycomment .= $this->input->post('textareaCommentDoc');
                    $nb   = 1 ;
                }
                $repert  = ($this->input->post('repertory') == "" || $this->input->post('repertory') == 0) ? NULL : $this->input->post('repertory');

                $additional_data = array(
                    'id_corporate_library_soc'  => $repert,
                    'titre'          => $this->input->post('inputTitleDoc'),
                    'commentaire'    => $mycomment,
                    'link'           => $data['upload_data']['file_name'],
                    'user_create'    => $this->session->userdata('GUSERID'),      
                    'type'           => 1,       
                    'date_create'    => time(),    
                );
                $retour['upload'] = true;
                $retour['idDocument'] = $this->content_corporate_library_soc_model->add($additional_data);
            }
            else{
                $retour = array(
                    'upload' => false,
                    'rep' => $rep,
                    'error_upload' => $this->upload->display_errors()
                );
            }
            echo json_encode($retour);
        }

        public function saveEditRepertory(){
            if (isset($_POST['dataRep'])) {
                $data = array(
                    'name'        => $_POST['dataRep']['repertory-document-edit'],
                    'description' => $_POST['dataRep']['description-cat-edit'],
                    'date'        => time()
                );
                echo $this->corporate_library_soc_model->update($_POST['dataRep']['id_repertory_edit'],$data);
            }
        }

        public function deleteRepertory(){
           if (isset($_POST['id_repertory'])) {
                if ($_POST['id_repertory'] == 0 || $_POST['id_repertory'] == '0') {                
                    $this->content_corporate_library_soc_model->deleteByIdCorporateLibrary(NULL);
                }
                else{               
                    $this->content_corporate_library_soc_model->deleteByIdCorporateLibrary($_POST['id_repertory']);
                    $this->corporate_library_soc_model->delete($_POST['id_repertory']); 
                }
                echo "1";
            } 
        }

        public function saveEditContent(){
            $retour = array();
            $fichier = '';
            $groupe = '';
            if ($this->isTuteurConnet()) { 
                $idGroupe = $this->session->userdata ('STAGIAIREGRP');
                $idSociete = $this->session->userdata('IDSOCIETESTAGIAIRE');
            } 
            else{
                $idGroupe = $this->session->userdata ('GROUPE');
                $idSociete = $this->session->userdata('IDSOCIETE');
            }

            if (isset($_POST['inputTitleDoc_edit'])) {
                if ($_POST['type_doc_edit'] == 0) {
                    $fichier          = $_POST['inputLink_edit'];
                }
                else{
                    $rep = RP_SOCIETE.'SOCIETE'.$idSociete;
                    if ( ! is_dir($rep) ) {
                        mkdir($rep, 0755,true);
                    }
                    $config['upload_path']=$rep;
                    $config['allowed_types']='*';
                    $config['encrypt_name'] = TRUE;
                    $config['max_size'] = '100000';
                    $this->load->library('upload');
                    $this->upload->initialize($config); 
                    if($this->upload->do_upload("inputFileDoc_edit")){
                        $data = array('upload_data' => $this->upload->data());
                        $fichier   = $data['upload_data']['file_name'];
                        $retour['upload'] = true;
                    }
                    
                }

                if ($_POST['textareaCommentDoc_edit'] != "") {
                    if (isset($fichier) && $fichier != '') {                
                        $edit_data = array(
                            'titre'          => $_POST['inputTitleDoc_edit'],
                            'link'        => $fichier,
                            'id_corporate_library_soc'   => $_POST['repertory_edit'],
                            'commentaire'        => $this->session->userdata('GUSER'),
                            'date_create'    => time()
                        );
                    }
                    else{
                        $edit_data = array(
                            'titre'          => $_POST['inputTitleDoc_edit'],
                            'id_corporate_library_soc'   => $_POST['repertory_edit'],
                            'commentaire'    => $_POST['textareaCommentDoc_edit'],
                            'date_create'    => time()
                        );
                    }
                }
                else{
                    if (isset($fichier) && $fichier != '') {                    
                        $edit_data = array(
                            'titre'          => $_POST['inputTitleDoc_edit'],
                            'link'        => $fichier,
                            'id_corporate_library_soc'   => $_POST['repertory_edit'],
                            'date_create'    => time()
                        );
                    }
                    else{
                        $edit_data = array(
                            'titre'          => $_POST['inputTitleDoc_edit'],
                            'id_corporate_library_soc'   => $_POST['repertory_edit'],
                            'date_create'    => time()
                        );
                    }
                }
                $retour['idDoc'] = $this->content_corporate_library_soc_model->update($_POST['id_doc_edit'],$edit_data);
            }
            echo json_encode($retour);
        }

        public function deletedata(){
            if (isset($_POST['id'])) {
                $this->content_corporate_library_soc_model->delete($_POST['id']);
                echo "1";
            } 
        }

        public function saveUpdateComment(){
            if (isset($_POST['id_new_content'])) {
                $data = array(
                    'commentaire' => $_POST['comment_content'],
                    'date_create' => time()
                );
                $this->content_corporate_library_soc_model->update($_POST['id_new_content'],$data);
                echo "1";
            } 
        }

        public function addContentInTodo(){
            $retour = '1';
            $sender = Array();
            $replyto = Array();
            $destination = Array();
            $subject = '';
            $mailbody = '';
            $mailAltBody = '';
            $filePath = '';

            $width      = "1200";
            $height     = "1280";
            $type;
            $linkD;
            $idHistorikCours;
            if (isset($_POST['id'])) {

                $idHistorikCours = $_POST['ch'];  

                $type = $this->content_corporate_library_soc_model->Request('type',$_POST['id']);
                $linkD = $this->content_corporate_library_soc_model->Request('link',$_POST['id']);

                if ($type == 1) {
                    $repDocTodoTuteur=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                    if ( ! is_dir($repDocTodoTuteur) ) {
                        mkdir($repDocTodoTuteur, 0777,true);
                    } 
                    $ext            = explode(".", $this->content_corporate_library_soc_model->Request('link',$_POST['id']));
                    $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                    copy(RP_SOCIETE.'SOCIETE'.$this->session->userdata('IDSOCIETESTAGIAIRE').'/'.$linkD , $repDocTodoTuteur."/".$filename);  

                    $linkInfo = array(
                        'titre'=>$this->content_corporate_library_soc_model->Request('titre',$_POST['id']), 
                        'link'=>$filename,
                        'type'=>$type, 
                        'commentaire'=>"",
                        'date_create'=>date('Y-m-d'), 
                        'user_create'=>$this->session->userdata ('GUSERID'),
                        "thumbnail_file"=>''
                    );
                }
                else{                  


                    $linkInfo = array(
                        'titre'=>$this->content_corporate_library_soc_model->Request('titre',$_POST['id']), 
                        'link'=>$linkD,
                        'type'=>$type, 
                        'commentaire'=>"",
                        'date_create'=>date('Y-m-d'), 
                        'user_create'=>$this->session->userdata ('GUSERID'),
                        "thumbnail_file"=>''
                    );
                }
                $idNewLink = $this->todolist_model->addnewlink($linkInfo);
                
                $todoId = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);

                if (isset($linkD)) {
                    /*$docTodoTuteur      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
             
                    $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                    if ( ! is_dir($docTodoTuteur) ) {
                        mkdir($docTodoTuteur, 0777,true);
                    } */  
                }

                 /*add data to notification trainee*/
                $data_notification = array(
                    'id_tuteur'  => $this->session->userdata('GUSERID'),
                    'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                    'data_type'  => 'todo',
                    'id_data'    => $todoId,
                    'date_create'=> time()
                );

                $this->Notification_model->add($data_notification);

                if (isset($_POST['notify']) && $_POST['notify'] == 'on') {
                                
                    $sender = array(
                        'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                        'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                    );
                    $replyto = array(
                        'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                        'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                    );
                    $destination = array(
                        'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                        'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                    );

                    $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.$this->convert_utf8($this->coursHistorik_model->Request('intitule',$idHistorikCours)).')';

                    $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                    if($type == 1){
                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                    }
                    else{
                        $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                    }

                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                    
                    $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                    $mailbody .= '<br><br><br>';
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                    $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                    $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                    $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                    if ($sendMail) {
                        $retour = '1';
                    }
                    else{
                        $retour = '0';
                    }

                    $this->load->model('Mail_box_model');

                    $data_mail_box = array(
                        'sender'    => $sender['email'],
                        'recipient' => $destination['email'],
                        'subject'   => $subject,
                        'body'      => $mailbody,
                        'attachfile'=> $filePath,
                        'status'    => $sendMail,
                        'author'    => $this->session->userdata ('GUSERID'),
                        'target'    => $this->session->userdata ('STAGIAIREID'),
                        'source'    => $this->lang->line('corporate_library'),
                        'date'      => date("Y-m-d H:i:s")
                    );
                    $this->Mail_box_model->add($data_mail_box);
                }

                if (isset($_POST['modal_view']) && $_POST['modal_view'] == "on") {
                    $retour = $todoId;
                }
                echo "###".$retour;
            }
      
        }

        public function scan(){
            $ret = array();
            $url = "";
            $idGroupe = "";
            $idSociete = "";
            $ret['retour'] = "tracking and url final";
            if ($this->isTuteurConnet()) { 
                $idGroupe = $this->session->userdata ('STAGIAIREGRP');
                $idSociete = $this->session->userdata('IDSOCIETESTAGIAIRE');
            } 
            else{
                $idGroupe = $this->session->userdata ('GROUPE');
                $idSociete = $this->session->userdata('IDSOCIETE');
            }

            if (isset($_POST['page_name']) && $_POST['page_name'] == 'favoris') {
                $this->tracking_type = 24;
            }
            if (isset($_POST['dataId'])) {           
                $allResult = $this->content_corporate_library_soc_model->getResultById($_POST['dataId']);
                foreach ($allResult as $res) {
                    $urlTodo1 = $res->link;
                    if ($res->type == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
                        $url = $res->link;
                    }
                    elseif ($res->type == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
                        $url = $this->getEmbedUrl($urlTodo1);
                    }            
                    elseif ((strpos(HTTP_MAIN.'groupes/SOCIETE/'.$idSociete.'/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/SOCIETE/'.$idSociete.'/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/SOCIETE/'.$idSociete.'/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/SOCIETE/'.$idSociete.'/'.$urlTodo1, '.pdf') !== false)){
                        $url = HTTP_MAIN.'groupes/SOCIETE/'.$idSociete.'/'.$urlTodo1;
                    }
                    else{
                        $url = HTTP_MAIN.'groupes/SOCIETE/'.$idSociete.'/'.$urlTodo1;
                    }
                }
                $ret['finalUrl']  = $this->findUltimateDestination($url,10);
                $ret['responses'] = $this->getHeaderResponses($ret['finalUrl']);
                     
            }

            echo json_encode($ret);
        }
       
    }
