<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class IncidentTechnic extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Stat_model');
        $this->load->model('membres_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }
    
    public function add(){
        $return = array();
        if (isset($_FILES['incident_file_attach']['name'])) {            
            $incident_file_attach_temp = $_FILES['incident_file_attach']['tmp_name'];
            $incident_file_attach_name = $_FILES['incident_file_attach']['name'];
        }

        if (isset($_POST)) {
            require_once(APPPATH.'models/Browser.php');
            $browser = new Browser(); 

            $data = array(
                'nom'                  => $this->membres_model->Request('nom',$this->session->userdata ('GUSERID')),
                'prenom'               => $this->membres_model->Request('prenom',$this->session->userdata ('GUSERID')),
                'statut'               => $this->isTuteurConnet() ? 'Prof' : 'Stagiaire',
                'description'          => $this->session->userdata ('GUSERID'),
                'tel'                  => $this->membres_model->Request('tel',$this->session->userdata ('GUSERID')),
                'temp_file'            => isset($incident_file_attach_temp) ? $incident_file_attach_temp : NULL,
                'name_file'            => isset($incident_file_attach_name) ? $incident_file_attach_name : NULL,
                'date_incident'        => date('Y-m-d H:i:s'),
                'navigateur'           => $this->Stat_model->RequestByIdMembres('navigateur',$this->session->userdata ('STAGIAIREID')),
                'origin'               => 'E-LEARNING',
                'os' => $this->Stat_model->RequestByIdMembres('platform',$this->session->userdata ('STAGIAIREID')),
            );
            $return['data'] = $this->postDataIncidentTechnic($data);           
        }  
        echo json_encode($return);      
    }
    
   
}

?>