<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Parcours extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('matieres_model');
        $this->load->model('sessions_model');
        $this->load->model('formations_model');
        $this->load->model('domaines_model');
        $this->load->model('admin_model');
        $this->isLoggedIn();   
        
    }
  
    public function index(){
        $this->global['pageTitle'] = 'E-learning : Gestion des parcours';
        $data['allResults'] = $this->domaines_model->read();
        $this->loadViews("admin/parcours/index", $this->global,$data, NULL );
    }
    public function list(){
        $ret = '';
        define("DETAILS", 0);
        define("IDM", 0);
        $id_ref = -1 ;

        $action = array() ;
  
        $dom = $this->domaines_model->read();
        
        for($i=0;$i<$dom['cnt'];$i++)  {
            $ret .= '<li><span class="domaineName">'.$dom[$i]['name'].'</span>
                <ul class="materialmenu">';

            $par = $this->parcours_model->readByDomaineThreeView($dom[$i]['id']);
            //var_dump($par);
            for($j=0;$j<$par['cnt'];$j++)  {
                $name_mat = $this->matieres_model->read($par[$j]['matiere_id']) ;
                /*if(!in_array($name_mat['name'], $name_mat)){    
                    if ($par[$j]['matiere_id'] != $id_ref ) {
                        $name = $par[$j]['matiere_id']==0?'Aucun':$name_mat['name'];
                        $id_ref = $par[$j]['matiere_id'] ;
                    }

                    if (isset($par[$i]['matiere_id']) && $par[$i]['matiere_id'] != $id_ref ) {

                        $name = $par[$i]['matiere_id']==0?'Aucun':$name_mat['name'];
                        if ( IDM==$par[$i]['matiere_id'] ) {

                            $ret .= '<li class="material"><span class="materialName" style="color:brown;font-weight:bold;">&nbsp;&nbsp;'.$name.'</span></li>';

                        } 
                        else {
                            $ret .= '<li class="material"><span class="materialName" style="color:brown;font-weight:bold;">&nbsp;&nbsp;'.$name.'</span></li>';

                        }

                        $id_ref = $par[$i]['matiere_id'] ;

                    }
                }*/
           


                if ( IDM!=$par[$j]['matiere_id'] ) continue;

                //if ($this->formations_model->ItemIsValid($par[$j]['id'],$this->session->userdata ('GUSERID'),TYPE_PARCOURS,$this->session->userdata ('STAGIAIREGRP'),1) >= 1) {
                if ($this->formations_model->ItemIsValid($par[$j]['id'],-1,TYPE_PARCOURS,$this->session->userdata ('STAGIAIREGRP'),1) >= 1) {

                    $ret .= '<li class="material"><span class="materialName" style="color:brown;font-weight:bold;">&nbsp;&nbsp;'.$par[$j]['titre'].'</span></li>';

                } else {

                    $ret .= '<li class="material">
                        <a data-mat="'.$par[$j]['matiere_id'].'" onclick="addItemsFormation(this);" data-id="'.$par[$j]['id'].'" data-domaine="'.$par[$j]['domaine_id'].'" title="Add parcours" href="#" class="btn btn-success btn-action-el add-parcours-program"><span class="glyphicon glyphicon-plus-sign"></span></a><span class="materialName">&nbsp;&nbsp;'.$par[$j]['titre'].'</span>
                    </li>';

                }
                

                if ( DETAILS == 1 ) {
                }
            }

            
            $ret .= '</ul></li>';
        }
        echo $ret;
    }

    public function deletematerial(){
        $id = $this->input->post('id');
        $this->matieres_model->del($id) ;
        $this->sequence_model->delMatiere($id);
        $this->modules_model->delMatiere($id);
        $this->parcours_model->delMatiere($id);
    }

    public function delete(){
        $id = $this->input->post('idDomains');
        $this->domaines_model->del($id) ;
        $this->matieres_model->delAll($id) ;
        $this->sequence_model->delDomaine($id);
        $this->modules_model->delDomaine($id);
        $this->parcours_model->delDomaine($id);
        return true;
    }
  
    public function add(){
        $name   = $this->input->post('domain_name');
        $id     = $this->domaines_model->add($name);
        redirect("/managedomains","refresh");
    }

    public function edit(){
        
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->domaines_model->update($id, $name);
        echo "###".$id."###";
    }

    public function editmatiere(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->matieres_model->update($id, $name);
        echo "###".$id."###";
    }

    public function addmaterial(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $id     = $this->matieres_model->add($name, $id);
        echo "###".$id."###";
    }

    public function showall(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $dom            = $this->domaines_model->read(-1,LOC);
        $ret            = "";
        //$cursor         = "";
        for($i=0;$i<$dom['cnt'];$i++)  {
            /*$mat = $this->matieres_model->readAll($dom[$i]['id']);
            for ($j=0;$j<$mat['cnt'];$j++) {
                if ($mat[$j]['id']==$idMaterial) {
                    # code...
                }
            }*/
            if ( in_array($dom[$i]['id'],$idDomains) ) {
                $cursor         = "not-allowed";
            } 
            else {
                $cursor         = "pointer";
            }
            $ret .= '<p><a class="movematerials" onclick="movematerial(this);">';
            $ret .= '<input type="hidden" class="materialid" value="'.$idMaterial.'">';
            $ret .= '<input type="hidden" class="domainsid" value="'.$dom[$i]['id'].'">';
            $ret .= '<span class="glyphicon glyphicon-plus" style="cursor:'.$cursor.';"></span>&nbsp;&nbsp;'.$dom[$i]['name'].'</a></p>';
        }
        echo "###".$ret."###";
    }

    public function movematerial(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $this->matieres_model->move($idMaterial,$idDomains,LOC);
        $this->sequence_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->modules_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->parcours_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);

    }

    public function ajaxDelete(){
        if (isset($_POST['idParcours'])) {
            $this->admin_model->SupprimerItemFormation(-1,-1,-1,-1,-1,$_POST['idParcours'],1,$_POST['idGroupes']);
            return true;
        }
    }

    public function deleteParcoursAdmin(){
        if (isset($_POST['idParcours'])) {
            echo $this->parcours_model->del($_POST['idParcours']);
        }
    }

    public function addNew(){
        $return = array();
        if (isset($_POST['dataParcours'])) {
            $idParcours = $this->admin_model->ajouterUnParcours($_POST['dataParcours']['title'],$_POST['dataParcours']['code'],-1,$_POST['dataParcours']['objectives'],0,-1);
            $dataParcoursUpdate = array(
                'domaine_id'     => $_POST['dataParcours']['domaine_select'],
                'matiere_id'     => $_POST['dataParcours']['matiere_select']
            ); 
            $this->parcours_model->update($idParcours,$dataParcoursUpdate);
            $parcoursInfosData = $this->afficheDetailParcours($idParcours,-1,false);
            $return['parcoursInfosData'] = array();
            foreach($parcoursInfosData as $p){

                $return['parcoursInfosData'] = array(
                    'item_id'  => $p->item_id,
                    'ordre'    => $p->ordre,
                    'type'     => $p->type,
                    'loc'      => $p->loc
                );  
            }
            $return['sequencesInfosData'] = $this->sequence_model->readByDomaineThreeView(0,1,'');
            $return['modulesInfosData']   = $this->modules_model->getAll();
            $return['idParcours'] = $idParcours;

            echo json_encode($return);
        }
    }

    public function getDetail(){
        $return = array();
        $i = 0;
        if (isset($_POST['idParcours'])) {
            $parcoursInfosData = $this->parcours_model->getInfosById($_POST['idParcours'],-1,false);
            foreach($parcoursInfosData as $p){

                $return['parcoursInfosData'] = array(
                    'parcours_titre'  => $p->parcours_titre,
                    'parcours_objectifs'    => $p->parcours_objectifs,
                    'parcours_duree'     => $p->parcours_duree,
                    'auteur_id'     => $this->membres_model->Request('prenom',$p->auteur_id).' '.$this->membres_model->Request('nom',$p->auteur_id),
                    'code'      => $p->code,
                    'domaine_id'      => $p->domaine_id,
                    'domaine_name'      => $this->domaines_model->Request('name',$p->domaine_id),
                    'matiere_name'      => $this->matieres_model->Request('name',$p->matiere_id),
                    'matiere_id'      => $p->matiere_id
                ); 
            }
            $parcoursInfosDataContent = $this->parcours_model->readParcours($_POST['idParcours'],-1,false);
            foreach($parcoursInfosDataContent as $pc){
                $return['parcoursInfosDataContent'][$i]= array(
                    'data_type'=> ($pc->type == TYPE_SEQUENCE) ? 'sequences' :'modules',
                    'item_id'  => $pc->item_id,
                    'ordre'    => $pc->ordre,
                    'type'     => $pc->type,
                    'name'     => ($pc->type == TYPE_SEQUENCE) ? $this->sequence_model->Request('sequence_titre',$pc->item_id) : $this->modules_model->Request('module_titre',$pc->item_id),
                    'loc'      => $pc->loc
                );
                $i++;
            }
            $return['sequencesInfosData'] = $this->sequence_model->readByDomaineThreeView(0,1,'');
            $return['modulesInfosData']   = $this->modules_model->getAll();

            echo json_encode($return);
        }
    }
    /*public function addNew(){
        $return = array();
        if (isset($_POST['dataParcours'])) {
            $idParcours = $this->admin_model->ajouterUnParcours($_POST['dataParcours']['title'],$_POST['dataParcours']['code'],-1,$_POST['dataParcours']['objectives'],0,-1);
            $parcoursInfosData = $this->afficheDetailParcours($idParcours,-1,false);
            $return['parcoursInfosData'] = array();
            foreach($parcoursInfosData as $p){

                $return['parcoursInfosData'] = array(
                    'item_id'  => $p->item_id,
                    'ordre'    => $p->ordre,
                    'type'     => $p->type,
                    'loc'      => $p->loc
                );  
            }
            $return['sequencesInfosData'] = $this->sequence_model->readByDomaineThreeView(0,1,'');
            $domaineArray = $this->domaines_model->read(-1);
            for ($y=0; $y < $domaineArray['cnt']; $y++) { 
                $return['modulesInfosData'] = $this->modules_model->readByDomaineAjax($domaineArray[$y]['id']);
                for ($ii=0; $ii < $moduleArray['cnt']; $ii++) { 
                    $return['modulesInfosData'] = array(
                        'id'          => isset($moduleArray[$ii]['id']) ? $moduleArray[$ii]['id'] : '',
                        'titre'       => isset($moduleArray[$ii]['titre']) ? $moduleArray[$ii]['titre'] : '',
                        'nom'         => isset($moduleArray[$ii]['nom']) ? $moduleArray[$ii]['nom'] : '',
                        'code'        => isset($moduleArray[$ii]['code']) ? $moduleArray[$ii]['code'] : '',
                        'domaine_id'  => isset($moduleArray[$ii]['domaine_id']) ? $moduleArray[$ii]['domaine_id'] : '',
                        'matiere_id'  => isset($moduleArray[$ii]['matiere_id']) ? $moduleArray[$ii]['matiere_id'] : ''
                    ); 
                }
            }
            $return['idParcours'] = $idParcours;

            echo json_encode($return);
        }
    }*/

    public function afficheDetailParcours($idp,$loc,$position=false){
        return $this->parcours_model->readParcours($idp,$loc);
    }
    public function addSequence(){
        if (isset($_POST['idParcours']) && isset($_POST['sequence_id'])) {
           echo $this->admin_model->ajouterUneSequenceParcours($_POST['idParcours'],$_POST['sequence_id'],1);
        }
    }
    public function addModule(){
        if (isset($_POST['idParcours']) && isset($_POST['module_id'])) {
           echo $this->admin_model->ajouterUnModuleParcours($_POST['idParcours'],$_POST['module_id'],1);
        }
    }

}

?>