<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 22 November 2018
 */
class Dashboard extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('societe_model');
        $this->load->model('membres_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        global $titre_profil;
        $this->global['pageTitle'] = 'E-learning : Forma2+';

        $url = base_url()."filemanager?loc=".LOC."&cmd=1&cmd2=1&id=&form=";
        $this->global['urlfilemanager'] = " onClick=\"openWindow('".$url."','manager','scrollbars=yes,width=700,height=590,resizable=yes')\" ";

        if ( substr(HTTP_PHPMYADMIN,0,7)!='http://' && isset($_SERVER['HTTP_REFERER']) ) {
            $tab =  explode("/", $_SERVER['HTTP_REFERER']);
            $urlphpmyadmin =  $tab[0]."/".$tab[1]."/".$tab[2].HTTP_PHPMYADMIN;
        } else {
           $urlphpmyadmin = HTTP_PHPMYADMIN ;
        }
        $data['phpmyadmin']= $urlphpmyadmin;
        $data['user_connecte']  = $this->connexion_model->readCnxActive();      
        
        $this->loadViews("admin/index", $this->global, $data , NULL);
    }  
}

?>