<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

/**** USER DEFINED CONSTANTS **********/
define('REP_RACINE_WEB',         '/var/www/html/');
define('RP_GRP_OLD',         '/var/www/html/elearning/groupes/');


define('RP_MAIN',            '/var/www/html/elearning/');
define('STAGIAIRE',0);
define('ADMIN'    ,2);
define('TUTEUR'   ,3);
define('SUPERVISEUR'   ,4);
define('COORDONNATEUR'   ,6);
define('VISITOR' ,5);
define('ROLEAUTRES'   ,'');
define('RP_GROUPES', RP_MAIN.'groupes/');
define('RP_SOCIETE', RP_GROUPES.'SOCIETE/');

define('HTTP_MAIN',            'https://elearning.forma2plus.com/') ;
define('REP_ACTIVITY_SEQUENCE',RP_MAIN.'groupes/ACTIVITES/') ;
define('RP_SEQUENCE_MODULES', RP_MAIN.'groupes/SEQUENCES/');
define('REP_MODULES_PARCOURS',RP_MAIN.'groupes/MODULES/') ;
define('REP_PARCOURS_DOMAINES',RP_MAIN.'groupes/PARCOURS/') ;
define('REP_DOMAINES',RP_MAIN.'groupes/DOMAINES/') ;


define('HTTP_ACTIVITY_SEQUENCE',HTTP_MAIN.'groupes/ACTIVITES/') ;
define('HTTP_SEQUENCE_MODULES', HTTP_MAIN.'groupes/SEQUENCES/');
define('HTTP_MODULES_PARCOURS',HTTP_MAIN.'groupes/MODULES/') ;
define('HTTP_PARCOURS_DOMAINES',HTTP_MAIN.'groupes/PARCOURS/') ;
define('HTTP_DOMAINES',HTTP_MAIN.'groupes/DOMAINES/') ;

define('RP_UPLOAD_PHOTOS', RP_MAIN.'upload_photos/');
define('HTTP_UPLOAD_PHOTOS', HTTP_MAIN.'upload_photos/');
define('HTTP_BNO'        , HTTP_MAIN.'commun/bno')        ; //  PYG


define('HTTP_GANESHA',         HTTP_MAIN.'sequence/')    ;
define('HTTP_COMMUN'     , HTTP_GANESHA.'commun/')	;

define('HTTP_HOST',     'https://elearning.forma2plus.com/');
define('HTTP_PHPMYADMIN',     HTTP_HOST.'phpmyadmin/');
/**
* Liste des profils composes geres par Ganesha
*/
define('TUTEUR_INTEGRATEUR'          ,10); //2
define('TUTEUR_ADMIN'                ,20); //1
define('TUTEUR_ADMIN_INTEGRATEUR'    ,30); //3

define('SEGMENT',								2);

/************************** EMAIL CONSTANTS *****************************/

define('EMAIL_FROM',                            'Your from email');		// e.g. email@example.com
define('EMAIL_BCC',                            	'Your bcc email');		// e.g. email@example.com
define('FROM_NAME',                             'CIAS Admin System');	// Your system name
define('EMAIL_PASS',                            'Your email password');	// Your email password
define('PROTOCOL',                             	'smtp');				// mail, sendmail, smtp
define('SMTP_HOST',                             'Your smtp host');		// your smtp host e.g. smtp.gmail.com
define('SMTP_PORT',                             '25');					// your smtp port e.g. 25, 587
define('SMTP_USER',                             'Your smtp user');		// your smtp user
define('SMTP_PASS',                             'Your smtp password');	// your smtp password
define('MAIL_PATH',                             '/usr/sbin/sendmail');

/* End of file constants.php */
/* Location: ./application/config/constants.php */
define('TITRE'			,0);
define('NATIONAL'	   ,0);
define('LOCAL'	     ,1);
define('NATIONAL_LOCAL' ,2);
define('STANDARD' ,3);

define('COMPLETED',		2)	;
define('HTTP_FORMATION'  , HTTP_MAIN.'formation/')	;
define('HTTP_FORMATIONS'  , HTTP_MAIN.'formation')	;
define('RP_FORMATION',    RP_MAIN.'formation/') ;
define('CHAPITRE_LU'		,3);
define('DOCUMENT'			,1);

define('QUIZZ_AICC'		,4);
define('QUIZZ_SCORM'		,5);
define('QUIZZ_SCORM_WS'	,6);
define('IMCOS_BI'	,7);	// v1.20.2 : contenu int�gr� IMCOS (glossaire en ligne)
define('STAGIAIRE_LINK'	,8);
define('QUIZZ_GANESHA'	,2);
define('HTTP_SEQUENCE'  ,  HTTP_GANESHA.'sequence/');

define('LOC', 1);
define('TYPE_SEQUENCE'		,0);
define('TYPE_MODULE'		,1);
define('TYPE_PARCOURS'		,2);
define('MENU_ACCEUIL',		0)	;
define('MENU_QUOTIDIENNE_TUYEUR', 1)	;
define('MENU_SOCIETE',		2)	;
define('MENU_GROUPE',		3)	;
define('MENU_STAGIAIRE',	4)	;
define('MENU_TUTEUR',		5)	;
define('MENU_ADMIN',		6)	;
define('MENU_DOMAINE',		7)	;
define('MENU_SEQUENCE',		8)	;
define('MENU_MODULE',		9)	;
define('MENU_PARCOURS',		10)	;
define('MENU_RESERVATION',	11)	;
define('MENU_INSCRIPTION',	12)	;
define('MENU_QUICKSTATS',	20) ;
define('MENU_SGROUPE',		50)	;
define('MENU_OPTION',		97)	;
define('MENU_SITE',			98) ;
define('MENU_BDD',100);
define('MENU_ATELIER',101);
define('MENU_VERIFICATIONLIEN',102);
define('MENU_WIKI',103);


define('FILTRE_ALL',	   	'0');
define('FORMATDATETIME', "d/m/y H:i:s") ;


define('CMD_ALL',				0)	; // -> Lister a partir de la racine
define('CMD_FILE_FORMATION',	1)	; // -> Lister les fichiers + selection
define('CMD_LIST_FORMATION',	2)	; // -> lister les fichiers formation

/**
* Liste des commandes pour le WebMail
*/
define('CMD_WM_INBOX',	0)	; // -> Lister les messages envoyés
define('CMD_WM_OUTBOX',	1)	; // -> lister les messages recus
define('CMD_WM_POST',	2)	; // -> poster un message
define('GUSERTYPE',	0)	; // -> poster un message





define('HTTP_ERROR', HTTP_MAIN.'intro/error.php');

define('LG_TA',80);
define('ERROR',			   	0);
define('OK',			   	1);
define('ERR_LOGIN_PWD',		2);
define('ERR_EMAIL_INVALID',	3);
define('ERR_EMAIL_USED',	4);
define('NB_CAR_LOGIN',	    1);
define('NB_CAR_MDP',	    0);

//Envoi sms ovh
define('SENDER_NAME', 'Forma2Plus');
define('OVH_APPLICATION_KEY', 'hfjsOccG04grAgZw');
define('OVH_APPLICATION_SECRET', '0W0YoG8sq1a0FIsHgSifiz2ZKMmX2X4g');
define('OVH_CONSUMER_KEY', 'A0QRV1sX6N2LGHQHr0WKMafsmSJN9LGS');

//mail
define('MAIL_RS', 'rs.mail@forma2plus.com');
define('MAIL_HS', 'helene.schandeler@forma2plus.com');

define('SUBMENU',	MENU_ADMIN)	;


//Recaptache EL
define('RECAPTCHAEL',	'6LdrBRwqAAAAAPI4OyR27Ae31MbvMJYfCL0N-1nx')	;

