<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
//include (APPPATH.'libraries/html_script.php');
class Traineestat_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table = 'membres';        
        $this->table_doc = 'document';  
        $this->load->model('log_model');      
        $this->load->model('membres_model');      
        $this->load->model('utilities_model'); 
        $this->load->library('pagination'); 
        $this->script = new HTML_Script();    
    }


    public function traineestatcnx($id) {

        //date du dernier moi
        $dt           = new DateTime();
        $date         =  $dt->format('Y-m-d');
        $date_explode = explode("-", $date);
        $mois         = $date_explode[1];
        $annee        = $date_explode[0];
        $d1           = date("U", mktime(0, 0, 0, $mois, 1 ,$annee));
        $d2           = date("U", mktime(0, 0, 0, $mois +1, 0, $annee));

        $startTime = mktime(0, 0, 0, date('m')-1 , 1 , date('Y')); 
        $endTime = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));

        //années en cours
        $startTimeYear = mktime(0, 0, 0, 1, 1, date('Y')); 
        $endTimeYear = mktime();

        $this->db->select("m.id,m.prenom, m.nom, m.email, s.description as societe,(select SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres='".$id."' and date_cnx >='".$endTime."' and date_cnx <='".$d2."') as duree_connexion,(select SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres='".$id."' and date_cnx >='".$startTime."' and date_cnx <='".$endTime."') as duree_connexion_month_before,(select SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres='".$id."' and date_cnx >='".$startTimeYear."' and date_cnx <='".$endTimeYear."') as duree_connexion_for_year, from_unixtime((select date_cnx from stat_connexion where id_membres='".$id."' order by date_cnx desc limit 1,1)) as date_connexion, m.nbconnexion, m.id_groupe");

        $this->db->from($this->table.' as m');
        $this->db->join('list_societe as s', 's.id_societe=m.id_societe','left');
        $this->db->where('m.id', $id);
        $this->db->limit(1);

        $ret = array() ;
        $i = 0 ;

        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $groupe_id = $res->id_groupe;
            $ret['id']      = $res->id;
            $ret['prenom']  = htmlentities($res->prenom);
            $ret['nom']     = htmlentities($res->nom);
            $ret['societe']  = htmlentities($res->societe);
            $ret['date_connexion']= $res->date_connexion;
            $ret['totalTimeConnexion']  =$res->duree_connexion;
            $ret['totalTimeConnexionBefore']  =$res->duree_connexion_month_before;
            $ret['totalTimeConnexionYear']  =$res->duree_connexion_for_year;
            $ret['nbconnexion']  = $res->nbconnexion;
            $ret['documents']= $this->getCountDocument($groupe_id);
            $ret['liens']  =   $this->getCountLink($groupe_id);
            //$ret['totaltime']  = Ganesha2011_getdetailsConnexions($stagiaire_id,$groupe_id);            
            $i++ ;
           
        }
        return($ret);
    }

    public function getCountDocument($groupe_id) {
        $nbdoc = "";
        $this->db->select('count(*) AS documents');
        $this->db->from($this->table_doc);
        $this->db->where('groupe', $groupe_id);
        $this->db->where('lien', "");
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $nbdoc .= $res->documents;
           
        }
        return $nbdoc;
    }

    public function getCountLink($groupe_id) {
        $nbdoc = "";
        $this->db->select('count(*) AS documents');
        $this->db->from($this->table_doc);
        $this->db->where('groupe', $groupe_id);
        $this->db->where('lien', "lien");
        $query = $this->db->get();        
        $result =  $query->result();
        foreach ($result as $res){
            $nbdoc .= $res->documents;
           
        }
        return $nbdoc;
    }

    public function detailsConnexionsTuteur($idu, $idg) {

        return $this->log_model->readTuteur($idu,NULL);
    }
    public function detailsConnexions($idu, $idg) {

        $codeHTML = '<div class="box">';
        $limit = 10;
        

        if (!empty($_GET['filtre'])) {
            $config["base_url"] = base_url('tuteur/detail/index?action=listerConnexions&groupe='.$idg.'&id='.$idu.'&filtre=' . $_GET['filtre']);
        } 
        else {
            $config["base_url"] = base_url('tuteur/detail/index?action=listerConnexions&groupe='.$idg.'&id='.$idu.'&filtre=');
        }
     
        
        $details_stagaire = $this->membres_model->readListStagiaire($idg);      
        $codeHTML .= '<table><tr>';
        $codeHTML .= '<td>Connexions of &nbsp;'.$details_stagaire['0']['prenom'].'  '.$details_stagaire['0']['nom'].' </td>';
        $codeHTML .= '</tr></table>';

        $codeHTML .= '<table class="table connexion_detail">';
            $codeHTML .= '<thead>';
                $codeHTML .= '<tr>';
                    $codeHTML .= '<th></th>';
                    $codeHTML .= '<th>Date</th>';
                    $codeHTML .= '<th>Time</th>';
                    $codeHTML .= '<th>Duration</th>';
                    $codeHTML .= '<th>Total Activity</th>';
                $codeHTML .= '</tr>';
        $codeHTML .= '</thead>';
        $codeHTML .= '<tbody>';
        
        $ret = $this->log_model->read($idu,$limit) ;
        $retTol = $this->log_model->readTot($idu) ;
        
        $config["total_rows"] = $retTol['cnt'];
        $config["per_page"] = $limit;
        $config['use_page_numbers'] = TRUE;
        $config['page_query_string'] = TRUE;
        $config['enable_query_strings'] = TRUE;
        $config['num_links'] = 5;

        $this->pagination->initialize($config);
        $str_links = $this->pagination->create_links();
        $links = explode('&nbsp;', $str_links);

        $offset = 0;
        if (!empty($_GET['per_page'])) {
            $pageNo = $_GET['per_page'];
            $offset = ($pageNo - 1) * $limit;
        }

        
        if ( $ret['cnt'] > 0 ) {
            $tot = 0 ;
            for ($i=0; $i<$ret['cnt']; $i++) {             
                $tot += $ret[$i]['time'];          
               if ($ret[$i]['activite'] > 0) {               
                    $url_activites  = base_url().'get-activity-detail?stag='.$ret[$i]['id_membres'].'&groupe='.$ret[$i]['id_groupe'].'&stag_cnx='.$ret[$i]['stagiaire_cnx'];                
                    $lien_log = $this->script->LienNormal(array('url'=>$url_activites, 'val'=> $ret[$i]['activite']));
                } 
                else {
                    $lien_log = "0";
                }
                $codeHTML .= '<tr>';
                    $codeHTML .= '<td>'.($i+1).'</td>';
                    $codeHTML .= '<td>'.$ret[$i]['date'].'</td>';
                    $codeHTML .= '<td>'.$ret[$i]['heure'].'</td>';
                    $codeHTML .= '<td>'.$this->utilities_model->ReplaceTime($ret[$i]['time']).'</td>';
                    $codeHTML .= '<td>'.$lien_log.'</td>';
                $codeHTML .= '</tr>';
                         
            } 

            if ( $tot > 0 ) {              

                $codeHTML .= '<tr>';
                    $codeHTML .= '<td></td>';
                    $codeHTML .= '<td></td>';
                    $codeHTML .= '<td><strong>TOTAL</strong></td>';
                    $codeHTML .= '<td>'.$this->utilities_model->ReplaceTime($tot).'</td>';
                    $codeHTML .= '<td></td>';
                $codeHTML .= '</tr>';
            }
        }
      
        $codeHTML.= '<tr><td><input type="button" class="btn btn-primary" value="Print" onclick="window.print();">';
        $codeHTML.= '<input type="button" class="btn btn-default" value="Back" onclick="history.back();"></td></tr>';
       
        $codeHTML .= '</tbody>';
        $codeHTML .= '</table>';

        $codeHTML .= '<div class="text-center">
                    <ul class="pagination">';
                       
                        foreach ($links as $link) {
                            $codeHTML .= "<li>" . $link . "</li>";
                        }
               

        $codeHTML .= '</ul>
                </div></div>';

        return $codeHTML;
    }

}

?>
