<?php 
    if(!defined('BASEPATH')) exit('No direct script access allowed');

    class Membres_model extends CI_Model
    {
        
        /**
         * Holds an array of tables used
         *
         * @var array
         **/
        public $tables = array();

        /**
         * activation code
         *
         * @var string
         **/
        public $activation_code;

        /**
         * forgotten password key
         *
         * @var string
         **/
        public $forgotten_password_code;

        /**
         * new password
         *
         * @var string
         **/
        public $new_password;

        /**
         * Identity
         *
         * @var string
         **/
        public $identity;

        /**
         * Where
         *
         * @var array
         **/
        public $_ion_where = array();

        /**
         * Select
         *
         * @var array
         **/
        public $_ion_select = array();

        /**
         * Like
         *
         * @var array
         **/
        public $_ion_like = array();

        /**
         * Limit
         *
         * @var string
         **/
        public $_ion_limit = NULL;

        /**
         * Offset
         *
         * @var string
         **/
        public $_ion_offset = NULL;

        /**
         * Order By
         *
         * @var string
         **/
        public $_ion_order_by = NULL;

        /**
         * Order
         *
         * @var string
         **/
        public $_ion_order = NULL;

        /**
         * Hooks
         *
         * @var object
         **/
        protected $_ion_hooks;

        /**
         * Response
         *
         * @var string
         **/
        protected $response = NULL;

        /**
         * message (uses lang file)
         *
         * @var string
         **/
        protected $messages;

        /**
         * error message (uses lang file)
         *
         * @var string
         **/
        protected $errors;

        /**
         * error start delimiter
         *
         * @var string
         **/
        protected $error_start_delimiter;

        /**
         * error end delimiter
         *
         * @var string
         **/
        protected $error_end_delimiter;

        /**
         * caching of users and their groups
         *
         * @var array
         **/
        public $_cache_user_in_group = array();

        /**
         * caching of groups
         *
         * @var array
         **/
        protected $_cache_groups = array();

        public function __construct(){            
            parent::__construct();
            $this->load->database();
            $this->table     = 'membres';
            $this->table_soc = 'list_societe';
            $this->table_grp = 'list_groupe';
            $this->table_stage = 'stag_individu';
            $this->table_tracking = 'tracking';
            $this->table_stat_connexion = 'stat_connexion';
            $this->table_cours_plannifier = 'cours_plannifier';
            $this->load->model('utilities_model');        
            $this->load->model('societe_model');        
            $this->load->model('log_model');       
            $this->config->load('el_f2plus_auth', TRUE);
            $this->load->helper('cookie');
            $this->load->helper('date');
            $this->lang->load('el_f2plus_auth'); 

            //initialize data
            $this->identity_column = $this->config->item('identity_column', 'el_f2plus_auth');;
            $this->store_salt      = $this->config->item('store_salt', 'el_f2plus_auth');
            $this->salt_length     = $this->config->item('salt_length', 'el_f2plus_auth');
            $this->join            = $this->config->item('join', 'el_f2plus_auth');


            // initialize hash method options (Bcrypt)
            $this->hash_method = $this->config->item('hash_method', 'el_f2plus_auth');
            $this->default_rounds = $this->config->item('default_rounds', 'el_f2plus_auth');
            $this->random_rounds = $this->config->item('random_rounds', 'el_f2plus_auth');
            $this->min_rounds = $this->config->item('min_rounds', 'el_f2plus_auth');
            $this->max_rounds = $this->config->item('max_rounds', 'el_f2plus_auth');


            // initialize messages and error
            $this->messages    = array();
            $this->errors      = array();

            $delimiters_source = $this->config->item('delimiters_source', 'el_f2plus_auth');

            // load the error delimeters either from the config file or use what's been supplied to form validation
            if ($delimiters_source === 'form_validation')
            {
                // load in delimiters from form_validation
                // to keep this simple we'll load the value using reflection since these properties are protected
                $this->load->library('form_validation');
                $form_validation_class = new ReflectionClass("CI_Form_validation");

                $error_prefix = $form_validation_class->getProperty("_error_prefix");
                $error_prefix->setAccessible(TRUE);
                $this->error_start_delimiter = $error_prefix->getValue($this->form_validation);
                $this->message_start_delimiter = $this->error_start_delimiter;

                $error_suffix = $form_validation_class->getProperty("_error_suffix");
                $error_suffix->setAccessible(TRUE);
                $this->error_end_delimiter = $error_suffix->getValue($this->form_validation);
                $this->message_end_delimiter = $this->error_end_delimiter;
            }
            else
            {
                // use delimiters from config
                $this->message_start_delimiter = $this->config->item('message_start_delimiter', 'el_f2plus_auth');
                $this->message_end_delimiter   = $this->config->item('message_end_delimiter', 'el_f2plus_auth');
                $this->error_start_delimiter   = $this->config->item('error_start_delimiter', 'el_f2plus_auth');
                $this->error_end_delimiter     = $this->config->item('error_end_delimiter', 'el_f2plus_auth');
            }


            // initialize our hooks object
            $this->_ion_hooks = new stdClass;

            // load the bcrypt class if needed
            if ($this->hash_method == 'bcrypt') {
                if ($this->random_rounds)
                {
                    $rand = rand($this->min_rounds,$this->max_rounds);
                    $params = array('rounds' => $rand);
                }
                else
                {
                    $params = array('rounds' => $this->default_rounds);
                }

                $params['salt_prefix'] = $this->config->item('salt_prefix', 'el_f2plus_auth');
                $this->load->library('bcrypt',$params);
            }

            $this->trigger_events('model_constructor');

        }


        public function update($idm,$data) {
            $this->db->where('id', $idm);
            $this->db->update($this->table, $data);
            $this->db->affected_rows();
            return true;
        }

        public function getInfoMembres($idM){

            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->where('id', $idM);
            $query = $this->db->get();
            
            return $query->result();
        }

        public function getInfoMembresAdmin($idM){

            $this->db->select('*, from_unixtime(date_debut_acces, "%d/%m/%Y") AS dateDebutAccess, from_unixtime(date_fin_acces, "%d/%m/%Y") AS dateFinAccess');
            $this->db->from($this->table);
            $this->db->where('id', $idM);
            $query = $this->db->get();            
            return $query->result();
        }
        public function getInfoStagiaire($grpId){

            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->where('id_groupe', $grpId);
            $query = $this->db->get();
            
            return $query->result();
        }

        public function getAll() {
            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->order_by('id', 'DESC');
            $query = $this->db->get(); 
            return $query->result()  ;
        }

        public function GetAuteurName($idu) {   
            $this->db->select('nom,prenom,id_societe');
            $this->db->from($this->table);
            $this->db->where('id', $idu);
            $query = $this->db->get();
            $result = $query->result();
            $ret = "";
            foreach ($result as $res){
                $ret = $res->nom." ".$res->prenom  ;
                $soc = $this->societe_model->read($res->id_societe) ;
                if (is_array($soc)) {
                    foreach ($soc as $s) {
                        if ( isset($s['name']) && strlen(trim($s['name']))>0 ) {
                           $ret.= " (".trim($s['name']).")" ;
                        }
                    }
                }
            }
            return($ret);
        }

        public function GetTuteur($idg) {
            $tuteur = array() ;
            $i = 0;
            $this->db->select('m.prenom,m.nom,m.cv, m.id');
            $this->db->from($this->table_grp.' as g');
            $this->db->join($this->table.' as m', 'g.id_tuteur=m.id','inner');
            $this->db->where('g.id_groupe', $idg);
            $query = $this->db->get();
            $tuteur['cnt'] =  $query->num_rows() ;            
            $result = $query->result();  
            foreach ($result as $res){
                $tuteur[$i]['nom']      = $res->nom ;
                $tuteur[$i]['prenom']   = $res->prenom ;
                $tuteur[$i]['name']     = $res->nom.' '.$res->prenom ;
                $tuteur[$i]['cv']       = $res->cv ;
                $tuteur[$i]['id']       = $res->id ;
                $i++ ;
            }
            return($tuteur);
        }

        public function GetIdByGrp($idGrp) {
            return $this->RequestByGrp("id",$idGrp);
        }
        public function GetNom($idu) {
            return $this->Request("nom",$idu);
        }

        public function GetPrenom($idu) {
            return $this->Request("prenom",$idu);
        }

        public function Request($field,$idu) {

            $this->db->select($field);
            $this->db->from($this->table);
            $this->db->where('id', $idu);
            $query = $this->db->get();
            $result = $query->result();
            $ret = "";
            if ($query->num_rows() != 0) {
                foreach ($result as $res){
                    $ret .= $res->$field ;
                }
            }       
            return($ret);
        }
        public function requestByIdExtranet($field,$id_extranet) {
            $this->db->select($field);
            $this->db->from($this->table);
            $this->db->where('extranet_id', $id_extranet);
            $this->db->limit(1);
            $query = $this->db->get();
            $result = $query->result();
            $ret = "";
            if ($query->num_rows() != 0) {
                foreach ($result as $res){
                    $ret .= $res->$field ;
                }
            }       
            return($ret);
        }

         public function RequestByPasswordForgotten($field,$forgotten_password_code) {

            $this->db->select($field);
            $this->db->from($this->table);
            $this->db->where('forgotten_password_code', $forgotten_password_code);
            $query = $this->db->get();
            $result = $query->result();
            $ret = "";
            if ($query->num_rows() != 0) {
                foreach ($result as $res){
                    $ret .= $res->$field ;
                }
            }       
            return($ret);
        }

        public function RequestByGrp($field,$idGrp) {

            $this->db->select($field);
            $this->db->from($this->table);
            $this->db->where('id_groupe', $idGrp);
            $query = $this->db->get();
            $result = $query->result();
            $ret = "";
            if ($query->num_rows() != 0) {
                foreach ($result as $res){
                    $ret .= $res->$field ;
                }
            }       
            return($ret);
        }
        public function RequestFullNameTrainee($idg) {

            $this->db->select("nom,prenom");
            $this->db->from($this->table);
            $this->db->where('id_groupe', $idg);
            $query = $this->db->get();
            $result = $query->result();
            $ret = "";
            if ($query->num_rows() != 0) {
                foreach ($result as $res){
                    $ret .= $res->prenom." ".$res->nom;
                }
            }       
            return($ret);
        }


        public function nb($type) {
        
            $ret = "";
            $this->db->select('count(*) AS nb');
            $this->db->from($this->table);
            $this->db->where('type', $type);
            $query = $this->db->get();
            $result = $query->result();
          
            foreach ($result as $res){
                $ret = $res->nb;           
            }
           
            return $ret;
        }

        /* public function getEtherpadInfos() {
            $this->db->select('CONCAT(m.nom," ", m.prenom) AS trainee, m.id_groupe AS group, m.id AS Id, (SELECT CONCAT(nom," ", prenom) FROM membres WHERE id = l.id_tuteur) AS tuteur');            
            $this->db->from($this->table.' AS m');
            $this->db->join($this->table_grp.' AS l', 'm.id_groupe = l.id_groupe', 'INNER');
            $this->db->where('((FROM_UNIXTIME(m.date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (m.date_fin_acces >= UNIX_TIMESTAMP()))');
            $this->db->where('m.type', 0);
            $this->db->where_not_in('l.id_tuteur', array(0,6997));
            $this->db->group_by(array('l.id_groupe', 'l.id_tuteur'));        
            $this->db->order_by('m.date_creation', 'DESC');        
            $query = $this->db->get();
            return $query->result();                     
        }*/


        /*public function getEtherpadInfos() {
            $this->db->distinct('CONCAT(m.nom," ", m.prenom) AS trainee, m.id_groupe AS group, m.id AS Id, (SELECT CONCAT(nom," ", prenom) FROM membres WHERE id = l.id_tuteur) AS tuteur');
            $this->db->from($this->table_tracking.' AS tr');            
            $this->db->join($this->table.' AS m', 'm.id_groupe = tr.groupe_id', 'INNER');
            $this->db->join($this->table_grp.' AS l', 'm.id_groupe = l.id_groupe', 'INNER');
            $this->db->where('((FROM_UNIXTIME(m.date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (m.date_fin_acces >= UNIX_TIMESTAMP()))');
            $this->db->where('m.type', 0);
            $this->db->where_not_in('l.id_tuteur', array(0,6997));
            $this->db->where('tr.type', 26);
            $this->db->group_by(array('l.id_groupe', 'l.id_tuteur', 'tr.groupe_id'));        
            $this->db->order_by('ztr.groupe_id', 'DESC');        
            $query = $this->db->get();
            return $query->result();                     
        }*/

        public function getInfosByDate($startDate, $endDate, $RP_GROUPES) {
            $i = 0;
            $return = array();
            $this->db->select('CONCAT(nom," ", prenom) AS stagiaire, CONCAT("GRP","", id_groupe) AS dossierGroup, id AS idMembre, date(from_unixtime(date_connexion)) as dateDernierCnx');
            $this->db->from($this->table);
            $this->db->where('date(from_unixtime(date_connexion)) BETWEEN "'.$startDate.'" AND "'.$endDate.'" ');
            $this->db->where('type', 0);      
            $this->db->order_by('date(from_unixtime(date_connexion))', 'DESC');        
            $query = $this->db->get();
            $result =  $query->result();     
            foreach ($result as $res) {
                if(is_dir($RP_GROUPES.$res->dossierGroup)) {
                    $return[$i] = array(
                        'stagiaire'             => $res->stagiaire,
                        'folder'                => $res->dossierGroup,
                        'dernCnx'               => $res->dateDernierCnx,
                        'stagiaire'             => $res->stagiaire,
                        'dernModiFolder'        => date("Y-m-d", filemtime($RP_GROUPES.$res->dossierGroup)),
                        'folderFullDirectory'   => $RP_GROUPES.$res->dossierGroup,
                    );
                    $i++;
                }
            } 
            return $return;               
        }

        public function getEtherpadInfos($startDate, $endDate) {
            $this->db->select('CONCAT(m.nom," ", m.prenom) AS trainee, m.id_groupe AS group, m.id AS Id, date(from_unixtime(tr.date)) as accessDate');
            $this->db->from($this->table_tracking.' AS tr');            
            $this->db->join($this->table.' AS m', 'm.id_groupe = tr.groupe_id', 'INNER');
            $this->db->where('tr.date BETWEEN "'.$startDate.'" AND "'.$endDate.'" ');
            $this->db->where('m.type', 0);
            $this->db->where('tr.type', 26);
            $this->db->group_by('tr.groupe_id');        
            $this->db->order_by('tr.date', 'DESC');        
            $query = $this->db->get();
            return $query->result();                     
        }

        public function filtrer($filtre, $type=STAGIAIRE, $statut = '2')
        {
            $WHERE = '' ;

            if (is_null($type)) $type = STAGIAIRE;
            switch($type)
            {
                case STAGIAIRE :
                    
                    $WHERE = $this->db->where('type', STAGIAIRE);

                    break;
                case TUTEUR :
                    if (SUBMENU==MENU_TUTEUR)
                    {
                        $WHERE = $this->db->where('type', TUTEUR);
                    }
                    elseif (SUBMENU==MENU_GROUPE)
                    {
                        $WHERE = $this->db->where('type', TUTEUR);
                        $WHERE .= $this->db->where('tuteur_entreprise', 0);
                    }
                    else{
                        $WHERE = $this->db->where('type', TUTEUR);
                    }
                    break;
                case TUTEUR_INTEGRATEUR :

                    $ANDWHERE = "type = ".TUTEUR." AND tuteur_entreprise = 0 AND acces_fonctions_admin > 0 ";
                    $WHERE = $this->db->where($ANDWHERE);

                    break;
                case ADMIN :
                    $WHERE = $this->db->where('type', ADMIN);
                    break;
                case "4" :
                    $WHERE = $this->db->where('type', 4);
                    break;
                default :
                    $WHERE = $this->db->where('type', TUTEUR);
            }
          

            $this->db->select('prenom,nom,id,login,password,date_creation,date_connexion,nbconnexion,acces_bar, mode_acces,date_debut_acces,date_fin_acces,acces_fonctions_admin,tuteur_entreprise,id_groupe,extranet_id');
            
            $this->db->from($this->table);
            $WHERE;

            $sql_actif = '((FROM_UNIXTIME(date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (date_fin_acces >= UNIX_TIMESTAMP()))';

            if ($statut == '0')
            {
                $this->db->where('NOT' .$sql_actif);
            }
            elseif ($statut == '1')
            {
                $this->db->where($sql_actif);
            }
            else {
            }
           
            if ( $filtre != FILTRE_ALL && $filtre != '') {

                $likeCriteria = "(nom  LIKE '%".$filtre."%'
                                or  prenom  LIKE '%".$filtre."%'
                                or  email  LIKE '%".$filtre."%')";
                $this->db->where($likeCriteria);
            }       
            else{
               
            }
            $this->db->order_by('nom', 'asc');        
            $this->db->order_by('prenom', 'asc');    
            //$this->db->limit(2);    

            $query = $this->db->get();
            
            $ret['cnt'] = $query->num_rows();
            $i = 0 ;
            $result = $query->result();      
           
            foreach ($result as $res){
                $ret[$i]['name']    = $res->nom.' '.$res->prenom;
                $ret[$i]['id']      = $res->id      ;
                $ret[$i]['groupeId']      = $res->id_groupe      ;
                $ret[$i]['login']   = $res->login   ;
                $ret[$i]['password']= $res->password;
                $ret[$i]['cnx']     = ($res->date_connexion==''?'(Pas de connexion)':date(FORMATDATETIME,$res->date_connexion));
                $ret[$i]['nbcnx']   = $res->nbconnexion ;
                $ret[$i]['acces_bar']   = $res->acces_bar   ;
                $ret[$i]['mode_acces']  = $res->mode_acces  ;
                $ret[$i]['date_debut_acces']    = $res->date_debut_acces    ;
                $ret[$i]['date_fin_acces']  = $res->date_fin_acces ;
                $ret[$i]['acces_fonctions_admin']   = $res->acces_fonctions_admin  ;
                $ret[$i]['tuteur_entreprise']   = $res->tuteur_entreprise  ;
                $ret[$i]['extranet_id']   = $res->extranet_id  ;
                $i++ ;           
            }
            return($ret);
                
        }
        public function adminFilter($type=STAGIAIRE, $statut = '2',$key)
        {
            $WHERE = '' ;

            if (is_null($type)) $type = STAGIAIRE;

            switch($type)
            {
                case STAGIAIRE :
                    
                    $WHERE = $this->db->where('type', STAGIAIRE);

                    break;
                case TUTEUR :
                    $WHERE = $this->db->where('type', TUTEUR);
                    break;
                case TUTEUR_INTEGRATEUR :

                    $ANDWHERE = "type = ".TUTEUR." AND tuteur_entreprise = 0 AND acces_fonctions_admin > 0 ";
                    $WHERE = $this->db->where($ANDWHERE);

                    break;
                case ADMIN :
                    $WHERE = $this->db->where('type', ADMIN);
                    break;
                case "4" :
                    $WHERE = $this->db->where('type', 4);
                    break;
                default :
                    $WHERE = $this->db->where('type', TUTEUR);
            }
          

            $this->db->select('prenom,nom,id,login,password,date_creation,date_connexion,nbconnexion,acces_bar, mode_acces,date_debut_acces,date_fin_acces,acces_fonctions_admin,tuteur_entreprise');
            
            $this->db->from($this->table);
            $WHERE;

            $sql_actif = '((FROM_UNIXTIME(date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (date_fin_acces >= UNIX_TIMESTAMP()))';

            if ($statut == '0')
            {
                $this->db->where('NOT' .$sql_actif);
            }
            elseif ($statut == '1')
            {
                $this->db->where($sql_actif);
            }
            else {
            }
           
            if ( $key != "") {

                $likeCriteria = "(nom  LIKE '%".$key."%'
                                or  prenom  LIKE '%".$key."%'
                                or  email  LIKE '%".$key."%')";
                $this->db->where($likeCriteria);
            }       
            else{
               
            }
            $this->db->order_by('nom', 'asc');        
            $this->db->order_by('prenom', 'asc');    
            //$this->db->limit($page, $segment); 
            $query = $this->db->get();
            
            $ret['cnt'] = $query->num_rows();
            $i = 0 ;
            $result = $query->result();      
           
            foreach ($result as $res){
                $ret[$i]['name']    = $res->nom.' '.$res->prenom;
                $ret[$i]['id']      = $res->id      ;
                $ret[$i]['login']   = $res->login   ;
                $ret[$i]['password']= $res->password;
                $ret[$i]['cnx']     = ($res->date_connexion==''?'(Pas de connexion)':date(FORMATDATETIME,$res->date_connexion));
                $ret[$i]['nbcnx']   = $res->nbconnexion ;
                $ret[$i]['acces_bar']   = $res->acces_bar   ;
                $ret[$i]['mode_acces']  = $res->mode_acces  ;
                $ret[$i]['date_debut_acces']    = $res->date_debut_acces    ;
                $ret[$i]['date_fin_acces']  = $res->date_fin_acces ;
                $ret[$i]['acces_fonctions_admin']   = $res->acces_fonctions_admin  ;
                $ret[$i]['tuteur_entreprise']   = $res->tuteur_entreprise  ;
                $i++ ;           
            }
            return($ret);
                
        }
        public function readCountAdminFilter($type=STAGIAIRE, $statut = '2',$key)
        {
            $WHERE = '' ;

            if (is_null($type)) $type = STAGIAIRE;

            switch($type)
            {
                case STAGIAIRE :
                    
                    $WHERE = $this->db->where('type', STAGIAIRE);

                    break;
                case TUTEUR :
                    $WHERE = $this->db->where('type', TUTEUR);
                    break;
                case TUTEUR_INTEGRATEUR :

                    $ANDWHERE = "type = ".TUTEUR." AND tuteur_entreprise = 0 AND acces_fonctions_admin > 0 ";
                    $WHERE = $this->db->where($ANDWHERE);

                    break;
                case ADMIN :
                    $WHERE = $this->db->where('type', ADMIN);
                    break;
                case "4" :
                    $WHERE = $this->db->where('type', 4);
                    break;
                default :
                    $WHERE = $this->db->where('type', TUTEUR);
            }
          

            $this->db->select('prenom,nom,id,login,password,date_creation,date_connexion,nbconnexion,acces_bar, mode_acces,date_debut_acces,date_fin_acces,acces_fonctions_admin,tuteur_entreprise');
            
            $this->db->from($this->table);
            $WHERE;

            $sql_actif = '((FROM_UNIXTIME(date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (date_fin_acces >= UNIX_TIMESTAMP()))';

            if ($statut == '0')
            {
                $this->db->where('NOT' .$sql_actif);
            }
            elseif ($statut == '1')
            {
                $this->db->where($sql_actif);
            }
            else {
            }
           
            if ( $key != "") {

                $likeCriteria = "(nom  LIKE '%".$key."%'
                                or  prenom  LIKE '%".$key."%'
                                or  email  LIKE '%".$key."%')";
                $this->db->where($likeCriteria);
            }       
            else{
               
            }
            $this->db->order_by('nom', 'asc');        
            $this->db->order_by('prenom', 'asc');    

            $query = $this->db->get();
            
            return $query->num_rows();
           
        }
        public function filtrerAdminCount($key='') {
              
            $this->db->select('tuteur_entreprise,prenom,nom,type,id_groupe,id,login,password,date_creation,date_connexion,nbconnexion,acces_bar, mode_acces,date_debut_acces,date_fin_acces,acces_fonctions_admin,tuteur_entreprise');        
            $this->db->from($this->table);

            $sql_actif = '((FROM_UNIXTIME(date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (date_fin_acces >= UNIX_TIMESTAMP()))';
        
            $this->db->order_by('nom', 'asc');        
            $this->db->order_by('prenom', 'asc');    

            $query = $this->db->get();
            
            return $query->num_rows();
        }

        public function filtrerAdmin($arrayKey)
        {
            
            $this->db->select('tuteur_entreprise,prenom,nom,type,id_groupe,id,login,password,date_creation,date_connexion,nbconnexion,acces_bar, mode_acces,date_debut_acces,date_fin_acces,acces_fonctions_admin,tuteur_entreprise');        
            $this->db->from($this->table);

            $sql_actif = '((FROM_UNIXTIME(date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (date_fin_acces >= UNIX_TIMESTAMP()))';
            if(isset($arrayKey['utilisateur_nom']) && $arrayKey['utilisateur_nom'] != '') {
                $likeCriteria = '(nom LIKE "%'.$arrayKey['utilisateur_nom'].'%" OR prenom LIKE "%'.$arrayKey['utilisateur_nom'].'%" OR CONCAT(nom," ", prenom) LIKE "%'.$arrayKey['utilisateur_nom'].'%" OR CONCAT(prenom," ", nom) LIKE "%'.$arrayKey['utilisateur_nom'].'%")';
                $this->db->where($likeCriteria);             
                
            }

            if(isset($arrayKey['utilisateur_type']) && $arrayKey['utilisateur_type'] != '') {
                $this->db->where('type', (int)$arrayKey['utilisateur_type']);             
                
            }

            $this->db->order_by('nom', 'asc');        
            $this->db->order_by('prenom', 'asc');   

            $query = $this->db->get();
            
            $ret['cnt'] = $query->num_rows();
            $i = 0 ;
            $result = $query->result();      
           
            foreach ($result as $res){
                $ret[$i]['name']    = $res->nom.' '.$res->prenom;
                $ret[$i]['id']      = $res->id      ;
                $ret[$i]['type']    = $res->type      ;
                $ret[$i]['tuteur_entreprise']    = $res->tuteur_entreprise      ;
                $ret[$i]['login']   = $res->login   ;
                $ret[$i]['password']= $res->password;
                $ret[$i]['last_cnx']= $res->date_connexion;
                $ret[$i]['nbcnx']   = $res->nbconnexion ;
                $ret[$i]['acces_bar']   = $res->acces_bar   ;
                $ret[$i]['id_groupe']   = $res->id_groupe   ;
                $ret[$i]['mode_acces']  = $res->mode_acces  ;
                $ret[$i]['date_debut_acces']    = $res->date_debut_acces    ;
                $ret[$i]['date_fin_acces']  = $res->date_fin_acces ;
                $ret[$i]['acces_fonctions_admin']   = $res->acces_fonctions_admin  ;
                $ret[$i]['tuteur_entreprise']   = $res->tuteur_entreprise  ;
                $i++ ;           
            }
            return($ret);
                
        }

        public function filtrerAdmin_backup($key='', $page = NULL, $segment = NULL)
        {
            
            $this->db->select('tuteur_entreprise,prenom,nom,type,id_groupe,id,login,password,date_creation,date_connexion,nbconnexion,acces_bar, mode_acces,date_debut_acces,date_fin_acces,acces_fonctions_admin,tuteur_entreprise');        
            $this->db->from($this->table);

            $sql_actif = '((FROM_UNIXTIME(date_connexion, "%Y") >= (DATE_FORMAT(NOW(), "%Y")-1)) OR (date_fin_acces >= UNIX_TIMESTAMP()))';
            if(!empty($key)) {
                $likeCriteria = '(nom LIKE "%'.$key.'%" OR prenom LIKE "%'.$key.'%" OR CONCAT(nom," ", prenom) LIKE "%'.$key.'%" OR CONCAT(prenom," ", nom) LIKE "%'.$key.'%")';
                $this->db->where($likeCriteria);
                /*$likeCriteriaCase = "(LCASE(nom) LIKE LCASE('%".$key."%') OR LCASE(prenom) LIKE LCASE('%".$key."%'))";
                $this->db->like($likeCriteriaCase);*/                
                $this->db->order_by('nom', 'asc');        
                $this->db->order_by('prenom', 'asc');   
            }
            else{                
                $this->db->order_by('nom', 'asc');        
                $this->db->order_by('prenom', 'asc');   
                $this->db->limit($page, $segment);
            } 

            $query = $this->db->get();
            
            $ret['cnt'] = $query->num_rows();
            $i = 0 ;
            $result = $query->result();      
           
            foreach ($result as $res){
                $ret[$i]['name']    = $res->nom.' '.$res->prenom;
                $ret[$i]['id']      = $res->id      ;
                $ret[$i]['type']    = $res->type      ;
                $ret[$i]['tuteur_entreprise']    = $res->tuteur_entreprise      ;
                $ret[$i]['login']   = $res->login   ;
                $ret[$i]['password']= $res->password;
                $ret[$i]['last_cnx']= $res->date_connexion;
                $ret[$i]['nbcnx']   = $res->nbconnexion ;
                $ret[$i]['acces_bar']   = $res->acces_bar   ;
                $ret[$i]['id_groupe']   = $res->id_groupe   ;
                $ret[$i]['mode_acces']  = $res->mode_acces  ;
                $ret[$i]['date_debut_acces']    = $res->date_debut_acces    ;
                $ret[$i]['date_fin_acces']  = $res->date_fin_acces ;
                $ret[$i]['acces_fonctions_admin']   = $res->acces_fonctions_admin  ;
                $ret[$i]['tuteur_entreprise']   = $res->tuteur_entreprise  ;
                $i++ ;           
            }
            return($ret);
                
        }
        public function getInfoAuthorDoc()
        {
            
            $this->db->select('m.*');        
            $this->db->from($this->table.' as m');
            $this->db->join('document as d', 'd.prop=m.id','inner');
            $this->db->order_by('m.nom', 'asc');        
            $this->db->group_by('m.id');  
            $query = $this->db->get();
            $ret['cnt'] = $query->num_rows();
            $i = 0 ;
            $result = $query->result();      
           
            foreach ($result as $res){
                $ret[$i]['name']    = $res->prenom.' '.$res->nom;
                $ret[$i]['id']      = $res->id      ;
                $ret[$i]['login']   = $res->login   ;
                $ret[$i]['password']= $res->password;
                $ret[$i]['cnx']     = $res->date_connexion;
                $ret[$i]['cnx']     = ($res->date_connexion==''?'(Pas de connexion)':date(FORMATDATETIME,$res->date_connexion));
                $ret[$i]['nbcnx']   = $res->nbconnexion ;
                $ret[$i]['acces_bar']   = $res->acces_bar   ;
                $ret[$i]['mode_acces']  = $res->mode_acces  ;
                $ret[$i]['date_debut_acces']    = $res->date_debut_acces    ;
                $ret[$i]['date_fin_acces']  = $res->date_fin_acces ;
                $ret[$i]['acces_fonctions_admin']   = $res->acces_fonctions_admin  ;
                $ret[$i]['tuteur_entreprise']   = $res->tuteur_entreprise  ;
                $i++ ;           
            }
            return($ret);
                
        }
        public function GetFiche($idu,$loc=-1) {
            $ret = array();
           

            $this->db->select("prenom,nom,login,password,date_creation,email,adresse,cp,ville,id_societe,mode_acces,date_debut_acces,date_fin_acces,cv,nbconnexion,date_connexion,acces_bar,acces_fonctions_admin,tuteur_entreprise,skin,stageSociete,extranet_id");
            $this->db->from($this->table);
            $this->db->where('id', $idu);
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ;   
            if (is_array($result)) {
                foreach ($result as $res){
                    $ret['prenom']          = trim($res->prenom)    ;
                    $ret['nom']             = trim($res->nom)       ;
                    $ret['name']            = $res->nom.' '.$res->prenom;
                    $ret['login']           = $res->login   ;
                    $ret['password']        = $res->password;
                    $ret['date_creation']   = date("Y-m-d", $res->date_creation);
                    $ret['email']           = $res->email   ;
                    $ret['adresse']         = $res->adresse ;
                    $ret['cp']              = $res->cp      ;
                    $ret['ville']           = $res->ville   ;
                    $ret['id_societe']      = $res->id_societe  ;
                    $ret['mode_acces']      = $res->mode_acces  ;
                    $ret['date_debut_acces']= $res->date_debut_acces    ;
                    $ret['date_fin_acces']  = $res->date_fin_acces      ;
                    $ret['cv']              = $res->cv          ;
                    $ret['nbconnexion']     = $res->nbconnexion ;
                    $ret['date_connexion']  = ($res->date_connexion==''?'No login to register':date("Y-m-d", $res->date_connexion));
                    $ret['acces_bar']       = $res->acces_bar   ;
                    $ret['acces_fonctions_admin']   = $res->acces_fonctions_admin   ;
                    $ret['tuteur_entreprise']       = $res->tuteur_entreprise   ;
                    $ret['skin']        = $res->skin    ;
                    $ret['stageSociete']        = $res->stageSociete    ;
                    $ret['stagiaire_id']        = $res->extranet_id ;
                }
            } 
            return($ret);
        }

        public function photo($id) {
            $nomPhoto = $this->Request('nom_photo', $id);
            if ($nomPhoto =='' || !file_exists(RP_UPLOAD_PHOTOS.$nomPhoto)) {
                $ret['photo']   = HTTP_UPLOAD_PHOTOS.'image.jpg';
            } else {
                $ret['photo']   = HTTP_UPLOAD_PHOTOS.$nomPhoto;
            }
            $ret['width']   = 122;
            $ret['height']  = 170;
            return($ret);
        }

        public function readListStagiaire($idg) {       

            $ret = Array() ;
            $i=0 ;

            $this->db->select("m.id, m.prenom, m.nom,m.mode_acces,m.date_debut_acces,m.date_fin_acces,m.extranet_id");
            $this->db->from($this->table." as m");
            $this->db->join('groupe as g', 'm.id=g.id_membres','left');
            $this->db->where('m.type', STAGIAIRE);
            $this->db->where('g.id_groupe', $idg);
            $this->db->order_by('m.nom', 'ASC');
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ;   
            if (is_array($result)) {
                foreach ($result as $res){
                    $ret[$i]['id']      = $res->id;
                    $ret[$i]['prenom']  = $res->prenom;
                    $ret[$i]['nom']     = $res->nom;
                    $ret[$i]['mode_acces']      = $res->mode_acces;
                    $ret[$i]['date_debut_acces']= $res->date_debut_acces;
                    $ret[$i]['date_fin_acces']  = $res->date_fin_acces;
                    $ret[$i]['extranet_id'] = $res->extranet_id; 
                }
            } 
            return($ret);
        }

        public function getStagiaireIDByGroupID($idg) {
            $return = "";
            $this->db->select('id_membres');
            $this->db->from("groupe");
            $this->db->where('id_groupe', $idg);
            $query = $this->db->get();
            $result = $query->result();      
            foreach ($result as $res){
                $return .= $res->id_membres;           
            }
            return $return;
        }

        public function membre_id_etherpad($stagiaire_id) {

            $this->db->select('CONCAT("G",id_groupe) as etherpad_id');
            $this->db->from($this->table);
            $this->db->where('id', $stagiaire_id);
            $query = $this->db->get();
            $result = $query->result();
          
            foreach ($result as $res){
                return $res->etherpad_id;           
            }
        }

        public function addUserCreate($grp_membres,$idUser) {
            $date   = getdate() ;
            $date   = $date["0"];
            $info = array("grp_membres"=>$grp_membres,"user_modif"=>$idUser,"date_modif"=>$date);           
            $this->db->trans_start();
            $this->db->insert("history_modif_membres", $info);        
            $id = $this->db->insert_id();        
            $this->db->trans_complete();

        }

        public function addUserModif($grp_membres,$idUser) {
            global $db, $TBL ;
            $date   = getdate() ;
            $date   = $date["0"];

            $this->db->select('*');
            $this->db->from("history_modif_membres_final");
            $this->db->where('grp_membres', $grp_membres);
            $query = $this->db->get();
            $count = $query->num_rows();

            if ($count >= 1) {          
                $infou = array("user_modif"=>$idUser,"date_modif"=>$date);
                $this->db->where('grp_membres', $grp_membres);
                $this->db->update("history_modif_membres_final", $infou);
                $this->db->affected_rows();

            }
            else{
                $infoi = array("grp_membres"=>$grp_membres,"user_modif"=>$idUser,"date_modif"=>$date);           
                $this->db->trans_start();
                $this->db->insert("history_modif_membres", $infoi);        
                $id = $this->db->insert_id();        
                $this->db->trans_complete();
            }
            
        }

        public function readAllCnxBySociete($ids) {
            $d = date('d');
            $m = date('m');
            $y = date('Y');
            $today = mktime(0, 0, 0, $m, $d, $y);
            $i=0 ;
            $ret = array();     

            $this->db->select('type, prenom, nom, date_connexion,id, tuteur_entreprise');
            $this->db->from($this->table);
            $this->db->where('id_societe', $ids);
            $this->db->where('date_connexion > ', $today);
            $this->db->order_by('nom', 'asc');    
            $query = $this->db->get();
            $ret['cnt'] = $query->num_rows();
            $result = $query->result();
          
            foreach ($result as $res){
                $ret[$i]['type']= $res->type ;
                $ret[$i]['name']= $res->prenom.' '.$res->nom;
                $ret[$i]['cnx'] = $res->date_connexion ;
                $ret[$i]['id']  = $res->id ;
                $ret[$i]['tuteur_entreprise'] = $res->tuteur_entreprise   ;
                $i++ ;     
            }
            return($ret);
        }
          
        public function delete($id,$type){
            global $db;
            $nomPhoto = $this->Request('nom_photo', $id);
            /*if($nomPhoto!='') {
                DeleteDocument(RP_UPLOAD_PHOTOS.$nomPhoto);
            } */
            $this->db->where('id', $id);
            $this->db->delete($this->table);    
            if ( $type == TUTEUR ) {
                $this->db->where('id_tuteur', $id);
                $this->db->delete('list_groupe');
            }
            $this->db->where('id_membres', $id);
            $this->db->delete('stat_connexion');


            $this->db->where('user_id', $id);
            $this->db->delete('tracking');

            $this->db->where('id_membres', $id);
            $this->db->delete('groupe');
        }

        public function Ganesha2011_getstats($stagiaire_id,$key,$page,$segment) {
            $dt           = new DateTime();
            $date         =  $dt->format('Y-m-d');
            $date_explode = explode("-", $date);
            $mois         = $date_explode[1];
            $annee        = $date_explode[0];
            $d1           = date("U", mktime(0, 0, 0, $mois, 1 ,$annee));
            $d2           = date("U", mktime(0, 0, 0, $mois +1, 0, $annee));

            $startTime = mktime(0, 0, 0, date('m')-1 , 1 , date('Y')); 
            $endTime = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));
            $startTimeYear = mktime(0, 0, 0, 1, 1, date('Y')); 
            $endTimeYear = time();
            $ret = array() ;
            $this->db->select('m.id,m.prenom, m.nom, m.email, s.description as societe');
            $this->db->select('(SELECT SEC_TO_TIME(sum(time_cnx)) FROM stat_connexion where id_membres='.$stagiaire_id.' and date_cnx >="'.$endTime.'" and date_cnx <= "'.$d2.'") as duree_connexion');
            $this->db->select('(SELECT SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres="'.$stagiaire_id.'" and date_cnx >="'.$startTime.'" and date_cnx <= "'.$endTime.'") as duree_connexion_month_before');
            $this->db->select('(SELECT SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres='.$stagiaire_id.' and date_cnx >="'.$startTimeYear.'" and date_cnx <= "'.$endTimeYear.'") as duree_connexion_for_year');
            $this->db->select('from_unixtime((select date_cnx from stat_connexion where id_membres='.$stagiaire_id.' order by date_cnx desc limit 1,1)) as date_connexion');
            $this->db->select('m.nbconnexion, m.id_groupe');
            $this->db->from($this->table.' as m');
            $this->db->join($this->table_soc.' as s', 's.id_societe=m.id_societe','inner');
            $this->db->where('m.id', $stagiaire_id);  
            $query = $this->db->get();
            $ret['cnt'] = $query->num_rows();
            $result = $query->result();
            $i=0;
            foreach ($result as $res){
                $groupe_id                            = $res->id_groupe;
                $ret[$i]['id']                            = $res->id;
                $ret[$i]['prenom']                        = htmlentities($res->prenom);
                $ret[$i]['nom']                           = htmlentities($res->nom);
                $ret[$i]['societe']                       = htmlentities($res->societe);
                $ret[$i]['date_connexion']                = $res->date_connexion;
                $ret[$i]['totalTimeConnexion']            = $res->duree_connexion;
                $ret[$i]['totalTimeConnexionBefore']      = $res->duree_connexion_month_before;
                $ret[$i]['totalTimeConnexionYear']        = $res->duree_connexion_for_year;
                $ret[$i]['nbconnexion']                   = $res->nbconnexion;
                $ret[$i]['documents']                     = $this->Ganesha2011_getnodocuments($groupe_id);
                $ret[$i]['liens']                         = $this->Ganesha2011_getnoliens($groupe_id);
                $ret[$i]['totaltime']                     = $this->Ganesha2011_getdetailsConnexions($stagiaire_id,$groupe_id);
                $i++ ;     
            }
            return($ret);
        }
        public function CountGanesha2011_getstats($key,$stagiaire_id) {
            $dt           = new DateTime();
            $date         =  $dt->format('Y-m-d');
            $date_explode = explode("-", $date);
            $mois         = $date_explode[1];
            $annee        = $date_explode[0];
            $d1           = date("U", mktime(0, 0, 0, $mois, 1 ,$annee));
            $d2           = date("U", mktime(0, 0, 0, $mois +1, 0, $annee));

            $startTime = mktime(0, 0, 0, date('m')-1 , 1 , date('Y')); 
            $endTime = mktime(23, 59, 59, date('m'), date('d')-date('j'), date('Y'));
            $startTimeYear = mktime(0, 0, 0, 1, 1, date('Y')); 
            $endTimeYear = time();
            $ret = array() ;
            $this->db->select('m.id,m.prenom, m.nom, m.email, s.description as societe');
            $this->db->select('(SELECT SEC_TO_TIME(sum(time_cnx)) FROM stat_connexion where id_membres='.$stagiaire_id.' and date_cnx >="'.$endTime.'" and date_cnx <= "'.$d2.'") as duree_connexion');
            $this->db->select('(SELECT SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres="'.$stagiaire_id.'" and date_cnx >="'.$startTime.'" and date_cnx <= "'.$endTime.'") as duree_connexion_month_before');
            $this->db->select('(SELECT SEC_TO_TIME(sum(time_cnx)) from stat_connexion where id_membres='.$stagiaire_id.' and date_cnx >="'.$startTimeYear.'" and date_cnx <= "'.$endTimeYear.'") as duree_connexion_for_year');
            $this->db->select('from_unixtime((select date_cnx from stat_connexion where id_membres='.$stagiaire_id.' order by date_cnx desc limit 1,1)) as date_connexion');
            $this->db->select('m.nbconnexion, m.id_groupe');
            $this->db->from($this->table.' as m');
            $this->db->join($this->table_soc.' as s', 's.id_societe=m.id_societe','inner');
            $this->db->where('m.id', $stagiaire_id);
            $query = $this->db->get();
            return $query->num_rows();
        }

        public function ReplaceTime($val, $format=0) {
            $h = intval(intval($val) / 3600);
            if ($h < 10 && $format==0) {
                $h =  "0".$h;
            }

            $m = ((intval($val) / 60) % 60);
            if ($m < 10 && $format==0) {
                $m =  "0".$m;
            }

            $s = (intval($val) % 60);
            if ($s < 10 && $format==0) {
                $s = "0".$s;
            }

            switch($format) {
            case 0 :
                $res = $h.':'.$m.':'.$s;
                break;
            case 1 :
                $res = ($h>0?$h.' h ':'');
                $res.= ($m>0?$m.' mn ':'');
                $res.= ($s>0 || strlen($res)==0?$s.' s':'');
                break;
            }
            return($res);
        }

        public function getAllMembresGOk() {
            $this->db->select('m.*, s.id_stage_ext, s.id_individu_ext');
            $this->db->from($this->table.' as m');
            $this->db->join($this->table_grp.' as l','m.id_groupe=l.id_groupe','inner');
            $this->db->join($this->table_stage.' as s','s.id_stagiare_el=m.id AND m.extranet_id = s.id_individu_ext','inner');
            $this->db->where('l.glossaireenligne', 1);
            $this->db->group_by('m.id');
            $query = $this->db->get();
            return $query->result();
        }

        public function getIpAllMembres() {
            $this->db->select('*');
            $this->db->from($this->table_stat_connexion.' as s');
            $this->db->join($this->table.' as m','m.id=s.id_membres','inner');
            $this->db->where('s.id_adresse !=', '');
            $this->db->order_by('s.id_adresse,DATE_FORMAT(s.date_cnx, "%Y-%m-%d")');
            $query = $this->db->get();
            return $query->result();
        }

        public function Ganesha2011_getnodocuments($groupe_id) {
            $this->db->select('count(*) as documents');
            $this->db->from('document');
            $this->db->where('groupe', $groupe_id);
            $this->db->where('lien', '');
            $query = $this->db->get();
            $result = $query->result();
            foreach ($result as $res){
                return $res->documents;           
            }
        }
        public function Ganesha2011_getnoliens($groupe_id) {
            $this->db->select('count(*) as liens');
            $this->db->from('document');
            $this->db->where('groupe', $groupe_id);
            $this->db->where('lien', 'lien');
            $query = $this->db->get();
            $result = $query->result();
            foreach ($result as $res){
                return $res->liens;           
            }
                   
        }

        public function Ganesha2011_getdetailsConnexions($idu, $idg) {
            $ret = $this->log_model->read($idu) ;
            if ( $ret['cnt'] > 0 ) {
                $tot = 0 ;
                $t1 = 0 ;
                $t2 = 0 ;
                for ( $i=0; $i<$ret['cnt']; $i++) {
                    if (isset($ret[$i]['time'])) {
                        $res = explode(':',$ret[$i]['time']) ;
                        if (isset($res[1])) {
                            $t1 = $res[1] ;
                        }
                        if (isset($res[2])) {
                            $t2 = $res[2] ;
                        }

                        $tot = $tot + ($res[0]) + $t1 + $t2;
                    }

                }
                return $this->ReplaceTime($tot);
            }
            
        }

        public function VerifPwdLogin($pwd,$login,$idu=-1) {
            // mdp
            $pwd = strip_tags($pwd);
            if ( strlen(trim($pwd)) == 0 ) {
                return(false);
            }
            if ( strlen(trim($pwd)) < NB_CAR_MDP ) {
                return(false);
            }
            // identifiant
            if ( strlen(trim($login)) == 0 ) {
                return(false);
            }
            if ( strlen(trim($login)) < NB_CAR_LOGIN ) {
                return(false);
            }

            $this->db->select('login');
            $this->db->from($this->table);
            $this->db->where('password', $pwd);
            $this->db->where('login ', $login);
            if ($idu!=-1) {
                $this->db->where('id <> ', $idu);
            }    
            $query = $this->db->get();
            return($query->num_rows() == 0);
        }

        public function emailExist($idu,$email) {
            if ( strlen(trim($email)) == 0 ) {
                return(false);
            }
            if ( ! $this->isEmail($email) ) {
                return(false);
            }

            $this->db->select('id');
            $this->db->from($this->table);
            $this->db->where('email', $email);
            if ($idu!=-1) {
                $this->db->where('id <> ', $idu);
            }    
            $query = $this->db->get();
            return($query->num_rows() > 0);
        }
        
        public function isEmail($email){
            $ret    = false ;
            $name   = ""    ;
            $domain = ""    ;
            @list($name, $domain) = @explode("@", $email) ;
            if( !strstr($email, " ") && @strstr($domain, ".") ){
                $ret = true;
            }
            return($ret);
        }

        public function getByExtranetId($extranet_id) {
            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->where('extranet_id', $extranet_id);
            $query = $this->db->get();
            return $query->result();                   
        }

        public function getById($id) {
            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->where('id', $id);
            $query = $this->db->get();
            return $query->result();                   
        }


        public function getProfByExtranetId($extranet_id) {
            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->where('extranet_id', $extranet_id);
            $this->db->where('type', 3);
            $this->db->order_by('date_creation', 'DESC');
            $this->db->limit(1);
            $query = $this->db->get();
            return $query->result();                   
        }

        public function updateByExtranetId($extranet_id,$data) {
            $test = array();
            $this->db->where('extranet_id', $extranet_id);
            if($this->db->update($this->table, $data)){
                $test['rum'] = $this->db->affected_rows();
            }
            else{
                $test['error'] =  $this->db->error();
            }
            return $test;
        }

        public function add($additional_data){
            $this->db->trans_start();
            $this->db->insert($this->table, $additional_data);       
            $id = $this->db->insert_id();        
            $this->db->trans_complete();
            return $id;  
        }

        public function addProfil($sql){
            if ($this->db->simple_query($sql)) {
                return 'success';
            }
            else{
                return $this->db->error();
            }
        }

        public function getMaxIdGroup() {
            $this->db->select('max(id_groupe) AS idGrpMax');
            $this->db->from($this->table);
            $query = $this->db->get();
            $result = $query->result();
            $ret = "";
            if ($query->num_rows() != 0) {
                foreach ($result as $res){
                    $ret .= $res->idGrpMax ;
                }
            }       
            return($ret);
        }

        /**
         * Misc functions
         *
         * Hash password : Hashes the password to be stored in the database.
         * Hash password db : This function takes a password and validates it
         * against an entry in the users table.
         * Salt : Generates a random salt value.
         *
         * @author Mathew
         */

        /**
         * Hashes the password to be stored in the database.
         *
         * @return void
         * @author Mathew
         **/
        public function hash_password($password, $salt=false, $use_sha1_override=FALSE)
        {
            if (empty($password))
            {
                return FALSE;
            }

            // bcrypt
            if ($use_sha1_override === FALSE && $this->hash_method == 'bcrypt')
            {
                return $this->bcrypt->hash($password);
            }


            if ($this->store_salt && $salt)
            {
                return  sha1($password . $salt);
            }
            else
            {
                $salt = $this->salt();
                return  $salt . substr(sha1($salt . $password), 0, -$this->salt_length);
            }
        }

        /**
         * This function takes a password and validates it
         * against an entry in the users table.
         *
         * @return void
         * @author Mathew
         **/
        public function hash_password_db($id, $password, $use_sha1_override=FALSE)
        {
            if (empty($id) || empty($password))
            {
                return FALSE;
            }

            $this->trigger_events('extra_where');

            $query = $this->db->select('password, salt')
                              ->where('id', $id)
                              ->limit(1)
                              ->order_by('id', 'desc')
                              ->get($this->table);

            $hash_password_db = $query->row();

            if ($query->num_rows() !== 1)
            {
                return FALSE;
            }

            // bcrypt
            if ($use_sha1_override === FALSE && $this->hash_method == 'bcrypt')
            {
                if ($this->bcrypt->verify($password,$hash_password_db->password))
                {
                    return TRUE;
                }

                return FALSE;
            }

            // sha1
            if ($this->store_salt)
            {
                $db_password = sha1($password . $hash_password_db->salt);
            }
            else
            {
                $salt = substr($hash_password_db->password, 0, $this->salt_length);

                $db_password =  $salt . substr(sha1($salt . $password), 0, -$this->salt_length);
            }

            if($db_password == $hash_password_db->password)
            {
                return TRUE;
            }
            else
            {
                return FALSE;
            }
        }

        /**
         * Insert a forgotten password key.
         *
         * @return bool
         * @author Mathew
         * @updated Ryan
         * @updated 52aa456eef8b60ad6754b31fbdcc77bb
         **/
        public function forgotten_password($membresId,$identity)
        {
            if (empty($identity))
            {
                return FALSE;
            }

            // All some more randomness
            $activation_code_part = "";
            if(function_exists("openssl_random_pseudo_bytes")) {
                $activation_code_part = openssl_random_pseudo_bytes(128);
            }

            for($i=0;$i<1024;$i++) {
                $activation_code_part = sha1($activation_code_part . mt_rand() . microtime());
            }

            $key = $this->hash_code($activation_code_part.$identity);

            // If enable query strings is set, then we need to replace any unsafe characters so that the code can still work
            if ($key != '' && $this->config->item('permitted_uri_chars') != '' && $this->config->item('enable_query_strings') == FALSE)
            {
                // preg_quote() in PHP 5.3 escapes -, so the str_replace() and addition of - to preg_quote() is to maintain backwards
                // compatibility as many are unaware of how characters in the permitted_uri_chars will be parsed as a regex pattern
                if ( ! preg_match("|^[".str_replace(array('\\-', '\-'), '-', preg_quote($this->config->item('permitted_uri_chars'), '-'))."]+$|i", $key))
                {
                    $key = preg_replace("/[^".$this->config->item('permitted_uri_chars')."]+/i", "-", $key);
                }
            }

            $this->forgotten_password_code = $key;

            $update = array(
                'forgotten_password_code' => $key,
                'forgotten_password_time' => time()
            );

            $this->db->where('id', $membresId);
            $this->db->update($this->table, $update);
            $this->db->affected_rows();

            return true;
        }

        /**
         * Generates a random salt value for forgotten passwords or any other keys. Uses SHA1.
         *
         * @return void
         * @author Mathew
         **/
        public function hash_code($password)
        {
            return $this->hash_password($password, FALSE, TRUE);
        }

        /**
         * Generates a random salt value.
         *
         *
         * @return void
         * @author Anthony Ferrera
         **/
        public function salt()
        {

            $raw_salt_len = 16;

            $buffer = '';
            $buffer_valid = false;

            if (function_exists('random_bytes')) {
              $buffer = random_bytes($raw_salt_len);
              if ($buffer) {
                $buffer_valid = true;
              }
            }

            if (!$buffer_valid && function_exists('mcrypt_create_iv') && !defined('PHALANGER')) {
                 $buffer = mcrypt_create_iv($raw_salt_len, MCRYPT_DEV_URANDOM);
                if ($buffer) {
                    $buffer_valid = true;
                }
            }

            if (!$buffer_valid && function_exists('openssl_random_pseudo_bytes')) {
                $buffer = openssl_random_pseudo_bytes($raw_salt_len);
                if ($buffer) {
                    $buffer_valid = true;
                }
            }

            if (!$buffer_valid && @is_readable('/dev/urandom')) {
                $f = fopen('/dev/urandom', 'r');
                $read = strlen($buffer);
                while ($read < $raw_salt_len) {
                    $buffer .= fread($f, $raw_salt_len - $read);
                    $read = strlen($buffer);
                }
                fclose($f);
                if ($read >= $raw_salt_len) {
                    $buffer_valid = true;
                }
            }

            if (!$buffer_valid || strlen($buffer) < $raw_salt_len) {
                $bl = strlen($buffer);
                for ($i = 0; $i < $raw_salt_len; $i++) {
                    if ($i < $bl) {
                        $buffer[$i] = $buffer[$i] ^ chr(mt_rand(0, 255));
                    } else {
                        $buffer .= chr(mt_rand(0, 255));
                    }
                }
            }

            $salt = $buffer;

            // encode string with the Base64 variant used by crypt
            $base64_digits   = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
            $bcrypt64_digits = './ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
            $base64_string   = base64_encode($salt);
            $salt = strtr(rtrim($base64_string, '='), $base64_digits, $bcrypt64_digits);

            $salt = substr($salt, 0, $this->salt_length);


            return $salt;

        }


        /**
         * Identity check
         *
         * @return bool
         * @author Mathew
         **/
        public function identity_check($identity = '')
        {
            $this->trigger_events('identity_check');

            if (empty($identity))
            {
                return FALSE;
            }

            return $this->db->where($this->identity_column, $identity)
                            ->count_all_results($this->table) > 0;
        }


        /**
         * register
         *
         * @return bool
         * @author Mathew
         **/
        public function register($identity, $password, $email, $additional_data = array(), $groups)
        {
            $this->trigger_events('pre_register');

            $manual_activation = $this->config->item('manual_activation', 'el_f2plus_auth');

            if ($this->identity_check($identity))
            {
                $this->set_error('account_creation_duplicate_identity');
                return FALSE;
            }

            // IP Address
            $ip_address = $this->_prepare_ip($this->input->ip_address());
            $salt       = $this->store_salt ? $this->salt() : FALSE;
            $password   = $this->hash_password($password, $salt);

            // Users table.
            $data = array(
                $this->identity_column   => $identity,
                'username'   => $identity,
                'password'   => $password,
                'email'      => $email,
                'ip_address' => $ip_address,
                'created_on' => time(),
                'active'     => ($manual_activation === false ? 1 : 0)
            );

            if ($this->store_salt)
            {
                $data['salt'] = $salt;
            }

            // filter out any data passed that doesnt have a matching column in the users table
            // and merge the set user data and the additional data
            $user_data = array_merge($this->_filter_data($this->table, $additional_data), $data);

            $this->trigger_events('extra_set');

            $this->db->insert($this->table, $user_data);

            $id = $this->db->insert_id();

            // add in groups array if it doesn't exists and stop adding into default group if default group ids are set
            /*if( isset($default_group->id) && empty($groups) )
            {
                $groups[] = $default_group->id;
            }

            if (!empty($groups))
            {
                // add to groups
                foreach ($groups as $group)
                {
                    $this->add_to_group($group, $id);
                }
            }*/
            $this->add_to_group($groups, $id);

            $this->trigger_events('post_register');

            return (isset($id)) ? $id : FALSE;
        }

        /**
         * login
         *
         * @return bool
         * @author Mathew
         **/
        public function login($identity, $password, $remember=FALSE)
        {
            $this->trigger_events('pre_login');

            if (empty($identity) || empty($password))
            {
                $this->set_error('login_unsuccessful');
                return FALSE;
            }
            $return = 0;

            $this->trigger_events('extra_where');
            $this->db->select('m.*, l.description');
            $this->db->from($this->table.' as m');
            $this->db->join($this->table_soc.' as l', 'l.id_societe = m.id_societe', 'left');
            $this->db->where('m.'.$this->identity_column, $identity);
            $this->db->limit(1);
            $query = $this->db->get();  

            if($this->is_time_locked_out($identity))
            {
                // Hash something anyway, just to take up time
                $this->hash_password($password);

                $this->trigger_events('post_login_unsuccessful');
                $this->set_error('login_timeout');

                return FALSE;
            }

            if ($query->num_rows() === 1)
            {
                $user = $query->row();

                $password = $this->hash_password_db($user->id, $password);

                if ($password === TRUE)
                {


                    if ($remember && $this->config->item('remember_users', 'el_f2plus_auth'))
                    {
                        $this->remember_user($user->id);
                    }

                    
                    return $query->result();
                }
            }

            // Hash something anyway, just to take up time
            $this->hash_password($password);

            $this->increase_login_attempts($identity);

            $this->trigger_events('post_login_unsuccessful');
            $this->set_error('login_unsuccessful');

            return FALSE;
        }

        public function get ()
        {
            $params = $this->books();
            $limit = $params[0]['limit'] ? $params[0]['limit'] : 0;
            $offset = $params[0]['offset'] ? $params[0]['offset'] : 0;
            
            $items = $this->_get_items();
            $ret_array = array();
            
            for ($i = 0; $i < $limit; $i ++) {
                if ($offset < count($items)) {
                    $ret_array[] = $items[$offset];
                    $offset ++;
                }
            }
            
            return $ret_array;
        }

        /**
         * is_max_login_attempts_exceeded
         * Based on code from Tank Auth, by Ilya Konyukhov (https://github.com/ilkon/Tank-Auth)
         *
         * @param string $identity
         * @return boolean
         **/
        public function is_max_login_attempts_exceeded($identity) {
            if ($this->config->item('track_login_attempts', 'el_f2plus_auth')) {
                $max_attempts = $this->config->item('maximum_login_attempts', 'el_f2plus_auth');
                if ($max_attempts > 0) {
                    $attempts = $this->get_attempts_num($identity);
                    return $attempts >= $max_attempts;
                }
            }
            return FALSE;
        }

        /**
         * Get number of attempts to login occured from given IP-address or identity
         * Based on code from Tank Auth, by Ilya Konyukhov (https://github.com/ilkon/Tank-Auth)
         *
         * @param   string $identity
         * @return  int
         */
        public function get_attempts_num($identity)
        {
            if ($this->config->item('track_login_attempts', 'el_f2plus_auth')) {
                $ip_address = $this->_prepare_ip($this->input->ip_address());
                $this->db->select('1', FALSE);
                if ($this->config->item('track_login_ip_address', 'el_f2plus_auth')) {
                    $this->db->where('ip_address', $ip_address);
                    $this->db->where('login', $identity);
                } else if (strlen($identity) > 0) $this->db->or_where('login', $identity);
                $qres = $this->db->get($this->tables['login_attempts']);
                return $qres->num_rows();
            }
            return 0;
        }

        /**
         * Get a boolean to determine if an account should be locked out due to
         * exceeded login attempts within a given period
         *
         * @return  boolean
         */
        public function is_time_locked_out($identity) {

            return $this->is_max_login_attempts_exceeded($identity) && $this->get_last_attempt_time($identity) > time() - $this->config->item('lockout_time', 'el_f2plus_auth');
        }

        /**
         * Get the time of the last time a login attempt occured from given IP-address or identity
         *
         * @param   string $identity
         * @return  int
         */
        public function get_last_attempt_time($identity) {
            if ($this->config->item('track_login_attempts', 'el_f2plus_auth')) {
                $ip_address = $this->_prepare_ip($this->input->ip_address());

                $this->db->select('time');
                if ($this->config->item('track_login_ip_address', 'el_f2plus_auth')) $this->db->where('ip_address', $ip_address);
                else if (strlen($identity) > 0) $this->db->or_where('login', $identity);
                $this->db->order_by('id', 'desc');
                $qres = $this->db->get($this->tables['login_attempts'], 1);

                if($qres->num_rows() > 0) {
                    return $qres->row()->time;
                }
            }

            return 0;
        }

        /**
         * increase_login_attempts
         * Based on code from Tank Auth, by Ilya Konyukhov (https://github.com/ilkon/Tank-Auth)
         *
         * @param string $identity
         **/
        public function increase_login_attempts($identity) {
            if ($this->config->item('track_login_attempts', 'el_f2plus_auth')) {
                $ip_address = $this->_prepare_ip($this->input->ip_address());
                return $this->db->insert($this->tables['login_attempts'], array('ip_address' => $ip_address, 'login' => $identity, 'time' => time()));
            }
            return FALSE;
        }


        public function limit($limit)
        {
            $this->trigger_events('limit');
            $this->_ion_limit = $limit;

            return $this;
        }

        public function offset($offset)
        {
            $this->trigger_events('offset');
            $this->_ion_offset = $offset;

            return $this;
        }

        public function where($where, $value = NULL)
        {
            $this->trigger_events('where');

            if (!is_array($where))
            {
                $where = array($where => $value);
            }

            array_push($this->_ion_where, $where);

            return $this;
        }

        public function like($like, $value = NULL, $position = 'both')
        {
            $this->trigger_events('like');

            array_push($this->_ion_like, array(
                'like'     => $like,
                'value'    => $value,
                'position' => $position
            ));

            return $this;
        }

        public function select($select)
        {
            $this->trigger_events('select');

            $this->_ion_select[] = $select;

            return $this;
        }

        public function order_by($by, $order='desc')
        {
            $this->trigger_events('order_by');

            $this->_ion_order_by = $by;
            $this->_ion_order    = $order;

            return $this;
        }

        public function row()
        {
            $this->trigger_events('row');

            $row = $this->response->row();

            return $row;
        }

        public function row_array()
        {
            $this->trigger_events(array('row', 'row_array'));

            $row = $this->response->row_array();

            return $row;
        }

        public function result()
        {
            $this->trigger_events('result');

            $result = $this->response->result();

            return $result;
        }

        public function result_array()
        {
            $this->trigger_events(array('result', 'result_array'));

            $result = $this->response->result_array();

            return $result;
        }

        public function num_rows()
        {
            $this->trigger_events(array('num_rows'));

            $result = $this->response->num_rows();

            return $result;
        }

        /**
         * users
         *
         * @return object Users
         * @author Ben Edmunds
         **/
        public function users($groups = NULL)
        {
            $this->trigger_events('users');

            if (isset($this->_ion_select) && !empty($this->_ion_select))
            {
                foreach ($this->_ion_select as $select)
                {
                    $this->db->select($select);
                }

                $this->_ion_select = array();
            }
            else
            {
                //default selects
                $this->db->select(array(
                    $this->table.'.*',
                    $this->table.'.id as id',
                    $this->table.'.id as user_id'
                ));
            }

            // filter by group id(s) if passed
            if (isset($groups))
            {
                // build an array if only one group was passed
                if (!is_array($groups))
                {
                    $groups = Array($groups);
                }

                // join and then run a where_in against the group ids
                if (isset($groups) && !empty($groups))
                {
                    $this->db->distinct();
                    $this->db->join(
                        $this->tables['users_groups'],
                        $this->tables['users_groups'].'.'.$this->join['users'].'='.$this->table.'.id',
                        'inner'
                    );
                }

                // verify if group name or group id was used and create and put elements in different arrays
                $group_ids = array();
                $group_names = array();
                foreach($groups as $group)
                {
                    if(is_numeric($group)) $group_ids[] = $group;
                    else $group_names[] = $group;
                }
                $or_where_in = (!empty($group_ids) && !empty($group_names)) ? 'or_where_in' : 'where_in';
                // if group name was used we do one more join with groups
                if(!empty($group_names))
                {
                    $this->db->join($this->tables['groups'], $this->tables['users_groups'] . '.' . $this->join['groups'] . ' = ' . $this->tables['groups'] . '.id', 'inner');
                    $this->db->where_in($this->tables['groups'] . '.name', $group_names);
                }
                if(!empty($group_ids))
                {
                    $this->db->{$or_where_in}($this->tables['users_groups'].'.'.$this->join['groups'], $group_ids);
                }
            }

            $this->trigger_events('extra_where');

            // run each where that was passed
            if (isset($this->_ion_where) && !empty($this->_ion_where))
            {
                foreach ($this->_ion_where as $where)
                {
                    $this->db->where($where);
                }

                $this->_ion_where = array();
            }

            if (isset($this->_ion_like) && !empty($this->_ion_like))
            {
                foreach ($this->_ion_like as $like)
                {
                    $this->db->or_like($like['like'], $like['value'], $like['position']);
                }

                $this->_ion_like = array();
            }

            if (isset($this->_ion_limit) && isset($this->_ion_offset))
            {
                $this->db->limit($this->_ion_limit, $this->_ion_offset);

                $this->_ion_limit  = NULL;
                $this->_ion_offset = NULL;
            }
            else if (isset($this->_ion_limit))
            {
                $this->db->limit($this->_ion_limit);

                $this->_ion_limit  = NULL;
            }

            // set the order
            if (isset($this->_ion_order_by) && isset($this->_ion_order))
            {
                $this->db->order_by($this->_ion_order_by, $this->_ion_order);

                $this->_ion_order    = NULL;
                $this->_ion_order_by = NULL;
            }

            $this->response = $this->db->get($this->table);

            return $this;
        }

        /**
         * user
         *
         * @return object
         * @author Ben Edmunds
         **/
        public function user($id = NULL)
        {
            $this->trigger_events('user');

            // if no id was passed use the current users id
            $id = isset($id) ? $id : $this->session->userdata('user_id');

            $this->limit(1);
            $this->order_by($this->table.'.id', 'desc');
            $this->where($this->table.'.id', $id);

            $this->users();

            return $this;
        }


        /**
         * get_users_groups
         *
         * @return array
         * @author Ben Edmunds
         **/
        public function get_users_groups($id=FALSE)
        {
            $this->trigger_events('get_users_group');

            // if no id was passed use the current users id
            $id || $id = $this->session->userdata('user_id');

            return $this->db->select($this->tables['users_groups'].'.'.$this->join['groups'].' as id, '.$this->tables['groups'].'.name, '.$this->tables['groups'].'.description')
                            ->where($this->tables['users_groups'].'.'.$this->join['users'], $id)
                            ->join($this->tables['groups'], $this->tables['users_groups'].'.'.$this->join['groups'].'='.$this->tables['groups'].'.id')
                            ->get($this->tables['users_groups']);
        }

        /**
         * add_to_group
         *
         * @return bool
         * @author Ben Edmunds
         **/
        public function add_to_group($group_ids, $user_id=false)
        {
            $this->trigger_events('add_to_group');

            // if no id was passed use the current users id
            $user_id || $user_id = $this->session->userdata('user_id');

            if(!is_array($group_ids))
            {
                $group_ids = array($group_ids);
            }

            $return = 0;

            // Then insert each into the database
            foreach ($group_ids as $group_id)
            {
                if ($this->db->insert($this->tables['users_groups'], array( $this->join['groups'] => (float)$group_id, $this->join['users'] => (float)$user_id)))
                {
                    if (isset($this->_cache_groups[$group_id])) {
                        $group_name = $this->_cache_groups[$group_id];
                    }
                    else {
                        $group = $this->group($group_id)->result();
                        $group_name = $group[0]->name;
                        $this->_cache_groups[$group_id] = $group_name;
                    }
                    $this->_cache_user_in_group[$user_id][$group_id] = $group_name;

                    // Return the number of groups added
                    $return += 1;
                }
            }

            return $return;
        }

        /**
         * remove_from_group
         *
         * @return bool
         * @author Ben Edmunds
         **/
        public function remove_from_group($group_ids=false, $user_id=false)
        {
            $this->trigger_events('remove_from_group');

            // user id is required
            if(empty($user_id))
            {
                return FALSE;
            }

            // if group id(s) are passed remove user from the group(s)
            if( ! empty($group_ids))
            {
                if(!is_array($group_ids))
                {
                    $group_ids = array($group_ids);
                }

                foreach($group_ids as $group_id)
                {
                    $this->db->delete($this->tables['users_groups'], array($this->join['groups'] => (float)$group_id, $this->join['users'] => (float)$user_id));
                    if (isset($this->_cache_user_in_group[$user_id]) && isset($this->_cache_user_in_group[$user_id][$group_id]))
                    {
                        unset($this->_cache_user_in_group[$user_id][$group_id]);
                    }
                }

                $return = TRUE;
            }
            // otherwise remove user from all groups
            else
            {
                if ($return = $this->db->delete($this->tables['users_groups'], array($this->join['users'] => (float)$user_id))) {
                    $this->_cache_user_in_group[$user_id] = array();
                }
            }
            return $return;
        }

        /**
         * groups
         *
         * @return object
         * @author Ben Edmunds
         **/
        public function groups()
        {
            $this->trigger_events('groups');

            // run each where that was passed
            if (isset($this->_ion_where) && !empty($this->_ion_where))
            {
                foreach ($this->_ion_where as $where)
                {
                    $this->db->where($where);
                }
                $this->_ion_where = array();
            }

            if (isset($this->_ion_limit) && isset($this->_ion_offset))
            {
                $this->db->limit($this->_ion_limit, $this->_ion_offset);

                $this->_ion_limit  = NULL;
                $this->_ion_offset = NULL;
            }
            else if (isset($this->_ion_limit))
            {
                $this->db->limit($this->_ion_limit);

                $this->_ion_limit  = NULL;
            }

            // set the order
            if (isset($this->_ion_order_by) && isset($this->_ion_order))
            {
                $this->db->order_by($this->_ion_order_by, $this->_ion_order);
            }

            $this->response = $this->db->get($this->tables['groups']);

            return $this;
        }

        /**
         * group
         *
         * @return object
         * @author Ben Edmunds
         **/
        public function group($id = NULL)
        {
            $this->trigger_events('group');

            if (isset($id))
            {
                $this->where($this->tables['groups'].'.id', $id);
            }

            $this->limit(1);
            $this->order_by('id', 'desc');

            return $this->groups();
        }

        /**
         * update
         *
         * @return bool
         * @author Phil Sturgeon
         **/
        /*public function update($id, array $data)
        {
            $this->trigger_events('pre_update_user');

            $user = $this->user($id)->row();

            $this->db->trans_begin();

            if (array_key_exists($this->identity_column, $data) && $this->identity_check($data[$this->identity_column]) && $user->{$this->identity_column} !== $data[$this->identity_column])
            {
                $this->db->trans_rollback();
                $this->set_error('account_creation_duplicate_identity');

                $this->trigger_events(array('post_update_user', 'post_update_user_unsuccessful'));
                $this->set_error('update_unsuccessful');

                return FALSE;
            }

            // Filter the data passed
            $data = $this->_filter_data($this->table, $data);

            if (array_key_exists($this->identity_column, $data) || array_key_exists('password', $data) || array_key_exists('email', $data))
            {
                if (array_key_exists('password', $data))
                {
                    if( ! empty($data['password']))
                    {
                        $data['password'] = $this->hash_password($data['password'], $user->salt);
                    }
                    else
                    {
                        // unset password so it doesn't effect database entry if no password passed
                        unset($data['password']);
                    }
                }
            }

            $this->trigger_events('extra_where');
            $this->db->update($this->table, $data, array('id' => $user->id));

            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();

                $this->trigger_events(array('post_update_user', 'post_update_user_unsuccessful'));
                $this->set_error('update_unsuccessful');
                return FALSE;
            }

            $this->db->trans_commit();

            $this->trigger_events(array('post_update_user', 'post_update_user_successful'));
            $this->set_message('update_successful');
            return TRUE;
        }*/



        public function delete_user($id)
        {
            $this->trigger_events('pre_delete_user');

            $this->db->trans_begin();

            // remove user from groups
            $this->remove_from_group(NULL, $id);

            // delete user from users table should be placed after remove from group
            $this->db->delete($this->table, array('id' => $id));


            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
                $this->trigger_events(array('post_delete_user', 'post_delete_user_unsuccessful'));
                $this->set_error('delete_unsuccessful');
                return FALSE;
            }

            $this->db->trans_commit();

            $this->trigger_events(array('post_delete_user', 'post_delete_user_successful'));
            $this->set_message('delete_successful');
            return TRUE;
        }


        /**
         * set_lang
         *
         * @return bool
         * @author Ben Edmunds
         **/
        public function set_lang($lang = 'en')
        {
            $this->trigger_events('set_lang');

            // if the user_expire is set to zero we'll set the expiration two years from now.
            if($this->config->item('user_expire', 'el_f2plus_auth') === 0)
            {
                $expire = (60*60*24*365*2);
            }
            // otherwise use what is set
            else
            {
                $expire = $this->config->item('user_expire', 'el_f2plus_auth');
            }

            set_cookie(array(
                'name'   => 'lang_code',
                'value'  => $lang,
                'expire' => $expire
            ));

            return TRUE;
        }

        /**
         * set_session
         *
         * @return bool
         * @author jrmadsen67
         **/
        public function set_session($user)
        {

            $this->trigger_events('pre_set_session');

            $session_data = array(
                'identity'             => $user->{$this->identity_column},
                $this->identity_column             => $user->{$this->identity_column},
                'email'                => $user->email,
                'user_id'              => $user->id, //everyone likes to overwrite id so we'll use user_id
                'old_last_login'       => $user->last_login,
                'last_check'           => time(),
            );

            $this->session->set_userdata($session_data);

            $this->trigger_events('post_set_session');

            return TRUE;
        }

        /**
         * remember_user
         *
         * @return bool
         * @author Ben Edmunds
         **/
        public function remember_user($id)
        {
            $this->trigger_events('pre_remember_user');

            if (!$id)
            {
                return FALSE;
            }

            $user = $this->user($id)->row();

            $salt = $this->salt();

            $this->db->update($this->table, array('remember_code' => $salt), array('id' => $id));

            if ($this->db->affected_rows() > -1)
            {
                // if the user_expire is set to zero we'll set the expiration two years from now.
                if($this->config->item('user_expire', 'el_f2plus_auth') === 0)
                {
                    $expire = (60*60*24*365*2);
                }
                // otherwise use what is set
                else
                {
                    $expire = $this->config->item('user_expire', 'el_f2plus_auth');
                }

                set_cookie(array(
                    'name'   => $this->config->item('identity_cookie_name', 'el_f2plus_auth'),
                    'value'  => $user->{$this->identity_column},
                    'expire' => $expire
                ));

                set_cookie(array(
                    'name'   => $this->config->item('remember_cookie_name', 'el_f2plus_auth'),
                    'value'  => $salt,
                    'expire' => $expire
                ));

                $this->trigger_events(array('post_remember_user', 'remember_user_successful'));
                return TRUE;
            }

            $this->trigger_events(array('post_remember_user', 'remember_user_unsuccessful'));
            return FALSE;
        }

        /**
         * login_remembed_user
         *
         * @return bool
         * @author Ben Edmunds
         **/
        public function login_remembered_user()
        {
            $this->trigger_events('pre_login_remembered_user');

            // check for valid data
            if (!get_cookie($this->config->item('identity_cookie_name', 'el_f2plus_auth'))
                || !get_cookie($this->config->item('remember_cookie_name', 'el_f2plus_auth'))
                || !$this->identity_check(get_cookie($this->config->item('identity_cookie_name', 'el_f2plus_auth'))))
            {
                $this->trigger_events(array('post_login_remembered_user', 'post_login_remembered_user_unsuccessful'));
                return FALSE;
            }

            // get the user
            $this->trigger_events('extra_where');
            $query = $this->db->select($this->identity_column.', id, email, last_login')
                              ->where($this->identity_column, urldecode(get_cookie($this->config->item('identity_cookie_name', 'el_f2plus_auth'))))
                              ->where('remember_code', get_cookie($this->config->item('remember_cookie_name', 'el_f2plus_auth')))
                      ->where('active',1)
                              ->limit(1)
                              ->order_by('id', 'desc')
                              ->get($this->table);

            // if the user was found, sign them in
            if ($query->num_rows() == 1)
            {
                $user = $query->row();

                $this->update_last_login($user->id);

                $this->set_session($user);

                // extend the users cookies if the option is enabled
                if ($this->config->item('user_extend_on_login', 'el_f2plus_auth'))
                {
                    $this->remember_user($user->id);
                }

                $this->trigger_events(array('post_login_remembered_user', 'post_login_remembered_user_successful'));
                return TRUE;
            }

            $this->trigger_events(array('post_login_remembered_user', 'post_login_remembered_user_unsuccessful'));
            return FALSE;
        }


        /**
         * create_group
         *
         * @author aditya menon
        */
        public function create_group($group_name = FALSE, $group_description = '', $additional_data = array())
        {
            // bail if the group name was not passed
            if(!$group_name)
            {
                $this->set_error('group_name_required');
                return FALSE;
            }

            // bail if the group name already exists
            $existing_group = $this->db->get_where($this->tables['groups'], array('name' => $group_name))->num_rows();
            if($existing_group !== 0)
            {
                $this->set_error('group_already_exists');
                return FALSE;
            }

            $data = array('name'=>$group_name,'description'=>$group_description);

            // filter out any data passed that doesnt have a matching column in the groups table
            // and merge the set group data and the additional data
            if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['groups'], $additional_data), $data);

            $this->trigger_events('extra_group_set');

            // insert the new group
            $this->db->insert($this->tables['groups'], $data);
            $group_id = $this->db->insert_id();

            // report success
            $this->set_message('group_creation_successful');
            // return the brand new group id
            return $group_id;
        }

        /**
         * update_group
         *
         * @return bool
         * @author aditya menon
         **/
        public function update_group($group_id = FALSE, $group_name = FALSE, $additional_data = array())
        {
            if (empty($group_id)) return FALSE;

            $data = array();

            if (!empty($group_name))
            {
                // we are changing the name, so do some checks

                // bail if the group name already exists
                $existing_group = $this->db->get_where($this->tables['groups'], array('name' => $group_name))->row();
                if(isset($existing_group->id) && $existing_group->id != $group_id)
                {
                    $this->set_error('group_already_exists');
                    return FALSE;
                }

                $data['name'] = $group_name;
            }

            // restrict change of name of the admin group
            $group = $this->db->get_where($this->tables['groups'], array('id' => $group_id))->row();
            if($this->config->item('admin_group', 'el_f2plus_auth') === $group->name && $group_name !== $group->name)
            {
                $this->set_error('group_name_admin_not_alter');
                return FALSE;
            }


            // IMPORTANT!! Third parameter was string type $description; this following code is to maintain backward compatibility
            // New projects should work with 3rd param as array
            if (is_string($additional_data)) $additional_data = array('description' => $additional_data);


            // filter out any data passed that doesnt have a matching column in the groups table
            // and merge the set group data and the additional data
            if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['groups'], $additional_data), $data);


            $this->db->update($this->tables['groups'], $data, array('id' => $group_id));

            $this->set_message('group_update_successful');

            return TRUE;
        }

        /**
        * delete_group
        *
        * @return bool
        * @author aditya menon
        **/
        public function delete_group($group_id = FALSE)
        {
            // bail if mandatory param not set
            if(!$group_id || empty($group_id))
            {
                return FALSE;
            }
            $group = $this->group($group_id)->row();
            if($group->name == $this->config->item('admin_group', 'el_f2plus_auth'))
            {
                $this->trigger_events(array('post_delete_group', 'post_delete_group_notallowed'));
                $this->set_error('group_delete_notallowed');
                return FALSE;
            }

            $this->trigger_events('pre_delete_group');

            $this->db->trans_begin();

            // remove all users from this group
            $this->db->delete($this->tables['users_groups'], array($this->join['groups'] => $group_id));
            // remove the group itself
            $this->db->delete($this->tables['groups'], array('id' => $group_id));

            if ($this->db->trans_status() === FALSE)
            {
                $this->db->trans_rollback();
                $this->trigger_events(array('post_delete_group', 'post_delete_group_unsuccessful'));
                $this->set_error('group_delete_unsuccessful');
                return FALSE;
            }

            $this->db->trans_commit();

            $this->trigger_events(array('post_delete_group', 'post_delete_group_successful'));
            $this->set_message('group_delete_successful');
            return TRUE;
        }

        public function set_hook($event, $name, $class, $method, $arguments)
        {
            $this->_ion_hooks->{$event}[$name] = new stdClass;
            $this->_ion_hooks->{$event}[$name]->class     = $class;
            $this->_ion_hooks->{$event}[$name]->method    = $method;
            $this->_ion_hooks->{$event}[$name]->arguments = $arguments;
        }

        public function remove_hook($event, $name)
        {
            if (isset($this->_ion_hooks->{$event}[$name]))
            {
                unset($this->_ion_hooks->{$event}[$name]);
            }
        }

        public function remove_hooks($event)
        {
            if (isset($this->_ion_hooks->$event))
            {
                unset($this->_ion_hooks->$event);
            }
        }

        protected function _call_hook($event, $name)
        {
            if (isset($this->_ion_hooks->{$event}[$name]) && method_exists($this->_ion_hooks->{$event}[$name]->class, $this->_ion_hooks->{$event}[$name]->method))
            {
                $hook = $this->_ion_hooks->{$event}[$name];

                return call_user_func_array(array($hook->class, $hook->method), $hook->arguments);
            }

            return FALSE;
        }

        public function trigger_events($events)
        {
            if (is_array($events) && !empty($events))
            {
                foreach ($events as $event)
                {
                    $this->trigger_events($event);
                }
            }
            else
            {
                if (isset($this->_ion_hooks->$events) && !empty($this->_ion_hooks->$events))
                {
                    foreach ($this->_ion_hooks->$events as $name => $hook)
                    {
                        $this->_call_hook($events, $name);
                    }
                }
            }
        }


        /**
         * set_message
         *
         * Set a message
         *
         * @return void
         * @author Ben Edmunds
         **/
        public function set_message($message)
        {
            $this->messages[] = $message;

            return $message;
        }



        /**
         * messages
         *
         * Get the messages
         *
         * @return void
         * @author Ben Edmunds
         **/
        public function messages()
        {
            $_output = '';
            foreach ($this->messages as $message)
            {
                $messageLang = $this->lang->line($message) ? $this->lang->line($message) : '##' . $message . '##';
                $_output .= $this->message_start_delimiter . $messageLang . $this->message_end_delimiter;
            }

            return $_output;
        }


        /**
         * clear_messages
         *
         * Clear messages
         *
         * @return void
         * @author Ben Edmunds
         **/
        public function clear_messages()
        {
            $this->messages = array();

            return TRUE;
        }


        /**
         * set_error
         *
         * Set an error message
         *
         * @return void
         * @author Ben Edmunds
         **/
        public function set_error($error)
        {
            $this->errors[] = $error;

            return $error;
        }

        /**
         * errors
         *
         * Get the error message
         *
         * @return void
         * @author Ben Edmunds
         **/
        public function errors()
        {
            $_output = '';
            foreach ($this->errors as $error)
            {
                $errorLang = $this->lang->line($error) ? $this->lang->line($error) : '##' . $error . '##';
                $_output .= $this->error_start_delimiter . $errorLang . $this->error_end_delimiter;
            }

            return $_output;
        }


        protected function _filter_data($table, $data)
        {
            $filtered_data = array();
            $columns = $this->db->list_fields($table);

            if (is_array($data))
            {
                foreach ($columns as $column)
                {
                    if (array_key_exists($column, $data))
                        $filtered_data[$column] = $data[$column];
                }
            }

            return $filtered_data;
        }

        protected function _prepare_ip($ip_address) {
            // just return the string IP address now for better compatibility
            return $ip_address;
        }

        public function getInfoMembresByMail($email){

            $this->db->select('*');
            $this->db->from($this->table);
            $this->db->where('email', $email);
            $this->db->limit(1);
            $query = $this->db->get();
            
            return $query->result();
        }

        public function getAllDuplicateByConnexionDate($datetime) {
            $this->db->select('login');
            $this->db->from($this->table);
            $this->db->where('date_connexion >=', $datetime);
            $this->db->where('type', 0);
            $this->db->group_by('login');  
            $this->db->having('COUNT(login) >',1);  
            $query = $this->db->get(); 
            return $query->result()  ;
        }

        public function getAllInfosDuplicateByLoginAndDateTime($login,$datetime) {
            $this->db->select('id, login, prenom, nom, email, register_remember_pwd_time');
            $this->db->from($this->table);
            $this->db->where('date_connexion >=', $datetime);
            $this->db->where('login', $login);
            $query = $this->db->get(); 
            return $query->result()  ;
        }

        public function getInfosTypeDeCoursByStage($idStageCoursPlannifier){
            $this->db->select('if(`mode_acces` = "0", "COURS_EL", if(`mode_acces` = "1", "COURS_EL", if(`mode_acces` = "2", "COURS_EL", if(`mode_acces` = "3", "AUCTRES_COURS", "INCONNU")))) as typeDeCours');
            $this->db->from($this->table.' as m');
            $this->db->join($this->table_cours_plannifier.' as c', 'c.refIndividuStagiaireCoursPlannifier = m.extranet_id', 'INNER');
            $this->db->where('c.idStageCoursPlannifier', $idStageCoursPlannifier);
            $query = $this->db->get(); 
            $result =  $query->result()  ;
            return isset($result[0]->typeDeCours) ? $result[0]->typeDeCours : '';
        }

    }

?>
