<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Lib_time_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct();    
    }



    public function ReplaceDateTime($date) {
        if ($date == '') {
            return('');
        }
        return(date(FORMATDATETIME, $date));
    }

    /**
    * Retourne une date (sans l'heure) en utilisant le format formatDate
    * @param    integer $date   timestamp date a traiter
    * @access   public
    */
    public function ReplaceDate($date) {
        if ($date == '' ||
            $date < 0 || $date > 2147382000) {
            //2147382000 = timestamp max accepté à peu près. (19 Janvier 2038)
            return('');
        }
        return(date(FORMATDATE, $date));
    }

    /**
    * retourne une chaine au format voulu (0=>hh:mm:ss, 1=>2 h 36 mn)
    * @param    string  $val    valeur a afficher en sec
    * @param    integer $format indique le format du retour
    * @return string heure au format voulu
    * @access   public
    */
    public function ReplaceTime($val, $format=0) {
        $h = intval(intval($val) / 3600);
        if ($h < 10 && $format==0) {
            $h =  "0".$h;
        }

        $m = ((intval($val) / 60) % 60);
        if ($m < 10 && $format==0) {
            $m =  "0".$m;
        }

        $s = (intval($val) % 60);
        if ($s < 10 && $format==0) {
            $s = "0".$s;
        }

        switch($format) {
        case 0 :
            $res = $h.':'.$m.':'.$s;
            break;
        case 1 :
            $res = ($h>0?$h.' h ':'');
            $res.= ($m>0?$m.' mn ':'');
            $res.= ($s>0 || strlen($res)==0?$s.' s':'');
            break;
        }
        return($res);
    }

    /**
    * toTimeStamp()
    * Retourne le timestamp (en secondes) d'une date (au format JJ/MM/AA)
    * @param string  $date   la date à convertir
    * @return integer    timestamp
    * @access public
    **/
    public function toTimeStamp($date='') {
        if($date=='' || $date=='01/01/70'){
            //Si la date est vide, retourne le timestamp du jour
            return mktime (0, 0, 0, Date('m'), Date('d'), Date('Y'));;
        } else {
            $ret = explode('/', $date);
            $ret[0] = isset($ret[0])?$ret[0]:0 ;
            $ret[1] = isset($ret[1])?$ret[1]:0 ;
            $ret[2] = isset($ret[2])?$ret[2]:0 ;
            $res = @mktime(0,0,0,$ret[1], $ret[0], $ret[2]);
            return($res===-1?'01/01/70':$res);
        }
    }

   /**
   * Retourne le temps en secondes d'un temps au format hh:mm:ss
   * @param string  $time   le temps à convertir
   * @return integer temps en secondes
   * @access public
   **/
    public function toSeconds($time='') {
        $ret = explode(':', $time);
        $ret[0] = (!isset($ret[0]))?0:$ret[0] ;
        $ret[1] = (!isset($ret[1]) || isset($ret[1])>59)?0:$ret[1] ;
        $ret[2] = (!isset($ret[2]) || isset($ret[2])>59)?0:$ret[2] ;
        return $ret[0]*3600 + $ret[1]*60 + $ret[2];
    }

   /**
   * ExtractTime()
   * Retourne l'heure timestamp (en secondes) d'une date
   * @param integer $timestamp  la date à convertir
   * @return integer    timestamp
   * @access public
   **/
    public function ExtractTime($timestamp) {
        $val = ReplaceDateTime($timestamp) ;
        $res = 0 ;
        if ( strlen($val)>0) {
           $tab = explode(' ',$val);
           $tab = explode(':',$tab[1]);
           $res = ($tab[0]*3600)+ ($tab[1]*60) + $tab[2];
        }
        return($res);
    }

    /**
    * crée un timer (PYG)
    */
    public function initTimer(){
        list($usec, $sec) = explode(" ",microtime());
        return((float)$usec + (float)$sec) ;
    }

    /**
    * Affiche le temps entre 2 timers (PYG)
    */
    public function afficheTemps() {
      global $gInitTimer ;
        $fin = initTimer();
        $time = number_format( ($fin - $gInitTimer), 5)*1000;
        return(' ('.$time.' ms)');
    }
}

?>
