<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Domaines_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();
        $this->table = 'domaine';        
    }


    public function read($idd=-1,$loc=-1) {
        $ret = Array() ;
        $i = 0 ;
        $table = $this->table ;
        if ( $loc != -1 ) {
            $table = $loc==LOCAL?$this->table:$this->table.'_srv' ;
        }
        if ( $idd == -1 ) {

            $this->db->select('domaine_id,name');
            $this->db->from($table);
            $this->db->order_by('name', 'asc');
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ;      
            if (is_array($result)) {
         
                foreach ($result as $res) {
                    $ret[$i]['id']  = $res->domaine_id;
                    $ret[$i]['name']= $res->name;
                    $i++ ;
                }
            }
            
        } 
        else {

            $this->db->select('name');
            $this->db->from($table);
            $this->db->where('domaine_id', $idd);
            $this->db->order_by('name', 'asc');
            $query = $this->db->get(); 
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ; 
            $ret['name'] = '' ;     
            if (is_array($result)) {         
                foreach ($result as $res) {                   
                    $ret[$i]['name']= $res->name;
                }
            }
        }
        return($ret);
    }

    public function add($domaine) {

        $ret = 0 ;
        $doinfos = array("name"=>$domaine);           
        $this->db->trans_start();
        $this->db->insert($this->table, $doinfos);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();


        $this->db->select('domaine_id');
        $this->db->from($this->table);
        $this->db->order_by('domaine_id', 'desc');
        $this->db->limit(1);
        $query = $this->db->get(); 
        $result = $query->result()  ; 
        if (is_array($result)) {         
            foreach ($result as $res) {                   
                $ret= $res->domaine_id;
            }
        }

        return($ret);

    }

    public function update($idd,$domaine) {

        $infodomaine = array("name"=>htmlentities($domaine));
        $this->db->where('domaine_id', $idd);     
        $this->db->update($this->table, $infodomaine);
        $this->db->affected_rows();
    }

    public function del($idd) {
        $this->db->where('domaine_id', $idd);
        $this->db->delete($this->table);  
    }

    public function liste(){
        $ret = array();
        $ret[] = array('name'=>' ','id'=>-1) ;
        $dom = $this->read();
        for($i=0;$i<$dom['cnt'];$i++)  {
            $ret[] = array('name'=>$dom[$i]['name'], 'id'=>$dom[$i]['id']) ;
        }
        return($ret);
    }

    public function dom($idg){   
        $i = 0 ;
        $ret = array();
        $this->db->select('m.domaine_id, d.name');
        $this->db->distinct();        
        $this->db->from($this->table." as d");
        $this->db->join('list_sequence as m', 'm.domaine_id=d.domaine_id','left');
        $this->db->join('session_groupe as g', 'g.item_id=m.sequence_id','left');
        $this->db->where('m.groupe_id', $idg);
       
        $query = $this->db->get();         
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ; 
        if (is_array($result)) {         
            foreach ($result as $res) {                   
                $ret[$i]['id']= $res->domaine_id;
                $ret[$i]['name']= $res->name;
                $i++ ;
            }
        }
        return($ret);
    }

    public function insert($tab,$loc) {

        /*$this->table = $loc==LOCAL?$this->table:$this->table.'_srv';
        $this->del($tab['domaine_id']);
        return(parent::insert($tab));*/
    }

    public function addatelier($at_theme,$at_description) {
        $ret = 0 ;
        $atinfos = array("at_theme"=>$at_theme,"at_description"=>$at_description);           
        $this->db->trans_start();
        $this->db->insert("atelier_thematique", $atinfos);        
        $id = $this->db->insert_id();        
        $this->db->trans_complete();


        $this->db->select('at_id');
        $this->db->from("atelier_thematique");
        $this->db->order_by('at_id', 'desc');
        $this->db->limit(1);
       
        $query = $this->db->get();         
        $ret['cnt'] = $query->num_rows();
        $result = $query->result()  ; 
        if (is_array($result)) {         
            foreach ($result as $res) {                   
                $ret= $res->at_id;
            }
        }
        return($ret);


    }

    public function readatelier($idd=-1,$loc=-1) {
   
        $ret = Array() ;
        $i = 0 ;
        
        
        if ( $idd == -1 ) {

            $this->db->select('at_id as id,at_theme as name,at_description');
            $this->db->from("atelier_thematique");
            $this->db->order_by('at_theme', 'asc');
            $query = $this->db->get();         
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ; 
            if (is_array($result)) {         
                foreach ($result as $res) {                   
                    $ret[$i]['id'] = $res->at_id;
                    $ret[$i]['name'] = $res->name;
                    $ret[$i]['desc'] = $res->at_description;
                    $i++ ;
                }
            }

        } 
        else {

            $this->db->select('aat_theme as name,at_description');
            $this->db->from("atelier_thematique");
            $this->db->where('at_id', $idd);   
            $query = $this->db->get();         
            $ret['cnt'] = $query->num_rows();
            $result = $query->result()  ; 
            if (is_array($result)) {         
                foreach ($result as $res) {                   
                    $ret['name'] = $res->name;
                    $ret['desc'] = $res->at_description;
                    
                }
            }
        }
        return($ret);
    }

    public function updateatelier($at_id,$at_theme,$at_description) {
       
        $infoatelier = array("at_theme"=>$at_theme,"at_description"=>$at_description);
        $this->db->where('at_id', $at_id);     
        $this->db->update($this->table, $infoatelier);
        $this->db->affected_rows();
    }

    public function Request($field,$idc) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('domaine_id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }


    public function getAll($idd=-1,$loc=-1) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('name', 'asc');
        $query = $this->db->get();         
        return $query->result()  ;    
    }
}

?>
