<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class CoursPlannifier_model extends CI_Model
{
    
    public function __construct(){
        
        parent::__construct();
        $this->table           = 'cours_plannifier';           
        $this->table_connexion = 'connexion';           
        $this->table_stag      = 'stag_individu';           
        $this->table_membres   = 'membres';           
        $this->table_groupe    = 'list_groupe';           
    }

    public function checkDataExist($arrayData){

        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('idStageCoursPlannifier', $arrayData['idStageCoursPlannifier']);
        $this->db->where('dateHeureCoursPlannifier', $arrayData['dateHeureCoursPlannifier']);
        $this->db->where('dateHeureSaisieCoursPlannifier', $arrayData['dateHeureSaisieCoursPlannifier']);
        $this->db->where('refIndividuProfCoursPlannifier', $arrayData['refIndividuProfCoursPlannifier']);
        $this->db->where('dureeCoursPlannifier', $arrayData['dureeCoursPlannifier']);
        $this->db->where('typeDureeCoursPlannifier', $arrayData['typeDureeCoursPlannifier']);
        //$this->db->where('nomProfCoursPlannifier', $arrayData['nomProfCoursPlannifier']);
        //$this->db->where('prenomProfCoursPlannifier', $arrayData['prenomProfCoursPlannifier']);
        //$this->db->where('loginProfCOursPlannifier', $arrayData['loginProfCOursPlannifier']);
        $this->db->where('dateValidationCoursPlannifier', $arrayData['dateValidationCoursPlannifier']);
        $this->db->where('soldeStageCoursPlannifier', $arrayData['soldeStageCoursPlannifier']);
        $this->db->where('typeDeCoursCoursPlannifier', $arrayData['typeDeCoursCoursPlannifier']);
        //$this->db->where('matiereCoursPlannifier', $arrayData['matiereCoursPlannifier']);
        $this->db->where('refIndividuStagiaireCoursPlannifier', $arrayData['refIndividuStagiaireCoursPlannifier']);
        //$this->db->where('nomStagiaireCoursPlannifier', $arrayData['nomStagiaireCoursPlannifier']);
        //$this->db->where('prenomStagiaireCoursPlannifier', $arrayData['prenomStagiaireCoursPlannifier']);
        $query = $this->db->get(); 
        return $query->result()  ;

    }

    public function getTutorConnectByDate($dateConnexion){
        $this->db->select('CONCAT(prenomProfCoursPlannifier," ",nomProfCoursPlannifier) AS trainer');
        $this->db->from($this->table);
        if ($dateConnexion != '') {
            $this->db->where('DATE(dateHeureCoursPlannifier)', $dateConnexion);
        }
        $this->db->order_by('prenomProfCoursPlannifier', 'ASC');
        $this->db->group_by('CONCAT(prenomProfCoursPlannifier," ",nomProfCoursPlannifier)');
        $query = $this->db->get(); 
        return $query->result()  ;
    }


    public function add($arrayData){
        $this->db->trans_start();
        $this->db->insert($this->table, $arrayData);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function update($id,$data) {
        $this->db->where('idCoursPlannifier', $id);
        $this->db->update($this->table, $data);

    }

    public function delete($id){
        $this->db->where('idCoursPlannifier', $id);
        $this->db->delete($this->table);
    }

    public function getAll() {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->order_by('idCoursPlannifier', 'DESC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function search($criteriaFilter) {
        $likeCriteria = '';
        $this->db->select('c.*');
        $this->db->from($this->table.' as c');

        if(isset($criteriaFilter['statusConnexion']) && $criteriaFilter['statusConnexion'] != ''){
            $this->db->join($this->table_stag.' AS s', 's.id_stage_ext = c.idStageCoursPlannifier', 'INNER');       
        }

        if(isset($criteriaFilter['traineeFilter']) && $criteriaFilter['traineeFilter'] != ''){
            $this->db->join($this->table_membres.' AS m', 'c.idStageCoursPlannifier IN (SELECT MAX (id_stage_ext) FROM stag_individu WHERE id_stagiare_el = m.id LIMIT 1)', 'INNER');
        }

        if (isset($criteriaFilter['creneauHoraire']) && $criteriaFilter['creneauHoraire'] != '') {
            $this->db->where('TIME(c.dateHeureCoursPlannifier)', $criteriaFilter['creneauHoraire']);
        }

        if(isset($criteriaFilter['trainer']) && $criteriaFilter['trainer'] != ''){
            $likeCriteria .= 'CONCAT(c.prenomProfCoursPlannifier," ",c.nomProfCoursPlannifier) LIKE "%'.$criteriaFilter['trainer'].'%" ';
        }

        if (isset($criteriaFilter['datecoursplanifier']) && $criteriaFilter['datecoursplanifier'] != '') {
            $date = date('Y-m-d');
            $finalyDate = '';
            switch ($criteriaFilter['datecoursplanifier']) {
                case 'jm1':
                    $finalyDate .= date('Y-m-d', strtotime("-1 day"));
                    break;
                case 'j':
                    $finalyDate .= $date;
                    break;
                case 'jp1':
                    $finalyDate .= date('Y-m-d', strtotime("+1 day"));
                    break;
                
                default:
                    // code...
                    break;
            }
            if (isset($finalyDate) && $finalyDate != '') {
                $this->db->where('DATE(c.dateHeureCoursPlannifier)', $finalyDate);
            }
        }

        if(isset($criteriaFilter['statusConnexion']) && $criteriaFilter['statusConnexion'] != ''){     
            switch ($criteriaFilter['statusConnexion']) {
                case 'En ligne':
                    $this->db->where_in('s.id_stagiare_el', $criteriaFilter['allTraineeConnected']);
                    //$this->db->where_in('s.id_stagiare_el', 'SELECT id_user FROM '.$this->table_connexion.'');
                    break;
                case 'Deconnecté':
                    $this->db->where_not_in('s.id_stagiare_el', $criteriaFilter['allTraineeConnected']);
                    //$this->db->where_not_in('s.id_stagiare_el', 'SELECT id_user FROM '.$this->table_connexion.'');
                    break;
                
                default:
                    // code...
                    break;
            }
            
        }

        if(isset($criteriaFilter['traineeFilter']) && $criteriaFilter['traineeFilter'] != ''){
            if (isset($likeCriteria) && $likeCriteria != '') {
                $likeCriteria .= 'AND CONCAT(m.prenom," ",m.nom) LIKE "%'.$criteriaFilter['traineeFilter'].'%"';
            }
            else{
                $likeCriteria .= 'CONCAT(m.prenom," ",m.nom) LIKE "%'.$criteriaFilter['traineeFilter'].'%"';
            }
        }

        if (isset($likeCriteria) && $likeCriteria != '') {
            $this->db->where($likeCriteria);
        }

        $this->db->group_by(array("c.dateHeureCoursPlannifier", "c.idStageCoursPlannifier"));
        $this->db->order_by('c.dateHeureCoursPlannifier', 'ASC');
        //$this->db->limit(3);
        $query = $this->db->get(); 
        return $query->result()  ;
    }



    public function getAllNow() {
        $idStage = array(30397,30469,30292);
        $firstDate = date('Y-m-d 07:00:00');
        $endDate   = date('Y-m-d 20:00:00');
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('dateHeureCoursPlannifier BETWEEN "'.$firstDate.'" AND "'.$endDate.'" ');
        //$this->db->where_in('idStageCoursPlannifier',$idStage);
        $this->db->order_by('idCoursPlannifier', 'DESC');
        //$this->db->limit(3);
        $query = $this->db->get(); 
        return $query->result()  ;
    }
    public function getAllCreneau() {
        $firstDate = date('Y-m-d 07:00:00');
        $endDate   = date('Y-m-d 20:00:00');
        $this->db->select('dateHeureCoursPlannifier');
        $this->db->from($this->table);
        $this->db->where('dateHeureCoursPlannifier BETWEEN "'.$firstDate.'" AND "'.$endDate.'" ');
        $this->db->group_by('dateHeureCoursPlannifier', 'ASC');
        $this->db->order_by('dateHeureCoursPlannifier', 'ASC');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllCrenauRes() {
        $this->db->distinct('CAST(dateHeureCoursPlannifier AS time) AS creneauHoraire');
        $this->db->from($this->table);
        $this->db->where_not_in('TIME(dateHeureCoursPlannifier)', array('0','00:00:00'));
        $this->db->order_by('CAST(dateHeureCoursPlannifier AS time)', 'ASC');
        $this->db->group_by('CAST(dateHeureCoursPlannifier AS time)');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllTrainer() {
        $this->db->select('CONCAT(prenomProfCoursPlannifier," ",nomProfCoursPlannifier) AS trainer');
        $this->db->from($this->table);
        $this->db->order_by('prenomProfCoursPlannifier', 'ASC');
        $this->db->group_by('CONCAT(prenomProfCoursPlannifier," ",nomProfCoursPlannifier)');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function getAllTrainerCp() {
        $this->db->select('CONCAT(prenomProfCoursPlannifier," ",nomProfCoursPlannifier) AS trainer,refIndividuProfCoursPlannifier');
        $this->db->from($this->table);
        $this->db->order_by('prenomProfCoursPlannifier', 'ASC');
        $this->db->group_by('refIndividuProfCoursPlannifier');
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    /*public function getTrainerByStage($idStage) {
        $this->db->select('lg.id_tuteur, cp.idStageCoursPlannifier, cp.nomProfCoursPlannifier, cp.prenomProfCoursPlannifier');
        $this->db->from($this->table.' AS cp');
        $this->db->join($this->table_stag.' AS st', 'cp.idStageCoursPlannifier = MAX(st.id_stage_ext)','INNER');
        $this->db->join($this->table_membres.' AS mb', 'mb.nom LIKE "%cp.nomProfCoursPlannifier%" AND mb.prenom LIKE "%cp.prenomProfCoursPlannifier%"','INNER');
        $this->db->join($this->table_groupe.' AS lg', 'lg.id_tuteur = mb.id','INNER');
        $this->db->where('cp.idStageCoursPlannifier', $idStage);
        $query = $this->db->get(); 
        return $query->result()  ;
    }*/
    public function getTrainerByStage($idStage,$nomProf,$prenomProf) {
        $this->db->select('mb.id');
        $this->db->from($this->table.' AS cp');
        $this->db->join($this->table_membres.' AS mb', 'mb.nom LIKE "%'.$nomProf.'%" AND mb.prenom LIKE "%'.$prenomProf.'"','INNER');
        $this->db->where('cp.nomProfCoursPlannifier', $nomProf);
        $this->db->where('cp.prenomProfCoursPlannifier', $prenomProf);
        $this->db->where('cp.idStageCoursPlannifier', $idStage);
        $this->db->limit(1);
        $query = $this->db->get(); 
        return $query->result()  ;
    }

    public function Request($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('idCoursPlannifier', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }

    public function RequestByIdStage($field,$id) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('idStageCoursPlannifier', $id);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
    
}

?>
