<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Conference_call_model extends CI_Model
{
    
    public function __construct(){        
        parent::__construct(); 
        $this->table        = 'conference_call';   
        $this->max_usage    = 2;   
    }



    public function add($data){
        $this->db->trans_start();
        $this->db->insert($this->table, $data);        
        $insert_id = $this->db->insert_id();        
        $this->db->trans_complete();
        return $insert_id;
    }

    public function update($id,$data) {
        $this->db->where('id', $id);
        $this->db->update($this->table, $data);

    }
    public function delete($id){
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }
    public function getMaxCountByIdGroup($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $this->db->limit(1);
        $query = $this->db->get(); 
        return $query->result()  ; 
    }
    public function getByIdGroup($idGroup) {
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('id_groupe', $idGroup);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get(); 
        return $query->result()  ; 
    }

    public function RequestByIdGroup($field,$id_groupe) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id_groupe', $id_groupe);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }


    public function Request($field,$idc) {
        $this->db->select($field);
        $this->db->from($this->table);
        $this->db->where('id', $idc);
        $query = $this->db->get();
        $result = $query->result();
        $ret = "";
        if ($query->num_rows() != 0) {
            foreach ($result as $res){
                $ret .= $res->$field ;
            }
        }       
        return($ret);
    }
}

?>
