<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Admin_model extends CI_Model
{
    
    /*public function __construct(){

    }*/
    /**
     * This public function used to check the login credentials of the user
     * @param string $email : This is email of the user
     * @param string $password : This is encrypted password of the user
     */
    public function __construct(){
        
        parent::__construct();   
        $this->load->model('utilities_model');        
        $this->load->model('groupes_model');        
        $this->load->model('sessions_model');        
        $this->load->model('formations_model');        
        $this->load->model('tracking_model');        
        $this->load->model('membres_model');        
        $this->load->model('parcours_model');        
        $this->load->model('modules_model');        
    }

    public function ajouterStagiaireGroupe($idu,$idg) {
        $date   = getdate() ;
        $date   = $date["0"];
        $data = array(
            'id_groupe' => $idg, 
            'id_membres' => $idu, 
            'prototype' => 0, 
            'date_modif' => $date 
        );
        $this->groupes_model->addgrp($data);
        $this->formations_model->addSession($idu,$idg,$this->sessions_model->read($idg));
        return true;
    }

    public function supprimerStagiaireGroupe($idu,$idg) {
        $this->groupes_model->delUserGroupe($idu,$idg);
        $this->formations_model->delUser($idu,$idg);
        $this->tracking_model->delUser($idu,$idg);
        return true;
    }

    public function supprimerStagiairePortefeuille($idTuteur,$idGroup) {
        $this->groupes_model->supprimerStagiairePortefeuille($idTuteur,$idGroup);
        return true;
    }

    public function ajouterTuteurGroupe($idu,$idg) {
        $this->groupes_model->addTuteur($idg,$idu);
        return true;
    }

    public function modifierUnStagiaire($id,$login,$pwd,$prenom,$nom,$email,$mode_acces, $date_debut_acces, $date_fin_acces,$cv,$photo,$acces_bar,$stagesociete,$stagiaire_id) {
        $date   = getdate() ;
        $date   = $date["0"];
        $res = $this->verifLoginPwdEmail($id,$login,$pwd,$email) ;
        if ($res == OK || $res == TRUE) {
            $data = array(
                'login' => $login,
                'nom' => $nom,
                'prenom' => $prenom,
                'email' => $email,
                'cv' => $cv,
                'date_modif' => $date,
                'mode_acces' => $mode_acces,
                'date_debut_acces' => $date_debut_acces,
                'date_fin_acces' => $date_fin_acces,
                'acces_bar' => $acces_bar,
                'tuteur_entreprise' => 0,
                'acces_fonctions_admin' => 0,
                'stageSociete' => $stagesociete,
                'niveauStage' =>  $stagesociete,
                'extranet_id' => $stagiaire_id,
                'acces_fonctions_admin' => 0,
            );
            $this->membres_model->update( $id,$data);
            return true;
        }
        else{
            return $res;
        }
    }

    public function verifLoginPwdEmail($id=-1,$login,$password,$email, $display=1) {
        if (!$this->membres_model->VerifPwdLogin($password,$login,$id) ) {
            if ( $display ) {
                return $this->traiteLoginPwdEmail(ERR_LOGIN_PWD);
            } else {
                return(ERR_LOGIN_PWD);
            }
        }
        if ( $email != '') {
            if ( ! $this->isEmail($email) ) {
                if ( $display ) {
                    return $this->traiteLoginPwdEmail(ERR_EMAIL_INVALID);
                } 
                else{
                    return(ERR_EMAIL_INVALID);
                }
            }
            else {
                if ( $this->membres_model->emailExist($id,$email) ) {
                    if ( $display ) {
                        return $this->traiteLoginPwdEmail(ERR_EMAIL_USED);
                    } 
                    else{
                        return(ERR_EMAIL_USED);
                    }
                }
            }
        }
        return true;
    }

    public function isEmail($email){
        $ret    = false ;
        $name   = ""    ;
        $domain = ""    ;
        @list($name, $domain) = @explode("@", $email) ;
        if( !strstr($email, " ") && @strstr($domain, ".") ){
            $ret = true;
        }
        return($ret);
    }


    public function traiteLoginPwdEmail($err) {
        $url  = "JavaScript:window.history.back();" ;
        $data['goback'] = "<br><br>".$this->script->LienNormal(array('url'=>$url, 'val'=>'<i class="fa fa-go-back"></i>')).'<br>' ;
        $data['errormsg'] = '';
        switch($err){
            case ERR_LOGIN_PWD :
                $data['errormsg'] = $this->erreur('Erreur Identifiant/mot de passe',true);
                break;
            case ERR_EMAIL_INVALID :
                $data['errormsg'] = $this->erreur('L\'Email n\'est pas valide !!!',true);
                break;
            case ERR_EMAIL_USED:
                $data['errormsg'] = $this->erreur('Email deja utilis&eacute; !!!',true);'<div align="center" class="error">Email deja utiliss&eacute; !!!</div>' ;
                break;
        }
        return $data;
    }

    public function erreur($txt,$center=false) {
      if ( trim($txt) == '' ) return('');
      $center = $center?'align="center"':'';
        return('<div '.$center.' class="error">'.$txt.'</div>') ;
    }

    public function addOtherUser($prenom,$nom,$login,$pwd,$email,$cv,$photo,$type) {
        $res = $this->verifLoginPwdEmail(-1,$login,$pwd,$email) ;
        
        $data = array(
            'prenom' => $prenom,
            'nom' => $nom,
            'login' => $login,
            'password' => $pwd,
            'email' => $email,
            'cv' => $cv,
            'nom_photo' => $photo,
            'type' => $type
        );
        $this->membres_model->add($data);
        return true;
    }

    public function updateOtherUser($id,$login,$pwd,$prenom,$nom,$email,$cv) {
        $res = $this->verifLoginPwdEmail($id,$login,$pwd,$email) ;
        if ($res == OK || $res == TRUE) {
            $data = array(
                'login'   => $login,
                'prenom' => $prenom,
                'nom' => $nom,
                'email' => $email,
                'cv' => $cv
            );
            $this->membres_model->update( $id,$data);
            return(OK);
        }
        else{
            return $res;
        }
    }

    public function supprimerItemFormation($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg) {
        $this->formations_model->delItem($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg);
        $this->tracking_model->del($idu,$ids,$idg,$locs);
        return true;
    }

    public function ajouterParcoursFormation($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg,$idd) {
        $LOC_DEFAULT= 1;
        $parc = $this->parcours_model->readParcours($idp,$locp);
        
        foreach ($parc as $res) {
            if (isset($res->type) && ($res->type == 0)) {
               $this->ajouterSequenceFormation($idu,$res->item_id,$res->loc,0,$LOC_DEFAULT,$idp,$locp,$idg,$idd);
            } 
            elseif (isset($idd) && isset($res->item_id) && isset($res->loc)) {
                $this->ajouterModuleFormation($idu,0,$LOC_DEFAULT,$res->item_id,$res->loc,$idp,$locp,$idg,$idd);
            }
        }
        return true;
    }

    public function ajouterModuleFormation($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg,$idd) {
        $seq = $this->modules_model->readIdSequence($idm,$locm);
        foreach ($seq as $res) {
            $this->formations_model->addItem($res->sequence_id,$res->loc,$idm,$locm,$idp,$locp,$idg,$idu,$idd);
        }
        return true;
    }

    public function ajouterSequenceFormation($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg,$idd) {
        $this->formations_model->addItem($ids,$locs,$idm,$locm,$idp,$locp,$idg,$idu,$idd);
        return true;
    }

    public function ajouterUnParcours($titre,$code,$aut,$objectifs,$type,$loc){
        return $this->parcours_model->add($titre,$code,$aut,$objectifs,$type,$loc);
    }

    public function ajouterUnModuleParcours($idp,$idm,$loc) {
        return $this->parcours_model->addItem($idp,$idm,TYPE_MODULE,$loc);
    }

    public function ajouterUneSequenceParcours($idp,$ids,$loc) {
        return $this->parcours_model->addItem($idp,$ids,TYPE_SEQUENCE,$loc);
    }

}

?>
