<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.AutoscalingPolicyScalingSchedule</code>
 */
class AutoscalingPolicyScalingSchedule extends \Google\Protobuf\Internal\Message
{
    /**
     * A description of a scaling schedule.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    private $description = null;
    /**
     * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     *
     * Generated from protobuf field <code>optional bool disabled = 270940796;</code>
     */
    private $disabled = null;
    /**
     * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     *
     * Generated from protobuf field <code>optional int32 duration_sec = 212356902;</code>
     */
    private $duration_sec = null;
    /**
     * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     *
     * Generated from protobuf field <code>optional int32 min_required_replicas = 365514414;</code>
     */
    private $min_required_replicas = null;
    /**
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     *
     * Generated from protobuf field <code>optional string schedule = 375820951;</code>
     */
    private $schedule = null;
    /**
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of “UTC” if left empty.
     *
     * Generated from protobuf field <code>optional string time_zone = 36848094;</code>
     */
    private $time_zone = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $description
     *           A description of a scaling schedule.
     *     @type bool $disabled
     *           A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     *     @type int $duration_sec
     *           The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     *     @type int $min_required_replicas
     *           The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     *     @type string $schedule
     *           The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     *     @type string $time_zone
     *           The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of “UTC” if left empty.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * A description of a scaling schedule.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * A description of a scaling schedule.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     *
     * Generated from protobuf field <code>optional bool disabled = 270940796;</code>
     * @return bool
     */
    public function getDisabled()
    {
        return isset($this->disabled) ? $this->disabled : false;
    }

    public function hasDisabled()
    {
        return isset($this->disabled);
    }

    public function clearDisabled()
    {
        unset($this->disabled);
    }

    /**
     * A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
     *
     * Generated from protobuf field <code>optional bool disabled = 270940796;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->disabled = $var;

        return $this;
    }

    /**
     * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     *
     * Generated from protobuf field <code>optional int32 duration_sec = 212356902;</code>
     * @return int
     */
    public function getDurationSec()
    {
        return isset($this->duration_sec) ? $this->duration_sec : 0;
    }

    public function hasDurationSec()
    {
        return isset($this->duration_sec);
    }

    public function clearDurationSec()
    {
        unset($this->duration_sec);
    }

    /**
     * The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
     *
     * Generated from protobuf field <code>optional int32 duration_sec = 212356902;</code>
     * @param int $var
     * @return $this
     */
    public function setDurationSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->duration_sec = $var;

        return $this;
    }

    /**
     * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     *
     * Generated from protobuf field <code>optional int32 min_required_replicas = 365514414;</code>
     * @return int
     */
    public function getMinRequiredReplicas()
    {
        return isset($this->min_required_replicas) ? $this->min_required_replicas : 0;
    }

    public function hasMinRequiredReplicas()
    {
        return isset($this->min_required_replicas);
    }

    public function clearMinRequiredReplicas()
    {
        unset($this->min_required_replicas);
    }

    /**
     * The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
     *
     * Generated from protobuf field <code>optional int32 min_required_replicas = 365514414;</code>
     * @param int $var
     * @return $this
     */
    public function setMinRequiredReplicas($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_required_replicas = $var;

        return $this;
    }

    /**
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     *
     * Generated from protobuf field <code>optional string schedule = 375820951;</code>
     * @return string
     */
    public function getSchedule()
    {
        return isset($this->schedule) ? $this->schedule : '';
    }

    public function hasSchedule()
    {
        return isset($this->schedule);
    }

    public function clearSchedule()
    {
        unset($this->schedule);
    }

    /**
     * The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
     *
     * Generated from protobuf field <code>optional string schedule = 375820951;</code>
     * @param string $var
     * @return $this
     */
    public function setSchedule($var)
    {
        GPBUtil::checkString($var, True);
        $this->schedule = $var;

        return $this;
    }

    /**
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of “UTC” if left empty.
     *
     * Generated from protobuf field <code>optional string time_zone = 36848094;</code>
     * @return string
     */
    public function getTimeZone()
    {
        return isset($this->time_zone) ? $this->time_zone : '';
    }

    public function hasTimeZone()
    {
        return isset($this->time_zone);
    }

    public function clearTimeZone()
    {
        unset($this->time_zone);
    }

    /**
     * The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of “UTC” if left empty.
     *
     * Generated from protobuf field <code>optional string time_zone = 36848094;</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

}

