<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Todolist extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();   
        $this->tracking_type = 2;
        $this->idNewSequence = 0;

        if (isset($_GET['extranet_id']) && !empty($_GET['extranet_id'])) {
            $langageFormation = $this->groupes_model->RequestByGrp('langue',$_GET['groupe']);
            $langagePlateform = '';
            if (preg_match('/Anglais/i', $langageFormation, $matches)) {  
                $langagePlateform = 'english';
            } 
            else if (preg_match('/Français/i', $langageFormation, $matches)){
                $langagePlateform = 'french';
            }             
            else if ($langageFormation == NULL || $langageFormation == ''){
                $langagePlateform = 'english';
            }
            else{
                $langagePlateform = 'french';
            }
            $sessionArray = array(
                'site_lang'      =>$langagePlateform,
                'GLOSSAIREONLINE'=>$this->groupes_model->Request('glossaireenligne',$_GET['groupe'])
            ); 
            $this->global['GLOSSAIREONLINE']          = $this->groupes_model->Request('glossaireenligne',$_GET['groupe']);
            $this->session->set_userdata($sessionArray);
        }
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('cursus_formation');

        $order = '';

        $loader = false;
        if (isset($_GET['extranet_id']) && !empty($_GET['extranet_id'])) {           
            $this->global['displaygrp']       = $this->DisplayGroupe($_GET['groupe'],$_GET['id']);   
            $sessionArray = array(
                'STAGIAIREID'=>$_GET['id'],
                'STAGIAIREGRP'=>$_GET['groupe'],
                'STAGIAIRENAME'=>$this->membres_model->GetPrenom($_GET['id']).' '.$this->membres_model->GetNom($_GET['id']),
                'STAGIAIREEXTRANETID' =>$_GET['extranet_id'],
                'IDSOCIETE'           =>$this->membres_model->Request('id_societe',$_GET['id']),
                'IDSOCIETESTAGIAIRE'  =>$this->membres_model->Request('id_societe',$_GET['id']),
                'NAMESOCIETESTAGIAIRE'=>$this->societe_model->Request('description',$this->membres_model->Request('id_societe',$_GET['id']))
            ); 
            $this->session->set_userdata($sessionArray);
            $this->global['groupe']                = $_GET['groupe'];
            
            $this->global['STAGIAIREID']           = $_GET['id'];
            $this->global['STAGIAIREGRP']          = $_GET['groupe'];
            $loader = true;
        }
        else{
            $this->global['groupe']           = $this->session->userdata ('STAGIAIREGRP');
            $loader = true;
        }

        
        if (isset($_GET['load-content']) && isset($_GET['id'])) {
            $this->loadTrackingEl($_GET['id'],$this->todolist_model->Request('num_sequence',$_GET['id']),$this->tracking_type,$this->todolist_model->Request('historique_cours',$_GET['id']));
        }
        else{
            $this->loadTrackingEl(0,0,$this->tracking_type);
        }
        

        $searchText = $this->input->post('searchText');
        $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));

        if (isset($_GET['order']) && $_GET['order'] != '') {
            $order = $_GET['order'];
        }

        $data['order'] = $order;

        $data['historiqcours'] =(isset($_GET['action']) && $_GET['action'] == 'ch_tr' && isset($_GET['pr'])) ? $this->coursHistorik_model->getByUserCreateIdGroupTraineeCreateOrder($_GET['pr'],$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'),$order) : $this->coursHistorik_model->getByUserCreateIdGroupTraineeCreateOrder($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREID'),$this->session->userdata ('STAGIAIREGRP'),$order);
        $data['allDateFromTodo'] = $this->todolist_model->getByAllDateIdGroup($this->session->userdata ('STAGIAIREGRP'));
        $data['allTraineeFromSession'] = $this->groupes_model->readGroupStagiaire($this->session->userdata ('GUSERID'));
        $data['allProfessorForTrainee'] = $this->groupes_model->getAllProfessorByGroup($this->session->userdata ('STAGIAIREGRP'));
        $this->loadViews("tutor/todolist/index", $this->global,$data, NULL );
    }
    
    public function addlink(){

        $this->global['pageTitle'] = 'E-learning : Add new Link';
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        $this->loadViews("tutor/todolist/addnewlink", $this->global, NULL , NULL);            
            
        
    }

    public function listLinkDocsByParams(){
        $return = '<br>';
        $thumbnail;
        $imgClass;
        $allResult = array();
        if (isset($_POST['id'])) {
            $allResult = $this->todolist_model->getNewSeqById($_POST['id'],$_POST['order']);
        }
        else{
            $allResult = $this->todolist_model->getNewSeqByParams($this->session->userdata('GUSERID'),$_POST['key'],$_POST['order']);
        }
        if(isset($allResult) && count($allResult) >= 1){
            foreach($allResult as $record){
                if ($record->type==0) {
                    $type      =  "Link";
                    if ($record->thumbnail_file != '' && file_exists(RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file)) {
                        $thumbnail = HTTP_MAIN.
                        'groupes/'."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file;
                        $imgClass = 'image-timthumb img-vignette img-link-and-document';
                    }
                    else{
                        $thumbnail = HTTP_MAIN."assets/icons-f2+/link_and_document_and_favoris/ico-link.png";
                        $imgClass = 'user-image img-link-and-document';
                    }
                    $link_url = $record->link;
                }
                else{
                    $type =  "Documents" ;
                    if ($record->thumbnail_file != '' && file_exists(RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file)) {
                        $thumbnail = HTTP_MAIN.
                        'groupes/'."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$record->user_create.'/'.$record->thumbnail_file;
                        $imgClass = 'image-timthumb img-vignette img-link-and-document';
                    }
                    else{
                        $thumbnail = HTTP_MAIN."assets/icons-f2+/link_and_document_and_favoris/ico-document.png";
                        $imgClass = 'user-image img-link-and-document';
                    }
                    $link_url = base_url()."groupes/GRPT".$this->session->userdata('GUSERID').'/documentTodo/'.$record->link;

                } 
                $return .= '
                <div class="col-md-2 padding-col padding-link-and-document" date-create="'.$record->date_create.'" data-title="'.$this->convert_utf8($record->titre).'">
                    <div class="container-image hovereffect container-link-and-document">
                        <img class="'.$imgClass.'" title="" alt="Avatar" src="'.$thumbnail.'">
                        <div class="overlay overlay-link-and-document">
                            <div class="btn-group-vertical btn-group-link-and-document">
                                <input type="hidden" name="linkAddTodo" class="linkAddTodo" value="'.base_url().'addTodo">
                                <input type="hidden"  class="linkupdatesequence" name="linkupdatesequence" value="'.base_url().'updatesequence/'.$record->id.'">
                                <input type="hidden" name="thumbnailfile" class="thumbnailfile" value="'.$thumbnail.'">
                                <input type="hidden" name="clsdata" class="clsdata" value="'.$record->id.'">
                                <input type="hidden" name="clsIfrmAccessStat" class="clsIfrmAccessStat" value="'.$record->ifrmaccess.'">
                                <input type="hidden" name="typeLnk" class="typeLnk" value="'.$record->type.'">
                                <a href="#" class="btn link-action-nl delsequence" onclick="deleteSequence(this);" title="Add comment">
                                    <img src="'.base_url().'assets/icons-f2+/link_and_document_and_favoris/3669361_delete_ic_icon-normal.png" class="user-image img-home">
                                </a>
                                <a href="#" class="btn link-action-nl btn-add-docs-and-link-in-todo" onclick="addDocsAndLinkInTodo(this);" title="Add to course history">
                                    <img src="'.base_url().'assets/icons-f2+/historique_de_cours/favorite.png" class="user-image img-home">
                                </a>
                                <a target="_blank" href="'.$link_url.'" class="btn" title="Access to the docs">
                                    <img src="'.base_url().'assets/icons-f2+/link_and_document_and_favoris/ico-download-normal.png" class="user-image img-home">
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="legend title-vignette legend-link-and-document">
                        <span class="titleTumbnail title-link-and-document">'.substr($record->titre, 0, 20).'</span><br>
                        <span class="date date-in-link-and-document">
                            <img src="'.base_url().'assets/icons-f2+/link_and_document_and_favoris/ico-date.png" class="user-image">&nbsp;'.$record->date_create.'
                        </span>
                    </div>
                </div>  ';
            }
        }
        else{
            $return .= '
            <div class="text-center no-result">
                No results found in the database
            </div>';
        }
        echo $return;
    }

    public function listLinkAndDocs(){

        $this->global['pageTitle'] = 'E-learning : List Link and document';
        
        $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        $searchText = $this->input->post('key');
        $count      = $this->todolist_model->countLinksDocs($searchText,$this->session->userdata ('GUSERID'));
        $returns    = $this->paginationCompress ("listLinkDocs/", $count,12);

        $data['listDocLink'] = $this->todolist_model->listLinksDocs($searchText, $returns["page"], $returns["segment"],$this->session->userdata ('GUSERID'));
        $data['historik_course'] = $this->coursHistorik_model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP')); 
        $data['classification_favoris'] = $this->classificationFavoris_Model->getByUserCreateIdGroup($this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
        $this->loadViews("tutor/todolist/listLinkAndDocs", $this->global,$data, NULL );    
    }

    public function getAllTodoAndDocsAndLink(){
        $retourHtml = array();
        $HTML = '';
        $TODO = '';
        $LinkAndDocs = '';
        $optionTodo = '';
        $optionLinkAndDocs = '';
        $linkSequence = '';

        $pedagogicalTraining = '';
        $pedagogicalTrainingOption = '';

        $personnalInterest = '';
        $personnalInterestOption = '';

        $databaseDocument = '';
        $databaseDocumentOption = '';

        $newsletter = '';
        $newsletterOption = '';

        $OPTIONLIBRARY  = '';
        $LIBRARY = '';

        $communityLibraryForma2Plus = '';
        $communityLibraryForma2PlusOption = '';

        if (isset($_POST['idHistorikCours'])) {
            $newsletterResult = $this->newsletter_model->getAllArticle();
            $newsletter .= '<ul class="newslettermenu">';
            foreach ($newsletterResult as $nl) {
                $newsletter .= '
                    <li>
                        <a href="#" onclick="addNlInCoursHistorik(this,'.$nl->ID.','.$_POST['idHistorikCours'].');" class="btn btn-add-in-cours text-docs-and-link"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="nl-text">'.$this->convert_utf8($nl->article).'</span>
                        </a>
                    </li>';
                $newsletterOption .= '<option data-id="'.$nl->ID.'" value="'.$this->convert_utf8($nl->article).'">';
            }
            $newsletter .= '</ul>';

       
            $linkdocs = $this->todolist_model->getAllLinkAndDocNotInTodoByTutor($this->session->userdata ('GUSERID'));
            
            $TODO .= '<ul class="todolistmenu">';
            foreach ($linkdocs as $ld) {
                $TODO .= '<li>';
                    $TODO .= '<a href="#"  data-type="todo" class="btn btn-add-in-cours text-link-and-docs" onclick="addDocsLinkInCoursHistorik(this,'.$ld->id.','.$_POST['idHistorikCours'].');"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="todo-text">'.$this->convert_utf8($ld->titre).'</span></a>';
                $TODO .= '</li>';
                $optionTodo .= '<option data-id="'.$ld->id.'" value="'.$this->convert_utf8($ld->titre).'">';
            }
            $TODO .= '</ul>';


            $pedagogicalTraining .= '<ul class="pedagogicalMenu">';
            $pedagogicalResult = $this->sequence_model->getLinksByIdGroupIdDomaine($this->session->userdata ('STAGIAIREGRP'),6);
            for ($i=0; $i < count($pedagogicalResult) ; $i++) {
                $pedagogicalTraining .= '<li>';
                    $pedagogicalTraining .= '<a href="#" data-linkInit = "'.$pedagogicalResult[$i]['link'].'" data-titre = "'.$pedagogicalResult[$i]['titre'].'" data-final-url = "'.$pedagogicalResult[$i]['final_url'].'" data-thumb="'.$pedagogicalResult[$i]['thumbnail_file'].'" class="btn btn-add-in-cours" onclick="addPedagogicalTrainingInCoursHistorik(this,'.$pedagogicalResult[$i]['id_sequence'].','.$pedagogicalResult[$i]['numero'].','.$_POST['idHistorikCours'].',6);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'.$this->convert_utf8($pedagogicalResult[$i]['titre']).'</span></a>';
                $pedagogicalTraining .= '</li>';
                $pedagogicalTrainingOption .= '<option data-id="'.$pedagogicalResult[$i]['id_sequence'].'" value="'.$this->convert_utf8($pedagogicalResult[$i]['titre']).'">';
            }
            /*complementary activities*/

            $array_ped_training = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),6);
            $array_pers_ling = $this->sequence_model->getPavetHaut($this->session->userdata ('STAGIAIREGRP'),7);

            $ret_complementary_activities = $this->sequence_model->getPavetComplementary($this->session->userdata ('STAGIAIREGRP'));

            $arrayListeModule = array();
            $array_id_module_ped_training = array();
            $array_id_module_pers_ling = array();


            if(!empty($array_pers_ling)){
                if (is_array($array_pers_ling['module'])) {
                    foreach($array_pers_ling['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_pers_ling[] = $value2['module_id'];
                        }
                    }
                }
            }

            if(!empty($array_ped_training)){
                if (is_array($array_ped_training['module'])) {
                    foreach($array_ped_training['module'] as $key=>$value){
                        foreach($value as $key2=>$value2){
                            $arrayListeModule[] = $value2['module_id'];
                            $array_id_module_ped_training[] = $value2['module_id'];
                        }
                    }
                }
            }
            if(!empty($ret_complementary_activities)){
                if (is_array($ret_complementary_activities['module'])) {
                    foreach($ret_complementary_activities['module'] as $key=>$value){
                        $arrayListeModule[] = $value['module_id'];
                    }
                }
            }

            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_ped_training) ;
            $this->sequence_model->delete_values_from_array_array ($arrayListeModule, $array_id_module_pers_ling) ;

            if(!empty($ret_complementary_activities)){
                foreach($ret_complementary_activities['module'] as $key=>$value){
                    $chapitre = $this->chapitres_model->read($value['sequence_id'],$this->session->userdata ('GUSERID'),$this->session->userdata ('STAGIAIREGRP'));
                    if (isset($chapitre['cnt'])) {                                                    
                        for($i=0;$i<$chapitre['cnt'];$i++) {
                            $pedagogicalTraining .= '<li>';
                                $pedagogicalTraining .= '<a href="#" data-linkInit = "'.$chapitre[$i]['link'].'" data-titre = "'.$chapitre[$i]['titre'].'" data-final-url = "'.$chapitre[$i]['final_url'].'" data-thumb="'.$chapitre[$i]['thumbnail_file'].'" class="btn btn-add-in-cours" onclick="addPedagogicalTrainingInCoursHistorik(this,'.$chapitre[$i]['id_sequence'].','.$chapitre[$i]['numero'].','.$_POST['idHistorikCours'].',6);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-pdg">'.$this->convert_utf8($chapitre[$i]['titre']).'</span></a>';
                            $pedagogicalTraining .= '</li>';
                            $pedagogicalTrainingOption .= '<option data-id="'.$chapitre[$i]['id_sequence'].'" value="'.$this->convert_utf8($chapitre[$i]['titre']).'">';
                        }
                    }
                }
            }

            $pedagogicalTraining .= '</ul>';

            
            $teacherLinksAndDocs = $this->Teacher_link_and_document_model->getContentByUserCreate($this->session->userdata ('GUSERID'));

            $LIBRARY .= '<ul class="todolistmenu">';
            foreach ($teacherLinksAndDocs as $tld) {
                if ($tld->titre != '') {
                    $LIBRARY .= '<li>';
                        $LIBRARY .= '<a href="#"  data-type="teacherLinkAndDocs" class="btn btn-add-in-cours text-link-and-docs-lib" onclick="addTeacherLinkAndDocsInCoursHistorik(this,'.$tld->id.','.$_POST['idHistorikCours'].');"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="teacter-link-and-doc-text">'.$this->convert_utf8($tld->titre).'</span></a>';
                    $LIBRARY .= '</li>';
                    $OPTIONLIBRARY .= '<option data-id="'.$tld->id.'" value="'.$this->convert_utf8($tld->titre).'">';
                }
            }
            $LIBRARY .= '</ul>';


            $personnalInterest .= '<ul class="pedagogicalMenu">';
            $personnalIntersetResult = $this->sequence_model->getLinksByIdGroupIdDomaine($this->session->userdata ('STAGIAIREGRP'),7);
            for ($i=0; $i < count($personnalIntersetResult) ; $i++) {
                $personnalInterest .= '<li>';
                    $personnalInterest .= '<a href="#" data-linkInit = "'.$personnalIntersetResult[$i]['link'].'" data-titre = "'.$personnalIntersetResult[$i]['titre'].'" data-final-url = "'.$personnalIntersetResult[$i]['final_url'].'" data-thumb="'.$personnalIntersetResult[$i]['thumbnail_file'].'" class="btn btn-add-in-cours" onclick="addPedagogicalTrainingInCoursHistorik(this,'.$personnalIntersetResult[$i]['id_sequence'].','.$personnalIntersetResult[$i]['numero'].','.$_POST['idHistorikCours'].',7);"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-persint">'.$this->convert_utf8($personnalIntersetResult[$i]['titre']).'</span></a>';
                $personnalInterest .= '</li>';
                $personnalInterestOption .= '<option data-id="'.$personnalIntersetResult[$i]['id_sequence'].'" value="'.$this->convert_utf8($personnalIntersetResult[$i]['titre']).'">';
            }
            $personnalInterest .= '</ul>';


            $databaseDocument .= '<ul class="pedagogicalMenu">';
            $databasedc = $this->document_model->getAllDocumentByIdGroup($this->session->userdata ('STAGIAIREGRP'));
            foreach ($databasedc as $d) {
                $databaseDocument .= '<li>';
                    $databaseDocument .= '<a href="#" data-titre = "'.$d->titre.'" data-fichier = "'.$d->fichier.'" class="btn btn-add-in-cours" onclick="addDatabaseDocumentInCoursHistorik(this,'.$d->id.','.$_POST['idHistorikCours'].');"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-dc">'.$this->convert_utf8($d->titre).'</span></a>';
                $databaseDocument .= '</li>';
                $databaseDocumentOption .= '<option data-id="'.$d->id.'" value="'.$this->convert_utf8($d->titre).'">';
            }
            $databaseDocument .= '</ul>';

            $communityLibraryForma2Plus .= '<ul class="communityLibraryForma2plus">';
            $commulintyLibraryResult = $this->Content_community_library_forma2plus_model->getAll();
            foreach ($commulintyLibraryResult as $clf) {
                $communityLibraryForma2Plus .= '<li>';
                    $communityLibraryForma2Plus .= '<a href="#" data-titre = "'.$clf->titre.'" data-fichier = "'.$clf->link.'" class="btn btn-add-in-cours" onclick="addLibraryCommunityForma2PlusInCourseHistory(this,'.$clf->id.','.$_POST['idHistorikCours'].');"><i class="bx bxs-plus-circle glyphicon-plus-sign-modules"></i>&nbsp;&nbsp;<span class="text-dc">'.$this->convert_utf8($clf->titre).'</span></a>';
                $communityLibraryForma2Plus .= '</li>';
                $communityLibraryForma2PlusOption .= '<option data-id="'.$clf->id.'" value="'.$this->convert_utf8($clf->titre).'">';
            }
            $communityLibraryForma2Plus .= '</ul>';
        }

        $retourHtml = array(
            'htmlLibLinkAndDocs'                   => $LinkAndDocs,
            'htmlLibLinkAndDocsOption'             => $optionLinkAndDocs,
            'htmlLibPedagogicalTraining'           => $pedagogicalTraining,
            'htmlLibPedagogicalTrainingOption'     => $pedagogicalTrainingOption,
            'htmlLibDatabaseDocs'                  => $databaseDocument,
            'htmlLibDatabaseDocsOption'            => $databaseDocumentOption,
            'htmlLibNewsletter'                    => $newsletter,
            'htmlLibNewsletterOption'              => $newsletterOption,
            'htmlLibPersonnalInterest'             => $personnalInterest,
            'htmlLibPersonnalInterestOption'       => $personnalInterestOption,
            'htmlLibTeacherLinkAndDocs'            => $LIBRARY,
            'htmlLibTeacherLinkAndDocsOption'      => $OPTIONLIBRARY,
            'htmlLibCommunityLibF2P'               => $communityLibraryForma2Plus,
            'htmlLibCommunityLibF2POption'         => $communityLibraryForma2PlusOption,
            'idHistorikCours'                      => $_POST['idHistorikCours'],
        );
        echo json_encode($retourHtml);
    }

    public function addTodo(){
        $retour = array();
        $todoId = '';
        if (isset($_POST['idHisorikC'])) {
            if (isset($_POST['numero'])) {
                $linkInfo = array(
                    'titre'=>$_POST['title'], 
                    'link'=>$_POST['link'],
                    'type'=>0, 
                    'commentaire'=>"",
                    'date_create'=>date('Y-m-d'), 
                    'user_create'=>$this->session->userdata ('GUSERID'),
                    "thumbnail_file"=>$_POST['thumbName']
                );
                $idNewLink = $this->todolist_model->addnewlink($linkInfo);
                
                if ($_POST['thumbName'] != "") {
                    $destFile      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'/'.$_POST['thumbName'];
                    $sourceFile      =  REP_ACTIVITY_SEQUENCE.$_POST['thumbName'];
                    copy($sourceFile,$destFile);
                }

                $todoId =  $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$_POST['idHisorikC']);
            }
            else{
                $todoId =  $this->todolist_model->addTodo($_POST['idNewseq'],$this->session->userdata ('STAGIAIREGRP'),$_POST['idHisorikC']);
            }

        }
        else{
            $id = $this->input->post('id');
            $todoId = $this->todolist_model->addTodo($id,$this->session->userdata ('STAGIAIREGRP'));
        }



        /*add data to notification trainee*/
        $data_notification = array(
            'id_tuteur'  => $this->session->userdata('GUSERID'),
            'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
            'data_type'  => 'todo',
            'id_data'    => $todoId,
            'date_create'=> time()
        );

        $this->Notification_model->add($data_notification);
        $retour['todoId'] = $todoId;
        $retour['lib'] = $this->lang->line('educational_library_teacher_link_and_document');
        echo json_encode($retour);
  
    }
    public function addLibToCourseHistory(){
        $retour = '1';
        //$retour = Array();
        $sender = Array();
        $replyto = Array();
        $destination = Array();
        $subject = '';
        $mailbody = '';
        $mailAltBody = '';
        $filePath = '';

        $width      = "1200";
        $height     = "1280";
        $type;
        $linkD;
        $idHistorikCours;
        if (isset($_POST['id'])) {

            if (is_numeric($_POST['ch'])) {
                $idHistorikCours = $_POST['ch'];                
            } 
            else{
                $data = array(
                    'intitule'            => $_POST['ch'],
                    'commentaire'         => '',
                    'back_color'          => '#000000',
                    'user_create'         => $this->session->userdata('GUSERID'),
                    'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                    'date'                => time()
                );

                $idHistorikCours = $this->coursHistorik_model->add($data);
            }

            $type = $this->Teacher_link_and_document_model->RequestContent('type',$_POST['id']);
            $todoId = $this->todolist_model->addContentTeacherLinkAndDocInTodo($_POST['id'],$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);


            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'todo',
                'id_data'    => $todoId,
                'date_create'=> time()
            );

            $this->Notification_model->add($data_notification);


            if (isset($_POST['notify']) && $_POST['notify'] == 'on') {
                            
                $sender = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $replyto = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $destination = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                );

                $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.$this->convert_utf8($this->coursHistorik_model->Request('intitule',$idHistorikCours)).')';

                $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                if($type == 0){
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                }
                else{
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                }

                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                
                $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                $mailbody .= '<br><br><br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                //$retour['url-elearning'] = base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId;
                $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                if ($sendMail) {
                    $retour = '1';
                }
                else{
                    $retour = '0';
                }

                $this->load->model('Mail_box_model');

                $data_mail_box = array(
                    'sender'    => $sender['email'],
                    'recipient' => $destination['email'],
                    'subject'   => $subject,
                    'body'      => $mailbody,
                    'attachfile'=> $filePath,
                    'status'    => $sendMail,
                    'author'    => $this->session->userdata ('GUSERID'),
                    'target'    => $this->session->userdata ('STAGIAIREID'),
                    'source'    => $this->lang->line('educational_library_teacher_link_and_document'),
                    'date'      => date("Y-m-d H:i:s")
                );
                $this->Mail_box_model->add($data_mail_box);
            }
            //$retour['success'] = '1';
            //echo json_encode($retour);

            if (isset($_POST['modal_view']) && $_POST['modal_view'] == "on") {
                $retour = $todoId;
            }
            echo "###".$retour;
        }
  
    }
    public function addDatabaseDocumentInTodo(){
        $retour = '1';
        //$retour = Array();
        $sender = Array();
        $replyto = Array();
        $destination = Array();
        $subject = '';
        $mailbody = '';
        $mailAltBody = '';
        $filePath = '';

        $width      = "1200";
        $height     = "1280";
        $type;
        $linkD;
        $idHistorikCours;
        if (isset($_POST['id'])) {

            if (is_numeric($_POST['ch'])) {
                $idHistorikCours = $_POST['ch'];                
            } 
            else{
                $data = array(
                    'intitule'            => $_POST['ch'],
                    'commentaire'         => '',
                    'back_color'          => '#000000',
                    'user_create'         => $this->session->userdata('GUSERID'),
                    'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                    'date'                => time()
                );

                $idHistorikCours = $this->coursHistorik_model->add($data);
            }

            if ($this->document_model->Request('lien',$_POST['id']) == 'lien') {
                $type = 0;
                $linkD = $this->document_model->Request('fichier',$_POST['id']);
                $filename = $this->document_model->Request('fichier',$_POST['id']);
            }
            else{
                $type = 2;
                $repDocTodoTuteur=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                if ( ! is_dir($repDocTodoTuteur) ) {
                    mkdir($repDocTodoTuteur, 0777,true);
                } 
                $ext            = explode(".", $this->document_model->Request('fichier',$_POST['id']));
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                if (file_exists(RP_GROUPES.'GRP'.$this->session->userdata('STAGIAIREGRP').'/'.$this->document_model->Request('fichier',$_POST['id']))) {
                    copy(RP_GROUPES.'GRP'.$this->session->userdata('STAGIAIREGRP').'/'.$this->document_model->Request('fichier',$_POST['id']) , $repDocTodoTuteur."/".$filename);
                }
                $linkD = "https://docs.google.com/gview?url=".base_url().'groupes/GRP'.$this->session->userdata('STAGIAIREGRP').'/'.$this->document_model->Request('fichier',$_POST['id']) ;
            }


            $linkInfo = array(
                'titre'=>$this->document_model->Request('titre',$_POST['id']), 
                'link'=>$filename,
                'type'=>$type, 
                'commentaire'=>"",
                'date_create'=>date('Y-m-d'), 
                'user_create'=>$this->session->userdata ('GUSERID'),
                "thumbnail_file"=>''
            );
            $idNewLink = $this->todolist_model->addnewlink($linkInfo);
            
            $todoId = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);


            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'todo',
                'id_data'    => $todoId,
                'date_create'=> time()
            );

            $this->Notification_model->add($data_notification);

            if (isset($linkD)) {
                $docTodoTuteur      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
         
                $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                if ( ! is_dir($docTodoTuteur) ) {
                    mkdir($docTodoTuteur, 0777,true);
                }         

            }

            if (isset($_POST['notify']) && $_POST['notify'] == 'on') {
                            
                $sender = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $replyto = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $destination = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                );

                $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.$this->convert_utf8($this->coursHistorik_model->Request('intitule',$idHistorikCours)).')';

                $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                if($type == 2){
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                }
                else{
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                }

                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                
                $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                $mailbody .= '<br><br><br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                if ($sendMail) {
                    $retour = '1';
                }
                else{
                    $retour = '0';
                }

                $this->load->model('Mail_box_model');

                $data_mail_box = array(
                    'sender'    => $sender['email'],
                    'recipient' => $destination['email'],
                    'subject'   => $subject,
                    'body'      => $mailbody,
                    'attachfile'=> $filePath,
                    'status'    => $sendMail,
                    'author'    => $this->session->userdata ('GUSERID'),
                    'target'    => $this->session->userdata ('STAGIAIREID'),
                    'source'    => $this->lang->line('educational_library_my_link_and_document'),
                    'date'      => date("Y-m-d H:i:s")
                );
                $this->Mail_box_model->add($data_mail_box);
            }
            //$retour['success'] = '1';
            //echo json_encode($retour);

            if (isset($_POST['modal_view']) && $_POST['modal_view'] == "on") {
                $retour = $todoId;
            }
            echo "###".$retour;
        }
  
    }

    public function updatecomment(){
        if (isset($_POST['inputComment'])) {
            $data = array (
                'commentaire' => $_POST['inputComment']
            );
            $this->todolist_model->updateTodo($_POST['inputIdPlanW'],$data);
            //$this->todolist_model->updateNewSequence($_POST['inputIdSeq'],$data);
        }
    }

    public function update(){
        if (isset($_POST['idHisorikC'])) {
            $this->todolist_model->updateCoursHistorique($_POST['idp'],$_POST['idHisorikC']); 
        }
        else{
            $this->todolist_model->update($_POST['idp'],$_POST['stat']); 
        }
        
    }
    public function delete(){
        if(isset($_POST['id'])){
            echo $this->todolist_model->delete($_POST['id']); 
        }
    }
    public function deletenewsequence(){
        /*Get info from new sequence in plan de w*/
        $infp = $this->todolist_model->getInfoNewSeqInPlanDeW($_POST['id']);
        if (!empty($infp)) {
            $return = "NONOK";
        }
        else{
            $this->todolist_model->deletenewsequence($_POST['id']); 
            $return = "DELET";
        }
        echo $return;
        
    }
    public function updatelink($id){
        $getInfoNewSequence = $this->todolist_model->getInfoNewSequence($id);
        foreach($getInfoNewSequence as $s){
             //generate thumbnail usinng api
            $width      = "1200";
            $height     = "1280";
            //if is a doc word or pdf file
            if ($s->type == 2) {
                //verify file exist
                $current_file =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo/'.$s->link;

                
                $file_old      =  RP_GRP_OLD."GRPT".$this->session->userdata('GUSERID').'/documentTodo/'.$s->link;
            
                //copy the file in new app
                if (is_file($file_old)) {
                    copy($file_old, $current_file);
                }
               
               

                $ext            = explode(".", $s->link);

                if ($ext[1]=="pdf") {
                    $urlF          = base_url().'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$s->link;
                }
                else{
                    $urlF   = base_url().'groupes/index.php?link=GRPT'.$this->session->userdata('GUSERID').'___documentTodo___'.$s->link;
                }


                $ourpage = $urlF;
            }
            
            else{ //if is a link
                $ourpage = $s->link;
            }
           

            $docTodoTuteur      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';

            $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';
      
            if ( ! is_dir($docTodoTuteur) ) {
                mkdir($docTodoTuteur, 0777,true);
            }         
            
            $thumb = $this->generateThumbnail($ourpage,$width,$height,$docTodoTuteur."/".$thumbnailFile);
            if($thumb){
                if ($s->type == 2) {
                    $this->todolist_model->updatelink($id,$thumbnailFile);
                }
                else{
                    $this->todolist_model->updatelinks($id,$thumbnailFile,$this->detecturl($ourpage));
                }
            }
       
        }
  
    }

    public function addNewLink(){

        $urlF    = "";
        $this->load->library('form_validation');
        $type    = $this->input->post('typedocselect');
        $Title   = $this->input->post('Title');
        $link    = $this->input->post('link');
        $filedoc = $this->input->post('filedoc');
        $comment = $this->input->post('comment');     

        $width      = "1200";
        $height     = "1280";


        if ($type == 0) {
            $urlF    = $link;
            $filesdb = $link;
        }

        if ($type == 2) {

            $files['fichier']    = isset($_FILES['filedoc'])?$_FILES['filedoc']:'';

            if ( isset($files['fichier']['name']) && strlen($files['fichier']['name'])>0 && $files['fichier']['size']>0 ) {
                $repDocTodoTuteur=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                if ( ! is_dir($repDocTodoTuteur) ) {
                    mkdir($repDocTodoTuteur, 0777,true);
                } 
                $ext            = explode(".", $files['fichier']['name']);
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                $server_fichier = $this->copier_fichier( $files['fichier'],$repDocTodoTuteur."/".$filename);

                /*if ($ext[1]=="pdf") {
                    $urlF          = base_url().'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$filename;
                }
                else{
                    $urlF   = base_url().'groupes/index.php?link=GRPT'.$this->session->userdata('GUSERID').'___documentTodo___'.$filename;
                }*/
                $urlF = "https://docs.google.com/gview?url=".base_url().'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$filename."&amp;embedded=true";
                $filesdb        = $filename;               


            }
        }
       
         
        if ($type != "") {

            $docTodoTuteur      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
         
            $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

            if ( ! is_dir($docTodoTuteur) ) {
                mkdir($docTodoTuteur, 0777,true);
            }         

            $thumb = $this->generateThumbnail($urlF,$width,$height,$docTodoTuteur."/".$thumbnailFile);    
            
            if ($type == 0) {
                $linkInfo = array('titre'=>$Title, 'link'=>$filesdb,'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID'),"thumbnail_file"=>$thumbnailFile,"ifrmaccess"=>$this->detecturl($urlF));   
            }
            else{
                $linkInfo = array('titre'=>$Title, 'link'=>$filesdb,'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID'),"thumbnail_file"=>$thumbnailFile);   
            }
            if($thumb){
                $idNewLink = $this->todolist_model->addnewlink($linkInfo);
                if($idNewLink > 0)
                {
                    $this->session->set_flashdata('success', 'New link created successfully');
                }
                else
                {
                    $this->session->set_flashdata('error', 'Link creation failed');
                }
            }
            redirect('listLinkDocs');
        }
    }
    public function addDocsOrLinkInTodo(){
        if (isset($_POST['id-cours-historik']) && $_POST['typedocselect'] == "2") {

            $urlF       = "";
            $type       = $_POST['typedocselect'];
            $Title      = $_POST['Title'];
                      
            $comment    = $_POST['comment'];
            $type       = $_POST['typedocselect'];

            $width      = "1200";
            $height     = "1280";


            $files   = isset($_FILES['filedoc'])?$_FILES['filedoc']:'';
            if ( isset($files['name']) && strlen($files['name'])>0 && $files['size']>0 ) {
                $repDocTodoTuteur=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                if ( ! is_dir($repDocTodoTuteur) ) {
                    mkdir($repDocTodoTuteur, 0777,true);
                } 
                $ext            = explode(".", $files['name']);
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                $server_fichier = $this->copier_fichier($files,$repDocTodoTuteur."/".$filename);
                if ($server_fichier != '') {
                    $dataInfoNewDoc = array('titre'=>$Title, 'link'=>$filename,'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID')); 
                    $idNewLink = $this->todolist_model->addnewlink($dataInfoNewDoc);
                    $urlF = "https://docs.google.com/gview?url=".base_url().'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$filename."&amp;embedded=true";

                    $docTodoTuteur      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
                 
                    $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                    if ( ! is_dir($docTodoTuteur) ) {
                        mkdir($docTodoTuteur, 0777,true);
                    }         

                    $thumb = $this->generateThumbnail($urlF,$width,$height,$docTodoTuteur."/".$thumbnailFile); 
                    if($thumb){

                        $dataUpdate = array(
                            "thumbnail_file"=>$thumbnailFile
                        );
                        $this->todolist_model->updateNewSequence($idNewLink,$dataUpdate);
                    }
                    echo 'todo'.$this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$_POST['id-cours-historik']);
                }
            }
        }
        elseif ($_POST['dataDocOrLink']) {
            
            $urlF       = "";
            $type       = $_POST['dataDocOrLink']['typedocselect'];
            $Title      = $_POST['dataDocOrLink']['Title'];
                      
            $comment    = $_POST['dataDocOrLink']['comment'];
            $type       = $_POST['dataDocOrLink']['typedocselect'];
            $link       = $_POST['dataDocOrLink']['link'];  

            $width      = "1200";
            $height     = "1280";


            $urlF    = $link;
            $filesdb = $link;
             
            if (isset($urlF) && $urlF != '') {
                $dataInfo = array('titre'=>$Title, 'link'=>$filesdb,'type'=>$type, 'commentaire'=>$comment,'date_create'=>date('Y-m-d'), 'user_create'=>$this->session->userdata ('GUSERID'),"ifrmaccess"=>$this->detecturl($urlF));
                $idNewLink = $this->todolist_model->addnewlink($dataInfo);

                $docTodoTuteur      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID').'';
             
                $thumbnailFile = "thumbnail_".time().'_'.$this->session->userdata('GUSERID').'.png';

                if ( ! is_dir($docTodoTuteur) ) {
                    mkdir($docTodoTuteur, 0777,true);
                }         

                $thumb = $this->generateThumbnail($urlF,$width,$height,$docTodoTuteur."/".$thumbnailFile);    
                

                if($thumb){

                    $dataUpdate = array(
                        "thumbnail_file"=>$thumbnailFile
                    );
                    $this->todolist_model->updateNewSequence($idNewLink,$dataUpdate);
                }
                echo 'todo'.$this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$_POST['dataDocOrLink']['id-cours-historik']);
            }
        }
        else{

        }
    }
    public function addDocsOrLinkInTodo1(){
        //$retour = Array();
        $retour = '1';
        $sender = Array();
        $replyto = Array();
        $destination = Array();
        $subject = '';
        $mailbody = '';
        $mailAltBody = '';
        $filePath = '';
        $idHistorikCours;
        if (isset($_POST['ch'])) {
            if (is_numeric($_POST['ch'])) {
                $idHistorikCours = $_POST['ch'];                
            } 
            else{
                $data = array(
                    'intitule'            => $_POST['ch'],
                    'commentaire'         => '',
                    'back_color'          => '#000000',
                    'user_create'         => $this->session->userdata('GUSERID'),
                    'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                    'date'                => time()
                );

                $idHistorikCours = $this->coursHistorik_model->add($data);
            }

            $todoId = $this->todolist_model->addTodo($_POST['idNewseq'],$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);
            if (isset($_POST['notify']) && $_POST['notify'] == 'on') {
                            
                $sender = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $replyto = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $destination = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                );

                $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.$this->convert_utf8($this->coursHistorik_model->Request('intitule',$idHistorikCours)).')';

                $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                if($this->todolist_model->RequestNewSequence('type',$_POST['idNewseq']) == 2){                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                }
                else{
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                }

                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                
                $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                $mailbody .= '<br><br><br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                //$retour['url-elearning'] = base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$idHistorikCours.'&container='.$todoId;
                $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                if ($sendMail) {
                    $retour = '1';
                }
                else{
                    $retour = '0';
                }
            }
            //$retour['success'] = '1';
            //echo json_encode($retour);
            echo "###".$retour;
        }
    }


    public function getwebpage()
    { 
        echo  file_get_contents($this->input->post('link'));
    }
    public function viewTodo(){
        $this->global['pageTitle'] = 'E-learning : Forma2+';
        
        $this->loadViews("todolist/viewstodo", $this->global, NULL , NULL);
    }

    public function copier_fichier($fichier, $dest) {

        $name =  basename($dest);
        $extension = $this->check_docs_extension($fichier['name']);
        if ($extension) {        
            if ( is_uploaded_file($fichier['tmp_name']) ) {
         
                @move_uploaded_file($fichier['tmp_name'],$dest) ;
                return($name);
            } else {
                die('erreur tmp_file -> '.$fichier['error']);
                return(false) ;
            }
        }
    }

    public function check_docs_extension($docs){

        $docs_extentions = array("pdf","doc","docx","jpeg","jpg","xls","xlsx","PDF","PNG");

        $docs_parts = explode(".",$docs);

        $docs_end_part = end($docs_parts);

        if(in_array($docs_end_part,$docs_extentions ) == true){
            return true;
        }
        else{
            return false;
        }
    }
    public function getStat(){
        $ret = array();
        $ret['retour'] = "tracking and url final";
        if (isset($_POST['link'])) {
            $ret['finalUrl']  = $this->findUltimateDestination($_POST['link'],10);
            $ret['responses'] = $this->getHeaderResponses($_POST['link']);
            if (strpos($_POST['link'], 'vimeo.com') !== false || strpos($_POST['link'], 'facebook.com') !== false || strpos($_POST['link'], 'dailymotion.com') !== false || strpos($_POST['link'], 'youtube') !== false || strpos($_POST['link'], 'youtu.be') !== false) {
                $ret['mediaUrl'] = $this->getEmbedUrlFromTodo($this->todolist_model->Request('num_sequence',$_POST['idPlanDeTravail']));
            }
        }

        if (isset($_POST['idPlanDeTravail'])) {
            $this->loadTrackingEl($_POST['idHisorikC'],$_POST['idPlanDeTravail'],$this->tracking_type);
        }
        echo json_encode($ret);
    }

    public function accessinlink(){
        $this->global['pageTitle']  = 'E-learning : Todo';
        include (APPPATH.'libraries/DocxConversion.php');
        if (isset($_GET)) {        
            $iframaccess              = "";
            $id                       = $_GET['id'];
            $this->loadTrackingEl($this->todolist_model->Request('historique_cours',$id),$id,$this->tracking_type);
            $linkIfram = '';
            $urlTodo1 = $this->todolist_model->Request('url',$_GET['id']);
            $typeTodo = $this->todolist_model->RequestNewSequence('type',$this->todolist_model->Request('num_sequence',$_GET['id']));
            if (isset($_GET['local-data']) && $_GET['local-data'] == 'blam') {
                $linkIfram = 'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1;

                $data['linkIframFinal'] = $linkIfram;
                $iframaccess              = "no";
            }
            else{
                if ($typeTodo == 0 && strpos($urlTodo1, 'youtube') === false && strpos($urlTodo1, 'youtu.be') === false && strpos($urlTodo1, 'vimeo.com') === false && strpos($urlTodo1, 'facebook.com') === false && strpos($urlTodo1, 'dailymotion.com') === false) {
                    $linkIfram = $this->todolist_model->Request('url',$_GET['id']);
                }
                elseif ($typeTodo == 0 && (strpos($urlTodo1, 'vimeo.com') !== false || strpos($urlTodo1, 'facebook.com') !== false || strpos($urlTodo1, 'dailymotion.com') !== false || strpos($urlTodo1, 'youtube') !== false || strpos($urlTodo1, 'youtu.be') !== false)) {
                    $linkIfram = $this->getEmbedUrl($urlTodo1);
                }            
                elseif ((strpos(HTTP_MAIN.'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1, '.doc') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1, '.docx') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1, '.ppt') !== false) || (strpos(HTTP_MAIN.'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1, '.pdf') !== false)){

                    //$linkIfram = "https://docs.google.com/gview?url=".HTTP_MAIN.'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1."&amp;embedded=true";
                    $linkIfram = HTTP_MAIN.'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1;
                }
                else{
                    $linkIfram = HTTP_MAIN.'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$urlTodo1;
                }
                /*else{
                    $linkIfram = "https://docs.google.com/gview?url=".base_url().'groupes/GRPT'.$this->session->userdata('GUSERID').'/documentTodo/'.$this->todolist_model->Request('url',$_GET['id'])."&amp;embedded=true";
                }*/
                $iframaccess              = "yes";
                $data['linkIframFinal'] = $this->findUltimateDestination($linkIfram,10);
            }
            $data['DocxConversionClass']       = new DocxConversion(RP_GROUPES.'GRPT9322/documentTodo/DOCUMENT_9322_1646244793.docx');
            $this->global['trackingsession'] = $this->session->userdata ('TRACKINGID');
            $data['totoData']       = $this->todolist_model->ReadTrainingProg($id);
            $data['iframaccess']       = $iframaccess;
            $this->loadViews("tutor/todolist/read", $this->global,$data, NULL );
        }

    }


    public function addLog($txt) {
        if (!file_exists("log.txt")) file_put_contents("log.txt", "");
        file_put_contents("log.txt",date("[j/m/y H:i:s]")." - $txt \r\n".file_get_contents("log.txt"));
    }
   
   public function addActivity(){
        $retour = Array();
        $sender = Array();
        $replyto = Array();
        $destination = Array();
        $subject = '';
        $mailbody = '';
        $mailAltBody = '';
        $filePath = '';

        if (isset($_POST['data'])) {
             if ($this->sequence_model->RequestSeqByIdAndNumero('final_url',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']) != '') {
               $link = $this->sequence_model->RequestSeqByIdAndNumero('final_url',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']);
            }
            else{
                $link = $this->sequence_model->RequestSeqByIdAndNumero('link',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']);
            }
            $linkInfo = array(
                'titre'         => $this->sequence_model->RequestSeqByIdAndNumero('titre',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']), 
                'link'          => $link,
                'type'          =>$this->sequence_model->RequestSeqByIdAndNumero('type',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']) == 1 ? 0 : 2, 
                'commentaire'   =>"",
                'date_create'   =>date('Y-m-d'), 
                'user_create'   =>$this->session->userdata ('GUSERID'),
                "thumbnail_file"=>$this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity'])
            );

            $idNewLink = $this->todolist_model->addnewlink($linkInfo);
            $todoId = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$_POST['data']['course-historik']);
            $retour['todoId'] = $todoId;

            if ($this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']) != "") {
                $rep      =  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/THUMBNAIL'.$this->session->userdata('GUSERID');
                if ( ! is_dir($rep) ) {
                    mkdir($rep, 0755,true);
                }
                $sourceFile      =  REP_ACTIVITY_SEQUENCE.$this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']);
                if (is_file($sourceFile)) {
                    copy($sourceFile,$rep.'/'.$this->sequence_model->RequestSeqByIdAndNumero('thumbnail_file',$_POST['data']['id_sequence_activity'],$_POST['data']['numero_activity']));
                }
            }

            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'todo',
                'id_data'    => $todoId,
                'date_create'=> time()
            );

            $this->Notification_model->add($data_notification);

            if (isset($_POST['data']['send_mail']) && $_POST['data']['send_mail'] == 'on') {
                $sender = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $replyto = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))),
                );
                $destination = array(
                    'email' => $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('STAGIAIREID'))),
                    'name'  => $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))),
                );

                $subject = 'Forma2plus - E-learning plateform ('.$this->convert_utf8($this->lang->line('training_period_course_history')).' - '.utf8_decode($this->coursHistorik_model->Request('intitule',$_POST['data']['course-historik'])).')';

                $mailbody .= $this->lang->line('el_send_mail_infos_hello').' '.$this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('STAGIAIREID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('STAGIAIREID'))).',<br><br>';

                if ($this->todolist_model->RequestNewSequence('type',$idNewLink) == 2) {
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_doc')).' ';
                }
                else{
                    $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_new_link')).' ';
                }

                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been')).'<br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_has_been_access')).' : <br>';
                
                $mailbody .= '<a href="'.base_url().'loginMe?auth=true&pr='.$this->session->userdata ('GUSERID').'&action=ch_tr&ident='.$this->convert_utf8($this->membres_model->Request('login',$this->session->userdata ('STAGIAIREID'))).'&pd='.$this->convert_utf8($this->membres_model->Request('password',$this->session->userdata ('STAGIAIREID'))).'&access=ch&id='.$_POST['data']['course-historik'].'&container='.$todoId.'" target="_blank">F2+ | E-learning Plateform</a><br>';
                $mailbody .= '<br><br><br>';
                $mailbody .= $this->convert_utf8($this->lang->line('el_send_mail_infos_sign')).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('prenom',$this->session->userdata ('GUSERID'))).' '.$this->convert_utf8($this->membres_model->Request('nom',$this->session->userdata ('GUSERID'))).' <br>';
                $mailbody .= $this->convert_utf8($this->membres_model->Request('email',$this->session->userdata ('GUSERID')));

                $sendMail = $this->sendMailElearning($sender,$destination,$subject,$mailbody,$mailAltBody,$filePath,$replyto);
                if ($sendMail) {
                    $retour['infosSendMail'] = true;
                }
                else{
                    $retour['infosSendMail'] = false;
                }

                $this->load->model('Mail_box_model');

                $data_mail_box = array(
                    'sender'    => $sender['email'],
                    'recipient' => $destination['email'],
                    'subject'   => $subject,
                    'body'      => $mailbody,
                    'attachfile'=> $filePath,
                    'status'    => $sendMail,
                    'author'    => $this->session->userdata ('GUSERID'),
                    'target'    => $this->session->userdata ('STAGIAIREID'),
                    'source'    => ($_POST['data']['pave_sequence'] && $_POST['data']['pave_sequence'] == 7) ? $this->lang->line('educational_library_personnal_interest') : $this->lang->line('educational_library_pedagogical_training'),
                    'date'      => date("Y-m-d H:i:s")
                );
                $this->Mail_box_model->add($data_mail_box);
                
            }
            
        }
        else{
            $retour['dataInfo'] = false;
        }
        echo json_encode($retour);
    }

    public function addDbDocInTodo(){
        $retour = array();
        $type;
        $idHistorikCours;
        if (isset($_POST['id'])) {

            if (is_numeric($_POST['ch'])) {
                $idHistorikCours = $_POST['ch'];                
            } 
            else{
                $data = array(
                    'intitule'            => $_POST['ch'],
                    'commentaire'         => '',
                    'back_color'          => '#000000',
                    'user_create'         => $this->session->userdata('GUSERID'),
                    'id_groupe'           => $this->session->userdata('STAGIAIREGRP'),
                    'date'                => time()
                );

                $idHistorikCours = $this->coursHistorik_model->add($data);
            }

            $retour['idHistorikCours'] = $idHistorikCours;

            if ($this->document_model->Request('lien',$_POST['id']) == 'lien') {
                $type = 0;
                $filename = $this->document_model->Request('fichier',$_POST['id']);
            }
            else{
                $type = 2;
                $repDocTodoTuteur=  RP_GROUPES."GRPT".$this->session->userdata('GUSERID').'/documentTodo';
                if ( ! is_dir($repDocTodoTuteur) ) {
                    mkdir($repDocTodoTuteur, 0777,true);
                } 
                $ext            = explode(".", $this->document_model->Request('fichier',$_POST['id']));
                $filename       = "DOCUMENT_".$this->session->userdata('GUSERID').'_'.time().'.'.$ext[1];
                if (file_exists(RP_GROUPES.'GRP'.$this->session->userdata('STAGIAIREGRP').'/'.$this->document_model->Request('fichier',$_POST['id']))) {
                    copy(RP_GROUPES.'GRP'.$this->session->userdata('STAGIAIREGRP').'/'.$this->document_model->Request('fichier',$_POST['id']) , $repDocTodoTuteur."/".$filename);
                }
            }


            $linkInfo = array(
                'titre'=>$this->document_model->Request('titre',$_POST['id']), 
                'link'=>$filename,
                'type'=>$type, 
                'commentaire'=>"",
                'date_create'=>date('Y-m-d'), 
                'user_create'=>$this->session->userdata ('GUSERID'),
                "thumbnail_file"=>''
            );
            $idNewLink = $this->todolist_model->addnewlink($linkInfo);
            
            $retour['todoId'] = $this->todolist_model->addTodo($idNewLink,$this->session->userdata ('STAGIAIREGRP'),$idHistorikCours);


            /*add data to notification trainee*/
            $data_notification = array(
                'id_tuteur'  => $this->session->userdata('GUSERID'),
                'id_groupe'  => $this->session->userdata('STAGIAIREGRP'),
                'data_type'  => 'todo',
                'id_data'    =>  $retour['todoId'],
                'date_create'=> time()
            );

            $this->Notification_model->add($data_notification);
        }
        $retour['lib'] = $this->lang->line('educational_library_my_link_and_document');

        echo json_encode($retour);
  
    }
}

?>