<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Glossaire
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.0
 * @since : 04 Octobre 2022
 */
class Glossaire extends ElearningForma2PlusController
{
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model('bddl_model');
        $this->load->model('commande_glossaire_papier_model');
        $this->isLoggedIn(); 
        $this->tracking_type = 22;  
        $this->load->library('user_agent');  
    }
   
    public function index()
    {
        ini_set('memory_limit', '-1');
        $data             = array();        
        $arrayPrototypeId = array();
        $arrayprot       = array();
        $pcview           = '';
        $mview            = '';
        
        $this->global['pageTitle'] = 'E-learning : My glossary'; 


        if (isset($_POST['term'])) {
            $data['term'] = $this->input->post('term');
        }
        else{
            $data['term'] = '';
        }


        $this->loadTrackingEl(0,0,$this->tracking_type);

        if (isset($_GET['dl'])) {
            $sessionArray = array('LANGAGETXTSP'=>str_replace('_', ' ', $_GET['dl']));
            $this->session->set_userdata($sessionArray);      
        }

        $prototypeGrp = $this->groupes_model->readPrototypeGroupe($this->session->userdata('STAGIAIREGRP'));
        $data['allowed_commande_papers_glossary'] = $prototypeGrp['allowed_commande_papers_glossary'];
        if(!empty($prototypeGrp['prototype'])) {
            $prx = explode(",", $prototypeGrp['prototype']);
            for ($i=0; $i < count($prx); $i++) { 
                $arrayPrototypeId[$i] = (int)($prx[$i]);
                $arrayprot[$i] = $this->getGlossaireDigitalByPrototype((int)($prx[$i]));
            }
            
        }

        if (isset($_GET['id'])) {
            $data['allDataResults'] = $arrayprot;
            $pcview .= 'pcview';
            $mview  .= 'mview';
        }
        elseif (isset($_GET['theme']) && isset($_GET['pr']) && isset($_GET['soc'])) {
            $data['allDataResults'] =  $this->bddl_model->getAllVocabByIdPrototypeAccessAndIdLexiqueAndIdTheme($_GET['theme'],$_GET['pr'],$_GET['soc']);
            $pcview .= 'pcview-no-ws';
            $mview  .= 'mview-no-ws';
        }
        else{
            $data['allDataResults'] = $arrayprot;
            $pcview .= 'pcview';
            $mview  .= 'mview';
        }
        //$data['allExpressionNotInCategory'] = $this->databankExpression_Model->getAllByCategory($this->session->userdata('STAGIAIREID'),NULL);
        //$data['expressionCategoryResult'] = $this->databankExpression_Model->getCategoryByIdGroup($this->session->userdata('STAGIAIREGRP'));
        
        if ($this->agent->mobile()) {
            $this->loadViews("tutor/glossary/".$mview, $this->global, $data , NULL);
        }
        else{
            $this->loadViews("tutor/glossary/".$pcview, $this->global, $data , NULL);
        }
    }

    public function listExpressionByCat(){
        $arrayprot = array();
        $this->global['pageTitle'] = 'E-learning - Expression list'; 
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $idCat = isset($_GET['id']) && $_GET['id'] != '' ? $_GET['id'] : NULL;
        $data['expressionCategoryResult'] = $this->databankExpression_Model->getListByCat($this->session->userdata('GUSERID'),$idCat);
        $this->loadViews("trainee/glossary/listExpByCat", $this->global, $data , NULL);
    }
    public function getLeByIdPrototypeAccess(){
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->global['pageTitle'] = 'E-learning : Lexique list'; 


        if (isset($_GET['id'])) {
            $data['allLexique'] = $this->bddl_model->getLeByIdPrototypeAccess($_GET['id']);
        }

        $this->loadViews("trainee/glossary/listLe", $this->global, $data , NULL);
    }
    public function getAllByKey(){
        $prototypeGrp = $this->groupes_model->readPrototypeGroupe($this->session->userdata('GROUPE'));
        if(!empty($prototypeGrp['prototype'])) {
            $prx = explode(",", $prototypeGrp['prototype']);
            for ($i=0; $i < count($prx); $i++) { 
                $arrayprot[$i] = (int)($prx[$i]);
            }
            
        }
        if (isset($_POST['key']) && isset($arrayprot)) {
            $vocalbularyTermsByAllPrototype = $this->bddl_model->getAllVocabByArrayPrototype($arrayprot,$_POST['key'],NULL);
        }
    }

    public function personalise(){
        $idPrototype;
        if (isset($_GET['id'])) {
            $idPrototype = $_GET['id'];
        }
        $this->loadTrackingEl(0,0,$this->tracking_type);
        $data['urlBddlGlossairePapierStagiaire'] = $this->config->item('bddl_api_glossaire_papier').'stagiaire/';
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('glossary_btn_personalise'); 
        $data['resultsJson'] = json_decode(file_get_contents($data['urlBddlGlossairePapierStagiaire'].$this->session->userdata ('GUSERID').'/prototypes/edit/'.$idPrototype));
        $data['mobileDetect'] = $this->agent->mobile();

        $this->loadViews("trainee/glossary/personalise", $this->global, $data , NULL);

    }
}

?>