<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Todolist
 * Base Class to control over all the classes
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 22 November 2018
 */
class Audio extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->isLoggedIn();  
        $this->tracking_type = 88;  
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
    }

     public function list(){   
        $this->global['pageTitle'] = 'E-learning : '.$this->lang->line('training_my_audio');
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $idStagiaire = '';
        $idGroupe = '';

        if($this->isTuteurConnet()){
            $idStagiaire = $this->session->userdata('STAGIAIREID');
            $idGroupe    = $this->session->userdata('STAGIAIREGRP');
            $this->global['groupe'] = $this->session->userdata ('STAGIAIREGRP');
        }   
        else{
            $idStagiaire = $this->session->userdata('GUSERID');
            $idGroupe    = $this->session->userdata('GROUPE');
        }

        $data['audioResultApi'] = $this->getAudioResultByApi($idGroupe,$idStagiaire);
        //var_dump($data['audioResultApi']);

        $this->loadViews("trainee/audio/list", $this->global,$data, NULL );
    }

    public function list2(){      
        $id_group = $this->session->userdata('GROUPE');
        $id_tuteur = $this->session->userdata('GUSERID');
        $id_stag = $this->session->userdata('GUSERID');
        // ["STAGIAIREID"]=> string(4) "4626" ["STAGIAIREGRP"]
        if ($this->session->userdata('STAGIAIREID')){
            $id_group = $this->session->userdata('STAGIAIREGRP');
            $id_tuteur = $this->session->userdata('GUSERID');
            $id_stag = $this->session->userdata('STAGIAIREID');
        }
        //echo "111111";
        //var_dump($this->session->userdata);
        //var_dump($id_stag);

        
        $this->loadTrackingEl(0,0,$this->tracking_type);

        $this->load->library('pagination');
        $this->global['pageTitle'] = 'E-learning : Audio List';
        $this->global['groupe'] = $this->session->userdata ('GROUPE');
        // echo "AAAAAAAAAAAAA";
        // var_dump($this->session->userdata);
        // echo "idstag = ".$id_stag;
        // echo "id_group = ".$id_group;


        // $data = array(
        //     'videoResult' => $this->Audio_model->traineelist($id_stag, $id_group),
        //     'videoFirstResult' => $this->Audio_model->traineelistfirst($id_stag, $id_group),
        //     'groupeid' => $id_group,
        //     'IDstag' => $id_stag,
        //     'grps' => $id_group,
        // );

        $data['audioResult'] = $this->Audio_model->traineelist($id_stag, $id_group);


        //$data['audioResult'] = $this->Audio_model->traineelist($id_stag, $id_group);
        // echo "<pre>";
        // print_r($data['audioResult']);
        // echo "</pre>";
     


        $this->loadViews("trainee/audio/listslider2", $this->global,$data, NULL );
    }

}

?>