from fastapi import FastAPI, HTTPException, Depends
from fastapi.middleware.cors import CORSMiddleware
from fastapi import Response
from fastapi.responses import FileResponse
app = FastAPI()

origins = ["*"]

app.add_middleware(
    CORSMiddleware,
    allow_origins = origins,
    allow_credentials = True,
    allow_methods= ['*'],
    allow_headers= ['*']
)


import re
import requests
import os 

from openai import OpenAI
import json2table
import json
import pdfkit


def chat_gpt(prompt):
    clientopenai = OpenAI(
        # defaults to os.environ.get("OPENAI_API_KEY")
        api_key="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",
    )

    response = clientopenai.chat.completions.create(
        model="gpt-3.5-turbo", messages=[{"role": "user", "content": prompt}]
    )
    return response.choices[0].message.content.strip()


def convert_html_to_pdf(html_content, pdf_path):
    try:
        pdfkit.from_string(html_content, pdf_path)
        print(f"PDF generated and saved at {pdf_path}")
    except Exception as e:
        print(f"PDF generation failed: {e}")


@app.post("/transcription")
async def get_transcription( audio_link ):
    print("1111111111aaa")
    print(audio_link)
    response = requests.get(audio_link, verify=False)
    print("22222222")
    with open("audio.wav", mode="wb") as file:
        for chunk in response.iter_content(chunk_size=10 * 1024):
            file.write(chunk)
    #urlretrieve(audio_link, '/var/www/html/disk2/transcriptionia/transcription/audio.wav')
    print(os.getcwd())
    os.system(f" ffmpeg -y -i audio.wav -ar 16000 -ac 1 -f wav audio_convert.wav")
    os.system(f"/mnt/data/whisper/whisper.cpp/main -m /mnt/data/whisper/whisper.cpp/models/ggml-base.en.bin -f audio_convert.wav  > audio2.srt")
    import glob
    print(glob.glob("/*"))
    
    file = open("audio2.srt", "r")
    content = file.read()
    cln_txt = re.sub(r"\[(\d)+:(\d)+:(\d)+\.(\d)+ --> (\d)+:(\d)+:(\d)+\.(\d)+]", "", content)
    return cln_txt

@app.post("/transcription_fr2")
async def get_transcription( audio_link ):
    print("111111111111111111")
    response = requests.get(audio_link, stream=True)
    with open("audio.wav", mode="wb") as file:
        for chunk in response.iter_content(chunk_size=10 * 1024):
            file.write(chunk)
    #urlretrieve(audio_link, '/var/www/html/disk2/transcriptionia/transcription/audio.wav')
    print(os.getcwd())
    os.system(f" ffmpeg -y -i audio.wav -ar 16000 -ac 1 -f wav audio_convert.wav")
    #os.system(f"/mnt/data/whisper/whisper.cpp/main -m /mnt/data/whisper/whisper.cpp/models/ggml-base.bin --language fr -f {UPLOAD_AUDIO}{file_name}.wav  > {UPLOAD_AUDIO}{file_name}.srt")

    os.system(f"/mnt/data/whisper/whisper.cpp/main -m /mnt/data/whisper/whisper.cpp/models/ggml-base.bin --language fr -f audio_convert.wav  > audio2.srt")
    import glob
    print(glob.glob("/*"))
    
    file = open("audio2.srt", "r")
    content = file.read()
    cln_txt = re.sub(r"\[(\d)+:(\d)+:(\d)+\.(\d)+ --> (\d)+:(\d)+:(\d)+\.(\d)+]", "", content)
    return cln_txt



@app.post("/alo")
async def get_amp(txt):
    build_direction = "LEFT_TO_RIGHT"
    table_attributes = {"style": "width:100%"}

    print(txt)
    html = ""

    json_tense = "{\
                            'present' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'past' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'futur' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'gerund' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                        }"

    mod_aux = "{\
                            'mod_aux' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                        }"

    act_pass_form = "{\
                            'act_pass_form' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                        }"

    html = f"<h1>ETUDE GRAMMATICALE</h1>"
    user_input = f"from this text {txt} classify if the present tense, past tense, futur tense, gerund are not used or not mastered or or partially mastered or fully mastered and give the response in a JSON format like this {json_tense}"
    json_tense_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(json_tense_res)

    infoFromJson = json.loads(str(eval(json_tense_res)).replace("'", '"'))
    tab = json2table.convert(
        infoFromJson, build_direction=build_direction, table_attributes=table_attributes
    )
    html = f"{html} <br/> <h2>Temps grammaticaux en anglais</h2> <br/>{tab}"

    user_input = f"from this text {txt} classify if the modality auxiliaries are not used or not mastered or or partially mastered or fully mastered and give the response in a JSON format like this {mod_aux}"
    mod_aux_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(mod_aux_res)
    infoFromJson = json.loads(str(eval(mod_aux_res)).replace("'", '"'))
    tab = json2table.convert(
        infoFromJson, build_direction=build_direction, table_attributes=table_attributes
    )
    html = f"{html} <br/> <h2>Modaux en anglais</h2>  <br/>{tab}"

    user_input = f"from this text {txt} classify if active form and passive are not used or not mastered or or partially mastered or fully mastered and give the response in a JSON format like this {act_pass_form}"
    act_pass_form_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(act_pass_form_res)
    infoFromJson = json.loads(str(eval(act_pass_form_res)).replace("'", '"'))
    tab = json2table.convert(
        infoFromJson, build_direction=build_direction, table_attributes=table_attributes
    )
    html = f"{html} <br/>  <h2>Voix active / voix passive en anglais</h2> <br/>{tab}"

    user_input = f"based on the data about the tense,modality auxiliaries and active/passive form, give a correction for each potentially wrong sentence from the {txt} and for each correction separate very distinctively the sentence concerned and its correction by following this pattern 'sentence : ......  || correction:........'   and separate each set of sentence and correction with a breakline"
    correct_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(correct_res)

    html = f"{html} <h2>Correction</h2> <br/> {correct_res}"

    user_input = f"based on each sentence of the text from {txt} give a preconisation to improve the use of verb tense,modality auxiliaries and active/passive"
    precon_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(precon_res)

    html = f"{html} <br/> <h2>Preconisation</h2> {precon_res}"

    discours = "{\
                            'substantive' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'adjective' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'adverb' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'verb' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'Word tools' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                        }"

    complexity = "{\
                            'coordination' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'subordination' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                        }"

    html = f"{html} <br/> <h1>ETUDE SYNTAXIQUE</h1> <br/>{tab}"
    user_input = f"from this text {txt} classify if the substantive, adjective, adverb, verb, word tools are not used or not mastered or or partially mastered or fully mastered and give the response in a JSON format like this {discours}"
    discours_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(discours_res)
    infoFromJson = json.loads(str(eval(discours_res)).replace("'", '"'))
    tab = json2table.convert(
        infoFromJson, build_direction=build_direction, table_attributes=table_attributes
    )
    html = f"{html} <br/> <h2>Parties du discours</h2> <br/>{tab}"

    user_input = f"from this text {txt} classify if the coordination, subordination are not used or not mastered or or partially mastered or fully mastered and give the response in a JSON format like this {complexity}"
    complexity_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(complexity_res)
    infoFromJson = json.loads(str(eval(complexity_res)).replace("'", '"'))
    tab = json2table.convert(
        infoFromJson, build_direction=build_direction, table_attributes=table_attributes
    )
    html = f"{html} <br/> <h2>Complexité des phrases en anglais</h2> <br/>{tab}"

    user_input = f"based on each sentence of the text from {txt} give a preconisation to improve the use of substantive, adjective, adverb, verb, Word tools, coordination, subordination"
    discours_res_corr = chat_gpt(user_input)
    print("++++++++++++++++")
    print(discours_res_corr)
    html = f"{html} <br/> <h2>Preconisation</h2> <br/>{discours_res_corr}"

    user_input = f"based on the data about the  substantive, adjective, adverb, verb, Word tools, coordination, subordination give a correction for each potentially wrong sentence from the {txt} and for each correction separate very distinctively the sentence concerned and its correction by following this pattern 'sentence : ......  || correction:........'   and separate each set of sentence and correction with a breakline"
    discours_precon = chat_gpt(user_input)
    print("++++++++++++++++")
    print(discours_precon)
    html = f"{html} <br/> <h2>Correction</h2> <br/>{discours_precon}"

    # ---------------VOCABULAIRE USUEL
    # print(txt)

    lexic = "{\
                            'Common vocabulary' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'Technical vocabulary' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'Idiomatic expressions' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                        }"

    expression_degree = "{\
                            'Qualification' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'Quantification' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                            'Comparative or superlative' : \
                                {\
                                'not used' : 'no or yes',\
                                'not mastered' : 'no or yes',\
                                'partially mastered' : 'no or yes',\
                                'fully mastered' : 'no or yes',\
                                },\
                        }"

    html = f"{html} <br/> <h1>ETUDE LEXICALE</h1> <br/>{tab}"

    user_input = f"from this text {txt} classify if the Common vocabulary, Technical vocabulary, Idiomatic expressions,  are not used or not mastered or or partially mastered or fully mastered and give the response in a JSON format like this {lexic}"
    lexic_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(lexic_res)
    infoFromJson = json.loads(str(eval(lexic_res)).replace("'", '"'))
    tab = json2table.convert(
        infoFromJson, build_direction=build_direction, table_attributes=table_attributes
    )
    html = f"{html} <br/> <h2>Champs lexicaux  en anglais</h2> <br/>{tab}"

    user_input = f"from this text {txt} classify if the Qualification, Quantification,Comparative or superlative are not used or not mastered or or partially mastered or fully mastered and give the response in a JSON format like this {expression_degree}"
    expression_degree_res = chat_gpt(user_input)
    print("++++++++++++++++")
    print(expression_degree_res)
    infoFromJson = json.loads(str(eval(expression_degree_res)).replace("'", '"'))
    tab = json2table.convert(
        infoFromJson, build_direction=build_direction, table_attributes=table_attributes
    )
    html = f"{html} <br/> <h2>Expression des degrés  en anglais</h2> <br/>{tab}"

    user_input = f"based on each sentence of the text from {txt} give a preconisation to improve the use of  Common vocabulary, Technical vocabulary, Idiomatic expressions"
    expression_degree_res_corr = chat_gpt(user_input)
    print("++++++++++++++++")
    print(expression_degree_res_corr)
    html = f"{html} <br/> <h2>Preconisation</h2> <br/>{expression_degree_res_corr}"

    user_input = f"based on the data about the    Common vocabulary, Technical vocabulary, Idiomatic expressions, give a correction for each potentially wrong sentence from the {txt} and for each correction separate very distinctively the sentence concerned and its correction by following this pattern 'sentence : ......  || correction:........'   and separate each set of sentence and correction with a breakline"
    expression_degree_res_precon = chat_gpt(user_input)
    print("++++++++++++++++")
    print(expression_degree_res_precon)
    html = f"{html} <br/> <h2>Correction</h2> <br/>{expression_degree_res_precon}"

    pdf_path = 'alo.pdf'

    # Generate PDF
    convert_html_to_pdf(html, pdf_path)

    return FileResponse(path=pdf_path, filename=pdf_path, media_type='application/pdf')
