<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';
//require APPPATH . '/libraries/GroupeIncController.php';

/**
 * Class : CoursHistorik
 * Base Class to control over all the classes
 * @author : Alexandre Bors
 * @version : 1.1
 * @since : 22 November 2018
 */
class SpeedConnexion extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        
        $this->isLoggedIn();   
        $this->action_type = 31;
        $this->tracking_type = 25;
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Speed connexion';
        /*$duree_du_test=4;
        $taille=($duree_du_test/$this->envoi_des_donnnes(100000))*100000;
        $data['debit']=round(8*$taille/1000/$this->envoi_des_donnnes($taille),0);*/
        $this->loadTrackingEl(0,0,$this->tracking_type);

        if ($this->isTuteurConnet()) {
            $this->loadViews("tutor/speed-connexion/view", $this->global,NULL, NULL );

        }
        else{
            $this->loadViews("trainee/speed-connexion/view", $this->global,NULL, NULL );
        }


    }
    /**
     * @return string
     */
    public function getClientIp()
    {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_REAL_IP'])) {
            $ip = $_SERVER['HTTP_X_REAL_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            $ip = preg_replace('/,.*/', '', $ip); # hosts are comma-separated, client is first
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }

        return preg_replace('/^::ffff:/', '', $ip);
    }

    /**
     * @param string $ip
     *
     * @return string|null
     */
    public function getLocalOrPrivateIpInfo($ip)
    {
        // ::1/128 is the only localhost ipv6 address. there are no others, no need to strpos this
        if ('::1' === $ip) {
            return 'localhost IPv6 access';
        }

        // simplified IPv6 link-local address (should match fe80::/10)
        if (stripos($ip, 'fe80:') === 0) {
            return 'link-local IPv6 access';
        }

        // anything within the 127/8 range is localhost ipv4, the ip must start with 127.0
        if (strpos($ip, '127.') === 0) {
            return 'localhost IPv4 access';
        }

        // 10/8 private IPv4
        if (strpos($ip, '10.') === 0) {
            return 'private IPv4 access';
        }

        // 172.16/12 private IPv4
        if (preg_match('/^172\.(1[6-9]|2\d|3[01])\./', $ip) === 1) {
            return 'private IPv4 access';
        }

        // 192.168/16 private IPv4
        if (strpos($ip, '192.168.') === 0) {
            return 'private IPv4 access';
        }

        // IPv4 link-local
        if (strpos($ip, '169.254.') === 0) {
            return 'link-local IPv4 access';
        }

        return null;
    }

    /**
     * @return string
     */
    public function getIpInfoTokenString()
    {
        if (
            !file_exists(API_KEY_FILE)
            || !is_readable(API_KEY_FILE)
        ) {
            return '';
        }

        require API_KEY_FILE;

        if (empty($IPINFO_APIKEY)) {
            return '';
        }

        return '?token='.$IPINFO_APIKEY;
    }

    /**
     * @param string $ip
     *
     * @return array|null
     */
    public function getIspInfo($ip)
    {
        $json = file_get_contents('https://ipinfo.io/'.$ip.'/json'.$this->getIpInfoTokenString());
        if (!is_string($json)) {
            return null;
        }

        $data = json_decode($json, true);
        if (!is_array($data)) {
            return null;
        }

        return $data;
    }

    /**
     * @param array|null $rawIspInfo
     *
     * @return string
     */
    public function getIsp($rawIspInfo)
    {
        if (
            !is_array($rawIspInfo)
            || !array_key_exists('org', $rawIspInfo)
            || !is_string($rawIspInfo['org'])
            || empty($rawIspInfo['org'])
        ) {
            return 'Unknown ISP';
        }

        // Remove AS##### from ISP name, if present
        return preg_replace('/AS\\d+\\s/', '', $rawIspInfo['org']);
    }

    /**
     * @return string|null
     */
    public function getServerLocation()
    {
        $serverLoc = null;
        if (
            file_exists(SERVER_LOCATION_CACHE_FILE)
            && is_readable(SERVER_LOCATION_CACHE_FILE)
        ) {
            require SERVER_LOCATION_CACHE_FILE;
        }
        if (is_string($serverLoc) && !empty($serverLoc)) {
            return $serverLoc;
        }

        $json = file_get_contents('https://ipinfo.io/json'.$this->getIpInfoTokenString());
        if (!is_string($json)) {
            return null;
        }

        $details = json_decode($json, true);
        if (
            !is_array($details)
            || !array_key_exists('loc', $details)
            || !is_string($details['loc'])
            || empty($details['loc'])
        ) {
            return null;
        }

        $serverLoc = $details['loc'];
        $cacheData = "<?php\n\n\$serverLoc = '".addslashes($serverLoc)."';\n";
        file_put_contents(SERVER_LOCATION_CACHE_FILE, $cacheData);

        return $serverLoc;
    }

    /**
     * Optimized algorithm from http://www.codexworld.com
     *
     * @param float $latitudeFrom
     * @param float $longitudeFrom
     * @param float $latitudeTo
     * @param float $longitudeTo
     *
     * @return float [km]
     */
    public function distance(
        $latitudeFrom,
        $longitudeFrom,
        $latitudeTo,
        $longitudeTo
    ) {
        $rad = M_PI / 180;
        $theta = $longitudeFrom - $longitudeTo;
        $dist = sin($latitudeFrom * $rad)
            * sin($latitudeTo * $rad)
            + cos($latitudeFrom * $rad)
            * cos($latitudeTo * $rad)
            * cos($theta * $rad);

        return acos($dist) / $rad * 60 * 1.853;
    }

    /**
     * @param array|null $rawIspInfo
     *
     * @return string|null
     */
    public function getDistance($rawIspInfo)
    {
        if (
            !is_array($rawIspInfo)
            || !array_key_exists('loc', $rawIspInfo)
            || !isset($_GET['distance'])
            || !in_array($_GET['distance'], ['mi', 'km'], true)
        ) {
            return null;
        }

        $unit = $_GET['distance'];
        $clientLocation = $rawIspInfo['loc'];
        $serverLocation = $this->getServerLocation();

        if (!is_string($serverLocation)) {
            return null;
        }

        return $this->calculateDistance(
            $serverLocation,
            $clientLocation,
            $unit
        );
    }

    /**
     * @param string $clientLocation
     * @param string $serverLocation
     * @param string $unit
     *
     * @return string
     */
    public function calculateDistance($clientLocation, $serverLocation, $unit)
    {
        list($clientLatitude, $clientLongitude) = explode(',', $clientLocation);
        list($serverLatitude, $serverLongitude) = explode(',', $serverLocation);
        $dist = $this->distance(
            $clientLatitude,
            $clientLongitude,
            $serverLatitude,
            $serverLongitude
        );

        if ('mi' === $unit) {
            $dist /= 1.609344;
            $dist = round($dist, -1);
            if ($dist < 15) {
                $dist = '<15';
            }

            return $dist.' mi';
        }

        if ('km' === $unit) {
            $dist = round($dist, -1);
            if ($dist < 20) {
                $dist = '<20';
            }

            return $dist.' km';
        }

        return null;
    }
    public function getChunkCount()
    {
        if (
            !array_key_exists('ckSize', $_GET)
            || !ctype_digit($_GET['ckSize'])
            || (int) $_GET['ckSize'] <= 0
        ) {
            return 4;
        }

        if ((int) $_GET['ckSize'] > 1024) {
            return 1024;
        }

        return (int) $_GET['ckSize'];
    }

    /**
     * @return void
     */
    public function sendHeaders()
    {
        header('Content-Type: application/json; charset=utf-8');

        if (isset($_GET['cors'])) {
            header('Access-Control-Allow-Origin: *');
            header('Access-Control-Allow-Methods: GET, POST');
        }

        header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0, s-maxage=0');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');
    }

    /**
     * @param string $ip
     * @param string|null $ipInfo
     * @param string|null $distance
     * @param array|null $rawIspInfo
     *
     * @return void
     */
    public function sendResponse(
        $ip,
        $ipInfo = null,
        $distance = null,
        $rawIspInfo = null
    ) {
        $processedString = $ip;
        if (is_string($ipInfo)) {
            $processedString .= ' - '.$ipInfo;
        }

        if (
            is_array($rawIspInfo)
            && array_key_exists('country', $rawIspInfo)
        ) {
            $processedString .= ', '.$rawIspInfo['country'];
        }
        if (is_string($distance)) {
            $processedString .= ' ('.$distance.')';
        }

        $this->sendHeaders();
        echo json_encode([
            'processedString' => $processedString,
            'rawIspInfo' => $rawIspInfo ?: '',
        ]);
    }

    public function getIP(){
        error_reporting(0);
        define('API_KEY_FILE', 'getIP_ipInfo_apikey.php');
        define('SERVER_LOCATION_CACHE_FILE', 'getIP_serverLocation.php');
        $ip = $this->getClientIp();

        $localIpInfo = $this->getLocalOrPrivateIpInfo($ip);
        // local ip, no need to fetch further information
        if (is_string($localIpInfo)) {
            $this->sendResponse($ip, $localIpInfo);
            exit;
        }

        if (!isset($_GET['isp'])) {
            $this->sendResponse($ip);
            exit;
        }

        $rawIspInfo = $this->getIspInfo($ip);
        $isp = $this->getIsp($rawIspInfo);
        $distance = $this->getDistance($rawIspInfo);

        $this->sendResponse($ip, $isp, $distance, $rawIspInfo);
    }

    public function empty(){
        header('HTTP/1.1 200 OK');
        if (isset($_GET['cors'])) {
            header('Access-Control-Allow-Origin: *');
            header('Access-Control-Allow-Methods: GET, POST');
            header('Access-Control-Allow-Headers: Content-Encoding, Content-Type');
        }

        header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0, s-maxage=0');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');
        header('Connection: keep-alive');
    }

    public function garbage(){
        @ini_set('zlib.output_compression', 'Off');
        @ini_set('output_buffering', 'Off');
        @ini_set('output_handler', '');
        // Determine how much data we should send
        $chunks = $this->getChunkCount();

        // Generate data
        $data = openssl_random_pseudo_bytes(1048576);

        // Deliver chunks of 1048576 bytes
        $this->sendHeaders();
        for ($i = 0; $i < $chunks; $i++) {
            echo $data;
            flush();
        }
    }
    
   
}

?>