<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

class MailBox extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Mail_box_model');
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        
    }
    
    public function adminView(){
        $this->global['pageTitle'] = 'E-learning : List des mails notifications de course history';        
        $postData = array();
        $data['trainerResults'] = $this->membres_model->filtrer('', TUTEUR, '2');

        $this->load->library('form_validation');

        $this->form_validation->set_rules('expediteur_name', 'Professeur', 'required');
        $this->form_validation->set_rules('expediteur_date_d1', 'Date d1', '');
        $this->form_validation->set_rules('expediteur_date_d2', 'Date d2', '');

        if($this->form_validation->run() == TRUE){
            $postData = array(
                'expediteur_name'    => $this->input->post('expediteur_name'),
                'expediteur_date_d1' => $this->input->post('expediteur_date_d1'),
                'expediteur_date_d2' => $this->input->post('expediteur_date_d2'),
            );

            $data['postData']   = $postData;
            $data['allResults'] = $this->Mail_box_model->getByParams($postData);
        }
        else{
            $data['allResults'] = $this->Mail_box_model->getByParams($postData);  
        }
        
        $this->loadViews("commun/mailbox/adminView", $this->global, $data , NULL);
    }
   
   
}

?>