<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require APPPATH . '/libraries/vendor/autoload.php';

class Newsletter extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('newsletter_model');
        $this->load->model('utilities_model');
        $this->width      = "1200";
        $this->height     = "1280";
        $this->date       = time();
        
    }
  
    public function index(){
    }

    public function uploadThumbnailNl(){
        $return = array();
        ini_set('max_execution_time', 300); //300 seconds = 5 minutes
        if(isset($_FILES["fileThumbNailNl"]) && $_FILES["fileThumbNailNl"]["error"] == 0){
            
            $filesThumb=$_FILES['fileThumbNailNl'];
            $tmp_name_thumb=$filesThumb['tmp_name'];


            $thumbnailFiles = "thumbnail_".$this->date.'_'.$this->session->userdata('GUSERID').'.png';
            
            if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
            }  

            $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 

            $uploadFile = move_uploaded_file($tmp_name_thumb, $fileLocation);
            $return['uploadFileUrl'] = base_url().'groupes/ACTIVITES/'.$thumbnailFiles;
            $return['uploadFile'] = $uploadFile;
                
            /*On verifie tous d'abord si vignette existe déjà*/
            $thumbResult = $this->utilities_model->getThumbNlResult($_POST['monthId'],$_POST['artcileId']);
            //Existe
            if (count($thumbResult) >= 1) {
                //Verifion si le fichier existe vraiment dans le dossier local
                $thumbinfo = array(            
                    "thumbnail"         => $thumbnailFiles, 
                    "date_create"       => $this->date, 
                    'user_create'       =>$this->session->userdata ('GUSERID')
                );

                $return['message'] = array(
                    'status' => 'update', 
                    'infos' => $this->utilities_model->updateThumbNL1($thumbResult[0]->id,$thumbinfo), 
                );
                
                
            }
            else{ //Existe pas
                $thumbinfo = array(            
                    'idMonth'           => $_POST['monthId'], 
                    "idArticle"         => $_POST['artcileId'], 
                    "thumbnail"         => $thumbnailFiles, 
                    "date_create"       => $this->date, 
                    'user_create'       =>$this->session->userdata ('GUSERID')
                );
                
                $return['message'] = array(
                    'status' => 'insert', 
                    'infos' => $this->utilities_model->addthumbNL($thumbinfo)
                );
            }

        }

        echo json_encode($return);
        
    }

    public function generateThumbNlByOrigin(){
        $return = array();
        $staticUserId = $this->session->userdata('GUSERID') != '' ? $this->session->userdata('GUSERID') : 9851;
        ini_set('max_execution_time', 300); //300 seconds = 5 minutes

        if (isset($_POST['origine']) && $_POST['origine'] != "") {
            if ($this->validate_url($_POST['origine'])) {            
                //$thumbnailFiles = "thumbnail_".$this->date.'_'.$this->session->userdata('GUSERID').'.png';
                $thumbnailFiles = "thumbnail_".$this->date.'_'.$staticUserId.'.png';
                
                if ( ! is_dir(REP_ACTIVITY_SEQUENCE) ) {
                    mkdir(REP_ACTIVITY_SEQUENCE, 0777,true);
                }  
                $fileLocation = REP_ACTIVITY_SEQUENCE."/".$thumbnailFiles; 
                    
                /*On verifie tous d'abord si vignette existe déjà*/
                $thumbResult = $this->utilities_model->getThumbNlResult($_POST['monthId'],$_POST['artcileId']);
                //Existe
                if (count($thumbResult) >= 1) {
                    //Verifion si le fichier existe vraiment dans le dossier local
                  
                    $thumb = $this->generateThumbnail($_POST['origine'],$this->width,$this->height,$fileLocation);
                    if ($thumb) {
                        $thumbinfo = array(            
                            "thumbnail"         => $thumbnailFiles, 
                            "date_create"       => $this->date, 
                            'user_create'       => $staticUserId
                        );                                    
                        $return['message'] = array(
                            'infos' => 'update', 
                            'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                            'status' => $this->utilities_model->updateThumbNL1($thumbResult[0]->id,$thumbinfo)
                        );
                    }
                    else{
                        $return['message'] = array(
                            'infos' => 'generation_thumb', 
                            'status' => false
                        );
                    }
                    
                }
                else{ //Existe pas
                    $thumb = $this->generateThumbnail($_POST['origine'],$this->width,$this->height,$fileLocation);

                    if ($thumb) {
                        $thumbinfo = array(            
                            'idMonth'           => $_POST['monthId'], 
                            "idArticle"         => $_POST['artcileId'], 
                            "thumbnail"         => $thumbnailFiles, 
                            "date_create"       => $this->date, 
                            'user_create'       => $staticUserId
                        );
                        
                        $return['message'] = array(
                            'infos' => 'insert', 
                            'uploadFileUrl' => base_url().'groupes/ACTIVITES/'.$thumbnailFiles,
                            'status' => $this->utilities_model->addthumbNL($thumbinfo)
                        );
                    }
                    else{                            
                        $return['message'] = array(
                            'infos' => 'generation_thumb', 
                            'status' => false
                        );
                    }
              
                }
            }
            else{
                $return['message'] = array(
                    'infos' => 'validation_url_origin', 
                    'status' => false
                );
            }

        }
        else{
            $return['message'] = array(
                'infos' => 'POST_ERROR', 
                'status' => false
            );
        }
    
        echo json_encode($return);
    }

    /*Generate thumbnail*/
    public function generateThumbnail($url,$width,$height,$dest){
        $this->thumb = new Screen\Capture($url);

        if (!isset($url)) {
            exit;
        }

        if (isset($width)) { // Width
            $this->thumb->setWidth(intval($width));
        }

        if (isset($height)) { // Height
            $this->thumb->setHeight(intval($height));
        }

        if (isset($width)) { // Clip Width
            $this->thumb->setClipWidth(intval($width));
        }

        if (isset($height)) { // Clip Height
            $this->thumb->setClipHeight(intval($height));
        }

        if (isset($_GET['user-agent'])) { // User Agent String
            $this->thumb->setUserAgentString($_GET['user-agent']);
        }

        if (isset($_GET['bg-color'])) { // Background Color
            $this->thumb->setBackgroundColor($_GET['bg-color']);
        }

        if (isset($_GET['format'])) { // Format
            $this->thumb->setImageType($_GET['format']);
        }
        if($this->thumb->save($dest)){
            return true;
        }
        else{
            return false;
        }
        exit;
    }

    public function validate_url($url){
        $curl = curl_init($url); 
        curl_setopt($curl, CURLOPT_NOBODY, true); 
        $result = curl_exec($curl); 
          
        if ($result !== false) { 
            $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE); 
            if ($statusCode != 200 && $statusCode != 302 && $statusCode != 304) { 
                return false; 
            } 
            else { 
                return true; 
            } 
        } 
        else { 
            return false; 
        }
    }

}

?>