<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require APPPATH . '/libraries/ElearningForma2PlusController.php';

/**
 * Class : Domains
 * @author : Alexandre Boris
 * @version : 1.1
 * @since : 31 January 2019
 */
class Domains extends ElearningForma2PlusController
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->model('connexion_model');
        $this->load->model('sequence_model');
        $this->load->model('chapitres_model');
        $this->load->model('matieres_model');
        $this->load->model('modules_model');
        $this->load->model('parcours_model');
        $this->load->model('sessions_model');
        $this->load->model('groupes_model');
        $this->load->model('formations_model');
        $this->load->model('utilities_model');
        $this->load->model('membres_model');
        $this->load->model('domaines_model');
        $this->form_validation->set_error_delimiters($this->config->item('error_prefix'), $this->config->item('error_suffix'));
        $this->isLoggedIn();   
    }
    
    /**
     * This function used to load the first screen of the user
     */
    public function index()
    {
        $this->global['pageTitle'] = 'E-learning : Domains management';
       
        $ret = '';

        $action = array() ;
  
        $dom = $this->domaines_model->read();
        
        for($i=0;$i<$dom['cnt'];$i++)  {
            $ret .= '<li><span class="domaineName">'.$dom[$i]['name'].'</span>

                <input type="hidden" name="domainsId" class="domainsId" value="'.$dom[$i]['id'].'">
                <input type="hidden" name="domainstext" class="domainstext" value="'.$dom[$i]['name'].'">

                <a title="Delete domains" href="#" class="deleteDomaine">&nbsp;&nbsp;<span class="glyphicon glyphicon-trash"></span></a><a href="#" class="editDomaine"  data-toggle="modal" data-target="#exampleModal" title="Edit domains">&nbsp;&nbsp;<span class="glyphicon glyphicon-edit"></span></a><a href="#" class="addmaterial"  title="Add new material">&nbsp;&nbsp;<span class="glyphicon glyphicon-plus"></span></a><ul class="materialmenu">';

            $mat = $this->matieres_model->readAll($dom[$i]['id']);
            for ($j=0;$j<$mat['cnt'];$j++) {

                $ret .= '<li class="material">
                <input type="hidden" name="materialsId" class="materialsId" value="'.$mat[$j]['id'].'">
                <input type="hidden" name="materialstext" class="materialstext" value="'.$mat[$j]['name'].'">

                <a title="Delete material" href="#" class="deleteMaterial">&nbsp;&nbsp;<span class="glyphicon glyphicon-trash"></span></a><a href="#" class="editMaterial"  title="Edit material">&nbsp;&nbsp;<span class="glyphicon glyphicon-edit"></span></a><a href="#" class="moveMaterial"  title="Move material in other domains">&nbsp;&nbsp;<span class="glyphicon glyphicon-move"></span></a>&nbsp;&nbsp;<span class="materialName">'.$mat[$j]['name'].'</span></li>';
            }

            
            $ret .= '</ul></li>';
        }

        $this->global['content'] = $ret;

        $this->loadViews("admin/domains/index", $this->global,NULL, NULL );
    }

    public function deletematerial(){
        $id = $this->input->post('id');
        $this->matieres_model->del($id) ;
        $this->sequence_model->delMatiere($id);
        $this->modules_model->delMatiere($id);
        $this->parcours_model->delMatiere($id);
    }

    public function delete(){
        $id = $this->input->post('idDomains');
        $this->domaines_model->del($id) ;
        $this->matieres_model->delAll($id) ;
        $this->sequence_model->delDomaine($id);
        $this->modules_model->delDomaine($id);
        $this->parcours_model->delDomaine($id);
        return true;
    }
  
    public function add(){
        $name   = $this->input->post('domain_name');
        $id     = $this->domaines_model->add($name);
        redirect("/managedomains","refresh");
    }

    public function edit(){
        
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->domaines_model->update($id, $name);
        echo "###".$id."###";
    }

    public function editmatiere(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $this->matieres_model->update($id, $name);
        echo "###".$id."###";
    }

    public function addmaterial(){
        $id     = $this->input->post('id');
        $name   = $this->input->post('name');
        $id     = $this->matieres_model->add($name, $id);
        echo "###".$id."###";
    }

    public function showall(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $dom            = $this->domaines_model->read(-1,LOC);
        $ret            = "";
        //$cursor         = "";
        for($i=0;$i<$dom['cnt'];$i++)  {
            /*$mat = $this->matieres_model->readAll($dom[$i]['id']);
            for ($j=0;$j<$mat['cnt'];$j++) {
                if ($mat[$j]['id']==$idMaterial) {
                    # code...
                }
            }*/
            if ( in_array($dom[$i]['id'],$idDomains) ) {
                $cursor         = "not-allowed";
            } 
            else {
                $cursor         = "pointer";
            }
            $ret .= '<p><a class="movematerials" onclick="movematerial(this);">';
            $ret .= '<input type="hidden" class="materialid" value="'.$idMaterial.'">';
            $ret .= '<input type="hidden" class="domainsid" value="'.$dom[$i]['id'].'">';
            $ret .= '<span class="glyphicon glyphicon-plus" style="cursor:'.$cursor.';"></span>&nbsp;&nbsp;'.$dom[$i]['name'].'</a></p>';
        }
        echo "###".$ret."###";
    }

    public function movematerial(){
        $idMaterial     = $this->input->post('idMaterial');
        $idDomains      = $this->input->post('idDomains');
        $this->matieres_model->move($idMaterial,$idDomains,LOC);
        $this->sequence_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->modules_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);
        $this->parcours_model->updateMatiereDomaine($idMaterial,$idDomains,LOC);

    }

    public function deleteSequence(){
       
        
    }

    public function supprimerItemGroupe($ids,$locs,$idm,$locm,$idp,$locp,$idg) {
       
    }

    public function supprimerItemFormation($idu,$ids,$locs,$idm,$locm,$idp,$locp,$idg) {      
       
      
    }
}

?>